/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.util.UWCLogger;
import java.security.Principal;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class IdentitySSO {
    public static final String UWC_AUTH = "uwcauth.";
    public static final String CONFIG_SSO_PREFIX = "identitysso.";
    public static final String CONFIG_IDENTITY_ENABLE = "identity.enabled";
    public static final String CONFIG_BINDDN = "uwcauth.identity.binddn";
    public static final String CONFIG_BINDCRED = "uwcauth.identity.bindcred";
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    public static final String CONFIG_COOKIEDOMAIN = "cookiedomain";
    static Logger ssoLogger = UWCLogger.getLogger("uwc.common.auth");
    private String _defaultDomain = null;
    private boolean _enabled = true;
    private String _ambinddn = null;
    private String _ambindcred = null;
    private SSOToken _ssotoken = null;
    private AMStoreConnection _amConn = null;

    public IdentitySSO(Preferences preferences) {
        this._enabled = preferences.getBoolean("uwcauth.identity.enabled", false);
        this._ambinddn = preferences.get(CONFIG_BINDDN, null);
        this._ambindcred = preferences.get(CONFIG_BINDCRED, null);
        if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
            ssoLogger.fine("Read Identity SSO Properties....: ");
            ssoLogger.fine("enabled is...." + this._enabled);
            ssoLogger.fine("configbinddn is...." + this._ambinddn);
            ssoLogger.fine("configbindcred is...." + this._ambindcred);
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public Principal getAdminPrincipal() {
        UWCPrincipal uWCPrincipal = new UWCPrincipal(this._ambinddn);
        return uWCPrincipal;
    }

    public String getAdminDN() {
        return this._ambinddn;
    }

    public String getAdminCredentials() {
        return this._ambindcred;
    }

    public AMStoreConnection getAdminStoreConnection(String string, String string2) throws SSOException {
        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
        if (!sSOTokenManager.isValidToken(this._ssotoken)) {
            this._ssotoken = sSOTokenManager.createSSOToken((Principal)new UWCPrincipal(string), string2);
            this._amConn = new AMStoreConnection(this._ssotoken);
        }
        return this._amConn;
    }

    public AMStoreConnection getAdminStoreConnection() throws SSOException {
        return this.getAdminStoreConnection(this.getAdminDN(), this.getAdminCredentials());
    }

    public SSOToken getAdminSSOToken() throws SSOException {
        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
        return sSOTokenManager.createSSOToken(this.getAdminPrincipal(), this.getAdminCredentials());
    }

    public static SSOToken getAdminSSOToken(String string, String string2) throws SSOException {
        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
        return sSOTokenManager.createSSOToken((Principal)new UWCPrincipal(string), string2);
    }

    public static String getOrganizationDN(String string) {
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(string);
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            String string2 = sSOToken.getPrincipal().getName();
            AMUser aMUser = aMStoreConnection.getUser(string2);
            String string3 = aMUser.getOrganizationDN();
            return string3;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void addLoginCallbackMessage(Callback[] callbackArray, String string, String string2) throws UnsupportedCallbackException {
        int n = 0;
        try {
            for (n = 0; n < callbackArray.length; ++n) {
                Callback callback;
                if (callbackArray[n] instanceof NameCallback) {
                    callback = (NameCallback)callbackArray[n];
                    ((NameCallback)callback).setName(string);
                    continue;
                }
                if (!(callbackArray[n] instanceof PasswordCallback)) continue;
                callback = (PasswordCallback)callbackArray[n];
                ((PasswordCallback)callback).setPassword(string2.toCharArray());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static SSOToken getSSOToken(String string, String string2, String string3) throws UnsupportedCallbackException, LoginException, Exception {
        AuthContext authContext = null;
        try {
            authContext = new AuthContext(string);
            authContext.login();
        }
        catch (LoginException loginException) {
            return null;
        }
        Callback[] callbackArray = null;
        while (authContext.hasMoreRequirements()) {
            callbackArray = authContext.getRequirements();
            if (callbackArray == null) continue;
            IdentitySSO.addLoginCallbackMessage(callbackArray, string2, string3);
            authContext.submitRequirements(callbackArray);
        }
        if (authContext.getStatus() != AuthContext.Status.SUCCESS) {
            ssoLogger.severe("Authentication Failed! - status=" + authContext.getStatus());
            return null;
        }
        return authContext.getSSOToken();
    }

    static class UWCPrincipal
    implements Principal {
        String name;

        UWCPrincipal(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            return object.toString().equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

