/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.util.Base64Utils;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCPreferences;
import java.io.File;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public abstract class AuthFilter
implements Filter {
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    public static final String CONFIG_IDENTITY_ENABLED = "uwcauth.identity.enabled";
    public static final String CONFIG_SSL_ENABLED = "uwcauth.ssl.enabled";
    public static final String CONFIG_UWC_SSL_PORT = "uwcauth.https.port";
    public static final String CONFIG_UWC_PORT = "uwcauth.http.port";
    public static final String PROXY_ADMINS = "uwcauth.admins";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String PROXY_USER = "proxyauth";
    protected String _config_filename = "uwcauth.properties";
    protected String _log_config_filename = "uwclogging.properties";
    static Logger authLogger = null;
    private UWCPreferences _preferences;
    protected boolean _identityEnabled = false;
    protected String _proxyAdmins = null;
    protected String[] _listOfProxyAdmins = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        File file;
        String string = filterConfig.getInitParameter("configPath");
        ServletContext servletContext = null;
        if (string == null && (string = (servletContext = filterConfig.getServletContext()).getRealPath("/")) == null) {
            string = "./";
        }
        if (!(file = new File(new File(string, "local-conf"), "config")).isDirectory() && !(file = new File(string, "WEB-INF/config")).isDirectory()) {
            throw new ServletException("AuthFilter: can't open configuration dir " + file.toString());
        }
        String string2 = file.getPath() + "/" + this._config_filename;
        String string3 = file.getPath() + File.separator + this._log_config_filename;
        UWCLogger.setConfigFile(string3);
        authLogger = UWCLogger.getLogger("uwc.common.auth");
        this._preferences = UWCPreferences.getSystemRootInstance();
        try {
            this._preferences = this._preferences.loadNode(string2, "/");
            authLogger.fine("read :uwcauth.identity.enabled");
            this._identityEnabled = this._preferences.getBoolean(CONFIG_IDENTITY_ENABLED, false);
            authLogger.fine("identity enabeld is :" + this._identityEnabled);
            authLogger.fine("read :uwcauth.admins");
            this._proxyAdmins = this._preferences.get(PROXY_ADMINS, null);
            authLogger.fine("list of proxy admins :" + this._proxyAdmins);
            if (null != this._proxyAdmins) {
                this._listOfProxyAdmins = this._proxyAdmins.split(",");
            }
        }
        catch (UWCException uWCException) {
            throw new ServletException(uWCException.getMessage());
        }
        authLogger.exiting("AuthFilter:", " init");
    }

    public Preferences getPreferences() {
        return this._preferences;
    }

    public boolean isIdentityEnabled() {
        return this._identityEnabled;
    }

    public static String getUserFromRequest(HttpServletRequest httpServletRequest) {
        String string;
        int n;
        String string2 = null;
        String string3 = httpServletRequest.getHeader("Authorization");
        if (string3 != null && (n = (string = Base64Utils.b64Decode(string3 = string3.substring(6).trim())).indexOf(":")) > 0) {
            string2 = string.substring(0, n);
        }
        if (string2 == null) {
            string2 = httpServletRequest.getParameter(USERNAME);
        }
        return string2;
    }

    public static String getPasswordFromRequest(HttpServletRequest httpServletRequest) {
        String string;
        int n;
        String string2 = null;
        String string3 = httpServletRequest.getHeader("Authorization");
        if (string3 != null && (n = (string = Base64Utils.b64Decode(string3 = string3.substring(6).trim())).indexOf(":")) > 0) {
            string2 = string.substring(n + 1);
        }
        if (string2 == null) {
            string2 = httpServletRequest.getParameter(PASSWORD);
        }
        return string2;
    }

    public static String getProxyUserFromRequest(HttpServletRequest httpServletRequest) {
        String string = null;
        string = httpServletRequest.getParameter(PROXY_USER);
        return string;
    }

    public static boolean isProxyRequest(HttpServletRequest httpServletRequest) {
        return null != AuthFilter.getProxyUserFromRequest(httpServletRequest);
    }

    public boolean isUserProxyAdmin(String string, String string2) {
        if (null != this._listOfProxyAdmins) {
            int n;
            String string3 = string + '@' + string2;
            for (n = 0; n < this._listOfProxyAdmins.length; ++n) {
                if (!string3.equals(this._listOfProxyAdmins[n])) continue;
                return true;
            }
            for (n = 0; n < this._listOfProxyAdmins.length; ++n) {
                if (!string.equals(this._listOfProxyAdmins[n])) continue;
                return true;
            }
        }
        return false;
    }
}

