/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.uwc.UWCServletBase;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.auth.IdentitySSOAuthFilter;
import com.sun.uwc.common.auth.UWCIdentitySSOTokenListener;
import com.sun.uwc.common.util.UWCLogger;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import netscape.ldap.LDAPEntry;

public class ISUserHelper {
    private static final String CLASS_NAME = "ISUserHelper";
    private static final Logger _log = UWCLogger.getLogger("uwc.common");

    private ISUserHelper() {
    }

    public static void invalidateISssoToken(String string, HttpSession httpSession) {
        SSOTokenManager sSOTokenManager = null;
        SSOToken sSOToken = null;
        try {
            sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = sSOTokenManager.createSSOToken(string);
        }
        catch (SSOException sSOException) {
            _log.warning("invalidateISSession: Error occured: " + sSOException.getMessage());
        }
        try {
            if (null != sSOToken) {
                UWCIdentitySSOTokenListener uWCIdentitySSOTokenListener = (UWCIdentitySSOTokenListener)httpSession.getAttribute("IdentitySSOTokenListener");
                if (uWCIdentitySSOTokenListener != null) {
                    uWCIdentitySSOTokenListener.ignoreEvents();
                }
                sSOTokenManager.destroyToken(sSOToken);
            }
        }
        catch (SSOException sSOException) {
            _log.severe("invalidateISSession: BNA destroy failed: " + sSOException.getMessage());
        }
    }

    public static boolean getMailServiceStatus(AMUser aMUser, AMOrganization aMOrganization) throws AMException, SSOException {
        String string = aMOrganization.getStringAttribute("mailDomainStatus");
        if (string != null && string.length() == 0) {
            string = null;
        }
        _log.info("ISUserHelper:mailDomainStatus = " + string);
        if (string != null && !string.equalsIgnoreCase("active") && !string.equalsIgnoreCase("overquota")) {
            return false;
        }
        String string2 = aMUser.getStringAttribute("mailUserStatus");
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        _log.info("ISUserHelper:mailUserStatus = " + string2);
        if (string2 != null && !string2.equalsIgnoreCase("active") && !string2.equalsIgnoreCase("overquota")) {
            return false;
        }
        String string3 = aMUser.getStringAttribute("mailAllowedServiceAccess");
        _log.info("ISUserHelper:mailAllowedServiceAccess = " + string3);
        return UWCUserHelper.isHttpMailServiceAllowed(string3);
    }

    public static boolean getCalendarServiceStatus(AMUser aMUser, AMOrganization aMOrganization) throws AMException, SSOException {
        boolean bl = true;
        String string = aMOrganization.getStringAttribute("icsStatus");
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string != null && !string.equalsIgnoreCase("active")) {
            bl = false;
        } else {
            String string2 = aMUser.getStringAttribute("icsStatus");
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            if (string2 != null && !string2.equalsIgnoreCase("active")) {
                bl = false;
            }
        }
        return bl;
    }

    public static LDAPEntry getUserEntry(String string, String string2) {
        AMOrganization aMOrganization;
        String string3 = null;
        try {
            aMOrganization = UWCServletBase.getApplicationConfigMgr().getDomainManager().loadDomainFromIS(string);
            if (aMOrganization != null) {
                AMUser aMUser = aMOrganization.getUser(string2, null);
                string3 = aMUser.getDN();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 == null) {
            return null;
        }
        aMOrganization = UWCUserHelper.getUserEntry(string3);
        return aMOrganization;
    }

    public static void removeIdentityCookie(ServletRequest servletRequest, ServletResponse servletResponse) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        Cookie[] cookieArray = httpServletRequest.getCookies();
        String string = null;
        String string2 = null;
        String string3 = IdentitySSOAuthFilter.getIdentityCookieName();
        String string4 = IdentitySSOAuthFilter.getIdentityCookieDomain();
        if (cookieArray != null && cookieArray.length > 0) {
            boolean bl = false;
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!cookieArray[i].getName().equalsIgnoreCase(string3)) continue;
                bl = true;
                string = cookieArray[i].getPath();
                string2 = cookieArray[i].getDomain();
                break;
            }
            if (bl) {
                Cookie cookie = new Cookie(string3, null);
                if (string != null) {
                    cookie.setPath(string);
                } else {
                    cookie.setPath("/");
                }
                if (string2 != null) {
                    cookie.setDomain(string2);
                } else if (string4 != null) {
                    cookie.setDomain(string4);
                }
                cookie.setMaxAge(0);
                httpServletResponse.addCookie(cookie);
            }
        }
    }
}

