/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.comclient.calendar.socs.SOCSEvent;
import com.sun.uwc.calclient.model.CalendarBaseModel;
import com.sun.uwc.calclient.model.EventsModel;
import com.sun.uwc.calclient.model.UWCCalendar;
import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.util.UWCLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WeekViewEventsModel
extends EventsModel {
    private static Logger _modelLogger = null;
    private static final String CLASS_NAME = "WeekViewEventsModel";
    protected static boolean _isFINELoggable;
    protected static boolean _isINFOLoggable;
    private CalendarExecutionModelContext _ctx = new CalendarExecutionModelContext(CalendarExecutionModelContext.LOAD_EVENT_CONTEXT);
    private String modelName = null;
    private ArrayList[][] weekEventsList = new ArrayList[7][48];
    private ArrayList[] weekAllDayEventsList = new ArrayList[7];
    private boolean[][] isSlotFilled = new boolean[7][48];
    private int[][] eventDaySlotIndex = new int[7][48];
    private int[][] eventTimeSlotIndex = new int[7][48];
    private DateTime[][] maxEndDateTimeForSlot = new DateTime[7][48];
    private String[][] relativeCalendarId = new String[7][48];
    private boolean nonAllDayEventsSorted = false;
    private int currentStartDaySlot = 0;
    private int currentEndDaySlot = 0;
    private int currentStartTimeSlot = 0;
    private int currentEndTimeSlot = 0;
    private DateTime maxEndDateTime = null;
    private boolean weekOverflow = false;
    CalendarBaseModel cbm = null;
    DateTime usersDayStart = null;
    DateTime usersDayEnd = null;
    String usersDayInterval = null;
    HashMap calendars = null;
    int timeSlotInterval = 30;
    int dayIndex = 0;
    int timeIndex = 0;
    boolean isOwnedCalendarSpanningSlot = false;
    private String _userid = null;
    private boolean _isAnon = false;
    private boolean _singleCalendarView = false;
    public static final String FIELD_IS_CONFLICTING = "isconflicting";
    public static final String FIELD_EDIT = "isedit";
    public static final String FIELD_OWNED = "owned";
    public static final String FIELD_UPDATE = "isupdate";
    public static final String FIELD_ISFREEBUSYONLY = "isavailabilityonly";
    public static final String FIELD_CAN_DELETE = "candelete";
    public static final String FIELD_CAN_READ = "canread";
    public static final String FIELD_CAN_MODIFY = "canmodify";
    public static final String FIELD_CALENDAR_OWNER_COMMON_NAME = "calendarownername";

    protected static void setLoggableFlags() {
        _isFINELoggable = _modelLogger.isLoggable(Level.FINE);
        _isINFOLoggable = _modelLogger.isLoggable(Level.INFO);
    }

    public WeekViewEventsModel(String string) {
        super(string);
    }

    public WeekViewEventsModel() {
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        _modelLogger.entering(CLASS_NAME, "execute()");
        String string = null;
        this._userid = UWCUserHelper.getUID(this._reqCtx);
        this._isAnon = UWCUserHelper.isAnonymous(this._reqCtx);
        if (this._isAnon) {
            this._userid = "@";
        }
        this.cbm = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        this.calendars = this.cbm.getCalendars();
        this._singleCalendarView = this.cbm.getIfSingleCalendarView();
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.WEEKVIEW_NONALLDAY_EVENTS_CONTEXT;
        if (string.equals(CalendarExecutionModelContext.WEEKVIEW_NONALLDAY_EVENTS_CONTEXT)) {
            if (!this.nonAllDayEventsSorted) {
                this.sortNonAllDayEvents();
                this.nonAllDayEventsSorted = true;
            }
        } else if (string.equals(CalendarExecutionModelContext.WEEKVIEW_ALLDAY_EVENTS_CONTEXT)) {
            this.sortAllDayEvents();
        }
        _modelLogger.exiting(CLASS_NAME, "execute()");
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        _modelLogger.entering(CLASS_NAME, "retrieve()");
        String string = null;
        boolean bl = false;
        CalendarComponent[] calendarComponentArray = null;
        int n = 0;
        this.clear();
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.WEEKVIEW_NONALLDAY_EVENTS_CONTEXT;
        _modelLogger.finest("operationName is" + string);
        if (string.equals(CalendarExecutionModelContext.WEEKVIEW_NONALLDAY_EVENTS_CONTEXT)) {
            _modelLogger.finest("dayIndex is" + this.dayIndex);
            _modelLogger.finest("timeIndex is" + this.timeIndex);
            calendarComponentArray = this.fetchNonAllDayEvents(this.dayIndex, this.timeIndex);
            if (calendarComponentArray != null) {
                n = calendarComponentArray.length;
            }
            bl = false;
        } else if (string.equals(CalendarExecutionModelContext.WEEKVIEW_ALLDAY_EVENTS_CONTEXT)) {
            _modelLogger.finest("dayIndex is" + this.dayIndex);
            calendarComponentArray = this.fetchAllDayEvents(this.dayIndex);
            if (calendarComponentArray != null) {
                n = calendarComponentArray.length;
            }
            bl = true;
        }
        this.clear();
        if (calendarComponentArray != null) {
            _modelLogger.finest("calentries is not null");
            String string2 = this.cbm.getSingleCalid();
            String string3 = this.cbm.getSingleCalCommonName();
            boolean bl2 = this.cbm.getIfSingleOwnedCal();
            boolean bl3 = this.cbm.getSingleCalHasReadAccess();
            boolean bl4 = this.cbm.getSingleCalHasWriteAccess();
            boolean bl5 = this.cbm.getSingleCalHasDeleteAccess();
            boolean bl6 = this.cbm.getSingleCalHasFreeBusyAccess();
            UWCCalendar uWCCalendar = this.cbm.getSingleUwcCal();
            for (int i = 0; i < n; ++i) {
                this.appendRow();
                SOCSEvent sOCSEvent = (SOCSEvent)calendarComponentArray[i];
                if (_isINFOLoggable) {
                    _modelLogger.info("Event is " + calendarComponentArray[i].toString());
                }
                this.setCurrentEvent((VEvent)sOCSEvent);
                super.retrieve((ModelExecutionContext)this._ctx);
                try {
                    Object object;
                    Object object2;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    if (!this._singleCalendarView) {
                        _modelLogger.finest("Not a single calendar view");
                        string2 = sOCSEvent.getCalID();
                        _modelLogger.finest("calid is " + string2);
                        uWCCalendar = (UWCCalendar)this.calendars.get(string2);
                        if (uWCCalendar != null) {
                            string2 = ((SOCSCalendar)uWCCalendar.getCalendar()).getRelativeCalId();
                            if (!this._isAnon) {
                                bl2 = UWCUserHelper.isUserTheCalendarOwner(this._reqCtx, string2, this._userid);
                                if (!bl2) {
                                    string3 = ((SOCSCalendar)uWCCalendar.getCalendar()).getOwnerCommonName();
                                    _modelLogger.finest("commonname is " + string3);
                                    this.setValue(FIELD_CALENDAR_OWNER_COMMON_NAME, string3);
                                }
                                bl3 = (bl4 = UWCUserHelper.hasCalendarPermission(uWCCalendar, this._userid, "c", "w")) ? true : UWCUserHelper.hasCalendarPermission(uWCCalendar, this._userid, "c", "r");
                                bl5 = UWCUserHelper.hasCalendarPermission(uWCCalendar, this._userid, "c", "d");
                                bl6 = UWCUserHelper.hasCalendarPermission(uWCCalendar, this._userid, "c", "f");
                            } else {
                                object2 = new Properties();
                                object = SOCSCalendar.getCalProps((String)string2, (String)UWCApplicationHelper.getWCAPHost(), (int)UWCApplicationHelper.getWCAPPort(), (Properties)object2);
                                if (object != null) {
                                    string3 = ((Properties)object).getProperty("COMMON_NAME");
                                    this.setValue(FIELD_CALENDAR_OWNER_COMMON_NAME, string3);
                                }
                            }
                        }
                    }
                    if (!this._isAnon) {
                        bl7 = sOCSEvent.isCalIdTheOrganizer(string2);
                        object2 = sOCSEvent.getAttendee(string2);
                        if (object2 != null) {
                            bl8 = true;
                        }
                        _modelLogger.finest("isCalIdTheOrganizer is " + bl7);
                        _modelLogger.finest("isCalIdTheAttendee is " + bl8);
                    }
                    this.isOwnedCalendarSpanningSlot = bl2;
                    if (bl2) {
                        _modelLogger.finest("owned cal is true  ");
                        this.setValue(FIELD_OWNED, "true");
                    } else {
                        _modelLogger.finest("owned cal is true  ");
                        this.setValue(FIELD_OWNED, "false");
                    }
                    this.setValue(FIELD_CAN_DELETE, bl5 ? "true" : "false");
                    object2 = "false";
                    object = "false";
                    if (bl4) {
                        if (bl7 && bl8) {
                            object2 = "true";
                            object = "true";
                        } else if (bl8) {
                            object2 = "false";
                            object = "true";
                        } else if (bl7) {
                            object2 = "true";
                            object = "false";
                        }
                    }
                    _modelLogger.finest("field edit is " + (String)object2);
                    _modelLogger.finest("field update is " + (String)object);
                    this.setValue(FIELD_EDIT, object2);
                    this.setValue(FIELD_UPDATE, object);
                    if (bl4) {
                        _modelLogger.fine("User Has write Permission");
                        this.setValue(FIELD_CAN_MODIFY, "true");
                    } else {
                        _modelLogger.fine("User doe not have write Permission");
                        this.setValue(FIELD_CAN_MODIFY, "false");
                    }
                    if (bl3) {
                        _modelLogger.fine("User Has Read Permission");
                        this.setValue(FIELD_CAN_READ, "true");
                    } else {
                        _modelLogger.fine("User doe not have read Permission");
                        this.setValue(FIELD_CAN_READ, "false");
                    }
                    if (bl6) {
                        _modelLogger.fine("User Has freebusy Permission");
                        this.setValue(FIELD_ISFREEBUSYONLY, "true");
                    } else {
                        _modelLogger.fine("User doe not have freebusy Permission");
                        this.setValue(FIELD_ISFREEBUSYONLY, "false");
                    }
                    if (n > 1) {
                        this.setValue(FIELD_IS_CONFLICTING, "true");
                        _modelLogger.finest("conflictinmg is true");
                        continue;
                    }
                    this.setValue(FIELD_IS_CONFLICTING, "false");
                    _modelLogger.finest("conflictinmg is false");
                    continue;
                }
                catch (OperationNotSupportedException operationNotSupportedException) {
                    _modelLogger.severe("OperationNotSupportedException Exception" + operationNotSupportedException.getMessage());
                    throw new ModelControlException();
                }
                catch (UWCException uWCException) {
                    _modelLogger.severe("UWCException Exception" + uWCException.getMessage());
                    throw new ModelControlException(uWCException.getDetails());
                }
                catch (Exception exception) {
                    _modelLogger.severe("Exception " + exception.getMessage());
                    throw new ModelControlException();
                }
            }
        }
        this.beforeFirst();
        _modelLogger.exiting(CLASS_NAME, "retrieve()");
        return null;
    }

    public void setDayInterval(String string) {
        this.usersDayInterval = string;
    }

    public void setDayStartTime(DateTime dateTime) {
        this.usersDayStart = dateTime;
    }

    public void setDayEndTime(DateTime dateTime) {
        this.usersDayEnd = dateTime;
    }

    public void setDayIndex(int n) {
        this.dayIndex = n;
    }

    public void setTimeIndex(int n) {
        this.timeIndex = n;
    }

    public void sortAllDayEvents() {
        _modelLogger.entering(CLASS_NAME, "sortAllDayEvents()");
        DateTime dateTime = this.cbm.getStartTime();
        DateTime dateTime2 = this.cbm.getEndTime();
        SOCSEvent sOCSEvent = null;
        DateTime dateTime3 = null;
        DateTime dateTime4 = null;
        int n = 0;
        ArrayList arrayList = this.cbm.getAllDayEvents();
        if (arrayList != null) {
            n = arrayList.size();
        }
        int n2 = 0;
        int n3 = 0;
        _modelLogger.fine(" numEvents is .. " + n);
        for (int i = 0; i < n; ++i) {
            sOCSEvent = (SOCSEvent)arrayList.get(i);
            dateTime3 = sOCSEvent.getStart();
            dateTime4 = sOCSEvent.getEnd();
            if (dateTime3 != null && dateTime != null) {
                _modelLogger.fine(" AllDayEvent Start Time is .. " + dateTime3.toISO8601());
                _modelLogger.fine(" weektart Time is .. " + dateTime.toISO8601());
                n2 = dateTime3.after((Object)dateTime) ? (7 + (dateTime3.get(7) - dateTime.get(7))) % 7 : 0;
            } else {
                _modelLogger.fine("event start time is null");
                n2 = 0;
            }
            if (dateTime4 != null && dateTime != null && dateTime2 != null) {
                n3 = dateTime4.before((Object)dateTime2) ? (7 + (dateTime4.get(7) - dateTime.get(7))) % 7 : 6;
                _modelLogger.fine(" AllDayEvent End Time is .. " + dateTime4.toISO8601());
                if (n3 > 6) {
                    n3 = 6;
                }
            } else {
                _modelLogger.fine("event start time is null");
                n3 = n2;
            }
            if (_isFINELoggable) {
                _modelLogger.fine("StartdaySlot is" + n2);
            }
            if (_isFINELoggable) {
                _modelLogger.fine("EnddaySlot is" + n3);
            }
            int n4 = n2;
            do {
                if (this.weekAllDayEventsList[n4] == null) {
                    _modelLogger.fine("AllDayEventsList is null");
                    this.weekAllDayEventsList[n4] = new ArrayList();
                }
                _modelLogger.fine("Store the event in weekAllDayEvents ArrayList");
                this.weekAllDayEventsList[n4].add(sOCSEvent);
                _modelLogger.fine("Store the event in weekAllDayEvents ArrayList : Done");
            } while (++n4 < n3);
        }
        _modelLogger.exiting(CLASS_NAME, "sortAllDayEvents()");
    }

    public void sortNonAllDayEvents() {
        _modelLogger.entering(CLASS_NAME, "sortNonAllDayEvents()");
        DateTime dateTime = this.cbm.getStartTime();
        DateTime dateTime2 = this.cbm.getEndTime();
        SOCSEvent sOCSEvent = null;
        DateTime dateTime3 = null;
        DateTime dateTime4 = null;
        int n = 0;
        ArrayList arrayList = this.cbm.getNonAllDayEvents();
        if (arrayList != null) {
            n = arrayList.size();
        }
        _modelLogger.fine(" numEvents is .. " + n);
        if (this.usersDayStart == null) {
            this.usersDayStart = new DateTime();
            this.usersDayStart.setTime(9, 0, 0);
        }
        if (this.usersDayEnd == null) {
            this.usersDayEnd = new DateTime();
            this.usersDayEnd.setTime(18, 0, 0);
        }
        if (this.usersDayInterval == null) {
            this.usersDayInterval = "PT1H";
        }
        int n2 = this.usersDayStart.getHours();
        int n3 = this.usersDayStart.getMinutes();
        try {
            Duration duration = new Duration(this.usersDayInterval);
            this.timeSlotInterval = duration.getHours() * 60 + duration.getMinutes();
        }
        catch (Exception exception) {
            _modelLogger.fine("Unable to set TimeSlot Interval");
        }
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            sOCSEvent = (SOCSEvent)arrayList.get(i);
            this.weekOverflow = false;
            try {
                if (_isFINELoggable) {
                    _modelLogger.fine(" Event .. " + sOCSEvent.toRFC2445());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            dateTime3 = sOCSEvent.getStart();
            dateTime4 = sOCSEvent.getEnd();
            boolean bl = false;
            boolean bl2 = false;
            if (dateTime3 != null && dateTime4 != null && dateTime != null) {
                dateTime4 = (DateTime)sOCSEvent.getEnd().clone();
                if (!dateTime4.equals((Object)dateTime3)) {
                    dateTime4.add(13, -1);
                }
                if (dateTime4.getDay() - dateTime3.getDay() > 0) {
                    bl2 = true;
                }
                if (_isFINELoggable) {
                    _modelLogger.fine(" Event is from.. " + dateTime3.toISO8601() + " to " + dateTime4.toISO8601());
                }
                this.currentStartDaySlot = dateTime3.after((Object)dateTime) ? (7 + (dateTime3.get(7) - dateTime.get(7))) % 7 : 0;
                if (dateTime4.before((Object)dateTime2)) {
                    this.currentEndDaySlot = (7 + (dateTime4.get(7) - dateTime.get(7))) % 7;
                } else {
                    this.currentEndDaySlot = 6;
                    this.weekOverflow = true;
                }
                n5 = dateTime3.getHours() - n2;
                n4 = dateTime3.getMinutes() - n3;
                if (n5 * 60 + n4 >= 0) {
                    if (_isFINELoggable) {
                        _modelLogger.fine("start hour > " + n2);
                    }
                    this.currentStartTimeSlot = dateTime3.after((Object)dateTime) ? (60 * n5 + n4) / this.timeSlotInterval : 0;
                } else {
                    this.currentStartTimeSlot = 0;
                }
                n5 = dateTime4.getHours() - n2;
                n4 = dateTime4.getMinutes() - n3;
                if (n5 * 60 + n4 >= 0) {
                    if (_isFINELoggable) {
                        _modelLogger.fine("end hour > " + n2);
                    }
                    if (dateTime4.before((Object)dateTime2)) {
                        this.currentEndTimeSlot = (60 * n5 + n4) / this.timeSlotInterval;
                        if (_isFINELoggable) {
                            _modelLogger.fine("end time slot before remainder-check:" + this.currentEndTimeSlot);
                        }
                        if ((n5 * 60 + n4) % this.timeSlotInterval > 0) {
                            bl = true;
                            ++this.currentEndTimeSlot;
                        } else if (dateTime4.equals((Object)dateTime3)) {
                            ++this.currentEndTimeSlot;
                        }
                        if (_isFINELoggable) {
                            _modelLogger.fine("end time slot after remainder-check:" + this.currentEndTimeSlot);
                        }
                    } else {
                        int n6 = (this.usersDayEnd.getHours() - this.usersDayStart.getHours()) * 60 + (this.usersDayEnd.getMinutes() - this.usersDayStart.getMinutes());
                        this.currentEndTimeSlot = n6 / this.timeSlotInterval;
                        if (n6 % this.timeSlotInterval > 0) {
                            ++this.currentEndTimeSlot;
                        }
                    }
                } else {
                    this.currentEndTimeSlot = 0;
                }
            } else {
                _modelLogger.fine("event start time is null");
                this.currentStartDaySlot = 0;
                this.currentStartTimeSlot = 0;
                this.currentEndDaySlot = 0;
                this.currentEndTimeSlot = 0;
            }
            if (_isFINELoggable) {
                _modelLogger.fine("Start[Day,Time] slot : [" + this.currentStartDaySlot + "," + this.currentStartTimeSlot + "]");
                _modelLogger.fine("End[Day,Time] slot : [" + this.currentEndDaySlot + "," + this.currentEndTimeSlot + "]");
            }
            this.maxEndDateTime = dateTime4;
            if (this.isSlotFilled[this.currentStartDaySlot][this.currentStartTimeSlot]) {
                n5 = this.eventDaySlotIndex[this.currentStartDaySlot][this.currentStartTimeSlot];
                n4 = this.eventTimeSlotIndex[this.currentStartDaySlot][this.currentStartTimeSlot];
                if (_isFINELoggable) {
                    _modelLogger.fine("tempSlot[Day,Time] : [" + n5 + "," + n4 + "]");
                }
                DateTime dateTime5 = this.maxEndDateTimeForSlot[n5][n4];
                if (_isFINELoggable) {
                    _modelLogger.fine("tempMaxEndDateTime :" + dateTime5.toISOString());
                }
                this.currentStartDaySlot = n5;
                this.currentStartTimeSlot = n4;
                if (dateTime4.after((Object)dateTime5)) {
                    if (_isFINELoggable) {
                        _modelLogger.fine("Existing slot already big enough.");
                    }
                    this.maxEndDateTime = dateTime4;
                } else {
                    if (_isFINELoggable) {
                        _modelLogger.fine("Expanding existing slot.");
                    }
                    this.maxEndDateTime = dateTime5;
                }
            } else {
                this.maxEndDateTime = dateTime4;
            }
            if (this.weekEventsList[this.currentStartDaySlot][this.currentStartTimeSlot] == null) {
                if (_isFINELoggable) {
                    _modelLogger.fine("initialize timeSlot ArrayList");
                }
                this.weekEventsList[this.currentStartDaySlot][this.currentStartTimeSlot] = new ArrayList();
            }
            this.weekEventsList[this.currentStartDaySlot][this.currentStartTimeSlot].add(sOCSEvent);
            this.updateSlots((VEvent)sOCSEvent);
        }
        _modelLogger.exiting(CLASS_NAME, "sortNonAllDayEvents()");
    }

    private void updateSlots(VEvent vEvent) {
        int n;
        DateTime dateTime = null;
        String string = null;
        try {
            dateTime = (DateTime)vEvent.getStartTime().clone();
            string = vEvent.getCalID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = this.currentStartDaySlot;
        int n3 = this.currentStartTimeSlot;
        int n4 = this.currentEndDaySlot;
        int n5 = 0;
        int n6 = n4 - n2;
        int n7 = 0;
        int n8 = 0;
        int n9 = this.currentStartDaySlot;
        int n10 = this.currentStartTimeSlot;
        DateTime dateTime2 = null;
        if (_isFINELoggable) {
            _modelLogger.fine("event spans " + n6 + " days, weekOverflow = " + this.weekOverflow);
        }
        if (n6 > 0 || this.weekOverflow) {
            n = (this.usersDayEnd.getHours() - this.usersDayStart.getHours()) * 60 + (this.usersDayEnd.getMinutes() - this.usersDayStart.getMinutes());
            n8 = n / this.timeSlotInterval;
            if (n % this.timeSlotInterval > 0) {
                ++n8;
            }
            n5 = n8;
            dateTime.setTime(23, 59, 59);
            dateTime2 = (DateTime)dateTime.clone();
        } else {
            n5 = this.currentEndTimeSlot;
            dateTime2 = this.maxEndDateTime;
        }
        if (_isFINELoggable) {
            _modelLogger.fine("relativeCalid is" + string);
        }
        do {
            n = n3;
            if (_isFINELoggable) {
                _modelLogger.fine("dayIndex :" + n2);
                _modelLogger.fine("timeEndIndex is" + n5);
                _modelLogger.fine("startSlot[Day,Time] : [" + n9 + "," + n10 + "]");
                _modelLogger.fine("spanEndDateTime :" + dateTime2);
            }
            if (_isFINELoggable) {
                _modelLogger.fine("<before loop> timeIndex is" + n3);
            }
            while (n3 < n5) {
                if (_isFINELoggable) {
                    _modelLogger.fine("timeIndex is" + n3);
                }
                this.isSlotFilled[n2][n3] = true;
                this.eventDaySlotIndex[n2][n3] = n9;
                this.eventTimeSlotIndex[n2][n3] = n10;
                this.maxEndDateTimeForSlot[n2][n3] = dateTime2;
                this.relativeCalendarId[n2][n3] = string;
                ++n3;
            }
            if (_isFINELoggable) {
                _modelLogger.fine("index is" + n7);
            }
            ++n7;
            n3 = 0;
            n9 = ++n2;
            n10 = n3;
            if (_isFINELoggable) {
                _modelLogger.fine("dayIndex is" + n2);
            }
            dateTime.add(5, 1);
            if (n7 == n6) {
                n5 = this.currentEndTimeSlot;
                dateTime2 = this.maxEndDateTime;
                if (this.weekEventsList[n2][n3] == null) {
                    this.weekEventsList[n2][n3] = new ArrayList();
                }
                this.weekEventsList[n2][n3].add(vEvent);
                continue;
            }
            if (n7 >= n6) continue;
            dateTime2 = (DateTime)dateTime.clone();
            if (this.weekEventsList[n2][n3] == null) {
                this.weekEventsList[n2][n3] = new ArrayList();
            }
            this.weekEventsList[n2][n3].add(vEvent);
        } while (n7 <= n6);
        _modelLogger.exiting(CLASS_NAME, "updateSlots()");
    }

    public CalendarComponent[] fetchAllDayEvents(int n) {
        ArrayList arrayList;
        _modelLogger.entering(CLASS_NAME, "fetchAllDayEvents()");
        if (_isFINELoggable) {
            _modelLogger.fine("fetching AllDay Events for slot" + n);
        }
        if ((arrayList = this.weekAllDayEventsList[n]) == null) {
            if (_isFINELoggable) {
                _modelLogger.fine("WeekViewEventsModel: fetchAllDayEvents:List is null... return");
            }
            _modelLogger.exiting(CLASS_NAME, "fetchAllDayEvents()");
            return null;
        }
        SOCSEvent[] sOCSEventArray = new SOCSEvent[arrayList.size()];
        _modelLogger.fine("return SortedAllDayEvents : done");
        _modelLogger.exiting(CLASS_NAME, "fetchAllDayEvents()");
        return (CalendarComponent[])arrayList.toArray(sOCSEventArray);
    }

    public boolean isConflictingAllDayEventSlot(int n) {
        ArrayList arrayList;
        _modelLogger.entering(CLASS_NAME, "isConflictingAllDayEventSlot()");
        if (_isFINELoggable) {
            _modelLogger.fine("checking conflicts for slot.. day=" + n);
        }
        if ((arrayList = this.weekAllDayEventsList[n]) == null || arrayList.size() == 0) {
            _modelLogger.fine("daySlot List is null... Empty.. return false");
            _modelLogger.exiting(CLASS_NAME, "isConflictingAllDayEventSlot()");
            return false;
        }
        if (arrayList.size() > 1) {
            _modelLogger.fine(" more than one event..return true");
            _modelLogger.exiting(CLASS_NAME, "isConflictingAllDayEventSlot()");
            return true;
        }
        _modelLogger.exiting(CLASS_NAME, "isConflictingAllDayEventSlot()");
        return false;
    }

    public boolean isEmptyAllDayEventSlot(int n) {
        ArrayList arrayList;
        _modelLogger.entering(CLASS_NAME, "isEmptyAllDayEventSlot()");
        if (_isFINELoggable) {
            _modelLogger.fine("checking emptiness for slot.. day=" + n);
        }
        if ((arrayList = this.weekAllDayEventsList[n]) == null || arrayList.size() == 0) {
            _modelLogger.fine("daySlot List is null... Empty.. return true");
            _modelLogger.exiting(CLASS_NAME, "isEmptyAllDayEventSlot()");
            return true;
        }
        _modelLogger.exiting(CLASS_NAME, "isEmptyAllDayEventSlot()");
        return false;
    }

    public int getNumAllDayEvents(int n) {
        ArrayList arrayList;
        _modelLogger.entering(CLASS_NAME, "getNumAllDayEvents()");
        if (_isFINELoggable) {
            _modelLogger.fine("checking numEvents for slot.. day=" + n);
        }
        if ((arrayList = this.weekAllDayEventsList[n]) == null || arrayList.size() == 0) {
            _modelLogger.exiting(CLASS_NAME, "getNumAllDayEvents()");
            return 0;
        }
        _modelLogger.exiting(CLASS_NAME, "getNumAllDayEvents()");
        return arrayList.size();
    }

    public CalendarComponent[] fetchNonAllDayEvents(int n, int n2) {
        _modelLogger.entering(CLASS_NAME, "fetchNonAllDayEvents()");
        if (_isFINELoggable) {
            _modelLogger.fine("fetching Events for slot.. day=" + n + "time=" + n2);
        }
        if (this.weekEventsList[n] == null) {
            _modelLogger.fine(" WeekEventsModel: fetchNonAllDayEvents : daySlot List is null... return");
            _modelLogger.exiting(CLASS_NAME, "fetchNonAllDayEvents()");
            return null;
        }
        ArrayList arrayList = this.weekEventsList[n][n2];
        if (arrayList == null || arrayList.size() == 0) {
            _modelLogger.fine(" WeekEventsModel: fetchNonAllDayEvents : List is null or empty..return");
            _modelLogger.exiting(CLASS_NAME, "fetchNonAllDayEvents()");
            return null;
        }
        SOCSEvent[] sOCSEventArray = new SOCSEvent[arrayList.size()];
        _modelLogger.fine(" return sortedNonAllDayEvents : done");
        _modelLogger.exiting(CLASS_NAME, "fetchNonAllDayEvents()");
        return (CalendarComponent[])arrayList.toArray(sOCSEventArray);
    }

    public boolean isConflictingNonAllDayEventSlot(int n, int n2) {
        _modelLogger.entering(CLASS_NAME, "isConflictingNonAllDayEventSlot()");
        if (_isFINELoggable) {
            _modelLogger.fine("checking conflicts for slot.. day=" + n + "time=" + n2);
        }
        if (this.weekEventsList[n] == null) {
            _modelLogger.fine("daySlot List is null... Empty.. return false");
            _modelLogger.exiting(CLASS_NAME, "isConflictingNonAllDayEventSlot()");
            return false;
        }
        ArrayList arrayList = this.weekEventsList[n][n2];
        if (arrayList == null || arrayList.size() == 0) {
            _modelLogger.fine(" timeSlot List is null or empty..return false");
            _modelLogger.exiting(CLASS_NAME, "isConflictingNonAllDayEventSlot()");
            return false;
        }
        if (arrayList.size() > 1) {
            _modelLogger.fine(" more than one event..return true");
            _modelLogger.exiting(CLASS_NAME, "isConflictingNonAllDayEventSlot()");
            return true;
        }
        _modelLogger.exiting(CLASS_NAME, "isConflictingNonAllDayEventSlot()");
        return false;
    }

    public boolean isEmptyNonAllDayEventSlot(int n, int n2) {
        _modelLogger.entering(CLASS_NAME, "isNonAllDayEventSlot()");
        boolean bl = this.isSlotFilled[n][n2];
        if (_isFINELoggable) {
            _modelLogger.fine("returning " + !bl);
        }
        return !bl;
    }

    public DateTime[][] getMaxEndTimeArray() {
        return this.maxEndDateTimeForSlot;
    }

    public boolean isNonAllDayEventSlot(int n, int n2) {
        _modelLogger.entering(CLASS_NAME, "isNonAllDayEventSlot()");
        if (_isFINELoggable) {
            _modelLogger.fine("checking event for slot.. day=" + n + "time=" + n2);
        }
        if (this.weekEventsList[n] == null) {
            _modelLogger.fine("daySlot List is null... Empty.. return false");
            _modelLogger.exiting(CLASS_NAME, "isNonAllDayEventSlot()");
            return false;
        }
        ArrayList arrayList = this.weekEventsList[n][n2];
        if (arrayList == null || arrayList.size() == 0) {
            _modelLogger.fine(" timeSlot List is null or empty..return false");
            _modelLogger.exiting(CLASS_NAME, "isNonAllDayEventSlot()");
            return false;
        }
        if (_isFINELoggable) {
            _modelLogger.fine(n + "," + n2 + "is not Empty..return true");
        }
        _modelLogger.exiting(CLASS_NAME, "isNonAllDayEventSlot()");
        return true;
    }

    public int getNumNonAllDayEvents(int n, int n2) {
        _modelLogger.entering(CLASS_NAME, "getNumNonAllDayEvents()");
        if (_isFINELoggable) {
            _modelLogger.fine("checking numEvents for slot.. day=" + n + "time=" + n2);
        }
        if (this.weekEventsList[n] == null) {
            _modelLogger.fine("daySlot List is null... Empty.. return 0");
            _modelLogger.exiting(CLASS_NAME, "getNumNonAllDayEvents()");
            return 0;
        }
        ArrayList arrayList = this.weekEventsList[n][n2];
        if (arrayList == null || arrayList.size() == 0) {
            _modelLogger.fine(" timeSlot List is null or empty..return true");
            _modelLogger.exiting(CLASS_NAME, "getNumNonAllDayEvents()");
            return 0;
        }
        if (_isFINELoggable) {
            _modelLogger.fine("numEvents is.." + arrayList.size());
        }
        _modelLogger.exiting(CLASS_NAME, "getNumNonAllDayEvents()");
        return arrayList.size();
    }

    private String[] calculateConflictIndex(CalendarComponent[] calendarComponentArray) {
        int n = calendarComponentArray.length;
        String[] stringArray = new String[n];
        if (n < 2) {
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "false";
            }
            return stringArray;
        }
        DateTime dateTime = null;
        DateTime dateTime2 = null;
        DateTime dateTime3 = null;
        DateTime dateTime4 = null;
        block3: for (int i = 0; i < n; ++i) {
            try {
                dateTime = calendarComponentArray[i].getStart();
                dateTime2 = calendarComponentArray[i].getEnd();
                stringArray[i] = "false";
                for (int j = 0; j < n; ++j) {
                    if (i == j) continue;
                    dateTime3 = calendarComponentArray[j].getStart();
                    dateTime4 = calendarComponentArray[j].getEnd();
                    if (!dateTime3.equals((Object)dateTime) && (!dateTime3.after((Object)dateTime) || !dateTime3.before((Object)dateTime2)) && (!dateTime.after((Object)dateTime3) || !dateTime.before((Object)dateTime4))) continue;
                    stringArray[i] = "true";
                    continue block3;
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringArray;
    }

    public boolean isOwnedCalendarSpanningSlot() {
        return this.isOwnedCalendarSpanningSlot;
    }

    static {
        _modelLogger = UWCLogger.getLogger("uwc.common.model");
        WeekViewEventsModel.setLoggableFlags();
    }
}

