/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.comclient.calendar.socs.SOCSOrganizer;
import com.sun.comclient.calendar.socs.SOCSUtils;
import com.sun.uwc.calclient.model.CalendarBaseModel;
import com.sun.uwc.calclient.model.UWCCalendar;
import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.model.UWCModelControlException;
import com.sun.uwc.common.model.UserPreferencesModel;
import com.sun.uwc.common.util.UWCConstants;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InvitationsModel
extends DefaultModel
implements RetrievingModel,
RequestParticipant {
    public static final String FIELD_INVITATION_DATE = "startDate";
    public static final String FIELD_INVITATION_TIME = "time";
    public static final String FIELD_TITLE = "Title";
    public static final String FIELD_ESC_TITLE = "EscTitle";
    public static final String FIELD_CALID = "calid";
    public static final String FIELD_EVENT_UID = "eventUid";
    public static final String FIELD_EVENT_RID = "eventRid";
    public static final String FIELD_LOCATION = "Location";
    public static final String FIELD_IS_RECURRING = "IsRecurring";
    public static final String FIELD_IS_REMINDING = "IsReminding";
    public static final String FIELD_IS_PUBLIC = "IsPublic";
    public static final String FIELD_ORGANIZER = "Organizer";
    public static final String FIELD_CALNAME = "calname";
    public static final String FIELD_EVENTURL = "eventurl";
    public static final String FIELD_MODIFIABLE = "modifiable";
    public static final String FIELD_ORG_EMAIL = "orgEmail";
    public static final String FIELD_USE_WEBMAIL = "useWebmail";
    public static final String FIELD_MAIL_COMPOSE_URL = "composeUrl";
    private RequestContext _reqCtx = null;
    private static Logger _invitationsModelLogger = null;
    private static final String CLASS_NAME = "InvitationsModel";
    private static String EDIT_EVENT_URL = "../calclient/ViewEvent?update=true&";
    private static String VIEW_EVENT_URL = "../calclient/ViewEvent?";
    private static String EVENT_ID_PARAM = "eventid=";
    private static String CALID_PARAM = "calid=";
    private static String EVENT_RID_PARAM = "rid=";
    private CalendarBaseModel calendarBaseModelObject = null;
    private UserPreferencesModel _userPrefsModel = null;
    private ArrayList calids = null;
    private ArrayList mailids = null;
    private ArrayList invitations = null;
    private String _originalCtxName = null;
    private String dateFormat = null;
    private String dateDelimiter = null;
    private String mailHandler = null;
    private String timeFormat = null;
    private String _userId = null;
    private String usersTimeFormatPref = null;
    private String[] ownedCalIds = null;
    private HashMap calendars = null;
    private boolean anonymous = false;
    private boolean isMailServiceEnabled = false;
    private int _inviteCount;
    private int _currCtxInviteCount;
    public static final String DOUBLE_QUOT = "&#92;&#34;";
    public static final String SINGLE_QUOT = "&#92;&#39;";
    public static final String SLASH_ENCODING = "&#92;&#92;";
    public static final String HYPHEN_ENCODING = "&#92;&#45;";

    public InvitationsModel() {
        _invitationsModelLogger.entering(CLASS_NAME, "InvitationsModel()");
        this.setUseDefaultValues(false);
        this.getCalendarBaseModel();
        this.getUserPrefsModel();
        _invitationsModelLogger.exiting(CLASS_NAME, "InvitationsModel()");
    }

    public InvitationsModel(String string) {
        super(string);
        _invitationsModelLogger.entering(CLASS_NAME, "InvitationsModel( " + string + ")");
        this.setUseDefaultValues(false);
        this.getCalendarBaseModel();
        this.getUserPrefsModel();
        _invitationsModelLogger.exiting(CLASS_NAME, "InvitationsModel( " + string + ")");
    }

    public void setStartTime(DateTime dateTime) {
        _invitationsModelLogger.entering(CLASS_NAME, "setStartTime()");
        this.calendarBaseModelObject.setStartTime(dateTime);
        _invitationsModelLogger.exiting(CLASS_NAME, "setStartTime()");
    }

    public void setEndTime(DateTime dateTime) {
        _invitationsModelLogger.entering(CLASS_NAME, "setEndTime()");
        this.calendarBaseModelObject.setEndTime(dateTime);
        _invitationsModelLogger.exiting(CLASS_NAME, "setEndTime()");
    }

    public void setTimeFormat(String string) {
        _invitationsModelLogger.entering(CLASS_NAME, "setTimeFormat()");
        this.usersTimeFormatPref = string;
        _invitationsModelLogger.entering(CLASS_NAME, "setTimeFormat()");
    }

    public void setDateFormat(String string) {
        _invitationsModelLogger.entering(CLASS_NAME, "setDateFormat()");
        this.dateFormat = string;
        _invitationsModelLogger.entering(CLASS_NAME, "setDateFormat()");
    }

    public void setDateDelimiter(String string) {
        _invitationsModelLogger.entering(CLASS_NAME, "setDateDelimiter()");
        this.dateDelimiter = string;
        _invitationsModelLogger.entering(CLASS_NAME, "setDateDelimiter()");
    }

    public void setMailHandler(String string) {
        _invitationsModelLogger.entering(CLASS_NAME, "setMailHandler()");
        this.mailHandler = string;
        _invitationsModelLogger.entering(CLASS_NAME, "setMailHandler()");
    }

    public void setAnonymous(boolean bl) {
        _invitationsModelLogger.entering(CLASS_NAME, "setAnonymous()");
        this.calendarBaseModelObject.setAnonymous(bl);
        this.anonymous = bl;
        _invitationsModelLogger.exiting(CLASS_NAME, "setAnonymous()");
    }

    public void clearAllCalids() {
        _invitationsModelLogger.entering(CLASS_NAME, "clearAllCalids()");
        this.calendarBaseModelObject.removeAllCalids();
        if (this.calids != null) {
            this.calids.clear();
        }
        _invitationsModelLogger.exiting(CLASS_NAME, "clearAllCalids()");
    }

    public void addCalidList(ArrayList arrayList) {
        _invitationsModelLogger.entering(CLASS_NAME, "addCalidList()");
        if (arrayList != null & arrayList.size() > 0) {
            this.calendarBaseModelObject.addCalid(arrayList);
            if (this.calids == null) {
                this.calids = new ArrayList();
            }
            this.calids.addAll(arrayList);
        }
        _invitationsModelLogger.exiting(CLASS_NAME, "addCalidList()");
    }

    public int getCount() {
        _invitationsModelLogger.entering(CLASS_NAME, "getCount()");
        _invitationsModelLogger.exiting(CLASS_NAME, "getCount()");
        return this._inviteCount;
    }

    public int getCurrentCtxCount() {
        _invitationsModelLogger.entering(CLASS_NAME, "getCurrentCtxCount()");
        _invitationsModelLogger.exiting(CLASS_NAME, "getCurrentCtxCount()");
        return this._currCtxInviteCount;
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        _invitationsModelLogger.entering(CLASS_NAME, "execute()");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.FETCH_INVITATIONS_CONTEXT;
        if (string != null && string.equals(CalendarExecutionModelContext.FETCH_INVITATIONS_CONTEXT)) {
            this.invitations = this.fetchInvitations();
        }
        _invitationsModelLogger.exiting(CLASS_NAME, "execute()");
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        _invitationsModelLogger.entering(CLASS_NAME, "retrieve()");
        if (this._userId == null) {
            this._userId = UWCUserHelper.getUID(this._reqCtx);
            if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                _invitationsModelLogger.info("retrieve() for User: " + this._userId);
            }
        }
        if (this.usersTimeFormatPref == null) {
            this.usersTimeFormatPref = "12";
        }
        if (this.dateFormat == null) {
            this.dateFormat = UWCConstants.dateFormatValues[0];
        }
        if (this.dateDelimiter == null) {
            this.dateDelimiter = "/";
        }
        this.isMailServiceEnabled = UWCUserHelper.isMailEnabled(this._reqCtx);
        this.clear();
        if (_invitationsModelLogger.isLoggable(Level.INFO)) {
            _invitationsModelLogger.info("dumpRecordValues before processing!");
            this.dumpRecordValues();
        }
        if (this.invitations != null && this.invitations.size() > 0) {
            for (int i = 0; i < this.invitations.size(); ++i) {
                String string;
                this.appendRow();
                VEvent vEvent = (VEvent)this.invitations.get(i);
                String string2 = null;
                String string3 = null;
                SOCSOrganizer sOCSOrganizer = null;
                String string4 = null;
                String string5 = null;
                DateTime dateTime = null;
                DateTime dateTime2 = null;
                DateTime dateTime3 = null;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                Object var15_15 = null;
                Object var16_16 = null;
                Object var17_17 = null;
                Object var18_18 = null;
                Object var19_19 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                String string10 = null;
                String string11 = null;
                String string12 = null;
                boolean bl4 = false;
                boolean bl5 = false;
                UWCCalendar uWCCalendar = null;
                Object var30_30 = null;
                String string13 = null;
                try {
                    string2 = vEvent.getSummary();
                    string4 = vEvent.getID();
                    string3 = vEvent.getLocation();
                    sOCSOrganizer = (SOCSOrganizer)vEvent.getOrganizer();
                    dateTime2 = vEvent.getStartTime();
                    dateTime3 = vEvent.getEndTime();
                    bl = vEvent.isRecurring();
                    if (vEvent.getRecurrenceRules() != null) {
                        bl = true;
                    }
                    bl2 = vEvent.hasAlarm();
                    bl3 = vEvent.isPublic();
                    if (vEvent.isRecurring()) {
                        dateTime = vEvent.getRecurrenceID();
                        string5 = dateTime.toISOString();
                    } else if (vEvent.getRecurrenceRules() != null) {
                        string5 = "0";
                    }
                }
                catch (OperationNotSupportedException operationNotSupportedException) {
                    string2 = null;
                    string4 = null;
                    string3 = null;
                    sOCSOrganizer = null;
                    dateTime2 = null;
                    dateTime3 = null;
                    bl = false;
                    bl2 = false;
                    bl3 = false;
                    dateTime = null;
                    string5 = null;
                }
                catch (CalendarComponentException calendarComponentException) {
                    if (_invitationsModelLogger.isLoggable(Level.WARNING)) {
                        _invitationsModelLogger.warning("Operations on Event failed: " + calendarComponentException.getMessage());
                    }
                    string2 = null;
                    string4 = null;
                    string3 = null;
                    sOCSOrganizer = null;
                    dateTime2 = null;
                    dateTime3 = null;
                    bl = false;
                    bl2 = false;
                    bl3 = false;
                    dateTime = null;
                    string5 = null;
                }
                if (dateTime2 != null) {
                    string8 = UWCUtils.getDisplayableDate(this._reqCtx, dateTime2, this.dateFormat, this.dateDelimiter);
                    string9 = this.usersTimeFormatPref.equals(UWCConstants.timeFormatValues[0]) ? UWCUtils.getLocaleTimePerPattern(this._reqCtx, dateTime2, "uwc-calclient-view-invitations-timeDisplayPatten12hr", 3) : UWCUtils.getLocaleTimePerPattern(this._reqCtx, dateTime2, "uwc-calclient-view-invitations-timeDisplayPatten24hr", 3);
                    if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                        _invitationsModelLogger.info("Formatted date to display: " + string8);
                    }
                    this.setValue(FIELD_INVITATION_DATE, string8);
                }
                if (string2 != null) {
                    this.setValue(FIELD_TITLE, string2);
                    this.setValue(FIELD_ESC_TITLE, InvitationsModel.escapeData(string2));
                } else {
                    this.setValue(FIELD_TITLE, UWCUserHelper.getLocalizedStringLabel(this._reqCtx, "uwc-calclient-events-UntitledEventLabel", "UnTitled Event"));
                    this.setValue(FIELD_ESC_TITLE, UWCUserHelper.getLocalizedStringLabel(this._reqCtx, "uwc-calclient-events-UntitledEventLabel", "UnTitled Event"));
                }
                if (string4 != null) {
                    if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                        _invitationsModelLogger.info("ID is: " + string4);
                    }
                    this.setValue(FIELD_EVENT_UID, string4);
                }
                if (dateTime3 != null) {
                    string10 = this.usersTimeFormatPref.equals(UWCConstants.timeFormatValues[0]) ? UWCUtils.getLocaleTimePerPattern(this._reqCtx, dateTime3, "uwc-calclient-view-invitations-timeDisplayPatten12hr", 3) : UWCUtils.getLocaleTimePerPattern(this._reqCtx, dateTime3, "uwc-calclient-view-invitations-timeDisplayPatten24hr", 3);
                }
                if (string9 != null && string10 != null) {
                    if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                        _invitationsModelLogger.info("Formatted invitation time to display: " + string9 + " - " + string10);
                    }
                    this.setValue(FIELD_INVITATION_TIME, string9 + " - " + string10);
                }
                this.setValue(FIELD_IS_REMINDING, bl2 ? "true" : "false");
                this.setValue(FIELD_IS_RECURRING, bl ? "true" : "false");
                this.setValue(FIELD_IS_PUBLIC, bl3 ? "true" : "false");
                if (string3 != null) {
                    this.setValue(FIELD_LOCATION, string3);
                } else {
                    this.setValue(FIELD_LOCATION, "None");
                }
                if (sOCSOrganizer != null) {
                    string11 = sOCSOrganizer.getCommonName();
                    string12 = sOCSOrganizer.getEmail();
                    if (string11 == null) {
                        string11 = sOCSOrganizer.getValue();
                    }
                }
                if (string11 != null) {
                    this.setValue(FIELD_ORGANIZER, string11);
                }
                if (string12 != null) {
                    this.setValue(FIELD_ORG_EMAIL, string12);
                }
                if (this.isMailServiceEnabled) {
                    if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                        _invitationsModelLogger.info("Mail Service is Enabled for User!");
                    }
                    if (this.mailHandler != null && this.mailHandler.equalsIgnoreCase("uc")) {
                        if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                            _invitationsModelLogger.info("Mail Handler: " + this.mailHandler);
                        }
                        if ((string = UWCApplicationHelper.getMailComposeURL()) != null && string.length() > 0) {
                            this.setValue(FIELD_USE_WEBMAIL, "true");
                            this.setValue(FIELD_MAIL_COMPOSE_URL, string + "&argv=popupLevel=0");
                        }
                    } else {
                        if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                            _invitationsModelLogger.info("Mail Handler: " + this.mailHandler);
                        }
                        this.setValue(FIELD_USE_WEBMAIL, "false");
                    }
                } else {
                    if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                        _invitationsModelLogger.info("Mail Service is Not Enabled for User!");
                    }
                    this.setValue(FIELD_USE_WEBMAIL, "false");
                }
                if (this.calendars == null) {
                    this.calendars = this.calendarBaseModelObject.getCalendars();
                }
                string = null;
                SOCSCalendar sOCSCalendar = null;
                string7 = "";
                try {
                    string = vEvent.getCalID();
                    uWCCalendar = (UWCCalendar)this.calendars.get(string);
                    if (uWCCalendar != null) {
                        sOCSCalendar = (SOCSCalendar)uWCCalendar.getCalendar();
                    }
                    if (sOCSCalendar != null) {
                        string7 = sOCSCalendar.getRelativeCalId();
                    }
                }
                catch (OperationNotSupportedException operationNotSupportedException) {
                    string7 = "";
                }
                catch (CalendarComponentException calendarComponentException) {
                    string7 = "";
                }
                catch (Exception exception) {
                    if (_invitationsModelLogger.isLoggable(Level.WARNING)) {
                        _invitationsModelLogger.warning("Exception: " + exception.getMessage());
                    }
                    string7 = "";
                }
                if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                    _invitationsModelLogger.info("CalID of invitation: " + string7);
                }
                this.setValue(FIELD_CALID, string7);
                try {
                    bl4 = UWCUserHelper.hasCalendarPermission(uWCCalendar, this._userId, "c", "w");
                }
                catch (UWCException uWCException) {
                    if (_invitationsModelLogger.isLoggable(Level.WARNING)) {
                        _invitationsModelLogger.warning("Failed to verify the permissions of the calendar: " + string7);
                    }
                    bl4 = false;
                }
                if (!bl4) {
                    if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                        _invitationsModelLogger.info("Event Calendar " + string7 + " does not belong to user nor does it have write permission");
                    }
                    if (uWCCalendar != null) {
                        try {
                            string13 = uWCCalendar.getCalendar().getDisplayName();
                        }
                        catch (CalendarException calendarException) {
                            string13 = null;
                        }
                        catch (OperationNotSupportedException operationNotSupportedException) {
                            string13 = null;
                        }
                    } else if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                        _invitationsModelLogger.info("Calendar object not obtained for: " + string7);
                    }
                    if (string13 != null) {
                        this.setValue(FIELD_CALNAME, UWCUtils.getCalendarNameToDisplay(string7, string13));
                    }
                    bl5 = false;
                    this.setValue(FIELD_MODIFIABLE, "false");
                } else {
                    if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                        _invitationsModelLogger.info("Event calendar " + string7 + " either belongs to user or has write permission");
                    }
                    bl5 = true;
                    this.setValue(FIELD_MODIFIABLE, "true");
                }
                string6 = sOCSOrganizer != null ? (SOCSUtils.isUserOrganizer((String)string7, (Organizer)sOCSOrganizer) ? EDIT_EVENT_URL + EVENT_ID_PARAM + string4 + "&" + CALID_PARAM + string7 : VIEW_EVENT_URL + EVENT_ID_PARAM + string4 + "&" + CALID_PARAM + string7) : VIEW_EVENT_URL + EVENT_ID_PARAM + string4 + "&" + CALID_PARAM + string7;
                if (string5 != null) {
                    if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                        _invitationsModelLogger.info("RID is: " + string5);
                    }
                    this.setValue(FIELD_EVENT_RID, string5);
                    string6 = string6 + "&" + EVENT_RID_PARAM + string5;
                }
                if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                    _invitationsModelLogger.info("Final constructed eventURL is: " + string6);
                }
                string6 = string6 + "&" + "fromInvitation=true";
                this.setValue(FIELD_EVENTURL, string6);
            }
            if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                _invitationsModelLogger.info("dumpRecordValues after processing!");
                this.dumpRecordValues();
            }
        } else if (_invitationsModelLogger.isLoggable(Level.INFO)) {
            _invitationsModelLogger.info("No Invitations obtained!");
        }
        this.beforeFirst();
        _invitationsModelLogger.exiting(CLASS_NAME, "retrieve()");
        return null;
    }

    private ArrayList fetchInvitations() {
        _invitationsModelLogger.entering(CLASS_NAME, "fetchInvitations()");
        Object var1_1 = null;
        ArrayList arrayList = null;
        this._inviteCount = 0;
        if (_invitationsModelLogger.isLoggable(Level.INFO)) {
            _invitationsModelLogger.info("Executing FETCH_INVITATIONS_CONTEXT in CBM");
        }
        CalendarExecutionModelContext calendarExecutionModelContext = new CalendarExecutionModelContext(CalendarExecutionModelContext.FETCH_INVITATIONS_CONTEXT);
        this.calendarBaseModelObject.setEventsFilter("needs-action");
        try {
            this.calendarBaseModelObject.execute((ModelExecutionContext)calendarExecutionModelContext);
        }
        catch (ModelControlException modelControlException) {
            if (_invitationsModelLogger.isLoggable(Level.WARNING)) {
                _invitationsModelLogger.warning("Failed to execute context in CBM: " + ((UWCModelControlException)modelControlException).getMessage());
            }
            return null;
        }
        if (_invitationsModelLogger.isLoggable(Level.INFO)) {
            _invitationsModelLogger.info("Retrieving FETCH_INVITATIONS_CONTEXT in CBM");
        }
        try {
            this.calendarBaseModelObject.retrieve((ModelExecutionContext)calendarExecutionModelContext);
            this._inviteCount = this.calendarBaseModelObject.getNumInvitations();
        }
        catch (ModelControlException modelControlException) {
            if (_invitationsModelLogger.isLoggable(Level.WARNING)) {
                _invitationsModelLogger.warning("Failed to retrieve context in CBM: " + ((UWCModelControlException)modelControlException).getMessage());
            }
            return null;
        }
        if (_invitationsModelLogger.isLoggable(Level.INFO)) {
            _invitationsModelLogger.info("Obtaining invitations from CBM");
        }
        if ((arrayList = this.calendarBaseModelObject.getInvitationEvents()) != null && arrayList.size() > 0) {
            this._currCtxInviteCount = arrayList.size();
            if (_invitationsModelLogger.isLoggable(Level.INFO)) {
                _invitationsModelLogger.info("Obtained Invitations!");
            }
        } else {
            this._currCtxInviteCount = 0;
        }
        _invitationsModelLogger.exiting(CLASS_NAME, "fetchInvitations()");
        return arrayList;
    }

    public void setRequestContext(RequestContext requestContext) {
        _invitationsModelLogger.entering(CLASS_NAME, "setRequestContext()");
        this._reqCtx = requestContext;
        _invitationsModelLogger.exiting(CLASS_NAME, "setRequestContext()");
    }

    private CalendarBaseModel getCalendarBaseModel() {
        _invitationsModelLogger.entering(CLASS_NAME, "getCalendarBaseModel()");
        if (this.calendarBaseModelObject == null) {
            this.calendarBaseModelObject = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        }
        _invitationsModelLogger.exiting(CLASS_NAME, "getCalendarBaseModel()");
        return this.calendarBaseModelObject;
    }

    private UserPreferencesModel getUserPrefsModel() {
        _invitationsModelLogger.entering(CLASS_NAME, "getUserPrefsModel()");
        if (this._userPrefsModel == null) {
            this._userPrefsModel = UWCUserHelper.getUserPrefModel(this._reqCtx);
        }
        _invitationsModelLogger.exiting(CLASS_NAME, "getUserPrefsModel()");
        return this._userPrefsModel;
    }

    private void dumpRecordValues() {
        _invitationsModelLogger.entering(CLASS_NAME, "dumpRecordValues()");
        Map map = null;
        int n = this.getNumRows();
        _invitationsModelLogger.info("Total Number of records: " + n);
        for (int i = 0; i < n; ++i) {
            this.setRowIndex(i);
            map = this.getValueMap(i);
            if (map != null) {
                if (map.isEmpty()) {
                    _invitationsModelLogger.info("Map is empty for row: " + i);
                    continue;
                }
                Set set = map.keySet();
                String[] stringArray = UWCUtils.getStringArray(set.toArray());
                if (stringArray == null || stringArray.length <= 0) continue;
                _invitationsModelLogger.info("Key-Value Pairs for record: " + i);
                for (int j = 0; j < stringArray.length; ++j) {
                    _invitationsModelLogger.info("Key: " + stringArray[j] + " Value: " + (String)this.getValue(stringArray[j]));
                }
                continue;
            }
            _invitationsModelLogger.info("No Value map present for the row: " + i);
        }
        _invitationsModelLogger.exiting(CLASS_NAME, "dumpRecordValues()");
    }

    public static String escapeData(String string) {
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\'': {
                    nonSyncStringBuffer.append(SINGLE_QUOT);
                    continue block6;
                }
                case '\"': {
                    nonSyncStringBuffer.append(DOUBLE_QUOT);
                    continue block6;
                }
                case '\\': {
                    nonSyncStringBuffer.append(SLASH_ENCODING);
                    continue block6;
                }
                case '-': {
                    nonSyncStringBuffer.append(HYPHEN_ENCODING);
                    continue block6;
                }
                default: {
                    nonSyncStringBuffer.append(c);
                }
            }
        }
        return nonSyncStringBuffer.toString();
    }

    static {
        _invitationsModelLogger = UWCLogger.getLogger("uwc.calclient.model");
    }
}

