/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.FreeBusy;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.PropertiesException;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.comclient.calendar.socs.SOCSFreeBusy;
import com.sun.uwc.calclient.model.CalendarBaseModel;
import com.sun.uwc.calclient.model.UWCCalendar;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.model.UWCModelControlException;
import com.sun.uwc.common.util.UWCConstants;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FreeBusyModel
extends DefaultModel
implements RequestParticipant,
RetrievingModel {
    public static final String FIELD_NAME_TO_DISPLAY = "calNameToDisplay";
    public static final String FIELD_START_DATE_DAY = "startday";
    public static final String FIELD_START_DATE_MONTH = "startmonth";
    public static final String FIELD_START_DATE_YEAR = "startyear";
    public static final String FIELD_START_TIME_HOURS = "starthour";
    public static final String FIELD_START_TIME_MINUTES = "startminutes";
    public static final String FIELD_DURATION_HOURS = "durationHours";
    public static final String FIELD_DURATION_MINUTES = "durationMinutes";
    private RequestContext _reqCtx = null;
    private CalendarBaseModel calendarBaseModelObject = null;
    private HashMap calidswithFBInfo = null;
    private ArrayList calids = null;
    private ArrayList mailids = null;
    private Hashtable calIdsWithNames = null;
    private static Logger _fbModelLogger = null;
    private static final String CLASS_NAME = "FreeBusyModel";
    private DateTime start = null;
    private DateTime end = null;
    private Duration splitHour = null;
    private Duration duration = null;
    private TimeZone timezone = null;
    private String usersTimeFormatPref = null;
    private boolean anonymous = false;

    public FreeBusyModel() {
        _fbModelLogger.entering(CLASS_NAME, "FreeBusyModel()");
        this.getCalendarBaseModel();
        _fbModelLogger.exiting(CLASS_NAME, "FreeBusyModel()");
    }

    public FreeBusyModel(String string) {
        super(string);
        _fbModelLogger.entering(CLASS_NAME, "FreeBusyModel(name)");
        this.getCalendarBaseModel();
        _fbModelLogger.exiting(CLASS_NAME, "FreeBusyModel(name)");
    }

    public void setStartTime(DateTime dateTime) {
        _fbModelLogger.entering(CLASS_NAME, "setStartTime()");
        this.calendarBaseModelObject.setStartTime(dateTime);
        this.start = dateTime;
        _fbModelLogger.exiting(CLASS_NAME, "setStartTime()");
    }

    public void setDuration(Duration duration) {
        _fbModelLogger.entering(CLASS_NAME, "setDuration()");
        this.duration = duration;
        _fbModelLogger.entering(CLASS_NAME, "setDuration()");
    }

    public void setTimeFormat(String string) {
        _fbModelLogger.entering(CLASS_NAME, "setTimeFormat()");
        this.usersTimeFormatPref = string;
        _fbModelLogger.entering(CLASS_NAME, "setTimeFormat()");
    }

    public void setEndTime(DateTime dateTime) {
        _fbModelLogger.entering(CLASS_NAME, "setEndTime()");
        this.calendarBaseModelObject.setEndTime(dateTime);
        this.end = dateTime;
        _fbModelLogger.exiting(CLASS_NAME, "setEndTime()");
    }

    public void setAnonymous(boolean bl) {
        _fbModelLogger.entering(CLASS_NAME, "setAnonymous()");
        this.calendarBaseModelObject.setAnonymous(bl);
        this.anonymous = bl;
        _fbModelLogger.exiting(CLASS_NAME, "setAnonymous()");
    }

    public void setInterval(Duration duration) {
        _fbModelLogger.entering(CLASS_NAME, "setInterval()");
        this.splitHour = duration;
        _fbModelLogger.exiting(CLASS_NAME, "setInterval()");
    }

    public void setTimeZone(TimeZone timeZone) {
        _fbModelLogger.entering(CLASS_NAME, "setTimeZone()");
        this.timezone = timeZone;
        _fbModelLogger.exiting(CLASS_NAME, "setTimeZone()");
    }

    public void setFetchBusyOnly() {
        _fbModelLogger.entering(CLASS_NAME, "setFetchBusyOnly()");
        _fbModelLogger.exiting(CLASS_NAME, "setFetchBusyOnly()");
    }

    public void clearAllCalids() {
        _fbModelLogger.entering(CLASS_NAME, "clearAllCalids()");
        this.calendarBaseModelObject.removeAllCalids();
        if (this.calids != null) {
            this.calids.clear();
        }
        _fbModelLogger.exiting(CLASS_NAME, "clearAllCalids()");
    }

    public void addCalidList(ArrayList arrayList) {
        _fbModelLogger.entering(CLASS_NAME, "addCalidList()");
        if (arrayList != null & arrayList.size() > 0) {
            this.calendarBaseModelObject.addCalid(arrayList);
            if (this.calids == null) {
                this.calids = new ArrayList();
            }
            this.calids.addAll(arrayList);
        }
        _fbModelLogger.exiting(CLASS_NAME, "addCalidList()");
    }

    public void setCalIdsWithDisplayName(Hashtable hashtable) {
        _fbModelLogger.entering(CLASS_NAME, "setCalIdsWithDisplayName()");
        this.calIdsWithNames = hashtable;
        _fbModelLogger.exiting(CLASS_NAME, "setCalIdsWithDisplayName()");
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        _fbModelLogger.entering(CLASS_NAME, "execute()");
        String string = null;
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.FETCH_FREEBUSY_CONTEXT;
        if ((this.calids == null || this.calids.isEmpty()) && (this.mailids == null || this.mailids.isEmpty())) {
            throw new UWCModelControlException(54);
        }
        if (this.start == null) {
            this.start = this.constructStartTime();
            if (this.start == null) {
                this.start = new DateTime();
                this.start.setTime(0, 0, 0);
            }
            this.setStartTime(this.start);
            if (_fbModelLogger.isLoggable(Level.INFO)) {
                _fbModelLogger.info("Start Time: " + this.start.toISOString());
            }
        }
        if (this.end == null) {
            this.end = this.constructEndTime();
            if (this.end == null) {
                this.end = (DateTime)this.start.clone();
                this.end.setTime(23, 59, 59);
            }
            this.setEndTime(this.end);
            if (_fbModelLogger.isLoggable(Level.INFO)) {
                _fbModelLogger.info("End Time: " + this.end.toISOString());
            }
        }
        CalendarExecutionModelContext calendarExecutionModelContext = new CalendarExecutionModelContext(string);
        try {
            this.calendarBaseModelObject.execute((ModelExecutionContext)calendarExecutionModelContext);
        }
        catch (ModelControlException modelControlException) {
            throw (UWCModelControlException)modelControlException;
        }
        arrayList = this.calendarBaseModelObject.getFreeBusy();
        arrayList2 = this.calendarBaseModelObject.getFreeBusyCalids();
        HashMap hashMap = this.calendarBaseModelObject.getCalendars();
        this.calidswithFBInfo = this.associateCalIdFBInfo(arrayList, arrayList2);
        if (this.calIdsWithNames == null || this.calIdsWithNames.size() <= 0) {
            String string2 = null;
            UWCCalendar uWCCalendar = null;
            String string3 = null;
            if (this.calIdsWithNames == null) {
                this.calIdsWithNames = new Hashtable();
            }
            for (int i = 0; i < this.calids.size(); ++i) {
                uWCCalendar = null;
                string3 = null;
                string2 = (String)this.calids.get(i);
                uWCCalendar = (UWCCalendar)hashMap.get(string2);
                if (uWCCalendar != null) {
                    try {
                        string3 = uWCCalendar.getCalendar().getDisplayName();
                    }
                    catch (CalendarException calendarException) {
                        string3 = null;
                    }
                    catch (OperationNotSupportedException operationNotSupportedException) {
                        string3 = null;
                    }
                } else {
                    string3 = null;
                }
                if (_fbModelLogger.isLoggable(Level.INFO)) {
                    _fbModelLogger.info(string3);
                    _fbModelLogger.info(string2);
                    _fbModelLogger.info(UWCUtils.getCalendarNameToDisplay(string2, string3));
                }
                this.calIdsWithNames.put(string2, UWCUtils.getCalendarNameToDisplay(string2, string3));
            }
        }
        _fbModelLogger.exiting(CLASS_NAME, "execute()");
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        _fbModelLogger.entering(CLASS_NAME, "retrieve()");
        String string = null;
        String string2 = null;
        FreeBusy[] freeBusyArray = null;
        ArrayList<DateTime> arrayList = null;
        ArrayList<DateTime> arrayList2 = null;
        ArrayList<DateTime> arrayList3 = null;
        ArrayList<DateTime> arrayList4 = null;
        String[] stringArray = null;
        Set set = null;
        this.clear();
        if (this.calidswithFBInfo != null) {
            set = this.calidswithFBInfo.keySet();
            if (set != null) {
                stringArray = UWCUtils.getStringArray(set.toArray());
            }
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = stringArray[i];
                    string = this.getCalNameToDisplay(string2);
                    freeBusyArray = (FreeBusy[])this.calidswithFBInfo.get(string2);
                    if (freeBusyArray != null) {
                        if (_fbModelLogger.isLoggable(Level.INFO)) {
                            _fbModelLogger.info("FB Info obtained for calendar: " + string);
                        }
                        arrayList = new ArrayList<DateTime>();
                        arrayList2 = new ArrayList<DateTime>();
                        arrayList3 = new ArrayList<DateTime>();
                        arrayList4 = new ArrayList<DateTime>();
                        for (int j = 0; j < freeBusyArray.length; ++j) {
                            if (_fbModelLogger.isLoggable(Level.INFO)) {
                                _fbModelLogger.info("FB-Type instance: " + freeBusyArray[j].toString());
                            }
                            if (freeBusyArray[j].getFBtype().equalsIgnoreCase("BUSY")) {
                                if (_fbModelLogger.isLoggable(Level.INFO)) {
                                    _fbModelLogger.info("FB-Type BUSY instance START: " + freeBusyArray[j].getStart().toISOString());
                                }
                                arrayList.add(freeBusyArray[j].getStart());
                                if (_fbModelLogger.isLoggable(Level.INFO)) {
                                    _fbModelLogger.info("FB-Type BUSY instance END: " + freeBusyArray[j].getEnd().toISOString());
                                }
                                arrayList2.add(freeBusyArray[j].getEnd());
                                continue;
                            }
                            arrayList3.add(freeBusyArray[j].getStart());
                            arrayList4.add(freeBusyArray[j].getEnd());
                        }
                        this.writeRecord(string, arrayList, arrayList2, arrayList3, arrayList4, true);
                        continue;
                    }
                    this.writeRecord(string, null, null, null, null, false);
                }
            }
        } else {
            if (_fbModelLogger.isLoggable(Level.INFO)) {
                _fbModelLogger.info("No FB information at all for any of calids or e-mail ids");
            }
            this.writeAllRecordsWithNoInfo();
        }
        if (_fbModelLogger.isLoggable(Level.INFO)) {
            _fbModelLogger.info("Num of rows - before beforeFirst(): " + this.getNumRows());
        }
        this.setStartDateFields();
        this.setStartTimeFields();
        this.setFBDurationFields();
        this.beforeFirst();
        this.start = null;
        this.end = null;
        if (_fbModelLogger.isLoggable(Level.INFO)) {
            this.dumpRecordValues();
        }
        this.beforeFirst();
        _fbModelLogger.exiting(CLASS_NAME, "retrieve()");
        return null;
    }

    private void writeAllRecordsWithNoInfo() {
        int n;
        _fbModelLogger.entering(CLASS_NAME, "writeAllRecordsWithNoInfo()");
        String string = null;
        if (this.calids != null && this.calids.size() > 0) {
            for (n = 0; n < this.calids.size(); ++n) {
                string = this.getCalNameToDisplay((String)this.calids.get(n));
                this.writeRecord(string, null, null, null, null, false);
            }
        }
        if (this.mailids != null && this.mailids.size() > 0) {
            for (n = 0; n < this.mailids.size(); ++n) {
                this.writeRecord((String)this.mailids.get(n), null, null, null, null, false);
            }
        }
        _fbModelLogger.exiting(CLASS_NAME, "writeAllRecordsWithNoInfo()");
    }

    private void writeRecord(String string, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, boolean bl) {
        _fbModelLogger.entering(CLASS_NAME, "writeRecord()");
        DateTime dateTime = (DateTime)this.start.clone();
        DateTime dateTime2 = (DateTime)this.end.clone();
        Duration duration = this.splitHour;
        if (duration == null) {
            try {
                duration = new Duration("PT30M");
            }
            catch (PropertiesException propertiesException) {
                duration = new Duration();
            }
        }
        this.appendRow();
        if (_fbModelLogger.isLoggable(Level.INFO)) {
            _fbModelLogger.info("Writing record for calendar: " + string);
        }
        this.setValue(FIELD_NAME_TO_DISPLAY, string);
        if (!bl) {
            while (!dateTime.equals((Object)dateTime2) && !dateTime.after((Object)dateTime2)) {
                this.setValue(dateTime.toISOString(), "NO_INFO");
                dateTime.add(duration);
            }
            if (dateTime.equals((Object)dateTime2)) {
                this.setValue(dateTime.toISOString(), "NO_INFO");
            }
        }
        if (bl) {
            DateTime dateTime3 = null;
            DateTime dateTime4 = null;
            DateTime dateTime5 = (DateTime)dateTime.clone();
            if (arrayList != null && arrayList.size() > 0) {
                DateTime dateTime6 = (DateTime)dateTime.clone();
                dateTime6.set(14, 0);
                while (!dateTime.equals((Object)dateTime2) && !dateTime.after((Object)dateTime2)) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        int n;
                        dateTime5 = (DateTime)dateTime.clone();
                        DateTime dateTime7 = (DateTime)arrayList.get(i);
                        DateTime dateTime8 = (DateTime)arrayList2.get(i);
                        dateTime7.set(14, 0);
                        dateTime8.set(14, 0);
                        dateTime5.set(14, 0);
                        dateTime3 = (DateTime)dateTime5.clone();
                        dateTime3.add(duration);
                        dateTime4 = (DateTime)dateTime3.clone();
                        if (_fbModelLogger.isLoggable(Level.INFO)) {
                            _fbModelLogger.info("Original Start time: " + dateTime6.toISOString());
                            _fbModelLogger.info("Current Busy Slottime: " + dateTime5.toISOString());
                            _fbModelLogger.info("Busy Start: " + dateTime7.toISOString());
                            _fbModelLogger.info("Busy End: " + dateTime8.toISOString());
                        }
                        int n2 = 0;
                        boolean bl2 = true;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (dateTime7.before((Object)dateTime6) && !dateTime6.before((Object)dateTime5)) {
                            if (_fbModelLogger.isLoggable(Level.INFO)) {
                                _fbModelLogger.info("BusyStartTime is before orig start time");
                            }
                            n2 = 0;
                            bl2 = true;
                            bl3 = false;
                            if (!dateTime8.before((Object)dateTime6)) {
                                while (dateTime3.before((Object)dateTime8)) {
                                    ++n2;
                                    dateTime3.add(duration);
                                }
                                if (dateTime8.before((Object)dateTime3)) {
                                    ++n2;
                                }
                                if (n2 > 0) {
                                    if (_fbModelLogger.isLoggable(Level.INFO)) {
                                        _fbModelLogger.info("Number of Slots to write BUSY: " + n2);
                                    }
                                    for (n = 0; n < n2; ++n) {
                                        if (_fbModelLogger.isLoggable(Level.INFO)) {
                                            _fbModelLogger.info("Writing: " + dateTime5.toISOString() + " BUSY");
                                        }
                                        this.setValue(dateTime5.toISOString(), "BUSY");
                                        dateTime5.add(duration);
                                    }
                                } else {
                                    if (_fbModelLogger.isLoggable(Level.INFO)) {
                                        _fbModelLogger.info("Number of Slots to write BUSY: " + n2);
                                    }
                                    this.setValue(dateTime5.toISOString(), "BUSY");
                                    dateTime5.add(duration);
                                }
                            }
                        }
                        if (dateTime7.before((Object)dateTime5)) continue;
                        if (_fbModelLogger.isLoggable(Level.INFO)) {
                            _fbModelLogger.info("Interval End Time: " + dateTime3.toISOString());
                        }
                        if (dateTime7.after((Object)dateTime3)) continue;
                        n2 = 0;
                        while (dateTime3.before((Object)dateTime8)) {
                            ++n2;
                            dateTime3.add(duration);
                        }
                        if (dateTime5.equals((Object)dateTime7)) {
                            if (_fbModelLogger.isLoggable(Level.INFO)) {
                                _fbModelLogger.info("BUSY-START: " + dateTime7.toISOString() + " CURR-SLOT: " + dateTime5.toISOString());
                                _fbModelLogger.info(" Slots to write BUSY: " + n2);
                            }
                            bl3 = true;
                        } else {
                            bl3 = false;
                        }
                        if (dateTime7.before((Object)dateTime4)) {
                            bl4 = true;
                            if (!bl3) {
                                if (_fbModelLogger.isLoggable(Level.INFO)) {
                                    _fbModelLogger.info("BUSY-START: " + dateTime7.toISOString() + " CURR-SLOT: " + dateTime5.toISOString());
                                }
                                ++n2;
                                if (_fbModelLogger.isLoggable(Level.INFO)) {
                                    _fbModelLogger.info(" NEW-Slots to write BUSY: " + n2);
                                }
                            } else if (dateTime7.equals((Object)dateTime6)) {
                                if (_fbModelLogger.isLoggable(Level.INFO)) {
                                    _fbModelLogger.info("BUSY-START == ORIG");
                                }
                                ++n2;
                            }
                        } else {
                            bl4 = false;
                        }
                        if (n2 > 0) {
                            if (_fbModelLogger.isLoggable(Level.INFO)) {
                                _fbModelLogger.info("Number of Slots to write BUSY: " + n2);
                            }
                            for (n = 0; n < n2; ++n) {
                                if (bl3 || bl4) {
                                    bl4 = false;
                                    bl3 = false;
                                } else {
                                    dateTime5.add(duration);
                                }
                                if (_fbModelLogger.isLoggable(Level.INFO)) {
                                    _fbModelLogger.info("Writing: " + dateTime5.toISOString() + " BUSY");
                                }
                                this.setValue(dateTime5.toISOString(), "BUSY");
                            }
                            continue;
                        }
                        if (bl3 || bl4) {
                            bl3 = false;
                            bl4 = false;
                        } else {
                            dateTime5.add(duration);
                            bl4 = false;
                        }
                        if (_fbModelLogger.isLoggable(Level.INFO)) {
                            _fbModelLogger.info("SAI-Writing: " + dateTime5.toISOString() + " BUSY");
                        }
                        this.setValue(dateTime5.toISOString(), "BUSY");
                    }
                    dateTime.add(duration);
                }
            }
        }
        _fbModelLogger.exiting(CLASS_NAME, "writeRecord()");
    }

    private String getCalNameToDisplay(String string) {
        _fbModelLogger.entering(CLASS_NAME, "getCalNameToDisplay()");
        String string2 = null;
        if (string == null) {
            _fbModelLogger.exiting(CLASS_NAME, "getCalNameToDisplay()");
            return null;
        }
        if (this.calIdsWithNames != null && (string2 = (String)this.calIdsWithNames.get(string)) == null) {
            string2 = string;
        }
        _fbModelLogger.exiting(CLASS_NAME, "getCalNameToDisplay()");
        return string2;
    }

    private CalendarBaseModel getCalendarBaseModel() {
        _fbModelLogger.entering(CLASS_NAME, "getCalendarBaseModel()");
        if (this.calendarBaseModelObject != null) {
            return this.calendarBaseModelObject;
        }
        this.calendarBaseModelObject = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        _fbModelLogger.exiting(CLASS_NAME, "getCalendarBaseModel()");
        return this.calendarBaseModelObject;
    }

    private HashMap associateCalIdFBInfo(ArrayList arrayList, ArrayList arrayList2) {
        SOCSFreeBusy sOCSFreeBusy = null;
        HashMap<String, FreeBusy[]> hashMap = new HashMap<String, FreeBusy[]>();
        FreeBusy[] freeBusyArray = null;
        _fbModelLogger.entering(CLASS_NAME, "associateCalIdFBInfo()");
        if (arrayList != null && arrayList2 != null) {
            int n;
            for (n = 0; n < arrayList.size(); ++n) {
                sOCSFreeBusy = null;
                sOCSFreeBusy = (SOCSFreeBusy)arrayList.get(n);
                try {
                    freeBusyArray = sOCSFreeBusy.getFreeBusy();
                }
                catch (CalendarComponentException calendarComponentException) {
                    freeBusyArray = null;
                }
                catch (OperationNotSupportedException operationNotSupportedException) {
                    freeBusyArray = null;
                }
                hashMap.put((String)arrayList2.get(n), freeBusyArray);
            }
            if (this.calids != null && this.calids.size() > 0) {
                for (n = 0; n < this.calids.size(); ++n) {
                    String string = (String)this.calids.get(n);
                    boolean bl = false;
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        String string2 = (String)arrayList2.get(i);
                        if (!string2.equals(string)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    hashMap.put(string, null);
                }
            }
            return hashMap;
        }
        return null;
    }

    private HashMap associateCalIdFBInfo(ArrayList arrayList, HashMap hashMap) {
        SOCSFreeBusy sOCSFreeBusy = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        FreeBusy[] freeBusyArray = null;
        boolean bl = false;
        HashMap<String, FreeBusy[]> hashMap2 = new HashMap<String, FreeBusy[]>();
        String string4 = "mailto:";
        boolean bl2 = false;
        if (arrayList != null) {
            if (this.calids != null && this.calids.size() > 0) {
                for (int i = 0; i < this.calids.size(); ++i) {
                    string = (String)this.calids.get(i);
                    string2 = (String)this.calids.get(i);
                    bl = false;
                    if (_fbModelLogger.isLoggable(Level.INFO)) {
                        _fbModelLogger.info("Looking for FB for calid: " + string);
                    }
                    if (string.startsWith(string4)) {
                        bl2 = true;
                        string = string.substring(string4.length());
                        if (_fbModelLogger.isLoggable(Level.INFO)) {
                            _fbModelLogger.info("Looking for FB for mailid: " + string);
                        }
                    } else {
                        bl2 = false;
                    }
                    for (int j = 0; j < arrayList.size(); ++j) {
                        sOCSFreeBusy = (SOCSFreeBusy)arrayList.get(j);
                        if (bl2) {
                            String string5 = sOCSFreeBusy.getCalID();
                            if (_fbModelLogger.isLoggable(Level.INFO)) {
                                _fbModelLogger.info("CalID from FB component: " + string5);
                            }
                            UWCCalendar uWCCalendar = null;
                            SOCSCalendar sOCSCalendar = null;
                            if (string5 != null) {
                                uWCCalendar = (UWCCalendar)hashMap.get(string5);
                            }
                            if (uWCCalendar != null) {
                                sOCSCalendar = (SOCSCalendar)uWCCalendar.getCalendar();
                            }
                            if (sOCSCalendar != null) {
                                try {
                                    string3 = sOCSCalendar.getOwnerEmailId();
                                }
                                catch (CalendarException calendarException) {
                                    string3 = "";
                                }
                                catch (OperationNotSupportedException operationNotSupportedException) {
                                    string3 = "";
                                }
                            }
                            if (_fbModelLogger.isLoggable(Level.INFO)) {
                                _fbModelLogger.info("Mail ID for SOCS FB : " + string3);
                            }
                        } else {
                            string3 = sOCSFreeBusy.getCalID();
                        }
                        if (string3 == null || !string.equals(string3)) continue;
                        bl = true;
                        if (_fbModelLogger.isLoggable(Level.INFO)) {
                            _fbModelLogger.info("FB for calid: " + string3 + " is: " + sOCSFreeBusy.toString());
                        }
                        try {
                            freeBusyArray = sOCSFreeBusy.getFreeBusy();
                        }
                        catch (CalendarComponentException calendarComponentException) {
                            freeBusyArray = null;
                        }
                        catch (OperationNotSupportedException operationNotSupportedException) {
                            freeBusyArray = null;
                        }
                        hashMap2.put(string, freeBusyArray);
                        break;
                    }
                    if (bl) continue;
                    hashMap2.put(string, null);
                }
                return hashMap2;
            }
            return null;
        }
        return null;
    }

    private void setStartDateFields() {
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
    }

    private void setStartTimeFields() {
        String string = null;
        String string2 = null;
        if (this.start != null) {
            if (this.usersTimeFormatPref == null) {
                this.usersTimeFormatPref = "12";
            }
            string = UWCUtils.getHoursValue(this.start, this.usersTimeFormatPref);
            string2 = UWCUtils.getMinutesValue(this.start, this.usersTimeFormatPref);
            this.setValue(FIELD_START_TIME_HOURS, string);
            this.setValue(FIELD_START_TIME_MINUTES, string2);
        }
    }

    private void setFBDurationFields() {
        String string = null;
        String string2 = null;
        if (this.duration != null) {
            string = UWCConstants.durationHoursValues[this.duration.getHours()];
            string2 = UWCConstants.durationMinutesValues[this.duration.getMinutes() / 5];
            this.setValue(FIELD_DURATION_HOURS, string);
            this.setValue(FIELD_DURATION_MINUTES, string2);
        }
    }

    private DateTime constructEndTime() {
        String string = null;
        String string2 = null;
        DateTime dateTime = null;
        if (this.start != null) {
            dateTime = (DateTime)this.start.clone();
        }
        string = (String)this.getValue(FIELD_DURATION_HOURS);
        if (_fbModelLogger.isLoggable(Level.INFO)) {
            _fbModelLogger.info("ConstructEndTime, Duration Hours - " + string);
        }
        string2 = (String)this.getValue(FIELD_DURATION_MINUTES);
        if (_fbModelLogger.isLoggable(Level.INFO)) {
            _fbModelLogger.info("ConstructEndTime, Duration Min - " + string2);
            _fbModelLogger.info(string);
            _fbModelLogger.info(string2);
        }
        if (dateTime != null) {
            if (string != null) {
                dateTime.add(10, Integer.parseInt(string));
            } else {
                dateTime.setHours(23);
            }
            if (string2 != null) {
                dateTime.add(12, Integer.parseInt(string2));
            } else {
                dateTime.setMinutes(59);
            }
        }
        return dateTime;
    }

    private DateTime constructStartTime() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        DateTime dateTime = null;
        string = (String)this.getValue(FIELD_START_DATE_MONTH);
        if (_fbModelLogger.isLoggable(Level.INFO)) {
            _fbModelLogger.info("ConstructStartTime, month - " + string);
        }
        string2 = (String)this.getValue(FIELD_START_DATE_DAY);
        if (_fbModelLogger.isLoggable(Level.INFO)) {
            _fbModelLogger.info("ConstructStartTime,day - " + string2);
        }
        string3 = (String)this.getValue(FIELD_START_DATE_YEAR);
        if (_fbModelLogger.isLoggable(Level.INFO)) {
            _fbModelLogger.info("ConstructStartTime, year - " + string3);
        }
        if (string != null && string2 != null && string3 != null && (dateTime = this.timezone != null ? new DateTime(this.timezone) : new DateTime()) != null) {
            dateTime.setMonth(Integer.parseInt(string) - 1);
            dateTime.setDay(Integer.parseInt(string2));
            dateTime.setYear(Integer.parseInt(string3));
            dateTime.setSeconds(0);
        }
        string4 = (String)this.getValue(FIELD_START_TIME_HOURS);
        if (_fbModelLogger.isLoggable(Level.INFO)) {
            _fbModelLogger.info("ConstructStartTime,hours - " + string4);
        }
        string5 = (String)this.getValue(FIELD_START_TIME_MINUTES);
        if (_fbModelLogger.isLoggable(Level.INFO)) {
            _fbModelLogger.info("ConstructStartTime, minutes - " + string5);
        }
        if (dateTime != null) {
            if (string4 != null) {
                dateTime.setHours(Integer.parseInt(string4));
            } else {
                dateTime.setHours(0);
            }
            if (string5 != null) {
                dateTime.setMinutes(Integer.parseInt(string5));
            } else {
                dateTime.setMinutes(0);
            }
        }
        return dateTime;
    }

    public void dumpRecordAtIndex(int n) {
        _fbModelLogger.entering(CLASS_NAME, "dumpRecordAtIndex(" + n + ")");
        Map map = null;
        this.setRowIndex(n);
        map = this.getValueMap(n);
        if (map != null) {
            if (map.isEmpty()) {
                if (_fbModelLogger.isLoggable(Level.INFO)) {
                    _fbModelLogger.info("Map is empty for row: " + n);
                }
            } else {
                Set set = map.keySet();
                String[] stringArray = UWCUtils.getStringArray(set.toArray());
                if (stringArray != null && stringArray.length > 0) {
                    if (_fbModelLogger.isLoggable(Level.INFO)) {
                        _fbModelLogger.info("Key-Value Pairs for record: " + n);
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        _fbModelLogger.info("Key: " + stringArray[i]);
                        _fbModelLogger.info("Value: " + (String)this.getValue(stringArray[i]));
                    }
                }
            }
        } else if (_fbModelLogger.isLoggable(Level.INFO)) {
            _fbModelLogger.info("No Value map present for the row: " + n);
        }
        _fbModelLogger.exiting(CLASS_NAME, "dumpRecordAtIndex(" + n + ")");
    }

    private void dumpRecordValues() {
        _fbModelLogger.entering(CLASS_NAME, "dumpRecordValues()");
        Map map = null;
        int n = this.getNumRows();
        if (_fbModelLogger.isLoggable(Level.INFO)) {
            _fbModelLogger.info("Total Number of records: " + n);
        }
        for (int i = 0; i < n; ++i) {
            this.setRowIndex(i);
            map = this.getValueMap(i);
            if (map != null) {
                if (map.isEmpty()) {
                    if (!_fbModelLogger.isLoggable(Level.INFO)) continue;
                    _fbModelLogger.info("Map is empty for row: " + i);
                    continue;
                }
                Set set = map.keySet();
                String[] stringArray = UWCUtils.getStringArray(set.toArray());
                if (stringArray == null || stringArray.length <= 0) continue;
                if (_fbModelLogger.isLoggable(Level.INFO)) {
                    _fbModelLogger.info("Key-Value Pairs for record: " + i);
                }
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!_fbModelLogger.isLoggable(Level.INFO)) continue;
                    _fbModelLogger.info("Key: " + stringArray[j] + " Value: " + (String)this.getValue(stringArray[j]));
                }
                continue;
            }
            if (!_fbModelLogger.isLoggable(Level.INFO)) continue;
            _fbModelLogger.info("No Value map present for the row: " + i);
        }
        _fbModelLogger.exiting(CLASS_NAME, "dumpRecordValues()");
    }

    public void setRequestContext(RequestContext requestContext) {
        _fbModelLogger.entering(CLASS_NAME, "setRequestContext()");
        this._reqCtx = requestContext;
        _fbModelLogger.exiting(CLASS_NAME, "setRequestContext()");
    }

    static {
        _fbModelLogger = UWCLogger.getLogger("uwc.calclient.model");
    }
}

