/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.InsertingModel;
import com.iplanet.jato.model.InvalidContextException;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.PropertiesException;
import com.sun.comclient.calendar.RecurrencePattern;
import com.sun.comclient.calendar.VAlarm;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.socs.SOCSEvent;
import com.sun.comclient.calendar.socs.SOCSOrganizer;
import com.sun.uwc.calclient.model.CalendarBaseModel;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalUserPreferencesModel;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.model.UWCModelControlException;
import com.sun.uwc.common.model.UserPreferencesModel;
import com.sun.uwc.common.util.UWCConstants;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventsModel
extends DefaultModel
implements RetrievingModel,
InsertingModel,
RequestParticipant {
    private VEvent _currentEvent = null;
    private String _eventUid = null;
    private String _eventRid = null;
    private String _eventCalid = null;
    private Organizer _organizer = null;
    private Attendee[] _attendees = null;
    private Attendee _attendeeForEventCalid = null;
    private VAlarm _alarm = null;
    private RecurrencePattern _recurrence = null;
    private DateTime _start = null;
    private DateTime _end = null;
    private String _modifier = null;
    private String _isAllDay = null;
    private boolean _isAlarmChanged = false;
    private boolean _enableDuration = true;
    private boolean _isFromInvitation = false;
    private boolean fetchMasterCopy = false;
    private static final String CLASS_NAME = "EventsModel";
    private static Logger _log = null;
    protected RequestContext _reqCtx = null;
    public static final String FIELD_TITLE = "Title";
    public static final String FIELD_CALID = "calid";
    public static final String FIELD_CAL_PRIMARY_OWNER_NAME = "calendarPrimaryOwnerName";
    public static final String FIELD_PREVIOUS_CALID = "PreviousCalid";
    public static final String FIELD_TIME_ZONE = "TimeZone";
    public static final String FIELD_NON_RSVPS = "RSVPNotRequestedAttendees";
    public static final String FIELD_EVENT_UID = "eventUid";
    public static final String FIELD_EVENT_RID = "eventRid";
    public static final String FIELD_START_DATE_MONTH = "StartDateMonth";
    public static final String FIELD_START_DATE_DAY = "StartDateDay";
    public static final String FIELD_START_DATE_YEAR = "StartDateYear";
    public static final String FIELD_END_DATE_MONTH = "EndDateMonth";
    public static final String FIELD_END_DATE_DAY = "EndDateDay";
    public static final String FIELD_END_DATE_YEAR = "EndDateYear";
    public static final String FIELD_IS_ALL_DAY = "IsAllDay";
    public static final String FIELD_START_TIME_HOURS = "StartTimeHours";
    public static final String FIELD_START_TIME_MINUTES = "StartTimeMinutes";
    public static final String FIELD_END_TIME_HOURS = "EndTimeHours";
    public static final String FIELD_END_TIME_MINUTES = "EndTimeMinutes";
    public static final String FIELD_DURATION_HOURS = "DurationHours";
    public static final String FIELD_DURATION_MINUTES = "DurationMinutes";
    public static final String FIELD_SHOW_AS_BUSY = "ShowAsBusy";
    public static final String FIELD_PREV_SHOW_AS_BUSY = "PreviousShowAsBusy";
    public static final String FIELD_CATEGORY = "Category";
    public static final String FIELD_PRIVACY = "Privacy";
    public static final String FIELD_PREV_PRIVACY = "PreviousPrivacy";
    public static final String FIELD_LOCATION = "Location";
    public static final String FIELD_DESCRIPTION = "Description";
    public static final String FIELD_ATTENDEE = "Attendee";
    public static final String FIELD_ATTENDEE_LIST = "AttendeeList";
    public static final String FIELD_HAS_ATTENDEES_MODIFIED = "hasAttendeesModified";
    public static final String FIELD_ATTENDEE_VALUE = "AttendeeValue";
    public static final String FIELD_ATTENDEE_COMMON_NAME = "AttendeeCommonName";
    public static final String FIELD_ATTENDEE_STATUS = "AttendeeStatus";
    public static final String FIELD_ATTENDEE_COMMENT = "AttendeeComment";
    public static final String FIELD_PARTSTAT_INFO = "partstatInfo";
    public static final String FIELD_COMMENTS = "Comment";
    public static final String FIELD_SEND_RSVP = "SendRSVP";
    public static final String FIELD_PREVIOUS_RRULE_IN_RFC = "PreviousRRuleInRFC2445";
    public static final String FIELD_PREVIOUS_START_DATE_TIME_IN_UTC = "PreviousStartDateTimeInUTC";
    public static final String FIELD_PREVIOUS_END_DATE_TIME_IN_UTC = "PreviousEndDateTimeInUTC";
    public static final String FIELD_ISO_8601_START_DATE_TIME = "ISO8601StartDateTime";
    public static final String FIELD_ISO_8601_END_DATE_TIME = "ISO8601EndDateTime";
    public static final String FIELD_START_TIME = "StartTime";
    public static final String FIELD_END_TIME = "EndTime";
    public static final String FIELD_ACCEPT_COUNT = "AcceptCount";
    public static final String FIELD_DECLINE_COUNT = "DeclineCount";
    public static final String FIELD_NO_RESPONSE_COUNT = "NoResponseCount";
    public static final String FIELD_UNDECIDED_COUNT = "UndecidedCount";
    public static final String FIELD_IS_RECURRING = "IsRecurring";
    public static final String FIELD_IS_REMINDING = "IsReminding";
    public static final String FIELD_IS_PUBLIC = "IsPublic";
    public static final String FIELD_START_DATE = "StartDate";
    public static final String FIELD_START_DAY_DATE = "StartDayDate";
    public static final String FIELD_START_DATE_TIME = "StartDateTime";
    public static final String FIELD_ORGANIZER = "Organizer";
    public static final String FIELD_ORG_CALID = "OrgCalid";
    public static final String FIELD_ORGANIZER_EMAIL = "OrgEmail";
    public static final String FIELD_IS_CALID_THE_ORGANIZER = "IsCalIdTheOrganizer";
    public static final String OPAQUE = "OPAQUE";
    public static final String TRANSPARENT = "TRANSPARENT";
    public static final String calendarEventPrivacyPrefix = "uwc-calclient-event-classification-";
    public static final String[] calendarEventPrivacyValues = new String[]{"PUBLIC", "PRIVATE", "CONFIDENTIAL"};
    public static final String[] calendarEventPrivacyNames = calendarEventPrivacyValues;
    public static final String calendarEventPrivacyDefaultValue = "PUBLIC";
    public static final String attendeeParticipantStatusPrefix = "uwc-calclient-event-attendee-participantStatus-";
    public static final String[] attendeeParticipantStatusNames = new String[]{"Accept", "Decline", "Undecided"};
    public static final String[] attendeeParticipantStatusValues = new String[]{"ACCEPTED", "DECLINED", "TENTATIVE"};

    public EventsModel() {
    }

    public EventsModel(String string) {
        super(string);
    }

    public void setRequestContext(RequestContext requestContext) {
        this._reqCtx = requestContext;
    }

    public VEvent getCurrentEvent() {
        return this._currentEvent;
    }

    public void setCurrentEvent(VEvent vEvent) {
        this._currentEvent = vEvent;
        this._eventUid = null;
        this._eventRid = null;
        this._eventCalid = null;
    }

    public String getEventUID() {
        return this._eventUid;
    }

    public void setEventUID(String string) {
        this._eventUid = string;
        this._currentEvent = null;
    }

    public String getEventRID() {
        return this._eventRid;
    }

    public void setEventRID(String string) {
        this._eventRid = string;
        this._currentEvent = null;
    }

    public String getEventCalid() {
        return this._eventCalid;
    }

    public void setIsFromInvitation(boolean bl) {
        this._isFromInvitation = bl;
    }

    public boolean getIsFromInvitation() {
        return this._isFromInvitation;
    }

    public void setEventCalid(String string) {
        this._eventCalid = string;
        this._currentEvent = null;
    }

    public void enableDuration(boolean bl) {
        this._enableDuration = bl;
    }

    public void setDefaultDates(DateTime dateTime, DateTime dateTime2) {
        this._start = dateTime;
        this._end = dateTime2;
    }

    public Organizer getOrganizer() {
        return this._organizer;
    }

    public Attendee getAttendeeForEventCalid() {
        return this._attendeeForEventCalid;
    }

    public void setAttendeeForEventCalid(Attendee attendee) {
        this._attendeeForEventCalid = attendee;
    }

    public Attendee[] getAttendees() {
        return this._attendees;
    }

    public void setAttendees(Attendee[] attendeeArray) {
        this._attendees = attendeeArray;
    }

    public VAlarm getAlarm() {
        return this._alarm;
    }

    public void setAlarm(VAlarm vAlarm) {
        this._alarm = vAlarm;
    }

    public RecurrencePattern getRecurrencePattern() {
        return this._recurrence;
    }

    public void setRecurrencePattern(RecurrencePattern recurrencePattern) {
        this._recurrence = recurrencePattern;
    }

    public String getRecurrenceModifier() {
        return this._modifier;
    }

    public void setRecurrenceModifier(String string) {
        this._modifier = string;
    }

    public void setAlarmChange(boolean bl) {
        this._isAlarmChanged = bl;
    }

    public void setAllDay(String string) {
        this._isAllDay = string;
    }

    public void setFetchMasterCopy(boolean bl) {
        this.fetchMasterCopy = bl;
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        throw new UWCModelControlException((Throwable)new InvalidContextException("Cuurently EventsModel doesn't support any Execute Contexts"));
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        Object var2_2 = null;
        String string = null;
        string = null != modelExecutionContext ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.LOAD_EVENT_CONTEXT;
        if (string.equals(CalendarExecutionModelContext.LOAD_EVENT_CONTEXT)) {
            try {
                this.loadEvent();
            }
            catch (UWCException uWCException) {
                UWCUtils.printStackTrace(uWCException);
                throw new UWCModelControlException(uWCException.getReason(), uWCException.getDetails());
            }
        } else if (string.equals(CalendarExecutionModelContext.LOAD_EVENT_DEFAULTS_CONTEXT)) {
            try {
                this.loadEventDefaults();
            }
            catch (UWCException uWCException) {
                UWCUtils.printStackTrace(uWCException);
                throw new UWCModelControlException(uWCException.getReason(), uWCException.getDetails());
            }
        } else {
            throw new UWCModelControlException((Throwable)new InvalidContextException("Event Retrieve operation failed: \"" + string + "\" is invalid Event Retrieve Context"));
        }
        return null;
    }

    public Object insert(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        Object var2_2 = null;
        String string = null;
        string = null != modelExecutionContext ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.ADD_EVENT_CONTEXT;
        if (string.equals(CalendarExecutionModelContext.ADD_EVENT_CONTEXT)) {
            try {
                this.addEvent();
            }
            catch (UWCException uWCException) {
                UWCUtils.printStackTrace(uWCException);
                throw new UWCModelControlException(uWCException.getReason(), uWCException.getDetails());
            }
        } else if (string.equals(CalendarExecutionModelContext.MODIFY_EVENT_CONTEXT)) {
            try {
                this.modifyEvent();
            }
            catch (UWCException uWCException) {
                UWCUtils.printStackTrace(uWCException);
                throw new UWCModelControlException(uWCException.getReason(), uWCException.getDetails());
            }
        } else if (string.equals(CalendarExecutionModelContext.UPDATE_EVENT_CONTEXT)) {
            try {
                this.updateEvent();
            }
            catch (UWCException uWCException) {
                UWCUtils.printStackTrace(uWCException);
                throw new UWCModelControlException(uWCException.getReason(), uWCException.getDetails());
            }
        } else if (string.equals(CalendarExecutionModelContext.DELETE_EVENT_CONTEXT)) {
            try {
                this.deleteEvent();
            }
            catch (UWCException uWCException) {
                UWCUtils.printStackTrace(uWCException);
                throw new UWCModelControlException(uWCException.getReason(), uWCException.getDetails());
            }
        } else {
            throw new UWCModelControlException((Throwable)new InvalidContextException("Event Insert operation failed: \"" + string + "\" is invalid Event Insert Context"));
        }
        return var2_2;
    }

    private void loadEventDates(DateTime dateTime, DateTime dateTime2, String string) throws PropertiesException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        if (null == dateTime2) {
            dateTime2 = dateTime;
        }
        if (null != dateTime && null != dateTime2) {
            Duration duration = new Duration(dateTime, dateTime2);
            string2 = UWCConstants.monthValues[dateTime.get(2)];
            string3 = UWCConstants.dayValues[dateTime.get(5) - 1];
            string4 = UWCUtils.getYearValue(this._reqCtx, dateTime);
            string5 = UWCUtils.getHoursValue(dateTime, string);
            string6 = UWCUtils.getMinutesValue(dateTime, string);
            string7 = UWCConstants.monthValues[dateTime2.get(2)];
            string8 = UWCConstants.dayValues[dateTime2.get(5) - 1];
            string9 = UWCUtils.getYearValue(this._reqCtx, dateTime2);
            string10 = UWCUtils.getHoursValue(dateTime2, string);
            string11 = UWCUtils.getMinutesValue(dateTime2, string);
            string12 = UWCConstants.durationHoursValues[duration.getHours()];
            string13 = UWCConstants.durationMinutesValues[duration.getMinutes() / 5];
        }
        this.setValue(FIELD_START_DATE_MONTH, string2);
        this.setValue(FIELD_START_DATE_DAY, string3);
        this.setValue(FIELD_START_DATE_YEAR, string4);
        this.setValue(FIELD_START_TIME_HOURS, string5);
        this.setValue(FIELD_START_TIME_MINUTES, string6);
        this.setValue(FIELD_END_DATE_MONTH, string7);
        this.setValue(FIELD_END_DATE_DAY, string8);
        this.setValue(FIELD_END_DATE_YEAR, string9);
        this.setValue(FIELD_END_TIME_HOURS, string10);
        this.setValue(FIELD_END_TIME_MINUTES, string11);
        this.setValue(FIELD_DURATION_HOURS, string12);
        this.setValue(FIELD_DURATION_MINUTES, string13);
    }

    private void loadEventDefaults() throws UWCException {
        try {
            String string;
            UserPreferencesModel userPreferencesModel = UWCUserHelper.getUserPrefModel(this._reqCtx);
            String string2 = userPreferencesModel.getTimeFormat();
            TimeZone timeZone = this.getEventTimeZone(true);
            String string3 = null;
            CalUserPreferencesModel calUserPreferencesModel = UWCUserHelper.getCalUserPrefModel(this._reqCtx);
            if (null != calUserPreferencesModel) {
                if (!calUserPreferencesModel.getInitialized()) {
                    try {
                        calUserPreferencesModel.initializeCalendarPreferences();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                string3 = calUserPreferencesModel.getDefaultCategory();
            }
            if (null == this._start) {
                this._start = new DateTime(timeZone);
            }
            if (null == this._end) {
                String string4;
                this._end = (DateTime)this._start.clone();
                string = null;
                if (null != calUserPreferencesModel && null != (string4 = calUserPreferencesModel.getInterval())) {
                    try {
                        string = new Duration(string4);
                    }
                    catch (Exception exception) {
                        string = null;
                    }
                }
                if (null == string) {
                    string = new Duration(1, 0);
                }
                this._end.add((Duration)string);
            }
            this.loadEventDates(this._start, this._end, string2);
            if (null == string3 || string3.trim().equals("")) {
                string3 = "Business";
            }
            string = "false";
            if (null != this._isAllDay && "1".equals(this._isAllDay.trim())) {
                string = "true";
            }
            this.setValue(FIELD_IS_ALL_DAY, "false");
            this.setValue(FIELD_SHOW_AS_BUSY, "true");
            this.setValues(FIELD_CATEGORY, new String[]{string3});
            this.setValue(FIELD_PRIVACY, calendarEventPrivacyDefaultValue);
            this.setValue(FIELD_ISO_8601_START_DATE_TIME, this._start.toISO8601());
            this.setValue(FIELD_ISO_8601_END_DATE_TIME, this._end.toISO8601());
            this.setValue(FIELD_IS_ALL_DAY, string);
        }
        catch (Exception exception) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Couldn't load the event. Reason: " + exception);
            }
            throw new UWCException(65, "Couldn't load the event.");
        }
    }

    private void loadDefaultStartTimeAndDuration(String string) throws UWCException {
        try {
            String string2;
            TimeZone timeZone = this.getEventTimeZone(true);
            DateTime dateTime = new DateTime(timeZone);
            CalUserPreferencesModel calUserPreferencesModel = UWCUserHelper.getCalUserPrefModel(this._reqCtx);
            if (null != calUserPreferencesModel && !calUserPreferencesModel.getInitialized()) {
                try {
                    calUserPreferencesModel.initializeCalendarPreferences();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Duration duration = null;
            if (null != calUserPreferencesModel && null != (string2 = calUserPreferencesModel.getInterval())) {
                try {
                    duration = new Duration(string2);
                }
                catch (Exception exception) {
                    duration = null;
                }
            }
            if (null == duration) {
                duration = new Duration(1, 0);
            }
            string2 = (DateTime)dateTime.clone();
            string2.add(duration);
            String string3 = UWCUtils.getHoursValue(dateTime, string);
            String string4 = UWCUtils.getMinutesValue(dateTime, string);
            String string5 = UWCUtils.getHoursValue((DateTime)string2, string);
            String string6 = UWCUtils.getMinutesValue((DateTime)string2, string);
            String string7 = UWCConstants.durationHoursValues[duration.getHours()];
            String string8 = UWCConstants.durationMinutesValues[duration.getMinutes() / 5];
            this.setValue(FIELD_START_TIME_HOURS, string3);
            this.setValue(FIELD_START_TIME_MINUTES, string4);
            this.setValue(FIELD_END_TIME_HOURS, string5);
            this.setValue(FIELD_END_TIME_MINUTES, string6);
            this.setValue(FIELD_DURATION_HOURS, string7);
            this.setValue(FIELD_DURATION_MINUTES, string8);
        }
        catch (Exception exception) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Couldn't load the event. Reason: " + exception);
            }
            throw new UWCException(65, "Couldn't load the event.");
        }
    }

    private void loadEvent() throws UWCException {
        try {
            Object object;
            String string;
            Object object2;
            VAlarm[] vAlarmArray;
            NonSyncStringBuffer nonSyncStringBuffer;
            Object object3;
            Object object4;
            CalendarBaseModel calendarBaseModel;
            this._organizer = null;
            this._attendees = null;
            this._attendeeForEventCalid = null;
            this._alarm = null;
            this._recurrence = null;
            if (null != this._eventUid && null != this._eventCalid) {
                calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
                if (null == calendarBaseModel) {
                    if (_log.isLoggable(Level.SEVERE)) {
                        _log.severe("Couldn't get CalendarBaseModel: Can't retrieve the event object for eventUID \"" + this._eventUid + "\", eventRID \"" + this._eventRid + "\" and eventCalid \"" + this._eventCalid + "\"");
                    }
                    return;
                }
                calendarBaseModel.setComponentUID(this._eventUid);
                calendarBaseModel.setComponentRID(this._eventRid);
                if (this._isFromInvitation) {
                    calendarBaseModel.setIsFromInvitation(this._isFromInvitation);
                }
                calendarBaseModel.removeAllCalids();
                calendarBaseModel.addCalid(this._eventCalid);
                if (this.fetchMasterCopy) {
                    calendarBaseModel.setFetchMasterCopy(true);
                }
                calendarBaseModel.execute((ModelExecutionContext)new CalendarExecutionModelContext(CalendarExecutionModelContext.FETCH_EVENT_BY_ID_CONTEXT));
                object4 = calendarBaseModel.getAllEvents();
                if (null != object4 && ((ArrayList)object4).size() > 0) {
                    this._currentEvent = (VEvent)((ArrayList)object4).get(0);
                }
                this.setValue(FIELD_TIME_ZONE, null == (object3 = calendarBaseModel.getTimeZone()) ? null : ((TimeZone)object3).getID());
            }
            if (null == this._currentEvent) {
                _log.severe("Couldn't get or load event object");
                throw new UWCException(65, "Couldn't get or load event object");
            }
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("loadEvent: Event calid: " + (String)this.getValue(FIELD_CALID));
                _log.finest("loadEvent: Event Dump:\n" + ((SOCSEvent)this._currentEvent).toRFC2445());
            }
            if (null != this._currentEvent) {
                this.setValue(FIELD_EVENT_UID, this._currentEvent.getID());
                calendarBaseModel = this._currentEvent.getRecurrenceID();
                if (null != calendarBaseModel) {
                    this.setValue(FIELD_EVENT_RID, calendarBaseModel.toISO8601());
                }
            }
            calendarBaseModel = this._currentEvent.getStartTime();
            object4 = this._currentEvent.getEndTime();
            object3 = UWCUserHelper.getUserPrefModel(this._reqCtx);
            String string2 = ((UserPreferencesModel)((Object)object3)).getTimeFormat();
            String string3 = ((UserPreferencesModel)((Object)object3)).getDateFormat();
            String string4 = ((UserPreferencesModel)((Object)object3)).getDateDelimiter();
            String string5 = this._currentEvent.isAllDay() ? "true" : "false";
            String string6 = OPAQUE.equalsIgnoreCase((String)this._currentEvent.getProperty("TRANSP")) ? "true" : "false";
            Object[] objectArray = this._currentEvent.getCategories();
            String string7 = this._currentEvent.getClassification();
            if (null == objectArray) {
                objectArray = new String[]{"Other"};
            }
            if (UWCUtils.isStringContainedInStringArray(string7, calendarEventPrivacyValues, true) < 0) {
                string7 = calendarEventPrivacyDefaultValue;
            }
            if (this._currentEvent.isAllDay() && null != calendarBaseModel && null != object4) {
                calendarBaseModel.setTime(0, 0, 0);
                calendarBaseModel.set(14, 0);
                object4.setTime(0, 0, 0);
                object4.set(14, 0);
                if (calendarBaseModel.before(object4)) {
                    object4.add(13, -1);
                    object4.setTime(0, 0, 0);
                }
            }
            this.loadEventDates((DateTime)calendarBaseModel, (DateTime)object4, string2);
            if (this._currentEvent.isAllDay()) {
                this.loadDefaultStartTimeAndDuration(string2);
            }
            this.setValue(FIELD_TITLE, this._currentEvent.getSummary());
            this.setValue(FIELD_CALID, this._currentEvent.getCalID());
            this.setValue(FIELD_PREVIOUS_CALID, this._currentEvent.getCalID());
            this.setValue(FIELD_IS_ALL_DAY, string5);
            this.setValue(FIELD_SHOW_AS_BUSY, string6);
            this.setValue(FIELD_PREV_SHOW_AS_BUSY, string6);
            this.setValues(FIELD_CATEGORY, objectArray);
            this.setValue(FIELD_PRIVACY, string7);
            this.setValue(FIELD_PREV_PRIVACY, string7);
            this.setValue(FIELD_LOCATION, this._currentEvent.getLocation());
            this.setValue(FIELD_DESCRIPTION, this._currentEvent.getDescription());
            this.setValue(FIELD_ATTENDEE, null);
            this.setValue(FIELD_ATTENDEE_LIST, null);
            this._organizer = this._currentEvent.getOrganizer();
            this._attendees = this._currentEvent.getAttendees();
            if (null != this._attendees) {
                nonSyncStringBuffer = new NonSyncStringBuffer(128);
                vAlarmArray = new NonSyncStringBuffer(64);
                object2 = null;
                char c = '\u0000';
                for (int i = 0; i < this._attendees.length; ++i) {
                    if (!this._attendees[i].isRSVPRequired()) {
                        nonSyncStringBuffer.append("$");
                        nonSyncStringBuffer.append(this._attendees[i].getValue());
                    }
                    if (((String)(object2 = this._attendees[i].getParticipantStatus())).equals("ACCEPTED")) {
                        c = '+';
                    } else if (((String)object2).equals("NEEDS-ACTION") || ((String)object2).equals("TENTATIVE")) {
                        c = '?';
                    } else if (((String)object2).equals("DECLINED")) {
                        c = '-';
                    }
                    vAlarmArray.append(this._attendees[i].getCommonName()).append(" (").append(this._attendees[i].getValue()).append(") ").append(c);
                    if (i >= this._attendees.length - 1) continue;
                    vAlarmArray.append("; ");
                }
                if (vAlarmArray != null) {
                    this.setValue(FIELD_PARTSTAT_INFO, vAlarmArray.toString());
                }
                if (null != (string = nonSyncStringBuffer.toString()) && !string.trim().equals("")) {
                    this.setValue(FIELD_NON_RSVPS, string);
                }
            }
            if (null != (nonSyncStringBuffer = this._currentEvent.getRecurrenceRules())) {
                this._recurrence = nonSyncStringBuffer[0];
            }
            if (null != (vAlarmArray = this._currentEvent.getAlarmComponents())) {
                this._alarm = vAlarmArray[0];
            }
            if (null != (object2 = this._currentEvent.getAttendee(this._currentEvent.getCalID()))) {
                this.setValue(FIELD_ATTENDEE_VALUE, object2.getValue());
                this.setValue(FIELD_ATTENDEE_COMMON_NAME, object2.getCommonName());
                this.setValue(FIELD_ATTENDEE_STATUS, object2.getParticipantStatus());
                this.setValue(FIELD_SEND_RSVP, object2.isRSVPRequired() ? "true" : "false");
            }
            this.setValue(FIELD_ATTENDEE_COMMENT, "");
            String[] stringArray = this._currentEvent.getComments();
            if (null != stringArray) {
                this.setValue(FIELD_COMMENTS, UWCUtils.getDelimiterSeperatedString(stringArray, "\n\n"));
            }
            if (null != this._recurrence) {
                this.setValue(FIELD_PREVIOUS_RRULE_IN_RFC, this._recurrence.toRFC2445());
            }
            if (null != calendarBaseModel) {
                string = calendarBaseModel.toISO8601();
                this.setValue(FIELD_PREVIOUS_START_DATE_TIME_IN_UTC, string);
                this.setValue(FIELD_ISO_8601_START_DATE_TIME, string);
            }
            if (null != object4) {
                string = null;
                if (this._currentEvent.isAllDay()) {
                    object = (DateTime)object4.clone();
                    object.add(6, 1);
                    string = object.toISO8601();
                } else {
                    string = object4.toISO8601();
                }
                this.setValue(FIELD_PREVIOUS_END_DATE_TIME_IN_UTC, string);
                this.setValue(FIELD_ISO_8601_END_DATE_TIME, string);
            }
            string = null;
            object = null;
            string = "24".equals(string2) ? UWCUtils.getLocaleTimePerPattern(this._reqCtx, (DateTime)calendarBaseModel, "uwc-calclient-24hr-timeslot-startPattern", 1) : UWCUtils.getLocaleTimePerPattern(this._reqCtx, (DateTime)calendarBaseModel, "uwc-calclient-12hr-timeslot-startPattern", 1);
            object = "24".equals(string2) ? UWCUtils.getLocaleTimePerPattern(this._reqCtx, (DateTime)object4, "uwc-calclient-24hr-timeslot-startPattern", 1) : UWCUtils.getLocaleTimePerPattern(this._reqCtx, (DateTime)object4, "uwc-calclient-12hr-timeslot-startPattern", 1);
            this.setValue(FIELD_START_TIME, string);
            this.setValue(FIELD_END_TIME, object);
            int n = this._currentEvent.getAcceptedAttendeesCount();
            int n2 = this._currentEvent.getDeclinedAttendeesCount();
            int n3 = this._currentEvent.getPendingAttendeesCount();
            int n4 = this._currentEvent.getTentativeAttendeesCount();
            if (-1 < n) {
                this.setValue(FIELD_ACCEPT_COUNT, Integer.toString(n));
            } else {
                this.setValue(FIELD_ACCEPT_COUNT, "0");
            }
            if (-1 < n2) {
                this.setValue(FIELD_DECLINE_COUNT, Integer.toString(n2));
            } else {
                this.setValue(FIELD_DECLINE_COUNT, "0");
            }
            if (-1 < n3) {
                this.setValue(FIELD_NO_RESPONSE_COUNT, Integer.toString(n3));
            } else {
                this.setValue(FIELD_NO_RESPONSE_COUNT, "0");
            }
            if (-1 < n4) {
                this.setValue(FIELD_UNDECIDED_COUNT, Integer.toString(n4));
            } else {
                this.setValue(FIELD_UNDECIDED_COUNT, "0");
            }
            this.setValue(FIELD_IS_RECURRING, this._currentEvent.isRecurring() ? "true" : "false");
            this.setValue(FIELD_IS_REMINDING, this._currentEvent.hasAlarm() ? "true" : "false");
            this.setValue(FIELD_IS_PUBLIC, this._currentEvent.isPublic() ? "true" : "false");
            Organizer organizer = this._currentEvent.getOrganizer();
            String string8 = null;
            String string9 = null;
            String string10 = null;
            if (null != organizer) {
                string9 = organizer.getValue();
                string8 = organizer.getCommonName();
                if (null == string8) {
                    string8 = organizer.getValue();
                }
                string10 = ((SOCSOrganizer)organizer).getEmail();
            }
            this.setValue(FIELD_START_DATE, UWCUtils.getDisplayableDate(this._reqCtx, (DateTime)calendarBaseModel, string3, string4));
            this.setValue(FIELD_START_DAY_DATE, UWCUtils.getDisplayableDayDate(this._reqCtx, (DateTime)calendarBaseModel));
            this.setValue(FIELD_START_DATE_TIME, UWCUtils.getDisplayableDateTime(this._reqCtx, (DateTime)calendarBaseModel, (DateTime)object4, string3, string4, string2));
            this.setValue(FIELD_ORGANIZER, string8);
            this.setValue(FIELD_ORG_CALID, string9);
            this.setValue(FIELD_ORGANIZER_EMAIL, string10);
            if (this._currentEvent.isCalIdTheOrganizer(this._currentEvent.getCalID())) {
                this.setValue(FIELD_IS_CALID_THE_ORGANIZER, "true");
            } else {
                this.setValue(FIELD_IS_CALID_THE_ORGANIZER, "false");
            }
        }
        catch (Exception exception) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Couldn't load the event. Reason: " + exception);
            }
            UWCUtils.printStackTrace(exception);
            throw new UWCException(65, "Couldn't load the event.");
        }
    }

    private void addEvent() throws UWCException {
        CalendarBaseModel calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        if (null == calendarBaseModel) {
            _log.severe("Couldn't get CalendarBaseModel: Can't add the event");
            throw new UWCException(66, "Couldn't get CalendarBaseModel object");
        }
        if (this._enableDuration) {
            this.makeTheEventWithDuration(true);
        } else {
            this.makeTheEvent(true);
        }
        calendarBaseModel.setTimeZone(this.getEventTimeZone(false));
        calendarBaseModel.removeAllCalids();
        calendarBaseModel.addCalid((String)this.getValue(FIELD_CALID));
        calendarBaseModel.addEvent(this._currentEvent, false);
    }

    private void modifyEvent() throws UWCException {
        CalendarBaseModel calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        if (null == calendarBaseModel) {
            _log.severe("Couldn't get CalendarBaseModel: Can't modify the event");
            throw new UWCException(67, "Couldn't get CalendarBaseModel object");
        }
        if (this._enableDuration) {
            this.makeTheEventWithDuration(false);
        } else {
            this.makeTheEvent(false);
        }
        if ("true".equalsIgnoreCase((String)this.getValue(FIELD_HAS_ATTENDEES_MODIFIED))) {
            _log.finest("Attendees changed? true");
            ((SOCSEvent)this._currentEvent).setAttendeeChange(true);
        } else {
            _log.finest("Attendees changed? false");
            ((SOCSEvent)this._currentEvent).removeAllAttendees();
            ((SOCSEvent)this._currentEvent).setAttendeeChange(false);
        }
        ((SOCSEvent)this._currentEvent).setAlarmChange(true);
        ((SOCSEvent)this._currentEvent).setAttachmentChange(false);
        ((SOCSEvent)this._currentEvent).setCategoryChange(true);
        ((SOCSEvent)this._currentEvent).setContactChange(false);
        ((SOCSEvent)this._currentEvent).setDescriptionChange(true);
        ((SOCSEvent)this._currentEvent).setExceptionDateChange(false);
        ((SOCSEvent)this._currentEvent).setExceptionRuleChange(false);
        ((SOCSEvent)this._currentEvent).setLocationChange(true);
        ((SOCSEvent)this._currentEvent).setRecurrenceDateChange(false);
        ((SOCSEvent)this._currentEvent).setRelatedToChange(false);
        ((SOCSEvent)this._currentEvent).setResourceChange(false);
        ((SOCSEvent)this._currentEvent).setSummaryChange(true);
        ((SOCSEvent)this._currentEvent).setUrlChange(false);
        calendarBaseModel.setTimeZone(this.getEventTimeZone(false));
        calendarBaseModel.removeAllCalids();
        calendarBaseModel.addCalid((String)this.getValue(FIELD_CALID));
        calendarBaseModel.modifyEvent(this._currentEvent, this._modifier, false);
    }

    private void updateEvent() throws UWCException {
        CalendarBaseModel calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        if (null == calendarBaseModel) {
            _log.severe("Couldn't get CalendarBaseModel: Can't update the event");
            throw new UWCException(68, "Couldn't get CalendarBaseModel object");
        }
        this.makeEventToUpdateStatus();
        ((SOCSEvent)this._currentEvent).setAlarmChange(this._isAlarmChanged);
        ((SOCSEvent)this._currentEvent).setAttendeeChange(false);
        ((SOCSEvent)this._currentEvent).setAttachmentChange(false);
        ((SOCSEvent)this._currentEvent).setCategoryChange(false);
        ((SOCSEvent)this._currentEvent).setContactChange(false);
        ((SOCSEvent)this._currentEvent).setDescriptionChange(false);
        ((SOCSEvent)this._currentEvent).setExceptionDateChange(false);
        ((SOCSEvent)this._currentEvent).setExceptionRuleChange(false);
        ((SOCSEvent)this._currentEvent).setLocationChange(false);
        ((SOCSEvent)this._currentEvent).setRecurrenceDateChange(false);
        ((SOCSEvent)this._currentEvent).setRecurrenceRuleChange(false);
        ((SOCSEvent)this._currentEvent).setRelatedToChange(false);
        ((SOCSEvent)this._currentEvent).setResourceChange(false);
        ((SOCSEvent)this._currentEvent).setSummaryChange(false);
        ((SOCSEvent)this._currentEvent).setUrlChange(false);
        calendarBaseModel.setTimeZone(this.getEventTimeZone(false));
        calendarBaseModel.removeAllCalids();
        calendarBaseModel.addCalid((String)this.getValue(FIELD_CALID));
        calendarBaseModel.modifyEvent(this._currentEvent, this._modifier, false);
    }

    private void deleteEvent() throws UWCException {
        CalendarBaseModel calendarBaseModel = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        if (null == calendarBaseModel) {
            _log.severe("Couldn't get CalendarBaseModel: Can't delete the event");
            throw new UWCException(69, "Couldn't get CalendarBaseModel object");
        }
        this.makeEventToDelete();
        calendarBaseModel.setTimeZone(this.getEventTimeZone(false));
        calendarBaseModel.removeAllCalids();
        calendarBaseModel.addCalid((String)this.getValue(FIELD_CALID));
        calendarBaseModel.deleteEvent(this._currentEvent, this._modifier, false);
    }

    private void makeTheEvent(boolean bl) throws UWCException {
        try {
            String string;
            String string2;
            String string3;
            int n;
            int n2;
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this._reqCtx, false);
            if (null == calendarStore) {
                String string4 = "Couldn't get CalendarStore object: Couldn't prepare the event";
                if (_log.isLoggable(Level.SEVERE)) {
                    _log.severe(string4);
                }
                if (bl) {
                    throw new UWCException(66, string4);
                }
                throw new UWCException(67, string4);
            }
            this._currentEvent = calendarStore.openCalendar().createEvent();
            if (null == this._currentEvent) {
                String string5 = "Couldn't create adapter specific Event object: Couldn't prepare the event";
                if (_log.isLoggable(Level.SEVERE)) {
                    _log.severe(string5);
                }
                if (bl) {
                    throw new UWCException(66, string5);
                }
                throw new UWCException(67, string5);
            }
            boolean bl2 = "true".equalsIgnoreCase((String)this.getValue(FIELD_IS_ALL_DAY));
            boolean bl3 = "true".equalsIgnoreCase((String)this.getValue(FIELD_SHOW_AS_BUSY));
            String string6 = (String)this.getValue(FIELD_START_DATE_MONTH);
            String string7 = (String)this.getValue(FIELD_START_DATE_DAY);
            String string8 = (String)this.getValue(FIELD_START_DATE_YEAR);
            String string9 = (String)this.getValue(FIELD_START_TIME_HOURS);
            String string10 = (String)this.getValue(FIELD_START_TIME_MINUTES);
            String string11 = (String)this.getValue(FIELD_END_DATE_MONTH);
            String string12 = (String)this.getValue(FIELD_END_DATE_DAY);
            String string13 = (String)this.getValue(FIELD_END_DATE_YEAR);
            String string14 = (String)this.getValue(FIELD_END_TIME_HOURS);
            String string15 = (String)this.getValue(FIELD_END_TIME_MINUTES);
            int n3 = UWCUtils.isStringContainedInStringArray(string6, UWCConstants.monthValues);
            int n4 = UWCUtils.isStringContainedInStringArray(string7, UWCConstants.dayValues);
            int n5 = UWCUtils.isStringContainedInStringArray(string8, UWCConstants.yearValues);
            int n6 = bl2 ? n3 : UWCUtils.isStringContainedInStringArray(string11, UWCConstants.monthValues);
            int n7 = bl2 ? n4 : UWCUtils.isStringContainedInStringArray(string12, UWCConstants.dayValues);
            int n8 = n2 = bl2 ? n5 : UWCUtils.isStringContainedInStringArray(string13, UWCConstants.yearValues);
            if (-1 == n3) {
                throw new IllegalArgumentException("Invalid event start date: Month value component [-1] is invalid");
            }
            if (-1 == n4) {
                throw new IllegalArgumentException("Invalid event start date: Day value component [-1] is invalid");
            }
            if (-1 == n5) {
                throw new IllegalArgumentException("Invalid event start date: Year value component [-1] is invalid");
            }
            if (-1 == n6) {
                throw new IllegalArgumentException("Invalid event end date: Month value component [-1] is invalid");
            }
            if (-1 == n7) {
                throw new IllegalArgumentException("Invalid event end date: Day value component [-1] is invalid");
            }
            if (-1 == n2) {
                throw new IllegalArgumentException("Invalid event end date: Year value component [-1] is invalid");
            }
            int n9 = UWCUtils.parseInteger(string7, "Couldn't parse start date day value to integer");
            int n10 = UWCUtils.parseInteger(string8, "Couldn't parse start date year value to integer");
            int n11 = bl2 ? 0 : UWCUtils.parseInteger(string9, "Couldn't parse start time hours value to integer");
            int n12 = bl2 ? 0 : UWCUtils.parseInteger(string10, "Couldn't parse start time minutes value to integer");
            int n13 = bl2 ? n9 : UWCUtils.parseInteger(string12, "Couldn't parse end date day value to integer");
            int n14 = bl2 ? n10 : UWCUtils.parseInteger(string13, "Couldn't parse end date year value to integer");
            int n15 = bl2 ? 0 : UWCUtils.parseInteger(string14, "Couldn't parse end time hours value to integer");
            int n16 = n = bl2 ? 0 : UWCUtils.parseInteger(string15, "Couldn't parse end time minutes value to integer");
            if (0 > n11 && 23 < n11) {
                throw new IllegalArgumentException("Invalid event start date: Hours value component [" + n11 + "] is invalid");
            }
            if (0 > n15 && 23 < n15) {
                throw new IllegalArgumentException("Invalid event end date: Hours value component [" + n15 + "] is invalid");
            }
            n11 += n12 / 60;
            n12 %= 60;
            n15 += n / 60;
            n %= 60;
            String string16 = (String)this.getValue(FIELD_PRIVACY);
            if (!(calendarEventPrivacyDefaultValue.equalsIgnoreCase(string16) || "PRIVATE".equalsIgnoreCase(string16) || "CONFIDENTIAL".equalsIgnoreCase(string16))) {
                string16 = calendarEventPrivacyDefaultValue;
            }
            String string17 = (String)this.getValue(FIELD_TITLE);
            String[] stringArray = UWCUtils.getStringArray(this.getValues(FIELD_CATEGORY));
            String string18 = (String)this.getValue(FIELD_LOCATION);
            String string19 = (String)this.getValue(FIELD_DESCRIPTION);
            TimeZone timeZone = this.getEventTimeZone(false);
            DateTime dateTime = null == timeZone ? new DateTime() : new DateTime(timeZone);
            dateTime.setDate(n10, n3, n9);
            dateTime.setTime(n11, n12, 0);
            dateTime.set(14, 0);
            DateTime dateTime2 = null == timeZone ? new DateTime() : new DateTime(timeZone);
            dateTime2.setDate(n14, n6, n13);
            dateTime2.setTime(n15, n, 0);
            dateTime2.set(14, 0);
            if (!bl) {
                string3 = (String)this.getValue(FIELD_EVENT_UID);
                string2 = (String)this.getValue(FIELD_EVENT_RID);
                if (null == string3) {
                    _log.severe("Couldn't get Event UID: Couldn't prepare the event");
                    throw new UWCException(67, "Couldn't get Event UID: Couldn't prepare the event");
                }
                this._currentEvent.setID(string3);
                this.setEventRecurrenceID(this._currentEvent, string2);
            }
            if (bl2) {
                dateTime.setTime(0, 0, 0);
                dateTime2.add(6, 1);
                dateTime2.setTime(0, 0, 0);
            }
            if (null != dateTime && null != this._recurrence && null != (string3 = this._recurrence.getUntilDate()) && string3.before((Object)dateTime)) {
                throw new UWCException(81);
            }
            if (bl) {
                this._currentEvent.setStartTime(dateTime);
                this._currentEvent.setEndTime(dateTime2);
            } else {
                boolean bl4 = true;
                boolean bl5 = true;
                string = (String)this.getValue(FIELD_PREVIOUS_START_DATE_TIME_IN_UTC);
                String string20 = (String)this.getValue(FIELD_PREVIOUS_END_DATE_TIME_IN_UTC);
                if (null != string && string.equalsIgnoreCase(dateTime.toISO8601())) {
                    bl4 = false;
                }
                if (null != string20 && string20.equalsIgnoreCase(dateTime2.toISO8601())) {
                    bl5 = false;
                }
                if (bl4 || bl5) {
                    this._currentEvent.setStartTime(dateTime);
                    this._currentEvent.setEndTime(dateTime2);
                }
            }
            if (null != string17) {
                this._currentEvent.setSummary(string17);
            }
            if (null != string16) {
                this._currentEvent.setClassification(string16);
            }
            if (null != string18) {
                this._currentEvent.setLocation(string18);
            }
            if (null != string19) {
                this._currentEvent.setDescription(string19);
            }
            if (null != stringArray) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this._currentEvent.addCategory(stringArray[i]);
                }
            }
            this._currentEvent.setAllDay(bl2);
            this._currentEvent.setProperty("TRANSP", (Object)(bl3 ? OPAQUE : TRANSPARENT));
            if (bl) {
                String string21 = (String)this.getValue(FIELD_CAL_PRIMARY_OWNER_NAME);
                string2 = (String)this.getValue(FIELD_CALID);
                string = new Organizer(string21, string2);
                this._currentEvent.setOrganizer((Organizer)string);
            }
            if (null != this._attendees) {
                for (int i = 0; i < this._attendees.length; ++i) {
                    this._currentEvent.addAttendee(this._attendees[i]);
                }
            }
            String string22 = (String)this.getValue(FIELD_PREVIOUS_RRULE_IN_RFC);
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Previous RRule: " + string22);
            }
            if (null != this._recurrence) {
                string2 = this._recurrence.toRFC2445();
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Current RRule: " + string2);
                }
                if (null != string22) {
                    if (string22.equalsIgnoreCase(string2)) {
                        ((SOCSEvent)this._currentEvent).setRecurrenceRuleChange(false);
                        _log.finest("RRule is NOT changed!");
                    } else {
                        _log.finest("RRule is changed!");
                        ((SOCSEvent)this._currentEvent).setRecurrenceRuleChange(true);
                        this._currentEvent.addRecurrenceRule(this._recurrence);
                    }
                } else {
                    _log.finest("Previous RRule is null: Converting non-recurring to recurring event!");
                    ((SOCSEvent)this._currentEvent).setRecurrenceRuleChange(true);
                    this._currentEvent.addRecurrenceRule(this._recurrence);
                }
            } else if (null != string22) {
                _log.finest("Current RRule is null. But Previous RRule is non null: Converting recurring to non-recurring event!");
                ((SOCSEvent)this._currentEvent).setRecurrenceRuleChange(true);
            } else {
                _log.finest("Both Current and Previous RRule are null: No change in rrule");
                ((SOCSEvent)this._currentEvent).setRecurrenceRuleChange(false);
            }
            if (null != this._alarm) {
                this._currentEvent.addAlarmComponent(this._alarm);
            }
            ((SOCSEvent)this._currentEvent).setProperty(SOCSEvent.METHOD, (Object)"REQUEST");
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("makeTheEvent: Previous calid: " + (String)this.getValue(FIELD_PREVIOUS_CALID));
                _log.finest("makeTheEvent: Event calid: " + (String)this.getValue(FIELD_CALID));
                _log.finest("makeTheEvent: Event Dump:\n" + ((SOCSEvent)this._currentEvent).toRFC2445());
            }
        }
        catch (UWCException uWCException) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Couldn't prepare event. Reason: " + uWCException);
            }
            throw uWCException;
        }
        catch (Exception exception) {
            String string = "Couldn't prepare event.";
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe(string + " Reason: " + exception);
            }
            if (bl) {
                throw new UWCException(66, "Couldn't prepare event.");
            }
            throw new UWCException(67, "Couldn't prepare event.");
        }
    }

    private void makeTheEventWithDuration(boolean bl) throws UWCException {
        try {
            String string;
            String string2;
            String string3;
            int n;
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this._reqCtx, false);
            if (null == calendarStore) {
                String string4 = "Couldn't get CalendarStore object: Couldn't prepare the event";
                if (_log.isLoggable(Level.SEVERE)) {
                    _log.severe(string4);
                }
                if (bl) {
                    throw new UWCException(66, string4);
                }
                throw new UWCException(67, string4);
            }
            this._currentEvent = calendarStore.openCalendar().createEvent();
            if (null == this._currentEvent) {
                String string5 = "Couldn't create adapter specific Event object: Couldn't prepare the event";
                if (_log.isLoggable(Level.SEVERE)) {
                    _log.severe(string5);
                }
                if (bl) {
                    throw new UWCException(66, string5);
                }
                throw new UWCException(67, string5);
            }
            boolean bl2 = "true".equalsIgnoreCase((String)this.getValue(FIELD_IS_ALL_DAY));
            boolean bl3 = "true".equalsIgnoreCase((String)this.getValue(FIELD_SHOW_AS_BUSY));
            String string6 = (String)this.getValue(FIELD_START_DATE_MONTH);
            String string7 = (String)this.getValue(FIELD_START_DATE_DAY);
            String string8 = (String)this.getValue(FIELD_START_DATE_YEAR);
            String string9 = (String)this.getValue(FIELD_START_TIME_HOURS);
            String string10 = (String)this.getValue(FIELD_START_TIME_MINUTES);
            String string11 = (String)this.getValue(FIELD_DURATION_HOURS);
            String string12 = (String)this.getValue(FIELD_DURATION_MINUTES);
            int n2 = UWCUtils.isStringContainedInStringArray(string6, UWCConstants.monthValues);
            int n3 = UWCUtils.isStringContainedInStringArray(string7, UWCConstants.dayValues);
            int n4 = UWCUtils.isStringContainedInStringArray(string8, UWCConstants.yearValues);
            if (-1 == n2) {
                throw new IllegalArgumentException("Invalid event start date: Month value component [-1] is invalid");
            }
            if (-1 == n3) {
                throw new IllegalArgumentException("Invalid event start date: Day value component [-1] is invalid");
            }
            if (-1 == n4) {
                throw new IllegalArgumentException("Invalid event start date: Year value component [-1] is invalid");
            }
            int n5 = UWCUtils.parseInteger(string7, "Couldn't parse start date day value to integer");
            int n6 = UWCUtils.parseInteger(string8, "Couldn't parse start date year value to integer");
            int n7 = bl2 ? 0 : UWCUtils.parseInteger(string9, "Couldn't parse start time hours value to integer");
            int n8 = bl2 ? 0 : UWCUtils.parseInteger(string10, "Couldn't parse start time minutes value to integer");
            int n9 = bl2 ? 0 : UWCUtils.parseInteger(string11, "Couldn't parse duration hours value to integer");
            int n10 = n = bl2 ? 0 : UWCUtils.parseInteger(string12, "Couldn't parse duration minutes value to integer");
            if (0 > n7 && 23 < n7) {
                throw new IllegalArgumentException("Invalid event start date: Hours value component [" + n7 + "] is invalid");
            }
            if (0 > n9 && 23 < n9) {
                throw new IllegalArgumentException("Invalid event duration: DurationHours value component [" + n9 + "] is invalid");
            }
            if (0 > n && 59 < n) {
                throw new IllegalArgumentException("Invalid event duration: Duration Minutes value component [" + n + "] is invalid");
            }
            n7 += n8 / 60;
            n8 %= 60;
            String string13 = (String)this.getValue(FIELD_PRIVACY);
            if (!(calendarEventPrivacyDefaultValue.equalsIgnoreCase(string13) || "PRIVATE".equalsIgnoreCase(string13) || "CONFIDENTIAL".equalsIgnoreCase(string13))) {
                string13 = calendarEventPrivacyDefaultValue;
            }
            String string14 = (String)this.getValue(FIELD_TITLE);
            String[] stringArray = UWCUtils.getStringArray(this.getValues(FIELD_CATEGORY));
            String string15 = (String)this.getValue(FIELD_LOCATION);
            String string16 = (String)this.getValue(FIELD_DESCRIPTION);
            TimeZone timeZone = this.getEventTimeZone(false);
            DateTime dateTime = null == timeZone ? new DateTime() : new DateTime(timeZone);
            dateTime.setDate(n6, n2, n5);
            dateTime.setTime(n7, n8, 0);
            dateTime.set(14, 0);
            if (!bl) {
                string3 = (String)this.getValue(FIELD_EVENT_UID);
                string2 = (String)this.getValue(FIELD_EVENT_RID);
                if (null == string3) {
                    _log.severe("Couldn't get Event UID: Couldn't prepare the event");
                    throw new UWCException(67, "Couldn't get Event UID: Couldn't prepare the event");
                }
                this._currentEvent.setID(string3);
                this.setEventRecurrenceID(this._currentEvent, string2);
            }
            string3 = null;
            if (bl2) {
                dateTime.setTime(0, 0, 0);
                string3 = (DateTime)dateTime.clone();
                string3.add(6, 1);
            } else {
                string3 = (DateTime)dateTime.clone();
                string3.add(new Duration(n9, n));
            }
            if (null != dateTime && null != this._recurrence && null != (string2 = this._recurrence.getUntilDate()) && string2.before((Object)dateTime)) {
                throw new UWCException(81);
            }
            if (bl) {
                this._currentEvent.setStartTime(dateTime);
                this._currentEvent.setEndTime((DateTime)string3);
            } else {
                boolean bl4 = true;
                boolean bl5 = true;
                string = (String)this.getValue(FIELD_PREVIOUS_START_DATE_TIME_IN_UTC);
                String string17 = (String)this.getValue(FIELD_PREVIOUS_END_DATE_TIME_IN_UTC);
                if (null != string && string.equalsIgnoreCase(dateTime.toISO8601())) {
                    bl4 = false;
                }
                if (null != string17 && string17.equalsIgnoreCase(string3.toISO8601())) {
                    bl5 = false;
                }
                if (bl4 || bl5) {
                    this._currentEvent.setStartTime(dateTime);
                    this._currentEvent.setEndTime((DateTime)string3);
                }
            }
            if (null != string14) {
                this._currentEvent.setSummary(string14);
            }
            if (null != string13) {
                this._currentEvent.setClassification(string13);
            }
            if (null != string15) {
                this._currentEvent.setLocation(string15);
            }
            if (null != string16) {
                this._currentEvent.setDescription(string16);
            }
            if (null != stringArray) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this._currentEvent.addCategory(stringArray[i]);
                }
            }
            this._currentEvent.setAllDay(bl2);
            this._currentEvent.setProperty("TRANSP", (Object)(bl3 ? OPAQUE : TRANSPARENT));
            if (bl) {
                String string18 = (String)this.getValue(FIELD_CAL_PRIMARY_OWNER_NAME);
                String string19 = (String)this.getValue(FIELD_CALID);
                string = new Organizer(string18, string19);
                this._currentEvent.setOrganizer((Organizer)string);
            }
            if (null != this._attendees) {
                for (int i = 0; i < this._attendees.length; ++i) {
                    this._currentEvent.addAttendee(this._attendees[i]);
                }
            }
            String string20 = (String)this.getValue(FIELD_PREVIOUS_RRULE_IN_RFC);
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Previous RRule: " + string20);
            }
            if (null != this._recurrence) {
                String string21 = this._recurrence.toRFC2445();
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Current RRule: " + string21);
                }
                if (null != string20) {
                    if (string20.equalsIgnoreCase(string21)) {
                        ((SOCSEvent)this._currentEvent).setRecurrenceRuleChange(false);
                        _log.finest("RRule is NOT changed!");
                    } else {
                        _log.finest("RRule is changed!");
                        ((SOCSEvent)this._currentEvent).setRecurrenceRuleChange(true);
                        this._currentEvent.addRecurrenceRule(this._recurrence);
                    }
                } else {
                    _log.finest("Previous RRule is null: Converting non-recurring to recurring event!");
                    ((SOCSEvent)this._currentEvent).setRecurrenceRuleChange(true);
                    this._currentEvent.addRecurrenceRule(this._recurrence);
                }
            } else if (null != string20) {
                _log.finest("Current RRule is null. But Previous RRule is non null: Converting recurring to non-recurring event!");
                ((SOCSEvent)this._currentEvent).setRecurrenceRuleChange(true);
            } else {
                _log.finest("Both Current and Previous RRule are null: No change in rrule");
                ((SOCSEvent)this._currentEvent).setRecurrenceRuleChange(false);
            }
            if (null != this._alarm) {
                this._currentEvent.addAlarmComponent(this._alarm);
            }
            ((SOCSEvent)this._currentEvent).setProperty(SOCSEvent.METHOD, (Object)"REQUEST");
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("makeTheEventWithDuration: Previous calid: " + (String)this.getValue(FIELD_PREVIOUS_CALID));
                _log.finest("makeTheEventWithDuration: Event calid: " + (String)this.getValue(FIELD_CALID));
                _log.finest("makeTheEventWithDuration: Event Dump:\n" + ((SOCSEvent)this._currentEvent).toRFC2445());
            }
        }
        catch (UWCException uWCException) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Couldn't prepare event. Reason: " + uWCException);
            }
            throw uWCException;
        }
        catch (Exception exception) {
            String string = "Couldn't prepare event.";
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe(string + " Reason: " + exception);
            }
            if (bl) {
                throw new UWCException(66, "Couldn't prepare event.");
            }
            throw new UWCException(67, "Couldn't prepare event.");
        }
    }

    private void makeEventToUpdateStatus() throws UWCException {
        try {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            Attendee attendee;
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this._reqCtx, false);
            if (null == calendarStore) {
                _log.severe("Couldn't get CalendarStore object: Couldn't prepare the event");
                throw new UWCException(68, "Couldn't get CalendarStore object: Couldn't prepare the event");
            }
            this._currentEvent = calendarStore.openCalendar().createEvent();
            if (null == this._currentEvent) {
                _log.severe("Couldn't create adapter specific Event object: Couldn't prepare the event");
                throw new UWCException(68, "Couldn't create adapter specific Event object: Couldn't prepare the event");
            }
            String string6 = (String)this.getValue(FIELD_ATTENDEE_VALUE);
            String string7 = (String)this.getValue(FIELD_ATTENDEE_COMMON_NAME);
            String string8 = (String)this.getValue(FIELD_ATTENDEE_STATUS);
            String string9 = (String)this.getValue(FIELD_ATTENDEE_COMMENT);
            String string10 = (String)this.getValue(FIELD_COMMENTS);
            boolean bl = "true".equalsIgnoreCase((String)this.getValue(FIELD_SEND_RSVP));
            String string11 = null == string7 ? string6 : string7;
            String string12 = "yyyy-MM-dd  EEE, d MMM yyyy HH:mm:ss z Z";
            TimeZone timeZone = this.getEventTimeZone(true);
            DateTime dateTime = new DateTime(timeZone);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string12);
            simpleDateFormat.setTimeZone(timeZone);
            simpleDateFormat.setLenient(false);
            String string13 = simpleDateFormat.format(dateTime.getTime());
            if (null != string9 && !string9.trim().equals("")) {
                attendee = new NonSyncStringBuffer(512);
                attendee.append(null == string10 ? "" : string10 + "\n\n");
                attendee.append(null == string11 ? "" : string11);
                attendee.append("  ");
                attendee.append(string13);
                attendee.append(":  \n");
                attendee.append(null == string9 ? "" : string9);
                string10 = attendee.toString();
            }
            attendee = new Attendee("INDIVIDUAL", string6);
            if (null != string7) {
                attendee.setCommonName(string7);
            }
            if (null != string8) {
                attendee.setParticipantStatus(string8);
            }
            attendee.setRSVPRequired(bl);
            if (null != this._attendeeForEventCalid) {
                string5 = this._attendeeForEventCalid.getLanguage();
                string4 = this._attendeeForEventCalid.getDir();
                string3 = this._attendeeForEventCalid.getSentBy();
                string2 = this._attendeeForEventCalid.getUserType();
                string = this._attendeeForEventCalid.getRole();
                String string14 = this._attendeeForEventCalid.getDelegatedTo();
                String string15 = this._attendeeForEventCalid.getDelegatedFrom();
                String string16 = this._attendeeForEventCalid.getMember();
                if (null == string5) {
                    attendee.setLanguage(string5);
                }
                if (null == string4) {
                    attendee.setDir(string4);
                }
                if (null == string3) {
                    attendee.setSentBy(string3);
                }
                if (null == string2) {
                    attendee.setUserType(string2);
                }
                if (null == string) {
                    attendee.setRole(string);
                }
                if (null == string14) {
                    attendee.setDelegatedTo(string14);
                }
                if (null == string15) {
                    attendee.setDelegatedFrom(string15);
                }
                if (null == string16) {
                    attendee.setMember(string16);
                }
            }
            string5 = (String)this.getValue(FIELD_EVENT_UID);
            string4 = (String)this.getValue(FIELD_EVENT_RID);
            if (null == string5) {
                _log.severe("Couldn't get Event UID: Couldn't prepare the event");
                throw new UWCException(68, "Couldn't get Event UID: Couldn't prepare the event");
            }
            this._currentEvent.setID(string5);
            this.setEventRecurrenceID(this._currentEvent, string4);
            this._currentEvent.addAttendee(attendee);
            if (null != string9) {
                this._currentEvent.addComment(string10);
            }
            if (null != this._alarm) {
                this._currentEvent.addAlarmComponent(this._alarm);
                string3 = (String)this.getValue(FIELD_ISO_8601_START_DATE_TIME);
                if (null != string3) {
                    string2 = new DateTime(string3);
                    this._currentEvent.setStartTime((DateTime)string2);
                }
            }
            string3 = (String)this.getValue(FIELD_CAL_PRIMARY_OWNER_NAME);
            string2 = (String)this.getValue(FIELD_ORGANIZER);
            if (null != string2) {
                string = new Organizer(string3, string2);
                this._currentEvent.setOrganizer((Organizer)string);
            }
            ((SOCSEvent)this._currentEvent).setProperty(SOCSEvent.METHOD, (Object)"REPLY");
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("makeEventToUpdateStatus: Previous calid: " + (String)this.getValue(FIELD_PREVIOUS_CALID));
                _log.finest("makeEventToUpdateStatus: Event calid: " + (String)this.getValue(FIELD_CALID));
                _log.finest("makeEventToUpdateStatus: Event Dump:\n" + ((SOCSEvent)this._currentEvent).toRFC2445());
            }
        }
        catch (UWCException uWCException) {
            throw uWCException;
        }
        catch (Exception exception) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Couldn't prepare event. Reason: " + exception);
            }
            throw new UWCException(68, "Couldn't prepare event.");
        }
    }

    private void makeEventToDelete() throws UWCException {
        try {
            CalendarStore calendarStore = UWCUserHelper.getCalStore(this._reqCtx, false);
            if (null == calendarStore) {
                _log.severe("Couldn't get CalendarStore object: Couldn't prepare the event");
                throw new UWCException(69, "Couldn't get CalendarStore object: Couldn't prepare the event");
            }
            this._currentEvent = calendarStore.openCalendar().createEvent();
            if (null == this._currentEvent) {
                _log.severe("Couldn't create adapter specific Event object: Couldn't prepare the event");
                throw new UWCException(69, "Couldn't create adapter specific Event object: Couldn't prepare the event");
            }
            String string = (String)this.getValue(FIELD_EVENT_UID);
            String string2 = (String)this.getValue(FIELD_EVENT_RID);
            if (null == string) {
                _log.severe("Couldn't get Event UID: Couldn't prepare the event");
                throw new UWCException(69, "Couldn't get Event UID: Couldn't prepare the event");
            }
            this._currentEvent.setID(string);
            this.setEventRecurrenceID(this._currentEvent, string2);
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("makeEventToDelete: Previous calid: " + (String)this.getValue(FIELD_PREVIOUS_CALID));
                _log.finest("makeEventToDelete: Event calid: " + (String)this.getValue(FIELD_CALID));
                _log.finest("makeEventToDelete: Event Dump:\n" + ((SOCSEvent)this._currentEvent).toRFC2445());
            }
        }
        catch (UWCException uWCException) {
            throw uWCException;
        }
        catch (Exception exception) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.severe("Couldn't prepare event. Reason: " + exception);
            }
            throw new UWCException(69, "Couldn't prepare event.");
        }
    }

    private void setEventRecurrenceID(VEvent vEvent, String string) throws ParseException {
        if ("THIS_AND_ALL".equals(this._modifier)) {
            return;
        }
        if (null == vEvent || null == string) {
            return;
        }
        DateTime dateTime = new DateTime(string);
        if (null != dateTime) {
            vEvent.setProperty("RECURRENCE-ID", (Object)dateTime);
        }
    }

    public TimeZone getEventTimeZone(boolean bl) {
        String string = (String)this.getValue(FIELD_TIME_ZONE);
        if (null == string || string.trim().equals("")) {
            if (bl) {
                string = "GMT";
            } else {
                return null;
            }
        }
        TimeZone timeZone = TimeZone.getTimeZone(string);
        return timeZone;
    }

    public DateTime getEventStartDate() throws IllegalArgumentException, NumberFormatException {
        int n;
        boolean bl = "true".equalsIgnoreCase((String)this.getValue(FIELD_IS_ALL_DAY));
        String string = (String)this.getValue(FIELD_START_DATE_MONTH);
        String string2 = (String)this.getValue(FIELD_START_DATE_DAY);
        String string3 = (String)this.getValue(FIELD_START_DATE_YEAR);
        String string4 = (String)this.getValue(FIELD_START_TIME_HOURS);
        String string5 = (String)this.getValue(FIELD_START_TIME_MINUTES);
        int n2 = UWCUtils.isStringContainedInStringArray(string, UWCConstants.monthValues);
        int n3 = UWCUtils.isStringContainedInStringArray(string2, UWCConstants.dayValues);
        int n4 = UWCUtils.isStringContainedInStringArray(string3, UWCConstants.yearValues);
        if (-1 == n2) {
            throw new IllegalArgumentException("Invalid event start date: Month value component [-1] is invalid");
        }
        if (-1 == n3) {
            throw new IllegalArgumentException("Invalid event start date: Day value component [-1] is invalid");
        }
        if (-1 == n4) {
            throw new IllegalArgumentException("Invalid event start date: Year value component [-1] is invalid");
        }
        int n5 = UWCUtils.parseInteger(string2, "Couldn't parse start date day value to integer");
        int n6 = UWCUtils.parseInteger(string3, "Couldn't parse start date year value to integer");
        int n7 = bl ? 0 : UWCUtils.parseInteger(string4, "Couldn't parse start time hours value to integer");
        int n8 = n = bl ? 0 : UWCUtils.parseInteger(string5, "Couldn't parse start time minutes value to integer");
        if (0 > n7 && 23 < n7) {
            throw new IllegalArgumentException("Invalid event start date: Hours value component [" + n7 + "] is invalid");
        }
        n7 += n / 60;
        TimeZone timeZone = this.getEventTimeZone(false);
        DateTime dateTime = null == timeZone ? new DateTime() : new DateTime(timeZone);
        dateTime.setDate(n6, n2, n5);
        dateTime.setTime(n7, n %= 60, 0);
        return dateTime;
    }

    static {
        _log = UWCLogger.getLogger("uwc.common.model");
    }
}

