/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient.model;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.uwc.calclient.model.CalendarBaseModel;
import com.sun.uwc.calclient.model.DisplayEvent;
import com.sun.uwc.calclient.model.DisplayRow;
import com.sun.uwc.calclient.model.EventsModel;
import com.sun.uwc.calclient.model.UWCCalendar;
import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.util.UWCLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;

public class DayViewEventsModel
extends EventsModel {
    public static final String FIELD_EDIT = "isedit";
    public static final String FIELD_OWNED = "owned";
    public static final String FIELD_UPDATE = "isupdate";
    public static final String FIELD_ISFREEBUSYONLY = "isavailabilityonly";
    public static final String FIELD_CAN_DELETE = "candelete";
    public static final String FIELD_CAN_READ = "canread";
    public static final String FIELD_CAN_MODIFY = "canmodify";
    public static final String FIELD_CALENDAR_OWNER_COMMON_NAME = "calendarownername";
    public static final String FIELD_IS_LAST_EVENT = "islastevent";
    public static final String FIELD_NO_ATTENDEES = "noofattendees";
    private DateTime daystart = null;
    private DateTime dayend = null;
    private Duration dayinterval = null;
    private CalendarComponent[][] dayevents = new CalendarComponent[50][];
    private int[][] eventspan = new int[50][];
    private int[][] slotcolspan = new int[50][];
    private int[] noevents = new int[50];
    private boolean[] displayemptycol = new boolean[50];
    private int[] lastEventColSpan = new int[50];
    private int maxspan = 0;
    private int currentslot = 0;
    private int timeslots = 0;
    CalendarBaseModel cbm = null;
    private static Logger _modelLogger = null;
    private static final String CLASS_NAME = "DayViewEventsModel";
    private ArrayList eventlist = null;
    private HashMap calids = null;
    private String[] ownedcalids = null;
    private String userid = null;
    boolean isAnon = false;
    private DisplayRow[] displayRows = new DisplayRow[50];
    private int noOfAllDayEvents = 0;

    public DayViewEventsModel() {
    }

    public DayViewEventsModel(String string) {
        super(string);
    }

    public void setDayStart(DateTime dateTime) {
        this.daystart = dateTime;
    }

    public void setDayEnd(DateTime dateTime) {
        this.dayend = dateTime;
    }

    public void setInterval(Duration duration) {
        this.dayinterval = duration;
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        _modelLogger.entering(CLASS_NAME, "execute()");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.DAYVIEW_NON_ALLDAYEVENTS_CONTEXT;
        this.cbm = UWCUserHelper.getCalendarBaseModel(this._reqCtx);
        this.calids = this.cbm.getCalendars();
        this.ownedcalids = UWCUserHelper.getOwnedCalIDs(this._reqCtx);
        this.userid = UWCUserHelper.getUID(this._reqCtx);
        this.isAnon = UWCUserHelper.isAnonymous(this._reqCtx);
        if (this.isAnon) {
            this.userid = "@";
        }
        if (string.equals(CalendarExecutionModelContext.DAYVIEW_NON_ALLDAYEVENTS_CONTEXT)) {
            this.fetchDayEvents();
        }
        _modelLogger.exiting(CLASS_NAME, "execute()");
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        int n;
        Object object;
        _modelLogger.entering(CLASS_NAME, "execute()");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : CalendarExecutionModelContext.DAYVIEW_NON_ALLDAYEVENTS_CONTEXT;
        CalendarComponent[] calendarComponentArray = null;
        if (string.equals(CalendarExecutionModelContext.DAYVIEW_NON_ALLDAYEVENTS_CONTEXT)) {
            calendarComponentArray = this.dayevents[this.currentslot];
        } else {
            object = this.cbm.getAllDayEvents();
            if (object != null) {
                calendarComponentArray = new CalendarComponent[((ArrayList)object).size()];
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    calendarComponentArray[n] = (CalendarComponent)((ArrayList)object).get(n);
                }
            }
        }
        this.clear();
        if (calendarComponentArray != null) {
            object = new CalendarExecutionModelContext(CalendarExecutionModelContext.LOAD_EVENT_CONTEXT);
            for (n = 0; n < calendarComponentArray.length; ++n) {
                this.appendRow();
                this.setCurrentEvent((VEvent)calendarComponentArray[n]);
                super.retrieve((ModelExecutionContext)object);
                if (n == calendarComponentArray.length - 1) {
                    this.setValue(FIELD_IS_LAST_EVENT, "true");
                } else {
                    this.setValue(FIELD_IS_LAST_EVENT, "false");
                }
                try {
                    Object object2;
                    Object object3;
                    String string2 = ((VEvent)calendarComponentArray[n]).getCalID();
                    UWCCalendar uWCCalendar = (UWCCalendar)this.calids.get(string2);
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    if (null != uWCCalendar) {
                        String string3;
                        Object object4;
                        object3 = (VEvent)calendarComponentArray[n];
                        if (!this.isAnon) {
                            Attendee[] attendeeArray;
                            object2 = null;
                            object4 = (SOCSCalendar)uWCCalendar.getCalendar();
                            object2 = object4.getRelativeCalId();
                            bl2 = UWCUserHelper.isUserTheCalendarOwner(this._reqCtx, string2, this.userid);
                            if (!bl2) {
                                string3 = null;
                                string3 = ((SOCSCalendar)uWCCalendar.getCalendar()).getOwnerCommonName();
                                this.setValue(FIELD_CALENDAR_OWNER_COMMON_NAME, string3);
                            }
                            bl3 = object3.isCalIdTheOrganizer((String)object2);
                            string3 = object3.getAttendee((String)object2);
                            if (string3 != null) {
                                bl4 = true;
                            }
                            if (null != (attendeeArray = object3.getAttendees()) && attendeeArray.length > 0) {
                                this.setValue(FIELD_NO_ATTENDEES, "1");
                            } else {
                                this.setValue(FIELD_NO_ATTENDEES, "0");
                            }
                            bl7 = UWCUserHelper.hasCalendarPermission(uWCCalendar, this.userid, "c", "w");
                            bl5 = bl7 ? true : UWCUserHelper.hasCalendarPermission(uWCCalendar, this.userid, "c", "r");
                            bl = UWCUserHelper.hasCalendarPermission(uWCCalendar, this.userid, "c", "d");
                            bl6 = UWCUserHelper.hasCalendarPermission(uWCCalendar, this.userid, "c", "f");
                        } else {
                            object2 = new Properties();
                            object4 = SOCSCalendar.getCalProps((String)string2, (String)UWCApplicationHelper.getWCAPHost(), (int)UWCApplicationHelper.getWCAPPort(), (Properties)object2);
                            if (object4 != null) {
                                string3 = ((Properties)object4).getProperty("COMMON_NAME");
                                this.setValue(FIELD_CALENDAR_OWNER_COMMON_NAME, string3);
                            }
                        }
                    }
                    if (bl2) {
                        this.setValue(FIELD_OWNED, "true");
                    } else {
                        this.setValue(FIELD_OWNED, "false");
                    }
                    this.setValue(FIELD_CAN_DELETE, bl ? "true" : "false");
                    object3 = "false";
                    object2 = "false";
                    if (bl7) {
                        if (bl3 && bl4) {
                            object3 = "true";
                            object2 = "true";
                        } else if (bl4) {
                            object3 = "false";
                            object2 = "true";
                        } else if (bl3) {
                            object3 = "true";
                            object2 = "false";
                        }
                    }
                    this.setValue(FIELD_EDIT, object3);
                    this.setValue(FIELD_UPDATE, object2);
                    if (bl7) {
                        this.setValue(FIELD_CAN_MODIFY, "true");
                    } else {
                        this.setValue(FIELD_CAN_MODIFY, "false");
                    }
                    if (bl5) {
                        this.setValue(FIELD_CAN_READ, "true");
                    } else {
                        this.setValue(FIELD_CAN_READ, "false");
                    }
                    if (bl6) {
                        this.setValue(FIELD_ISFREEBUSYONLY, "true");
                        continue;
                    }
                    this.setValue(FIELD_ISFREEBUSYONLY, "false");
                    continue;
                }
                catch (OperationNotSupportedException operationNotSupportedException) {
                    _modelLogger.severe("OperationNotSupportedException Exception");
                    throw new ModelControlException();
                }
                catch (CalendarComponentException calendarComponentException) {
                    _modelLogger.info("CalendarComponentException Exception");
                    throw new ModelControlException();
                }
                catch (UWCException uWCException) {
                    _modelLogger.severe("UWCException Exception");
                    throw new ModelControlException(uWCException.getDetails());
                }
                catch (Exception exception) {
                    throw new ModelControlException();
                }
            }
        }
        this.beforeFirst();
        return null;
    }

    public void fetchDayEvents() throws ModelControlException {
        _modelLogger.entering(CLASS_NAME, "fetchDayEvents()");
        boolean bl = true;
        DateTime dateTime = null;
        DateTime dateTime2 = this.daystart;
        int n = 0;
        try {
            this.eventlist = this.cbm.getNonAllDayEvents();
            DateTime dateTime3 = null;
            int n2 = dateTime2.get(5);
            while (bl) {
                dateTime = (DateTime)dateTime2.clone();
                dateTime3 = (DateTime)dateTime2.clone();
                dateTime2.add(10, this.dayinterval.getHours());
                dateTime2.add(12, this.dayinterval.getMinutes());
                CalendarComponent[] calendarComponentArray = this.fetchEventsByTimeSlot(dateTime, dateTime2);
                if (calendarComponentArray != null) {
                    if (null == this.displayRows[n]) {
                        this.displayRows[n] = new DisplayRow(n);
                    }
                    this.dayevents[n] = (CalendarComponent[])calendarComponentArray.clone();
                    this.eventspan[n] = new int[this.dayevents[n].length];
                    for (int i = 0; i < this.dayevents[n].length; ++i) {
                        DisplayEvent displayEvent = new DisplayEvent((VEvent)this.dayevents[n][i], n);
                        this.displayRows[n].addStartEvent(displayEvent);
                        int n3 = 0;
                        dateTime3 = (DateTime)dateTime.clone();
                        VEvent vEvent = (VEvent)this.dayevents[n][i];
                        DateTime dateTime4 = (DateTime)dateTime2.clone();
                        DateTime dateTime5 = (DateTime)vEvent.getEndTime().clone();
                        boolean bl2 = true;
                        while (bl2) {
                            if (dateTime4.after((Object)dateTime5)) {
                                bl2 = false;
                                if (!dateTime5.after((Object)dateTime3)) break;
                            }
                            if (++n3 > 1) {
                                int n4 = n + n3 - 1;
                                this.noevents[n4] = this.noevents[n4] + 1;
                                if (null == this.displayRows[n + n3 - 1]) {
                                    this.displayRows[n + n3 - 1] = new DisplayRow(n + n3 - 1);
                                }
                                this.displayRows[n + n3 - 1].addContainedEvent(displayEvent);
                                displayEvent.setSlotOccupied(n + n3 - 1);
                            }
                            dateTime4.add(10, this.dayinterval.getHours());
                            dateTime4.add(12, this.dayinterval.getMinutes());
                            dateTime3.add(10, this.dayinterval.getHours());
                            dateTime3.add(12, this.dayinterval.getMinutes());
                            if (dateTime3.get(5) == n2) continue;
                            bl2 = false;
                        }
                        this.eventspan[n][i] = n3;
                    }
                } else {
                    this.dayevents[n] = null;
                    this.eventspan[n] = null;
                }
                ++n;
                if (!dateTime2.after((Object)this.dayend)) continue;
                bl = false;
                this.timeslots = n;
            }
        }
        catch (CalendarComponentException calendarComponentException) {
            _modelLogger.severe("loadCalendar Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarComponentException));
            throw new ModelControlException();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _modelLogger.severe("loadCalendar Failed with OperationNotSupportedException: " + (Object)((Object)operationNotSupportedException));
            throw new ModelControlException();
        }
        this.maxspan = this.CalculateMaxTimeSpan();
        this.calRowColSpan();
        _modelLogger.exiting(CLASS_NAME, "fetchDayEvents()");
    }

    public void setCurrentSlot(int n) {
        this.currentslot = n;
    }

    public int getCurrentSlot() {
        return this.currentslot;
    }

    int CalculateMaxTimeSpan() {
        int n = 0;
        for (int i = 0; i < this.timeslots; ++i) {
            int n2 = this.noevents[i];
            if (this.dayevents[i] != null) {
                n2 += this.dayevents[i].length;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        ArrayList arrayList = this.cbm.getAllDayEvents();
        if (null != arrayList) {
            this.noOfAllDayEvents = arrayList.size();
            if (n < this.noOfAllDayEvents) {
                n = this.noOfAllDayEvents;
            }
        }
        if (n < 3) {
            n = 3;
        }
        return n;
    }

    public int getMaxSpan() {
        return this.maxspan;
    }

    public int getNoOfAllDayEvents() {
        return this.noOfAllDayEvents;
    }

    public int getConflicts() {
        if (this.dayevents[this.currentslot] != null) {
            return this.dayevents[this.currentslot].length;
        }
        return 0;
    }

    public int getNumberOfEvents() {
        if (this.dayevents[this.currentslot] == null) {
            return this.noevents[this.currentslot];
        }
        return this.dayevents[this.currentslot].length + this.noevents[this.currentslot];
    }

    public int getNumberOfStartEvents() {
        if (this.dayevents[this.currentslot] == null) {
            return 0;
        }
        return this.dayevents[this.currentslot].length;
    }

    public int getEventTimeSpan(int n) {
        int n2 = 0;
        if (this.eventspan[this.currentslot] != null && this.eventspan[this.currentslot].length != 0) {
            n2 = n + 1 > this.eventspan[this.currentslot].length ? -1 : this.eventspan[this.currentslot][n];
        }
        return n2;
    }

    public int getNumberOfEvents(int n) {
        if (this.dayevents[n] == null) {
            return this.noevents[n];
        }
        return this.dayevents[n].length + this.noevents[n];
    }

    public int getNumberOfStartEvents(int n) {
        if (this.dayevents[n] == null) {
            return 0;
        }
        return this.dayevents[n].length;
    }

    public boolean isEmptyCol(int n) {
        return this.displayemptycol[n];
    }

    public void setIsEmptyCol(int n, boolean bl) {
        this.displayemptycol[n] = bl;
    }

    public int getLastEventColSpan() {
        return this.lastEventColSpan[this.currentslot];
    }

    public int getEventTimeSpan(int n, int n2) {
        _modelLogger.entering(CLASS_NAME, "fetchEventsByTimeSlot(getEventTimeSpan(int slot, int index)");
        int n3 = 0;
        if (this.eventspan[n] != null && this.eventspan[n].length != 0) {
            n3 = n2 + 1 > this.eventspan[n].length ? -1 : this.eventspan[n][n2];
        }
        return n3;
    }

    private CalendarComponent[] fetchEventsByTimeSlot(DateTime dateTime, DateTime dateTime2) throws ModelControlException {
        _modelLogger.entering(CLASS_NAME, "fetchEventsByTimeSlot()");
        Vector vector = new Vector();
        try {
            for (int i = 0; i < this.eventlist.size(); ++i) {
                int n;
                int n2;
                VEvent vEvent = (VEvent)this.eventlist.get(i);
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                DateTime dateTime3 = vEvent.getStartTime();
                DateTime dateTime4 = vEvent.getEndTime();
                if (vEvent.getStartTime().after((Object)dateTime) && dateTime3.before((Object)dateTime2)) {
                    bl3 = true;
                }
                if (dateTime3.before((Object)dateTime)) {
                    bl = true;
                }
                if (dateTime3.equals((Object)dateTime)) {
                    bl2 = true;
                }
                if (bl3 && dateTime4.before((Object)dateTime2)) {
                    vector.add(this.eventlist.get(i));
                    this.eventlist.remove(i);
                    --i;
                }
                if (bl3 && dateTime4.equals((Object)dateTime2)) {
                    vector.add(this.eventlist.get(i));
                    this.eventlist.remove(i);
                    --i;
                }
                if (bl3 && dateTime4.after((Object)dateTime2)) {
                    vector.add(this.eventlist.get(i));
                    this.eventlist.remove(i);
                    --i;
                }
                if (bl2 && dateTime4.before((Object)dateTime2)) {
                    vector.add(this.eventlist.get(i));
                    this.eventlist.remove(i);
                    --i;
                }
                if (bl2 && vEvent.getEndTime().after((Object)dateTime2)) {
                    vector.add(this.eventlist.get(i));
                    this.eventlist.remove(i);
                    --i;
                }
                if (bl2 && vEvent.getEndTime().equals((Object)dateTime2)) {
                    vector.add(this.eventlist.get(i));
                    this.eventlist.remove(i);
                    --i;
                }
                if (!bl) continue;
                int n3 = dateTime.get(11);
                int n4 = dateTime.get(12);
                if (n3 != 0 || n4 != 0 || (n2 = dateTime.get(5)) == (n = dateTime3.get(5))) continue;
                vector.add(this.eventlist.get(i));
                this.eventlist.remove(i);
                --i;
            }
        }
        catch (CalendarComponentException calendarComponentException) {
            _modelLogger.severe("loadCalendar Failed with CalendarStoreException: Unable to get ICalendar object: " + (Object)((Object)calendarComponentException));
            throw new ModelControlException();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            _modelLogger.severe("loadCalendar Failed with OperationNotSupportedException: " + (Object)((Object)operationNotSupportedException));
            throw new ModelControlException();
        }
        if (vector == null) {
            _modelLogger.info("FilterList is NULL");
            _modelLogger.exiting(CLASS_NAME, "fetchEventsByTimeSlot()");
            return null;
        }
        Object[] objectArray = new CalendarComponent[vector.size()];
        vector.copyInto(objectArray);
        _modelLogger.exiting(CLASS_NAME, "fetchEventsByTimeSlot()");
        return objectArray;
    }

    private void calRowColSpan() {
        _modelLogger.entering(CLASS_NAME, "calRowColSpan()");
        for (int i = 0; i < this.timeslots; ++i) {
            DisplayEvent displayEvent;
            _modelLogger.finest("Slot # " + i);
            DisplayRow displayRow = this.displayRows[i];
            if (null == displayRow) continue;
            ArrayList arrayList = displayRow.getContainEventsList();
            int n = 0;
            int n2 = 0;
            if (null != arrayList && arrayList.size() > 0) {
                n2 = arrayList.size();
                for (int j = 0; j < arrayList.size(); ++j) {
                    displayEvent = (DisplayEvent)arrayList.get(j);
                    n += displayEvent.getColSpan();
                }
            }
            _modelLogger.finest("Total Col Span for Contained Events = " + n);
            ArrayList arrayList2 = displayRow.getStartEventsList();
            if (null != arrayList2 && arrayList2.size() > 0) {
                n2 += arrayList2.size();
                this.lastEventColSpan[i] = 1;
                _modelLogger.finest("Total Col Span for Contained Events  + startevents  = " + (n += arrayList2.size()));
                if (n < this.maxspan) {
                    displayEvent = (DisplayEvent)arrayList2.get(arrayList2.size() - 1);
                    int n3 = displayEvent.getNoOfSlotsOccupied();
                    _modelLogger.finest("No of Slots occupied by last event is " + n3);
                    if (n3 == 0) {
                        _modelLogger.finest("Col Span is Less than MaxSpan, so setting last event col span as = " + (this.maxspan - n + 1));
                        displayEvent.setColSpan(this.maxspan - n + 1);
                        this.lastEventColSpan[i] = this.maxspan - n + 1;
                    } else {
                        boolean bl = true;
                        _modelLogger.finest("Total No of event in this slot is " + n2);
                        for (int j = 1; j <= n3; ++j) {
                            _modelLogger.finest("Total # of events for Slot " + (i + j) + " = " + this.getNumberOfEvents(i + j));
                            if (this.getNumberOfEvents(i + j) <= n2) continue;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            _modelLogger.finest("isExtend is True, setting last event col span as = " + (this.maxspan - n + 1));
                            displayEvent.setColSpan(this.maxspan - n + 1);
                            this.lastEventColSpan[i] = this.maxspan - n + 1;
                        }
                    }
                }
            }
            if (n2 <= 0) continue;
            this.displayemptycol[i] = false;
        }
    }

    static {
        _modelLogger = UWCLogger.getLogger("uwc.common.model");
    }
}

