/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.calclient;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.RequestHandler;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.model.ModelExecutionContext;
import com.sun.uwc.UWCServletBase;
import com.sun.uwc.calclient.model.CalendarListModel;
import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.CalUserPreferencesModel;
import com.sun.uwc.common.model.CalendarExecutionModelContext;
import com.sun.uwc.common.util.UWCLogger;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class CalModuleServlet
extends UWCServletBase {
    private static Logger _calLogger = UWCLogger.getLogger("uwc.calclient.view");
    public static final String DEFAULT_MODULE_URL = "/calclient";
    public static String PACKAGE_NAME = CalModuleServlet.getPackageName((String)(class$com$sun$uwc$calclient$CalModuleServlet == null ? (class$com$sun$uwc$calclient$CalModuleServlet = CalModuleServlet.class$("com.sun.uwc.calclient.CalModuleServlet")) : class$com$sun$uwc$calclient$CalModuleServlet).getName());
    private static HashMap CALVIEW_URL_MAP = new HashMap();
    private boolean _isAnonymous = false;
    private String DEFAULT_CAL_VIEW = "dayview";
    static /* synthetic */ Class class$com$sun$uwc$calclient$CalModuleServlet;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        CALVIEW_URL_MAP.put("dayview", "/calclient/DayView");
        CALVIEW_URL_MAP.put("weekview", "/calclient/WeekView");
        CALVIEW_URL_MAP.put("monthview", "/calclient/MonthView");
        CALVIEW_URL_MAP.put("yearview", "/calclient/YearView");
    }

    protected void initializeRequestContext(RequestContext requestContext) {
        super.initializeRequestContext(requestContext);
        ViewBeanManager viewBeanManager = new ViewBeanManager(requestContext, PACKAGE_NAME);
        ((RequestContextImpl)requestContext).setViewBeanManager(viewBeanManager);
        this._isAnonymous = false;
    }

    protected void onInitializeHandler(RequestContext requestContext, RequestHandler requestHandler) throws ServletException {
        super.onInitializeHandler(requestContext, requestHandler);
        HttpSession httpSession = requestContext.getRequest().getSession(false);
        String string = requestContext.getRequest().getParameter("anon");
        if (string != null && string.equals("true")) {
            this._isAnonymous = true;
        }
        if (!this._isAnonymous && (string = (String)httpSession.getAttribute("anon")) != null && string.equals("true")) {
            this._isAnonymous = true;
        }
        if (!this._isAnonymous) {
            try {
                UWCUserHelper.getCalStore(requestContext, true);
                if (_calLogger.isLoggable(Level.INFO)) {
                    _calLogger.info("[----- Obtained Calendar Session -------]");
                }
            }
            catch (Exception exception) {
                if (_calLogger.isLoggable(Level.SEVERE)) {
                    _calLogger.severe("Error[onBeforeRequest:getCalStore] " + exception.getMessage());
                }
                UWCApplicationHelper.forwardToErrorPage(requestContext, "server-misconfig");
            }
        }
        this.initCalSession(requestContext);
    }

    public String getModuleURL() {
        String string = super.getModuleURL();
        if (string != null) {
            return string;
        }
        return DEFAULT_MODULE_URL;
    }

    private void initCalSession(RequestContext requestContext) {
        HttpServletRequest httpServletRequest = requestContext.getRequest();
        HttpSession httpSession = httpServletRequest.getSession(false);
        String string = (String)httpSession.getAttribute("com.sun.uwc.calclient.init");
        String string2 = null;
        CalUserPreferencesModel calUserPreferencesModel = UWCUserHelper.getCalUserPrefModel(requestContext);
        try {
            Object object;
            String string3 = null;
            if (string == null) {
                calUserPreferencesModel.initializeCalendarPreferences();
                if (_calLogger.isLoggable(Level.INFO)) {
                    _calLogger.info("[----- Initialized the Calendar Preferences -------]");
                }
                if (this._isAnonymous) {
                    string3 = (String)httpSession.getAttribute("view");
                    if (string3 == null && (string3 = httpServletRequest.getParameter("view")) != null) {
                        httpSession.setAttribute("ceDefaultView", (Object)string3);
                    }
                    if ((object = (String)httpSession.getAttribute("tzid")) == null && (object = httpServletRequest.getParameter("tzid")) != null) {
                        httpSession.setAttribute("ceSingleCalendarTZID", object);
                    }
                } else {
                    object = UWCUserHelper.getCalendarListModel(requestContext);
                    CalendarExecutionModelContext calendarExecutionModelContext = new CalendarExecutionModelContext(CalendarExecutionModelContext.LOAD_MY_CALENDARS_CONTEXT);
                    ((CalendarListModel)((Object)object)).execute((ModelExecutionContext)calendarExecutionModelContext);
                    if (_calLogger.isLoggable(Level.INFO)) {
                        _calLogger.info("[----- Initialized Calendars in the session -------]");
                    }
                }
                httpSession.setAttribute("com.sun.uwc.calclient.init", (Object)"true");
            }
            if (this._isAnonymous) {
                object = httpServletRequest.getParameter("calid");
                if (object == null) {
                    object = (String)httpSession.getAttribute("calid");
                }
                if (object != null) {
                    string2 = "calid=" + (String)object;
                    if (((String)object).indexOf(";") > -1) {
                        string2 = string2 + "&caltype=temporaryCalendars";
                    }
                }
            }
            if (string3 == null) {
                string3 = calUserPreferencesModel.getDefaultView();
            }
            this.forwardToDefaultView(requestContext, string3, string2);
        }
        catch (Exception exception) {
            if (_calLogger.isLoggable(Level.SEVERE)) {
                _calLogger.severe("Error[initCalSession] " + exception.getMessage());
            }
            UWCApplicationHelper.forwardToErrorPage(requestContext, "server-misconfig");
        }
    }

    private void forwardToDefaultView(RequestContext requestContext, String string, String string2) {
        try {
            String string3 = (String)requestContext.getRequest().getAttribute("forwardtodefview");
            if (!CALVIEW_URL_MAP.containsKey(string)) {
                string = this.DEFAULT_CAL_VIEW;
            }
            if (string3 != null && string3.equals("true")) {
                String string4 = (String)CALVIEW_URL_MAP.get(string);
                if (string2 != null) {
                    string4 = string4 + "?" + string2;
                }
                requestContext.getRequest().removeAttribute("forwardtodefview");
                UWCApplicationHelper.forwardToURL(requestContext, string4);
            }
        }
        catch (ServletException servletException) {
            if (_calLogger.isLoggable(Level.SEVERE)) {
                _calLogger.severe("Error[initCalSession] " + servletException.getMessage());
            }
            UWCApplicationHelper.forwardToErrorPage(requestContext, "server-misconfig");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

