/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.abclient;

import com.iplanet.xslui.auth.ABUserSessionFactory;
import com.iplanet.xslui.auth.UserSession;
import com.sun.uwc.UWCISServletBase;
import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.auth.AuthFilter;
import com.sun.uwc.common.util.UWCLogger;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ABInitFilter
extends AuthFilter {
    private Preferences _preferences;
    private static final String CLASS_NAME = "ABInitFilter";
    private static final transient String DISPLAY_NAME = "cn";
    private static final transient String SBOOK_PSROOT = "psroot";
    private static final transient String UID = "uid";
    private static final transient String FQUID = "uid@domain";
    private static final transient String LOAD_ABS = "loadABs";
    private static final transient String MAIL = "mail";
    private static final transient String LOGOUT_XML = "/abs/logout.xml";
    private static final transient String LOGOUT_WABP = "/base/UWCMain?op=logout%26gotoUri=/wabp/login.wabp";
    private static Logger _abLogger = UWCLogger.getLogger("uwc.abclient");

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this._preferences = super.getPreferences();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        Object object;
        HttpSession httpSession;
        int n;
        _abLogger.entering(CLASS_NAME, "doFilter");
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String string = httpServletRequest.getParameter("IdentityHandled");
        if (UWCApplicationHelper.isIdentityEnabled() && string == null && (n = UWCISServletBase.handleIdentityEnabledUWC((HttpServletRequest)servletRequest)) == UWCISServletBase.LOGOUT) {
            try {
                String string2 = httpServletRequest.getRequestURI();
                String string3 = LOGOUT_XML;
                if (string2.indexOf("wabp") > -1) {
                    string3 = LOGOUT_WABP;
                }
                RequestDispatcher requestDispatcher = servletRequest.getRequestDispatcher(string3);
                requestDispatcher.forward(servletRequest, servletResponse);
                return;
            }
            catch (Exception exception) {
                _abLogger.severe("handleIdentityEnabledUWC:Error - " + exception.getMessage());
            }
        }
        if ((httpSession = httpServletRequest.getSession(false)) == null) {
            if (UWCApplicationHelper.IS_WARNING_LVL_LOGGABLE) {
                _abLogger.warning("Session is not created, user not authenticated!!");
            }
            servletRequest.setAttribute("integration", (Object)"true");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        UserSession userSession = (UserSession)httpSession.getAttribute("com.iplanet.xslui.ui.usersession");
        String string4 = (String)httpSession.getAttribute(LOAD_ABS);
        if (userSession != null && string4 == null) {
            if (UWCApplicationHelper.IS_WARNING_LVL_LOGGABLE) {
                _abLogger.warning("Address Book session already set!!");
            }
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        boolean bl = false;
        if (userSession == null && httpSession != null) {
            object = new ABUserSessionFactory();
            userSession = object.newUserSession(httpSession);
            bl = true;
        }
        if (userSession == null) {
            if (UWCApplicationHelper.IS_WARNING_LVL_LOGGABLE) {
                _abLogger.warning("Failed in preparing Address Book!!");
            }
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (bl) {
            httpSession.setAttribute("com.iplanet.xslui.ui.usersession", (Object)userSession);
            httpSession.setAttribute("integration", (Object)"true");
        }
        try {
            UWCUserHelper.loadAddressBooks(httpSession, userSession);
        }
        catch (UWCException uWCException) {
            _abLogger.severe("ABInitFilter.doFiliter: " + uWCException.getMessage());
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (bl) {
            object = (String)httpSession.getAttribute("sunAbInitialized");
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                _abLogger.fine(" What is sunAbInitialized: " + (String)object);
            }
            if (object == null || object != null && !((String)object).equals("true")) {
                this.initializeABPrefs(httpSession, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
                return;
            }
        }
        _abLogger.exiting(CLASS_NAME, "doFilter");
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void initializeABPrefs(HttpSession httpSession, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string;
        _abLogger.entering(CLASS_NAME, "initializeABPrefs");
        String string2 = httpServletRequest.getRequestURI();
        String string3 = httpServletRequest.getContextPath();
        if (string3 != null && !string3.equals("/")) {
            string2 = string2.substring(string3.length());
        }
        if ((string = httpServletRequest.getQueryString()) != null) {
            string2 = string2 + "?" + URLEncoder.encode(string);
        }
        try {
            RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher("/abclient/ABInit?gotoUri=" + string2);
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        catch (Exception exception) {
            _abLogger.severe("Error - " + exception.getMessage());
            _abLogger.exiting(CLASS_NAME, "initializeABPrefs");
            return;
        }
    }

    public void destroy() {
    }
}

