/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc;

import com.iplanet.jato.ApplicationServletBase;
import com.iplanet.jato.ModelManager;
import com.iplanet.jato.ModelTypeMap;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.RequestHandler;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.uwc.ModelTypeMapImpl;
import com.sun.uwc.UWCISServletBase;
import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.auth.Domain;
import com.sun.uwc.common.auth.LDAPConfig;
import com.sun.uwc.common.auth.LDAPDomainMap;
import com.sun.uwc.common.ldap.LDAPPool;
import com.sun.uwc.common.model.ABUserPreferencesModel;
import com.sun.uwc.common.model.CalUserPreferencesModel;
import com.sun.uwc.common.model.MailUserPreferencesModel;
import com.sun.uwc.common.model.UWCResourceBundleModel;
import com.sun.uwc.common.model.UserPreferencesModel;
import com.sun.uwc.common.util.MigratePab;
import com.sun.uwc.common.util.UWCConfigManager;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCPreferences;
import com.sun.uwc.common.util.UWCUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class UWCServletBase
extends ApplicationServletBase {
    private static ModelTypeMap MODEL_TYPE_MAP;
    public static final String DEFAULT_MODULE_URL = "base";
    private static final String CLASS_NAME = "UWCServletBase";
    private static final String APP_WEB_PATH = "WEB-INF";
    private static final String USER_CN = "CN";
    private static final String LANG_SUFFIX = ";lang-";
    private static final String MAIL_DEPLOYED_PARAM = "mail.deployed";
    private static final String CALENDAR_DEPLOYED_PARAM = "calendar.deployed";
    private static final String INET_DOMAIN_STATUS = "inetDomainStatus";
    private static final String AUTH_URL = "auth";
    private static final String CONFIG_PATH = "config";
    private static final String PAB_MIG_REQUIRED = "pab_mig_required";
    private static final String PAB_MIG_FNAME = "migrate.properties";
    private static final String UNDERSCORE = "_";
    private static final String HYPHEN = "-";
    private static final String USER_LDAPPOOL_MIN = "ldapusersession.ldappoolmin";
    private static final String USER_LDAPPOOL_MAX = "ldapusersession.ldappoolmax";
    private static final String USER_LDAPPOOL_TIMEOUT = "ldapusersession.ldappooltimeout";
    private static final String USER_LDAP_HOST = "ldapusersession.ldaphost";
    private static final String USER_LDAP_PORT = "ldapusersession.ldapport";
    private static final String USER_LDAP_AUTHDN = "ldapusersession.ldapbinddn";
    private static final String USER_LDAP_AUTHCRED = "ldapusersession.ldapbindcred";
    private static final String USER_LDAP_VERSION = "3";
    private static final String USER_LDAP_SSLENABLE_FLAG = "ldapusersession.ldapsslenabled";
    public static final String CONFIG_IDENTITY_ENABLED = "uwcauth.identity.enabled";
    public static final String CONFIG_AUTH_ONLY_SSL_ENABLED = "uwcauth.ssl.authonly";
    public static final String CONFIG_SSL_ENABLED = "uwcauth.ssl.enabled";
    private static boolean _appInit;
    public static String PACKAGE_NAME;
    public static UWCConfigManager configMgr;
    protected static UWCPreferences _authConfig;
    private static boolean _identityEnabled;
    private static boolean _sslAuthOnly;
    protected static boolean _sslEnabled;
    private Logger _uwcLogger = UWCLogger.getLogger("uwc");
    private UserPreferencesModel _usrPrefModel;
    private boolean _pabMig = false;
    static /* synthetic */ Class class$com$sun$uwc$common$model$UWCResourceBundleModel;
    static /* synthetic */ Class class$com$sun$uwc$UWCServletBase;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (!_appInit) {
            this._uwcLogger.fine("UWCServletBase: Initializing application..");
            String string = servletConfig.getServletContext().getRealPath("/") + File.separator + APP_WEB_PATH;
            ServletContext servletContext = servletConfig.getServletContext();
            UWCApplicationHelper.setApplicationContext(servletContext);
            try {
                _authConfig = UWCPreferences.getSystemRootInstance(string + "/config");
                _authConfig = _authConfig.loadNode("uwcauth.properties", "/");
                if (_authConfig == null) {
                    throw new ServletException("Error in loading the authentication configuration file");
                }
                _identityEnabled = _authConfig.getBoolean(CONFIG_IDENTITY_ENABLED, false);
                _sslAuthOnly = _authConfig.getBoolean(CONFIG_AUTH_ONLY_SSL_ENABLED, false);
                _sslEnabled = _authConfig.getBoolean(CONFIG_SSL_ENABLED, false);
                servletContext.setAttribute(CONFIG_SSL_ENABLED, (Object)String.valueOf(_sslEnabled));
                LDAPPool lDAPPool = this.initLDAPPool();
                servletContext.setAttribute("com.sun.uwc.common.ldappool", (Object)lDAPPool);
                configMgr.init(string);
                this.initPabMig(string + "/config", lDAPPool);
                _appInit = true;
                this._uwcLogger.fine("UWCServletBase: Initializing application..Done");
            }
            catch (UWCException uWCException) {
                if (this._uwcLogger.isLoggable(Level.SEVERE)) {
                    this._uwcLogger.severe(uWCException.getMessage());
                }
                throw new ServletException(uWCException.getMessage());
            }
        } else {
            this._uwcLogger.fine("UWCServletBase: Application already initialized..");
        }
        MODEL_TYPE_MAP = new ModelTypeMapImpl();
    }

    protected void initializeRequestContext(RequestContext requestContext) {
        String string;
        super.initializeRequestContext(requestContext);
        this._uwcLogger.entering(CLASS_NAME, "initializeRequestContext");
        HttpSession httpSession = requestContext.getRequest().getSession(false);
        if (httpSession != null) {
            string = requestContext.getRequest().getParameter("op");
            if (string != null && string.equals("logout")) {
                try {
                    UWCUserHelper.logout(requestContext);
                    return;
                }
                catch (Exception exception) {
                    if (this._uwcLogger.isLoggable(Level.SEVERE)) {
                        this._uwcLogger.severe("[Error:initializeRequestContext] - " + exception.getMessage());
                    }
                    try {
                        UWCApplicationHelper.gotoErrorView(requestContext, "server-misconfig", "uwc-calclient-error-");
                        return;
                    }
                    catch (Exception exception2) {}
                }
            } else if (null != string && string.equals("RedirectToLogin")) {
                try {
                    UWCUserHelper.redirectToLogin(requestContext);
                    return;
                }
                catch (Exception exception) {
                    if (this._uwcLogger.isLoggable(Level.SEVERE)) {
                        this._uwcLogger.severe("[Error:initializeRequestContext] - " + exception.getMessage());
                    }
                    try {
                        UWCApplicationHelper.gotoErrorView(requestContext, "server-misconfig", "uwc-calclient-error-");
                        return;
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
            }
        }
        if (_identityEnabled && (string = (String)requestContext.getRequest().getAttribute("IdentityHandled")) == null) {
            int n = UWCISServletBase.handleIdentityEnabledUWC(requestContext.getRequest());
            requestContext.getRequest().setAttribute("IdentityHandled", (Object)"true");
            if (n == UWCISServletBase.LOGOUT) {
                try {
                    UWCUserHelper.logout(requestContext);
                }
                catch (UWCException uWCException) {
                    // empty catch block
                }
                return;
            }
        }
        string = new ModelManager(requestContext, MODEL_TYPE_MAP);
        ((RequestContextImpl)requestContext).setModelManager((ModelManager)string);
        ViewBeanManager viewBeanManager = new ViewBeanManager(requestContext, PACKAGE_NAME);
        ((RequestContextImpl)requestContext).setViewBeanManager(viewBeanManager);
        this._uwcLogger.exiting(CLASS_NAME, "initializeRequestContext");
    }

    protected void onNewSession(RequestContext requestContext) throws ServletException {
        this._uwcLogger.entering(CLASS_NAME, "onNewSession");
        try {
            String string;
            String string2;
            HttpSession httpSession = requestContext.getRequest().getSession(false);
            String string3 = requestContext.getRequest().getParameter("anon");
            boolean bl = false;
            if (string3 != null && string3.equals("true")) {
                bl = true;
            } else {
                string3 = (String)httpSession.getAttribute("anon");
                if (string3 != null && string3.equals("true")) {
                    bl = true;
                }
            }
            String string4 = UWCUserHelper.getDomain(requestContext);
            configMgr.loadDomainConfig(string4);
            UWCPreferences uWCPreferences = null;
            uWCPreferences = configMgr.getUWCDomainProperties(string4);
            if (null != uWCPreferences) {
                string2 = "false";
                string2 = uWCPreferences.get("uwc-user-attr-isMailHDConfigured", "false");
                if (string2.equalsIgnoreCase("true")) {
                    httpSession.setAttribute("hosteddomain", (Object)"true");
                }
            }
            httpSession.setAttribute("mailurl", (Object)UWCApplicationHelper.getMailURL(requestContext.getRequest()));
            this._usrPrefModel = UWCUserHelper.getUserPrefModel(requestContext);
            this._usrPrefModel.initializeCommonPreferences();
            if (this._uwcLogger.isLoggable(Level.INFO)) {
                this._uwcLogger.info("[----- Common Preferences Initialized ------]");
                this._uwcLogger.info("Protocol: " + requestContext.getRequest().getProtocol());
            }
            if ((string2 = UWCUserHelper.getPreferredLanguage(requestContext)) == null && _identityEnabled && (string = UWCUserHelper.getPreferredLocale(requestContext)) != null) {
                string2 = string;
            }
            if ((string = configMgr.loadResourceBundle(string4, string2, UWCUserHelper.getAcceptLanguage(requestContext))) != null) {
                httpSession.setAttribute("userlang", (Object)string);
            }
            configMgr.loadTheme(string4, string);
            UWCPreferences uWCPreferences2 = configMgr.getUWCConfigProperties();
            if (!_identityEnabled && !bl) {
                Object object;
                LDAPEntry lDAPEntry;
                LDAPConfig lDAPConfig = new LDAPConfig(_authConfig);
                LDAPDomainMap lDAPDomainMap = LDAPDomainMap.getInstance(_authConfig);
                Domain domain = lDAPDomainMap.getDomainObject(string4, true);
                if (domain == null) {
                    if (this._uwcLogger.isLoggable(Level.SEVERE)) {
                        this._uwcLogger.severe("Error[onNewSession] - domain object of the user not configured properly");
                    }
                    UWCApplicationHelper.forwardToErrorPage(requestContext, "server-misconfig");
                }
                if ((lDAPEntry = UWCUserHelper.getUserEntry(UWCUserHelper.getUIDOnly(requestContext), domain, lDAPConfig, false)) == null) {
                    if (this._uwcLogger.isLoggable(Level.SEVERE)) {
                        this._uwcLogger.severe("Error[onNewSession] - user entry could not be obtained");
                    }
                    UWCApplicationHelper.forwardToErrorPage(requestContext, "server-misconfig");
                }
                httpSession.setAttribute("userdn", (Object)lDAPEntry.getDN());
                LDAPAttribute lDAPAttribute = null;
                if (string != null) {
                    lDAPAttribute = lDAPEntry.getAttribute("CN;lang-" + string);
                }
                if (lDAPAttribute == null) {
                    lDAPAttribute = lDAPEntry.getAttribute(USER_CN);
                }
                if (lDAPAttribute != null) {
                    object = lDAPAttribute.getStringValueArray();
                    httpSession.setAttribute("username", (Object)object[0]);
                }
                if ((object = domain.getAttribute(INET_DOMAIN_STATUS)) != null && ((String)object).equalsIgnoreCase("inactive")) {
                    httpSession.setAttribute("mail.service.enabled", (Object)"false");
                    httpSession.setAttribute("calendar.service.enabled", (Object)"false");
                } else {
                    boolean bl2 = uWCPreferences2.getBoolean(MAIL_DEPLOYED_PARAM, false);
                    boolean bl3 = UWCUserHelper.getMailServiceStatus(lDAPEntry, domain, bl2);
                    httpSession.setAttribute("mail.service.enabled", (Object)String.valueOf(bl3));
                    bl2 = uWCPreferences2.getBoolean(CALENDAR_DEPLOYED_PARAM, false);
                    bl3 = UWCUserHelper.getCalendarServiceStatus(lDAPEntry, domain, bl2);
                    httpSession.setAttribute("calendar.service.enabled", (Object)String.valueOf(bl3));
                }
                if (_sslAuthOnly) {
                    if (this._uwcLogger.isLoggable(Level.FINE)) {
                        this._uwcLogger.fine("SSL is Enabled for Auth Only...");
                    }
                    Cookie cookie = new Cookie("JSESSIONID", httpSession.getId());
                    cookie.setPath("/");
                    HttpServletResponse httpServletResponse = requestContext.getResponse();
                    httpServletResponse.addCookie(cookie);
                }
            }
            if (_identityEnabled && !bl) {
                boolean bl4 = uWCPreferences2.getBoolean(MAIL_DEPLOYED_PARAM, false);
                if (!bl4) {
                    httpSession.setAttribute("mail.service.enabled", (Object)"false");
                }
                if (!(bl4 = uWCPreferences2.getBoolean(CALENDAR_DEPLOYED_PARAM, false))) {
                    httpSession.setAttribute("calendar.service.enabled", (Object)"false");
                }
            }
            if (!bl && this._pabMig) {
                long l = System.currentTimeMillis();
                MigratePab.startMigration(UWCUserHelper.getUIDOnly(requestContext), string4, UWCUserHelper.getUserDN(requestContext));
            }
            httpSession.setAttribute("clientIP", (Object)requestContext.getRequest().getRemoteAddr());
        }
        catch (Exception exception) {
            if (this._uwcLogger.isLoggable(Level.SEVERE)) {
                this._uwcLogger.severe("Error[onNewSession] - " + exception.getMessage());
            }
            UWCUtils.printStackTrace(exception);
            UWCApplicationHelper.forwardToErrorPage(requestContext, "server-misconfig");
        }
        this._uwcLogger.exiting(CLASS_NAME, "onNewSession");
    }

    protected void onSessionTimeout(RequestContext requestContext) throws ServletException {
        this._uwcLogger.entering(CLASS_NAME, "onSessionTimeout");
        HttpSession httpSession = requestContext.getRequest().getSession(false);
        if (httpSession == null) {
            try {
                this.sendToAuth(requestContext, false);
                return;
            }
            catch (ServletException servletException) {
                if (this._uwcLogger.isLoggable(Level.SEVERE)) {
                    this._uwcLogger.severe("Error[OnIntitalizeRequest] - " + servletException.getMessage());
                }
                UWCApplicationHelper.forwardToErrorPage(requestContext, "server-misconfig");
            }
        }
    }

    protected boolean isSessionTimedOut(RequestContext requestContext, String string) {
        HttpSession httpSession = requestContext.getRequest().getSession(false);
        this._uwcLogger.info("[isSessionTimedOut: Client Session - ");
        if (httpSession != null) {
            return false;
        }
        this._uwcLogger.info("[isSessionTimedOut: Client Session - " + String.valueOf(!requestContext.getRequest().isRequestedSessionIdValid()));
        return !requestContext.getRequest().isRequestedSessionIdValid();
    }

    protected boolean isNewSession(RequestContext requestContext) {
        super.isNewSession(requestContext);
        this._uwcLogger.entering(CLASS_NAME, "isNewSession()");
        HttpSession httpSession = requestContext.getRequest().getSession(false);
        if (httpSession == null) {
            return false;
        }
        String string = (String)httpSession.getAttribute("com.sun.uwc.newsession");
        if (string != null && string.equals("true")) {
            requestContext.getRequest().getSession(false).removeAttribute("com.sun.uwc.newsession");
            this._uwcLogger.exiting(CLASS_NAME, "isNewSession()");
            return true;
        }
        this._uwcLogger.exiting(CLASS_NAME, "isNewSession()");
        return false;
    }

    protected void onInitializeHandler(RequestContext requestContext, RequestHandler requestHandler) throws ServletException {
        HttpSession httpSession = requestContext.getRequest().getSession(false);
        if (httpSession == null) {
            try {
                this.sendToAuth(requestContext, true);
                return;
            }
            catch (ServletException servletException) {
                if (this._uwcLogger.isLoggable(Level.SEVERE)) {
                    this._uwcLogger.severe("Error[onInitializeHandler] - " + servletException.getMessage());
                }
                UWCApplicationHelper.forwardToErrorPage(requestContext, "server-misconfig");
            }
        }
        try {
            UWCResourceBundleModel uWCResourceBundleModel;
            UWCResourceBundleModel uWCResourceBundleModel2;
            UWCResourceBundleModel uWCResourceBundleModel3 = (UWCResourceBundleModel)requestContext.getModelManager().getModel(class$com$sun$uwc$common$model$UWCResourceBundleModel == null ? (class$com$sun$uwc$common$model$UWCResourceBundleModel = UWCServletBase.class$("com.sun.uwc.common.model.UWCResourceBundleModel")) : class$com$sun$uwc$common$model$UWCResourceBundleModel, "i18nModel", true, true);
            if (!uWCResourceBundleModel3.isLoaded()) {
                uWCResourceBundleModel3.loadResourceBundle(UWCUserHelper.getResourceBundle(requestContext), UWCUserHelper.getUserLanguage(requestContext));
            }
            if (!(uWCResourceBundleModel2 = (UWCResourceBundleModel)requestContext.getModelManager().getModel(class$com$sun$uwc$common$model$UWCResourceBundleModel == null ? (class$com$sun$uwc$common$model$UWCResourceBundleModel = UWCServletBase.class$("com.sun.uwc.common.model.UWCResourceBundleModel")) : class$com$sun$uwc$common$model$UWCResourceBundleModel, "skinModel", true, true)).isLoaded()) {
                uWCResourceBundleModel2.loadResourceBundle(UWCUserHelper.getThemePreferences(requestContext));
            }
            if (!(uWCResourceBundleModel = (UWCResourceBundleModel)requestContext.getModelManager().getModel(class$com$sun$uwc$common$model$UWCResourceBundleModel == null ? (class$com$sun$uwc$common$model$UWCResourceBundleModel = UWCServletBase.class$("com.sun.uwc.common.model.UWCResourceBundleModel")) : class$com$sun$uwc$common$model$UWCResourceBundleModel, "appModel", true, true)).isLoaded()) {
                uWCResourceBundleModel.loadResourceBundle(UWCApplicationHelper.getApplicationPreferences());
            }
            httpSession.setAttribute("i18nModel", (Object)uWCResourceBundleModel3);
            httpSession.setAttribute("skinModel", (Object)uWCResourceBundleModel2);
            httpSession.setAttribute("appModel", (Object)uWCResourceBundleModel);
        }
        catch (Exception exception) {
            if (this._uwcLogger.isLoggable(Level.SEVERE)) {
                this._uwcLogger.severe("Error[initializeRequestContext] - " + exception.getMessage());
            }
            UWCApplicationHelper.forwardToErrorPage(requestContext, "server-misconfig");
        }
    }

    public void onRequestHandlerNotSpecified(RequestContext requestContext) throws ServletException {
        HttpSession httpSession = requestContext.getRequest().getSession(false);
        if (httpSession == null) {
            return;
        }
        UWCApplicationHelper.RedirectToErrorPage(requestContext, "rsrc-not-found", "uwc-common-");
    }

    protected void onRequestHandlerNotFound(RequestContext requestContext, String string) throws ServletException {
        this.onRequestHandlerNotSpecified(requestContext);
    }

    private LDAPPool initLDAPPool() throws UWCException {
        try {
            return new LDAPPool(_authConfig.getInt(USER_LDAPPOOL_MIN, 30), _authConfig.getInt(USER_LDAPPOOL_MAX, 100), _authConfig.getInt(USER_LDAPPOOL_TIMEOUT, 30), _authConfig.get(USER_LDAP_HOST, null), _authConfig.getInt(USER_LDAP_PORT, 389), _authConfig.get(USER_LDAP_AUTHDN, null), _authConfig.get(USER_LDAP_AUTHCRED, null), _authConfig.getInt(USER_LDAP_VERSION, 3), _authConfig.getBoolean(USER_LDAP_SSLENABLE_FLAG, false));
        }
        catch (LDAPException lDAPException) {
            if (this._uwcLogger.isLoggable(Level.SEVERE)) {
                this._uwcLogger.severe("Couldn't create pool:  " + lDAPException.getMessage());
            }
            throw new UWCException(38, lDAPException.getMessage());
        }
    }

    private void initPabMig(String string, LDAPPool lDAPPool) {
        if (_authConfig.getBoolean(PAB_MIG_REQUIRED, true) && MigratePab.initGlobals(string, lDAPPool)) {
            this._pabMig = true;
        }
    }

    private void sendToAuth(RequestContext requestContext, boolean bl) throws ServletException {
        this._uwcLogger.entering(CLASS_NAME, "sendToAuth()");
        HttpSession httpSession = requestContext.getRequest().getSession(false);
        if (httpSession == null) {
            HttpServletRequest httpServletRequest;
            int n;
            Cookie[] cookieArray = requestContext.getRequest().getCookies();
            boolean bl2 = false;
            for (n = 0; cookieArray != null && n < cookieArray.length; ++n) {
                if (!cookieArray[n].getName().equalsIgnoreCase("JSESSIONID")) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                httpServletRequest = new Cookie(cookieArray[n].getName(), null);
                httpServletRequest.setPath("/");
                httpServletRequest.setMaxAge(0);
                requestContext.getResponse().addCookie((Cookie)httpServletRequest);
            }
            httpServletRequest = requestContext.getRequest();
            String string = httpServletRequest.getParameter("anon");
            String string2 = UWCUtils.getContextPathPrefix(requestContext);
            NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(UWCUtils.getContextPathPrefix(requestContext));
            String string3 = httpServletRequest.getParameter("gotoUri");
            if (string3 != null && string3.indexOf("wabp") > -1) {
                UWCApplicationHelper.forwardToURI(requestContext, string3);
                return;
            }
            nonSyncStringBuffer.append(AUTH_URL);
            if (string != null && string.equals("true")) {
                nonSyncStringBuffer.append("?");
                nonSyncStringBuffer.append("anon");
                nonSyncStringBuffer.append("=");
                nonSyncStringBuffer.append("true");
                nonSyncStringBuffer.append("&");
            }
            String string4 = httpServletRequest.getQueryString();
            if (bl) {
                if (string4 != null && string4.length() > 0) {
                    String string5 = requestContext.getRequest().getRequestURI();
                    nonSyncStringBuffer.append("?");
                    nonSyncStringBuffer.append("gotoUri");
                    nonSyncStringBuffer.append("=");
                    string5 = string5 + "?";
                    try {
                        string5 = string5 + URLEncoder.encode(string4, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string5 = string5 + string4;
                    }
                    nonSyncStringBuffer.append(string5);
                }
            } else if (string4 != null && string4.length() > 0 && string != null && string.equals("true")) {
                nonSyncStringBuffer.append(string4);
            }
            UWCApplicationHelper.redirectToURL(requestContext, nonSyncStringBuffer.toString());
            return;
        }
    }

    protected void onAfterRequest(RequestContext requestContext) {
        HttpSession httpSession;
        HttpSession httpSession2 = httpSession = null == requestContext ? null : requestContext.getRequest().getSession(false);
        if (null != httpSession && null != requestContext) {
            ABUserPreferencesModel aBUserPreferencesModel;
            CalUserPreferencesModel calUserPreferencesModel;
            MailUserPreferencesModel mailUserPreferencesModel;
            UserPreferencesModel userPreferencesModel = UWCUserHelper.getUserPrefModel(requestContext);
            if (null != userPreferencesModel) {
                userPreferencesModel.setRequestContext(null);
            }
            if (null != (mailUserPreferencesModel = UWCUserHelper.getMailUserPrefModel(requestContext))) {
                mailUserPreferencesModel.setRequestContext(null);
            }
            if (null != (calUserPreferencesModel = UWCUserHelper.getCalUserPrefModel(requestContext))) {
                calUserPreferencesModel.setRequestContext(null);
            }
            if (null != (aBUserPreferencesModel = UWCUserHelper.getABUserPrefModel(requestContext))) {
                aBUserPreferencesModel.setRequestContext(null);
            }
        }
    }

    public static UWCPreferences getLoadedUserConfig() {
        return _authConfig;
    }

    public static UWCConfigManager getApplicationConfigMgr() {
        return configMgr;
    }

    public static boolean isIdentityEnabled() {
        return _identityEnabled;
    }

    public void destroy() {
        MigratePab.destroyMigration();
        LDAPPool lDAPPool = UWCApplicationHelper.getLDAPPool();
        if (lDAPPool != null) {
            lDAPPool.destroy();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _appInit = false;
        PACKAGE_NAME = UWCServletBase.getPackageName((String)(class$com$sun$uwc$UWCServletBase == null ? (class$com$sun$uwc$UWCServletBase = UWCServletBase.class$("com.sun.uwc.UWCServletBase")) : class$com$sun$uwc$UWCServletBase).getName());
        configMgr = new UWCConfigManager();
        _identityEnabled = false;
        _sslAuthOnly = false;
        _sslEnabled = false;
    }
}

