/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.wabp;

import com.iplanet.iabs.wabp.WABPEngine;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.ui.SessionObjectFactory;
import com.iplanet.xslui.ui.XSLServlet;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WABPEngineServlet
extends XSLServlet {
    public static final String CONFIG_FILENAME = "uwcconfig.properties";
    public static final String CONFIG_SESSIONOBJ_PREFIX = "sessionobjfactory.";
    public static final String CONFIG_SESSIONID_SUFFIX = ".sessionid";
    private WABPEngine _wabpHandler = null;
    private Hashtable _sessionObjTable = null;

    public void init(ServletConfig config) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(config);
        PropertyReader propertyReader = super.getPropertyReader();
        if (propertyReader == null) {
            throw new ServletException("Couldn't get config from uwcconfig.properties");
        }
        try {
            this._wabpHandler = new WABPEngine(propertyReader.getConfigPath(), Logging.getLogHandler());
        }
        catch (Exception ioe) {
            Logging.error((int)128, (String)("Couldn't create WABPEngine: " + ioe + ioe.getMessage()));
            throw new ServletException("Couldn't create WABPEngine: " + ioe + ioe.getMessage());
        }
        this._sessionObjTable = new Hashtable();
        Enumeration enumeration = propertyReader.getKeyProperty(CONFIG_SESSIONOBJ_PREFIX, ".class");
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String key = CONFIG_SESSIONOBJ_PREFIX + (String)enumeration.nextElement();
                String sessionID = propertyReader.getStringProperty(key + CONFIG_SESSIONID_SUFFIX, null);
                Object factory = null;
                try {
                    factory = propertyReader.getObjectProperty(key, true);
                }
                catch (Exception ex) {
                    Logging.error((int)128, (String)("Exception thrown while creating Factory for: " + key));
                    Logging.errorPrintStackTrace((Exception)ex);
                    throw new ServletException("Exception thrown while creating Factory for: " + key);
                }
                if (sessionID != null && sessionID.length() > 0) {
                    if (factory != null) {
                        this._sessionObjTable.put(sessionID, factory);
                        continue;
                    }
                    Logging.error((int)128, (String)("Couldn't create Factory for: " + key));
                    throw new ServletException("error while creating Factory for: " + key);
                }
                Logging.error((int)128, (String)("No sessionid for: " + key));
            }
        } else {
            Logging.error((int)128, (String)"No sessionObject defined");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession(false);
        String uri = request.getRequestURI();
        String cmdPage = uri.substring(uri.lastIndexOf("/") + 1);
        UserSession userSession = null;
        if (session != null) {
            userSession = (UserSession)session.getAttribute("com.iplanet.xslui.ui.usersession");
        }
        if (userSession == null) {
            Logging.trace((int)1, (String)"User Session is null");
        } else {
            Logging.trace((int)1, (String)"User Session is not null");
            Enumeration enumeration = this._sessionObjTable.keys();
            while (enumeration.hasMoreElements()) {
                String sessionID = (String)enumeration.nextElement();
                Object sessionObj = session.getAttribute(sessionID);
                if (sessionObj != null) continue;
                SessionObjectFactory sessionObjFactory = (SessionObjectFactory)this._sessionObjTable.get(sessionID);
                sessionObj = sessionObjFactory.newSessionObject(userSession, userSession.getDomain());
                if (sessionObj != null) {
                    session.setAttribute(sessionID, sessionObj);
                    continue;
                }
                Logging.error((int)1, (String)("Can't create SessionObject: " + sessionID + " for user " + userSession.getUserId()));
            }
        }
        this._wabpHandler.process(request, response, cmdPage);
    }
}

