/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.wabp;

import com.iplanet.iabs.coresrv.CorePersonalStore;
import com.iplanet.iabs.coresrv.CorePersonalStoreFactory;
import com.iplanet.iabs.iabsapi.AddressBookACL;
import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.Entry;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.iabs.iabsutil.ABUtils;
import com.iplanet.iabs.ldapplug.iLdapDb;
import com.iplanet.xslui.auth.LDAPUserSessionFactory;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.auth.UserSessionFactory;
import com.iplanet.xslui.tools.MultipartHttpServletRequest;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.tools.StringUtils;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WABPEngine {
    private static final String WABPTAG = "wabp";
    private static final String DEFAULT_BOOKTYPE = "abook";
    private static final String BOOKLIST = "booklist";
    private static final int DEBUG = 0;
    private static final String DEFAULT_IMPORTEXPORT_FORMAT = "ldif";
    public static final String CONFIG_FILENAME = "uwcconfig.properties";
    public static final String AUTHCONFIG_FILENAME = "uwcauth.properties";
    public static final String WABP_VERSION_PROPERTY = "addressbook.wabp.version";
    public static final String VERSION = "version";
    public static final String SERVERTIME = "servertime";
    public static final String AUTO_PURGE_ENABLED = "auto_purge_enabled";
    public static final String MANUAL_PURGE_ENABLED = "manual_purge_enabled";
    public static final String PURGE_INTERVAL = "purge_interval";
    public static final String EXPIRE_PERIOD = "expire_period";
    private CorePersonalStoreFactory _cpsFactory = null;
    private File _configPath;
    private UserSessionFactory _userFactory = null;
    private static boolean _autoPurgeEnabled;
    private static boolean _manualPurgeEnabled;
    private static int _expirePeriod;
    private static int _purgeInterval;
    private static PropertyReader _propertyReader;
    private static final String LOGOUT_URL = "/base/UWCMain?op=logout&gotoUri=/wabp/logout.wabp";
    private XSLXMLLogHandler _logHandler = null;
    private XMLDOMBuilder _xmlBuilder = null;
    private SimpleDateFormat _isoFormatter = new SimpleDateFormat("yyyyMMddHHmmss'Z'");

    public WABPEngine(File configPath, XSLXMLLogHandler logHandler) throws IOException {
        this._logHandler = logHandler;
        this._configPath = configPath;
        if (_propertyReader == null) {
            try {
                _propertyReader = new PropertyReader(configPath, CONFIG_FILENAME);
                _autoPurgeEnabled = _propertyReader.getBooleanProperty(AUTO_PURGE_ENABLED, "false");
                _manualPurgeEnabled = _propertyReader.getBooleanProperty(MANUAL_PURGE_ENABLED, "true");
                _expirePeriod = _propertyReader.getIntProperty(EXPIRE_PERIOD, 0);
                _purgeInterval = _propertyReader.getIntProperty(PURGE_INTERVAL, 30);
            }
            catch (IOException ex) {
                throw new IOException("WABPEngine: can't open configuration file uwcconfig.properties in " + configPath.toString() + " : " + ex.getMessage());
            }
        }
        try {
            this._xmlBuilder = new XMLDOMBuilder(this._logHandler);
        }
        catch (XMLProcessingException xpe) {
            throw new IOException("WABPEngine.process: Couldn't create XMLDOMBuilder: " + xpe.getMessage());
        }
        this._isoFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private void dump(HttpServletRequest req) {
        String name;
        Logging.trace((int)128, (String)("Begin request: Method:" + req.getMethod()));
        Logging.trace((int)128, (String)("URL the client used to make request:" + req.getRequestURL().toString()));
        Logging.trace((int)128, (String)("request's URL from protocol upto the the querystring:" + req.getRequestURI()));
        if (req.getRequestURI().indexOf("login.wabp") == -1) {
            Logging.trace((int)128, (String)("query string:" + req.getQueryString()));
        }
        Logging.trace((int)128, (String)"headers:");
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            String value = req.getHeader(name);
            Logging.trace((int)128, (String)(name + " = " + value));
        }
        Logging.trace((int)128, (String)"multivalued parameters will be seperated with ;");
        e = req.getParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            if (name.equalsIgnoreCase("password")) continue;
            String[] vals = req.getParameterValues(name);
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < vals.length; ++i) {
                s.append(vals[i]).append(";");
            }
            Logging.trace((int)128, (String)(name + " = " + s.toString()));
        }
        Logging.trace((int)128, (String)"End request");
    }

    public void process(HttpServletRequest request, HttpServletResponse response, String cmdPage) throws IOException {
        boolean isError = false;
        String errorCode = String.valueOf(0);
        String errorMsg = new String();
        this.dump(request);
        Document wabpDoc = this._xmlBuilder.newDocument();
        Element wabpElt = null;
        boolean sessionRequired = true;
        try {
            wabpElt = wabpDoc.createElement(WABPTAG);
        }
        catch (DOMException e) {
            Logging.error((int)128, (String)("WABPEngine.process: Could not create WabpRootElt: " + e.getMessage()));
            return;
        }
        if (!cmdPage.endsWith(".wabp")) {
            int separator = cmdPage.lastIndexOf(".");
            cmdPage = separator > 0 ? cmdPage.substring(0, separator) + ".wabp" : cmdPage + ".wabp";
        }
        String validClientIP = (String)request.getAttribute("validClientIP");
        try {
            boolean isCommandFound;
            block154: {
                String entryID;
                String entryid;
                Element resultElt;
                isCommandFound = false;
                if (validClientIP != null && validClientIP.equals("false")) {
                    throw new Exception("Client IP conflict.");
                }
                HttpSession session = request.getSession(false);
                if (cmdPage.equals("login.wabp")) {
                    isCommandFound = true;
                    UserSession userSession = null;
                    if (session != null) {
                        userSession = (UserSession)session.getAttribute("com.iplanet.xslui.ui.usersession");
                    }
                    if (userSession == null) {
                        errorCode = String.valueOf(1);
                        errorMsg = PStoreException.getDetailsForReason(1);
                    } else {
                        String encodedURL = response.encodeURL("/").substring(1);
                        if (encodedURL == null || encodedURL.equals("")) {
                            encodedURL = ";jsessionid=" + request.getSession(false).getId();
                        }
                        wabpElt.setAttribute("sessionstring", encodedURL);
                        if (_autoPurgeEnabled) {
                            try {
                                this.purge_entries(request, false, null);
                            }
                            catch (PStoreException pse) {
                                this._logHandler.error("WABPEngine.login.wabp:autopurge:" + pse.getMessage());
                            }
                        }
                    }
                }
                if (cmdPage.equals("get_version.wabp")) {
                    isCommandFound = true;
                    sessionRequired = false;
                    try {
                        String version = this.get_version();
                        wabpElt.setAttribute(VERSION, version);
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = "288";
                        errorMsg = pse.getMessage();
                        Logging.error((int)128, (String)("WABPEngine.process: exception in get_version.wabp " + errorMsg));
                    }
                }
                if (cmdPage.equals("get_servertime.wabp")) {
                    isCommandFound = true;
                    sessionRequired = false;
                    String servertime = this.get_servertime();
                    wabpElt.setAttribute(SERVERTIME, servertime);
                }
                if (cmdPage.equals("logout.wabp")) {
                    isCommandFound = true;
                    if (session != null) {
                        RequestDispatcher reqDisp = request.getRequestDispatcher(LOGOUT_URL);
                        reqDisp.forward((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    sessionRequired = false;
                }
                if (session == null && sessionRequired) {
                    errorCode = String.valueOf(23);
                    errorMsg = PStoreException.getDetailsForReason(23);
                    isError = true;
                } else if (cmdPage.equals("list_books.wabp")) {
                    isCommandFound = true;
                    try {
                        resultElt = this.list_books(request);
                        if (resultElt != null) {
                            wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt, wabpDoc));
                        }
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("search_entry.wabp")) {
                    isCommandFound = true;
                    try {
                        String entriesPerPage = request.getParameter("entriesperpage");
                        if (entriesPerPage == null || entriesPerPage.length() == 0) {
                            Element resultElt2 = this.search_entry(request);
                            wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt2, wabpDoc));
                            break block154;
                        }
                        String searchID = this.search_entry(request, entriesPerPage);
                        wabpElt.setAttribute("searchid", searchID);
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("getresult.wabp")) {
                    isCommandFound = true;
                    try {
                        resultElt = this.getresult(request);
                        wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt, wabpDoc));
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("create_entry.wabp")) {
                    isCommandFound = true;
                    try {
                        entryid = new String();
                        entryid = this.create_entry(request);
                        wabpElt.setAttribute("entryID", entryid);
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("create_book.wabp")) {
                    isCommandFound = true;
                    entryid = new String();
                    try {
                        entryid = this.create_book(request);
                        wabpElt.setAttribute("entryID", entryid);
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("get_entry.wabp")) {
                    isCommandFound = true;
                    try {
                        resultElt = this.get_entry(request);
                        wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt, wabpDoc));
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("get_acl.wabp")) {
                    isCommandFound = true;
                    try {
                        resultElt = this.getACL(request);
                        NodeList childNodes = resultElt.getChildNodes();
                        for (int i = 0; i < childNodes.getLength(); ++i) {
                            wabpElt.appendChild(this._xmlBuilder.copyNode(childNodes.item(i), wabpDoc));
                        }
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("delete_book.wabp")) {
                    isCommandFound = true;
                    try {
                        this.delete_book(request);
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("delete_entry.wabp")) {
                    isCommandFound = true;
                    try {
                        this.delete_entry(request);
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("purge_entries.wabp")) {
                    isCommandFound = true;
                    try {
                        String purgeAll = request.getParameter("purgeAllUserContacts");
                        if (purgeAll != null && purgeAll.equalsIgnoreCase("true")) {
                            this.purgeAll(request, wabpElt);
                            break block154;
                        }
                        this.purge_entries(request, true, wabpElt);
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("modify_entry.wabp")) {
                    isCommandFound = true;
                    try {
                        entryID = this.modify_entry(request);
                        wabpElt.setAttribute("entryid", entryID);
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("set_acl.wabp")) {
                    Logging.trace((int)128, (String)"Processing set_acl");
                    isCommandFound = true;
                    try {
                        Element resultElm = this.setACL(request);
                        if (null != resultElm) {
                            String entryID2 = resultElm.getAttribute("entryid");
                            resultElm.removeAttribute("entryid");
                            wabpElt.setAttribute("entryid", entryID2);
                            wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElm, wabpDoc));
                        }
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("modify_book.wabp")) {
                    isCommandFound = true;
                    try {
                        entryID = this.modify_book(request);
                        wabpElt.setAttribute("entryid", entryID);
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("add_bookmember.wabp")) {
                    isCommandFound = true;
                    try {
                        if (!this.add_bookmember(request)) {
                            errorMsg = "Entry is already a member";
                            wabpElt.setAttribute("rawmsg", errorMsg);
                        }
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("add_groupmember.wabp")) {
                    isCommandFound = true;
                    try {
                        if (!this.add_groupmember(request)) {
                            errorMsg = "Entry is already a member";
                            wabpElt.setAttribute("rawmsg", errorMsg);
                        }
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("remove_bookmember.wabp")) {
                    isCommandFound = true;
                    try {
                        if (!this.remove_bookmember(request)) {
                            errorMsg = "Entry is already not a member";
                            wabpElt.setAttribute("rawmsg", errorMsg);
                        }
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("remove_groupmember.wabp")) {
                    isCommandFound = true;
                    try {
                        if (!this.remove_groupmember(request)) {
                            errorMsg = "Entry is already not a member";
                            wabpElt.setAttribute("rawmsg", errorMsg);
                        }
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("import.wabp")) {
                    isCommandFound = true;
                    try {
                        resultElt = this.import_entry(request);
                        wabpElt = (Element)this._xmlBuilder.copyNode((Node)resultElt, wabpDoc);
                        wabpDoc.appendChild(wabpElt);
                        this.writeOutToResponse(request, response, wabpDoc, cmdPage);
                        return;
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                        Logging.error((int)128, (String)("TING: WABPEngine: " + errorMsg + " " + errorCode));
                    }
                } else if (cmdPage.equals("export.wabp")) {
                    isCommandFound = true;
                    try {
                        this.export_abook(request, response);
                        return;
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("get_book.wabp")) {
                    isCommandFound = true;
                    try {
                        resultElt = this.get_book(request);
                        if (resultElt != null) {
                            wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt, wabpDoc));
                        }
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("get_defaultbook.wabp")) {
                    isCommandFound = true;
                    try {
                        resultElt = this.get_defaultbook(request);
                        if (resultElt != null) {
                            wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt, wabpDoc));
                        }
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                        Logging.error((int)128, (String)("WABPEngine.process: exception in get_defaultbook.wabp " + errorMsg));
                    }
                } else if (cmdPage.equals("get_userprefs.wabp")) {
                    isCommandFound = true;
                    try {
                        resultElt = this.get_userprefs(request);
                        if (resultElt != null) {
                            wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt, wabpDoc));
                        }
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                        Logging.error((int)128, (String)("WABPEngine.process: exception in get_userprefs.wabp " + errorMsg));
                    }
                } else if (cmdPage.equals("get_profile.wabp")) {
                    isCommandFound = true;
                    try {
                        resultElt = this.get_profile(request);
                        if (resultElt != null) {
                            wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt, wabpDoc));
                        }
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("modify_profile.wabp")) {
                    isCommandFound = true;
                    try {
                        this.modify_profile(request);
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("stopsearch.wabp")) {
                    isCommandFound = true;
                    try {
                        this.stop_search(request);
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("get_subscribable_books.wabp")) {
                    isCommandFound = true;
                    try {
                        resultElt = this.get_subscribable_books(request);
                        wabpElt.appendChild(this._xmlBuilder.copyNode((Node)resultElt, wabpDoc));
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("subscribe_book.wabp")) {
                    isCommandFound = true;
                    try {
                        String bookid = this.subscribe_book(request);
                        wabpElt.setAttribute("entryID", bookid);
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                } else if (cmdPage.equals("unsubscribe_book.wabp")) {
                    isCommandFound = true;
                    try {
                        this.unsubscribe_book(request);
                    }
                    catch (PStoreException pse) {
                        isError = true;
                        errorCode = Integer.toString(pse.getReason());
                        errorMsg = pse.getMessage();
                    }
                }
            }
            if (!isError && !isCommandFound) {
                isError = true;
                errorCode = "290";
                errorMsg = "Invalid Command.";
            }
        }
        catch (Exception e) {
            Logging.error((int)128, (String)("WABPEngine: " + e.getMessage()));
            this.dump_stack(e);
            isError = true;
            if (validClientIP != null && validClientIP.equals("false")) {
                errorCode = "66";
                errorMsg = "Client IP conflict";
            }
            errorCode = "289";
            errorMsg = "Server can't anwser the query. Try Later.";
        }
        wabpDoc.appendChild(wabpElt);
        if (!isError) {
            wabpElt.setAttribute("errorcode", errorCode);
        } else {
            try {
                wabpElt.setAttribute("errorcode", errorCode);
                wabpElt.setAttribute("rawmsg", errorMsg);
            }
            catch (DOMException e) {
                Logging.error((int)128, (String)("WABPEngine.process: Could not create WabpErrorElt: " + e.getMessage()));
                return;
            }
        }
        try {
            this.writeOutToResponse(request, response, wabpDoc, cmdPage);
        }
        catch (IOException e) {
            Logging.error((int)128, (String)"WABPEngine: problem writing to response");
        }
    }

    public Element list_books(HttpServletRequest request) throws PStoreException {
        Document dummyDoc;
        PersonalStore pStore = this.loadPS(request);
        String booktype = request.getParameter("booktype");
        if (booktype == null) {
            booktype = DEFAULT_BOOKTYPE;
        }
        if ((dummyDoc = this._xmlBuilder.newDocument()) == null) {
            throw new PStoreException(20, "wabp/list_books: failed to create document");
        }
        Element dummyElement = null;
        try {
            dummyElement = dummyDoc.createElement(BOOKLIST);
            dummyDoc.appendChild(dummyElement);
        }
        catch (DOMException e) {
            throw new PStoreException(20, "wabp/list_books: failed to create element" + e.getMessage());
        }
        Book[] bookArray = pStore.listBooks(booktype);
        if (bookArray == null) {
            return null;
        }
        String subscribedArg = request.getParameter("subscribed");
        subscribedArg = null == subscribedArg ? null : subscribedArg.trim();
        boolean returnSubscribedBooksOnly = false;
        if ("1".equals(subscribedArg)) {
            returnSubscribedBooksOnly = true;
            Logging.trace((int)128, (String)"Returning only the subscribed book..");
        }
        try {
            Book currentBook = null;
            Node childNode = null;
            for (int i = 0; i < bookArray.length; ++i) {
                currentBook = bookArray[i];
                childNode = this._xmlBuilder.copyNode((Node)currentBook.getEntryElement(), dummyDoc);
                if (returnSubscribedBooksOnly && (!returnSubscribedBooksOnly || !currentBook.isSubscribedBook())) continue;
                dummyElement.appendChild(childNode);
            }
        }
        catch (XMLProcessingException xpe) {
            Logging.trace((int)128, (String)("Exception: " + xpe.getMessage()));
            throw new PStoreException(3, "wabp/list_books: failed to add child element" + xpe.getMessage());
        }
        return dummyElement;
    }

    public Element search_entry(HttpServletRequest request) throws PStoreException {
        Document dummyDoc;
        PersonalStore pStore = this.loadPS(request);
        String bookId = request.getParameter("bookid");
        if (bookId == null) {
            String bookType = request.getParameter("booktype");
            if (bookType == null || bookType.length() <= 0) {
                bookType = DEFAULT_BOOKTYPE;
            }
            Book defaultBook = null;
            try {
                defaultBook = pStore.getDefaultBook(bookType);
            }
            catch (PStoreException pe) {
                throw new PStoreException(20, "PagedSearchResultHdler.expand : couldn't get default Book :" + pe.getReason() + " : " + pe.getMessage());
            }
            if (defaultBook == null) {
                throw new PStoreException(20, "PagedSearchResultHandler.expand: no default book");
            }
            bookId = defaultBook.getEntryID();
        }
        String filter = request.getParameter("filter");
        String searchDeleted = request.getParameter("searchdeleted");
        if (filter == null || filter.length() == 0) {
            filter = "entry/displayname=*";
        }
        String sortBy = request.getParameter("sortby");
        Vector<String> entryType = null;
        String typeList = request.getParameter("type");
        if (typeList != null && typeList.length() > 0) {
            int index = 0;
            int newIndex = 0;
            entryType = new Vector<String>();
            while ((newIndex = typeList.indexOf(",", index)) != -1) {
                entryType.add(typeList.substring(index, newIndex));
                index = newIndex + 1;
            }
            entryType.add(typeList.substring(index));
        }
        if ((dummyDoc = this._xmlBuilder.newDocument()) == null) {
            throw new PStoreException(20, "wabp/search_entry: failed to create document");
        }
        Vector<String> returnattrs = null;
        String attrList = request.getParameter("attrlist");
        if (attrList != null && attrList.length() > 0) {
            int index = 0;
            int newIndex = 0;
            returnattrs = new Vector<String>();
            while ((newIndex = attrList.indexOf(",", index)) != -1) {
                returnattrs.add(attrList.substring(index, newIndex));
                index = newIndex + 1;
            }
            returnattrs.add(attrList.substring(index));
        }
        Element searchResult = dummyDoc.createElement("searchresult");
        dummyDoc.appendChild(searchResult);
        if (searchDeleted != null && searchDeleted.equalsIgnoreCase("true")) {
            pStore.searchDeletedEntries(true);
        }
        searchResult.setAttribute("bookid", bookId);
        searchResult.setAttribute("filter", filter);
        searchResult.setAttribute("sortby", sortBy);
        pStore.searchBook(bookId, filter, returnattrs, entryType, sortBy, searchResult);
        return searchResult;
    }

    public Element get_defaultbook(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.get_defaultbook: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.get_defaultbook: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String bookType = request.getParameter("booktype");
        Book result = null;
        result = pStore.getDefaultBook(bookType);
        if (result == null) {
            return null;
        }
        return result.getEntryElement();
    }

    public Element get_userprefs(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.get_userprefs: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.get_userprefs: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        Element result = null;
        result = pStore.getUserPrefs();
        if (result == null) {
            throw new PStoreException(6, "WABPEngine.get_userpreferences: Couldn't get User Prefereces");
        }
        return result;
    }

    public Element get_book(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.get_book: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.get_book: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        Book result = null;
        result = pStore.getBook(Bookid);
        if (result == null) {
            this._logHandler.error("WABPEngine.get_book: Couldn't retreive Book.");
            return null;
        }
        return result.getEntryElement();
    }

    public Element get_profile(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.get_profile: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.get_profile: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String profilename = null;
        profilename = request.getParameter("name");
        Element result = null;
        result = pStore.getProfile(profilename);
        return result;
    }

    public void modify_profile(HttpServletRequest request) throws PStoreException {
        String profilename = request.getParameter("name");
        if (profilename == null) {
            throw new PStoreException(20, "wabp/modify_profile: profilename is missing");
        }
        String data = request.getParameter("data");
        InputStream in = null;
        try {
            if (data != null) {
                in = new ByteArrayInputStream(data.getBytes());
            } else {
                MultipartHttpServletRequest mRequest = (MultipartHttpServletRequest)request;
                in = mRequest.getFileParameter("file");
            }
        }
        catch (Exception e) {
            throw new PStoreException(3, "wabp/modify_profile: error in getting XML file");
        }
        if (in == null) {
            throw new PStoreException(3, "wabp/modify_profile: empty input");
        }
        if (in == null) {
            this._logHandler.error("WABPEngine.modify_profile: null file");
            throw new PStoreException(6, "WABPEngine.modify_profile: no xml data");
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.modify_profile: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.modify_profile: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        try {
            Document EntryDoc = this._xmlBuilder.parse(in, true);
            Element Entryroot = EntryDoc.getDocumentElement();
            pStore.modifyProfile(profilename, Entryroot);
        }
        catch (XMLProcessingException xpe) {
            Logging.trace((int)128, (String)("Exception: " + xpe.getMessage()));
            throw new PStoreException(3, "wabp/modify_profile: failed to add child element" + xpe.getMessage());
        }
    }

    public Element import_entry(HttpServletRequest request) throws PStoreException {
        String data;
        String importFormat;
        String bookID = request.getParameter("bookid");
        PersonalStore pStore = this.loadPS(request);
        if (bookID == null || bookID.length() == 0) {
            Book defaultBook = null;
            try {
                defaultBook = pStore.getDefaultBook(DEFAULT_BOOKTYPE);
            }
            catch (PStoreException pse) {
                throw new PStoreException(pse.getReason(), "wabp/import_entry : " + pse.getDetails());
            }
            if (defaultBook == null) {
                throw new PStoreException(2, "wabp/import_entry: no default book");
            }
            bookID = defaultBook.getEntryID();
        }
        if ((importFormat = request.getParameter("format")) == null || importFormat.length() == 0) {
            importFormat = DEFAULT_IMPORTEXPORT_FORMAT;
        }
        if ((data = request.getParameter("data")) == null) {
            data = request.getParameter("file");
        }
        InputStream inStream = null;
        try {
            if (data != null) {
                inStream = new ByteArrayInputStream(data.getBytes());
            } else {
                MultipartHttpServletRequest mRequest = (MultipartHttpServletRequest)request;
                inStream = mRequest.getFileParameter("file");
            }
        }
        catch (Exception e) {
            this._logHandler.error(e.getMessage());
            throw new PStoreException(3, "wabp/import_entry: error in getting XML file");
        }
        if (inStream == null) {
            throw new PStoreException(3, "wabp/import_entry: empty input");
        }
        Document dummyDoc = this._xmlBuilder.newDocument();
        if (dummyDoc == null) {
            throw new PStoreException(9, "wabp/getresult: failed to create document");
        }
        Element importElt = dummyDoc.createElement(WABPTAG);
        try {
            pStore.importEntry(bookID, importFormat, inStream, importElt);
        }
        catch (PStoreException pse) {
            throw new PStoreException(pse.getReason(), "wabp/import_entry: " + pse.getMessage());
        }
        catch (Exception e) {
            throw new PStoreException(20, "wabp/import_entry: " + e.getMessage());
        }
        return importElt;
    }

    public void export_abook(HttpServletRequest request, HttpServletResponse response) throws PStoreException {
        String language;
        String format;
        HttpSession session = request.getSession(false);
        ServletOutputStream out = null;
        if (session == null) {
            this._logHandler.error("WABPEngine.create_entry: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.create_entry: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String bookId = request.getParameter("bookid");
        if (bookId == null) {
            throw new PStoreException(20, "bookid is null");
        }
        String filter = request.getParameter("filter");
        if (filter == null || filter.length() == 0) {
            filter = "entry/displayname=*";
        }
        if ((format = request.getParameter("format")) == null || format.length() == 0) {
            format = new String(DEFAULT_IMPORTEXPORT_FORMAT);
        }
        if ((language = request.getParameter("lang")) == null) {
            language = "us";
        }
        String extension = format.startsWith("csv") ? ".csv" : (format.startsWith("vcard") ? ".vcf" : ".ldif");
        String filename = "export" + extension;
        String contentType = new String("application/") + format;
        response.setContentType(contentType);
        response.setHeader("Content-Disposition", "inline;filename=\"" + filename + "\"");
        try {
            out = response.getOutputStream();
            pStore.exportEntry(bookId, filter, format, language, (OutputStream)out);
            out.close();
        }
        catch (IOException ioe) {
            throw new PStoreException(20, "io exception");
        }
    }

    public String search_entry(HttpServletRequest request, String entriesperpage) throws PStoreException {
        String sortBy;
        String filter;
        PersonalStore pStore = this.loadPS(request);
        String bookId = request.getParameter("bookid");
        if (bookId == null) {
            String bookType = request.getParameter("booktype");
            if (bookType == null || bookType.length() <= 0) {
                bookType = DEFAULT_BOOKTYPE;
            }
            Book defaultBook = null;
            try {
                defaultBook = pStore.getDefaultBook(bookType);
            }
            catch (PStoreException pe) {
                throw new PStoreException(20, "wabp/search_entry(entriesperpage) : couldn't get default Book :" + pe.getReason() + " : " + pe.getMessage());
            }
            if (defaultBook == null) {
                throw new PStoreException(20, "wabp/search_entry(entriesperpage): no default book");
            }
            bookId = defaultBook.getEntryID();
        }
        if ((filter = request.getParameter("filter")) == null || filter.length() == 0) {
            filter = "entry/displayname=*";
        }
        if ((sortBy = request.getParameter("sortby")) == null || sortBy.length() == 0) {
            sortBy = "+entry/displayname";
        }
        Vector<String> entryType = null;
        String typeList = request.getParameter("type");
        if (typeList != null && typeList.length() > 0) {
            int index = 0;
            int newIndex = 0;
            entryType = new Vector<String>();
            while ((newIndex = typeList.indexOf(",", index)) != -1) {
                entryType.add(typeList.substring(index, newIndex));
                index = newIndex + 1;
            }
            entryType.add(typeList.substring(index));
        }
        Vector<String> returnattrs = null;
        String attrList = request.getParameter("attrlist");
        if (attrList != null && attrList.length() > 0) {
            int index = 0;
            int newIndex = 0;
            returnattrs = new Vector<String>();
            while ((newIndex = attrList.indexOf(",", index)) != -1) {
                returnattrs.add(attrList.substring(index, newIndex));
                index = newIndex + 1;
            }
            returnattrs.add(attrList.substring(index));
        }
        String searchID = null;
        int intEntriesPerPage = Integer.parseInt(entriesperpage);
        searchID = pStore.searchBook(bookId, filter, returnattrs, entryType, sortBy, intEntriesPerPage);
        return searchID;
    }

    public Element getresult(HttpServletRequest request) throws PStoreException {
        Document dummyDoc;
        String searchID = request.getParameter("searchid");
        if (searchID == null || searchID.length() == 0) {
            throw new PStoreException(20, "wabp/getresult: No searchID");
        }
        PersonalStore pStore = this.loadPS(request);
        String firstEntry = request.getParameter("firstentry");
        if (firstEntry == null || firstEntry.length() == 0) {
            firstEntry = "1";
        }
        if ((dummyDoc = this._xmlBuilder.newDocument()) == null) {
            throw new PStoreException(20, "wabp/getresult: failed to create document");
        }
        Element searchResult = dummyDoc.createElement("searchresult");
        dummyDoc.appendChild(searchResult);
        pStore.getResult(searchID, Integer.parseInt(firstEntry), searchResult);
        String stopSearch = request.getParameter("stopsearch");
        if (stopSearch != null && stopSearch.equals("1")) {
            pStore.stopSearch(searchID);
        }
        return searchResult;
    }

    public void stop_search(HttpServletRequest request) throws PStoreException {
        String searchID = request.getParameter("searchid");
        if (searchID == null || searchID.length() == 0) {
            throw new PStoreException(20, "wabp/getresult: No searchID");
        }
        PersonalStore pStore = this.loadPS(request);
        pStore.stopSearch(searchID);
    }

    public Element get_subscribable_books(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.get_subscribable_books: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.get_subscribable_books: Couldn't retreive session");
        }
        String id = request.getParameter("id");
        if (id == null) {
            throw new PStoreException(28, "<id>");
        }
        UserSession currentUser = (UserSession)session.getAttribute("com.iplanet.xslui.ui.usersession");
        if (null == currentUser) {
            this._logHandler.error("getSubscribable: UserSession is null");
            throw new PStoreException(4, "wabp/get_subscribable: no such user");
        }
        this._logHandler.error("getSubscribable to get pstore for:" + id);
        UserSession targetUsr = this.getUserSession(request, id, currentUser);
        CorePersonalStore pStore = this.getPStore(currentUser, targetUsr);
        if (pStore == null) {
            throw new PStoreException(20, "wabp/get_subscribable: unable to construct personal store");
        }
        Book[] bookArray = pStore.listBooks(DEFAULT_BOOKTYPE);
        if (bookArray == null) {
            throw new PStoreException(38, "wabp/get_subscribable: shared books are not available");
        }
        Document bookDoc = this._xmlBuilder.newDocument();
        Element bookElement = null;
        Element bookListElement = null;
        String currUserId = currentUser.getUserId();
        String currentUserDomain = currentUser.getDomain();
        String fquid = currUserId + "@" + currentUserDomain;
        String rightsText = null;
        if (currUserId == null) {
            return null;
        }
        boolean found = false;
        try {
            bookListElement = bookDoc.createElement(BOOKLIST);
            for (int i = 0; i < bookArray.length; ++i) {
                String email;
                String uid;
                AddressBookACL aclObj = bookArray[i].getACLObj();
                Logging.trace((int)128, (String)("going to get permissions:" + currentUser.getUserId()));
                if (aclObj == null) continue;
                try {
                    rightsText = aclObj.getPermissions(currUserId);
                    boolean usrExists = aclObj.isUserPermExists(currUserId);
                    if (rightsText == null || rightsText != null && rightsText.length() == 0 || !usrExists) {
                        rightsText = aclObj.getPermissions(fquid);
                    }
                }
                catch (Exception e) {
                    this.dump_stack(e);
                }
                Logging.trace((int)128, (String)("<rights>" + rightsText + "</rights>"));
                if (rightsText == null || rightsText.length() == 0) continue;
                Logging.trace((int)128, (String)"creating a new node with rights");
                bookElement = bookDoc.createElement("book");
                bookElement.setAttribute("bookurl", bookArray[i].getBookURL());
                Element origBookElement = bookArray[i].getEntryElement();
                NodeList nodeList = origBookElement.getElementsByTagName("entry");
                Element entryElement = (Element)nodeList.item(0);
                bookElement.appendChild(this._xmlBuilder.copyNode((Node)entryElement, bookDoc));
                Element ownerElement = bookDoc.createElement("owner");
                String cn = targetUsr.getUserAttrib("cn");
                if (cn != null) {
                    ABUtils.insertNode(ownerElement, "displayname", cn);
                }
                if ((uid = pStore.getUserID()) != null) {
                    ABUtils.insertNode(ownerElement, "uid", uid);
                }
                if ((email = targetUsr.getUserAttrib("mail")) != null) {
                    ABUtils.insertNode(ownerElement, "email", email);
                }
                bookElement.appendChild(ownerElement);
                ABUtils.insertNode(bookElement, "rights", rightsText);
                bookListElement.appendChild(bookElement);
                found = true;
            }
        }
        catch (Exception xpe) {
            this.dump_stack(xpe);
            Logging.trace((int)128, (String)("Exception: " + xpe.getMessage()));
            throw new PStoreException(3, "wabp/get_subscribabale_books: failed to add child element" + xpe.getMessage());
        }
        if (!found) {
            throw new PStoreException(38, "wabp/get_subscribabale_books: " + pStore.getUserID() + " didn't share any books to you");
        }
        iLdapDb.dump(bookListElement, 20);
        return bookListElement;
    }

    private UserSession getUserSession(HttpServletRequest request, String fquid, UserSession currentUser) throws PStoreException {
        if (fquid == null) {
            throw new PStoreException(28, "<id>");
        }
        Object pStore = null;
        if (currentUser == null) {
            return null;
        }
        HttpSession session = request.getSession(false);
        String uid = fquid;
        String domainInFQUID = null;
        if (fquid.indexOf("mailto:") == -1) {
            String[] uidTokens = fquid.split("@");
            uid = uidTokens[0];
            domainInFQUID = uidTokens.length > 1 ? uidTokens[1] : null;
        }
        String dn = (String)session.getAttribute("userdn");
        String userID = currentUser.getUserId();
        String domain = currentUser.getDomain();
        if (userID.equalsIgnoreCase(uid)) {
            this._logHandler.error("getSubscribable: user cant subscribe to his books they are directly available");
            throw new PStoreException(39, "wabp/get_subscribable: self subscribe not allowed");
        }
        boolean factoryInited = true;
        if (this._userFactory == null) {
            factoryInited = this.initUserFactory();
        }
        if (!factoryInited) {
            return null;
        }
        String newDn = null;
        dn = dn.toLowerCase();
        uid = uid.toLowerCase();
        userID = userID.toLowerCase();
        this._logHandler.debug("uid: " + uid);
        this._logHandler.debug("curr userid: " + userID);
        this._logHandler.debug("curr user dn: " + dn);
        newDn = uid.indexOf("mailto:") != -1 ? dn.substring(dn.indexOf(44) + 1, dn.length()) : dn.replaceFirst(userID, uid);
        this._logHandler.debug("newdn:" + newDn + " ;currentdn:" + dn);
        UserSession targetUsr = null;
        targetUsr = this._userFactory.newUserSession(uid, newDn, domain);
        if (targetUsr == null) {
            throw new PStoreException(4, "wabp/get_subscribable: user id is not valid. Try with valid user id");
        }
        return targetUsr;
    }

    private CorePersonalStore getPStore(UserSession currentUser, UserSession targetUsr) throws PStoreException {
        Object pStore = null;
        if (currentUser == null) {
            return null;
        }
        String domain = currentUser.getDomain();
        boolean factoryInited = true;
        if (this._cpsFactory == null) {
            factoryInited = this.initCpsf();
        }
        if (targetUsr == null) {
            return null;
        }
        if (!factoryInited) {
            return null;
        }
        CorePersonalStore cps = null;
        cps = (CorePersonalStore)this._cpsFactory.newSessionObject(targetUsr, domain);
        if (cps == null) {
            Logging.trace((int)32, (String)"not able to get corepersonalstore from cps factory");
            throw new PStoreException(20, "wabp/get_subscribable: cant load personalstore");
        }
        return cps;
    }

    private boolean initCpsf() {
        if (this._cpsFactory != null) {
            return true;
        }
        this._cpsFactory = new CorePersonalStoreFactory();
        return this._cpsFactory.init(this._configPath);
    }

    private boolean initUserFactory() {
        try {
            if (this._userFactory != null) {
                return true;
            }
            this._userFactory = new LDAPUserSessionFactory();
            File f = new File(this._configPath.getPath(), AUTHCONFIG_FILENAME);
            if (!this._userFactory.init(f)) {
                Logging.error((int)32, (String)"Cant init LDAPUserSessionFactory, cannt proceed to initialize the userFactory");
                return false;
            }
        }
        catch (Exception e) {
            Logging.error((int)32, (String)e.getMessage());
            return false;
        }
        return true;
    }

    public String subscribe_book(HttpServletRequest request) throws PStoreException {
        String bookurl = request.getParameter("bookurl");
        if (bookurl == null) {
            throw new PStoreException(28, "<bookurl>");
        }
        if (!bookurl.startsWith("ps:///")) {
            throw new PStoreException(6, " A subscribed book URL should have following format: ps:///<domain>/<user>/<bookid>");
        }
        PersonalStore pStore = this.loadPS(request);
        Document bookDoc = this._xmlBuilder.newDocument();
        Element bookNode = null;
        try {
            bookNode = bookDoc.createElement("book");
            bookNode.setAttribute("booktype", DEFAULT_BOOKTYPE);
            bookNode.setAttribute("bookremoteurl", bookurl);
            ABUtils.insertNode(bookNode, "bookoc", "piRemoteBook");
            Element ele = bookDoc.createElement("entry");
            ABUtils.insertNode(ele, "displayname", bookurl);
            String bookid = bookurl.substring(bookurl.lastIndexOf("/") + 1);
            ele.setAttribute("entryID", bookid);
            bookNode.appendChild(this._xmlBuilder.copyNode((Node)ele, bookDoc));
        }
        catch (DOMException de) {
            throw new PStoreException(8, "Error adding book: " + de.getMessage());
        }
        catch (XMLProcessingException xe) {
            throw new PStoreException(8, "Error adding book: " + xe.getMessage());
        }
        String entryID = pStore.addBook(bookNode);
        if (entryID != null) {
            request.getSession(false).setAttribute("loadABs", (Object)"true");
        }
        return entryID;
    }

    public void unsubscribe_book(HttpServletRequest request) throws PStoreException {
        String bookid = request.getParameter("bookid");
        if (bookid == null) {
            throw new PStoreException(28, "<bookid>");
        }
        PersonalStore pStore = this.loadPS(request);
        Book s_book = pStore.getBook(bookid);
        if (s_book == null) {
            throw new PStoreException(4, "Bookid: " + bookid + " doesn't exist");
        }
        if (!s_book.isSubscribedBook()) {
            throw new PStoreException(29, bookid);
        }
        pStore.deleteBook(bookid);
        request.getSession(false).setAttribute("loadABs", (Object)"true");
    }

    public String create_entry(HttpServletRequest request) throws PStoreException {
        String data = request.getParameter("data");
        InputStream in = null;
        if (data != null) {
            try {
                data = URLDecoder.decode(data, "UTF-8");
                in = new ByteArrayInputStream(data.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ue) {
                throw new PStoreException(2, "wabp/create_entry: " + ue.getMessage());
            }
        }
        try {
            MultipartHttpServletRequest mRequest = (MultipartHttpServletRequest)request;
            in = mRequest.getFileParameter("file");
        }
        catch (Exception e) {
            throw new PStoreException(6, "wabp/create_entry: error in getting XML file");
        }
        if (in == null) {
            throw new PStoreException(6, "wabp/create_entry: empty XML input");
        }
        Document EntryDoc = null;
        Element Entryroot = null;
        if (in == null) {
            throw new PStoreException(6, "WABPEngine.create_entry: no xml data");
        }
        String bookIDString = request.getParameter("bookid");
        String[] bookIDs = StringUtils.stringToStringArray((String)bookIDString);
        if (bookIDs == null || bookIDs.length < 1) {
            throw new PStoreException(28, "wabp/create_entry: bookID is missing");
        }
        String entry_id = request.getParameter("entryid");
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new PStoreException(6, "WABPEngine.create_entry: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        try {
            EntryDoc = this._xmlBuilder.parse(in, true);
            Entryroot = EntryDoc.getDocumentElement();
        }
        catch (XMLProcessingException xpe) {
            throw new PStoreException(3, "wabp/create_entry: failed to add child element" + xpe.getMessage());
        }
        String entryId = pStore.addEntry(bookIDs, Entryroot, entry_id, true);
        return entryId;
    }

    public String create_book(HttpServletRequest request) throws PStoreException {
        Element Entryroot;
        String data = request.getParameter("data");
        InputStream in = null;
        if (data != null) {
            try {
                data = URLDecoder.decode(data, "UTF-8");
                in = new ByteArrayInputStream(data.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ue) {
                throw new PStoreException(2, "wabp/create_book: " + ue.getMessage());
            }
        }
        try {
            MultipartHttpServletRequest mRequest = (MultipartHttpServletRequest)request;
            in = mRequest.getFileParameter("file");
        }
        catch (Exception e) {
            throw new PStoreException(6, "wabp/create_book: error in getting XML file");
        }
        if (in == null) {
            throw new PStoreException(6, "WABPEngine.create_book: no xml data");
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new PStoreException(23, "WABPEngine.create_book: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        try {
            Document EntryDoc = this._xmlBuilder.parse(in, true);
            Entryroot = EntryDoc.getDocumentElement();
        }
        catch (XMLProcessingException xpe) {
            Logging.trace((int)128, (String)("Exception: " + xpe.getMessage()));
            throw new PStoreException(3, "wabp/create_book: failed to add child element" + xpe.getMessage());
        }
        String EntryId = pStore.addBook(Entryroot, true);
        return EntryId;
    }

    public void delete_book(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.delete_book: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.delete_book: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        if (Bookid == null || Bookid.length() <= 0) {
            this._logHandler.error("WABPEngine.delete_book: Bookid  not present/null");
            throw new PStoreException(6, "WABPEngine.delete_book: no bookEntryID");
        }
        Book defaultBook = null;
        try {
            defaultBook = pStore.getDefaultBook(DEFAULT_BOOKTYPE);
        }
        catch (PStoreException pe) {
            throw new PStoreException(20, pe.getReason() + " : " + pe.getMessage());
        }
        if (defaultBook == null) {
            throw new PStoreException(20, "no default book");
        }
        String defaultBookId = defaultBook.getEntryID();
        if (Bookid.equalsIgnoreCase(defaultBookId)) {
            throw new PStoreException(6, "WABPEngine.delete_book:WABPEngine.delete_book: Can't delete def ault book");
        }
        pStore.deleteBook(Bookid);
    }

    public void delete_entry(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.delete_entry: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.delete_entry: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        if (Bookid == null || Bookid.length() <= 0) {
            this._logHandler.error("WABPEngine.delete_entry: Bookid  not present/null");
            throw new PStoreException(6, "WABPEngine.delete_entry: no bookEntryID");
        }
        String Entryid = request.getParameter("entryid");
        if (Entryid == null || Entryid.length() <= 0) {
            this._logHandler.error("WABPEngine.delete_entry: Entryid  not present/null");
            throw new PStoreException(6, "WABPEngine.delete_entry: no EntryID");
        }
        pStore.deleteEntry(Bookid, Entryid);
    }

    private void dump_stack(Exception e) {
        this._logHandler.error("*** Start Stack Trace ******");
        StackTraceElement[] frames = e.getStackTrace();
        for (int i = 0; i < frames.length; ++i) {
            StackTraceElement frame = frames[i];
            this._logHandler.error(frame.getClassName() + "." + frame.getMethodName() + "@" + frame.getLineNumber());
        }
        this._logHandler.error("****** End Stack Trace ******");
    }

    public void purge_entries(HttpServletRequest request, boolean forcedPurge, Element wabpElt) throws PStoreException {
        String bookId;
        int count = 0;
        int expirePeriod = _expirePeriod;
        if (!_manualPurgeEnabled) {
            throw new PStoreException(20, "wabp/purge_entries: Purge facility is disabled");
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.delete_entry: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.delete_entry: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String expparam = request.getParameter("expireperiod");
        if (expparam != null && expparam.length() > 0) {
            expirePeriod = Integer.parseInt(expparam);
        }
        if ((bookId = request.getParameter("bookid")) == null) {
            String bookType = request.getParameter("booktype");
            if (bookType == null || bookType.length() <= 0) {
                bookType = DEFAULT_BOOKTYPE;
            }
            Book defaultBook = null;
            try {
                defaultBook = pStore.getDefaultBook(bookType);
            }
            catch (PStoreException pe) {
                throw new PStoreException(20, pe.getReason() + " : " + pe.getMessage());
            }
            if (defaultBook == null) {
                throw new PStoreException(20, "no default book");
            }
            bookId = defaultBook.getEntryID();
        }
        count = pStore.purgeEntries(bookId, forcedPurge, _purgeInterval, expirePeriod);
        if (wabpElt != null) {
            wabpElt.setAttribute("PurgeCount", String.valueOf(count));
        }
    }

    private void purgeAll(HttpServletRequest request, Element wabpElt) throws PStoreException {
        HttpSession session = request.getSession(false);
        int expirePeriod = _expirePeriod;
        if (session == null) {
            this._logHandler.error("WABPEngine.delete_entry: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.delete_entry: Couldn't retreive session");
        }
        String expparam = request.getParameter("expireperiod");
        if (expparam != null && expparam.length() > 0) {
            expirePeriod = Integer.parseInt(expparam);
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        Hashtable status = pStore.purgeAll(expirePeriod);
        Enumeration e = status.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)status.get(key);
            wabpElt.setAttribute(key.substring(key.indexOf(61) + 1, key.indexOf(44)), "purgeCount=" + val);
        }
    }

    public Element get_entry(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.get_entry: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.delete_entry: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        String Entryid = request.getParameter("entryid");
        Entry result = null;
        if (Entryid == null || Entryid.length() <= 0) {
            this._logHandler.error("WABPEngine.get_entry: Entryid  not present/null");
            throw new PStoreException(6, "WABPEngine.get_entry: no EntryID");
        }
        result = Bookid == null ? pStore.getEntry(Entryid) : pStore.getEntry(Bookid, Entryid);
        if (result == null) {
            this._logHandler.error("WABPEngine.get_entry: Couldn't retreive Entry.");
            throw new PStoreException(6, "WABPEngine.get_entry: Couldn't retreive Entry");
        }
        return result.getEntryElement();
    }

    public Element getACL(HttpServletRequest request) throws PStoreException {
        PersonalStore pStore;
        Element result;
        String userDomain;
        HttpSession session = request.getSession(false);
        if (null == session) {
            this._logHandler.error("wabp/get_acl: Couldn't retreive session.");
            throw new PStoreException(6, "wabp/get_acl: Couldn't retreive session");
        }
        String Entryid = request.getParameter("entryid");
        if (null == Entryid || Entryid.length() <= 0) {
            this._logHandler.error("wabp/get_acl: Entryid  not present/null");
            throw new PStoreException(28, "wabp/get_acl: no EntryID");
        }
        UserSession userObj = (UserSession)session.getAttribute("com.iplanet.xslui.ui.usersession");
        if (null == userObj) {
            this._logHandler.error("getACL: UserSession is null");
            throw new PStoreException(20, "wabp/get_acl: Null UserSesion");
        }
        String userID = null == userObj ? null : userObj.getUserId();
        String string = userDomain = null == userObj ? null : userObj.getDomain();
        if (null != userID && null != userDomain) {
            userID = userID + "@" + userDomain;
        }
        Logging.trace((int)128, (String)("getACL: getting acl for user \"" + userID + "\""));
        if (null == userID) {
            this._logHandler.error("getACL: Couldn't retrieve logged in userid");
        }
        if ((result = (pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore")).getACL(Entryid, userID)) == null) {
            this._logHandler.error("wabp/get_acl: ACL doesn't exists, returning blank acl");
            Document bookDoc = this._xmlBuilder.newDocument();
            result = bookDoc.createElement("acl");
        }
        return result;
    }

    public boolean add_bookmember(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.add_bookmember: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.add_bookmember: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        if (Bookid == null || Bookid.length() <= 0) {
            this._logHandler.error("WABPEngine.add_member: Bookid  not present/null");
            throw new PStoreException(28, "WABPEngine.add_bookmember: no bookEntryID");
        }
        String Entryid = request.getParameter("entryid");
        if (Entryid == null || Entryid.length() <= 0) {
            this._logHandler.error("WABPEngine.add_bookmember: Entryid  not present/null");
            throw new PStoreException(28, "WABPEngine.add_bookmember: no EntryID");
        }
        if (session == null) {
            this._logHandler.error("WABPEngine.add_bookmember: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.add_bookmember: Couldn't retreive session");
        }
        return pStore.addBookMember(Bookid, Entryid);
    }

    public boolean add_groupmember(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.add_groupmember: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.add_groupmember: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        if (Bookid == null || Bookid.length() <= 0) {
            this._logHandler.error("WABPEngine.add_groupmember: Bookid  not present/null");
            throw new PStoreException(6, "WABPEngine.add_groupmember: no bookEntryID");
        }
        String[] Entryid = request.getParameterValues("entryid");
        if (Entryid == null || Entryid.length == 0) {
            this._logHandler.error("WABPEngine.add_groupmember: Entryid  not present/null");
            throw new PStoreException(6, "WABPEngine.add_groupmember: no EntryID");
        }
        String Groupid = request.getParameter("groupid");
        if (Groupid == null || Groupid.length() <= 0) {
            this._logHandler.error("WABPEngine.add_groupmember: Groupid  not present/null");
            throw new PStoreException(6, "WABPEngine.add_groupmember: no groupID");
        }
        return pStore.addGroupMember(Bookid, Groupid, Entryid);
    }

    public boolean remove_bookmember(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.remove_bookmember: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.remove_bookmember: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        if (Bookid == null || Bookid.length() <= 0) {
            this._logHandler.error("WABPEngine.remove_bookmember: Bookid  not present/null");
            throw new PStoreException(28, "WABPEngine.remove_bookmember: no bookEntryID");
        }
        String Entryid = request.getParameter("entryid");
        if (Entryid == null || Entryid.length() <= 0) {
            this._logHandler.error("WABPEngine.remove_bookmember: Entryid  not present/null");
            throw new PStoreException(28, "WABPEngine.remove_bookmember: no EntryID");
        }
        return pStore.removeBookMember(Bookid, Entryid);
    }

    public boolean remove_groupmember(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("WABPEngine.remove_groupmember: Couldn't retreive session.");
            throw new PStoreException(6, "WABPEngine.remove_member: Couldn't retreive session");
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        String Bookid = request.getParameter("bookid");
        if (Bookid == null || Bookid.length() <= 0) {
            this._logHandler.error("WABPEngine.remove_groupmember: Bookid  not present/null");
            throw new PStoreException(6, "WABPEngine.remove_groupmember: no bookEntryID");
        }
        String[] Entryids = request.getParameterValues("entryid");
        if (Entryids == null || Entryids != null && Entryids.length == 0) {
            this._logHandler.error("WABPEngine.remove_groupmember: Entryid  not present/null");
            throw new PStoreException(6, "WABPEngine.remove_groupmember: no EntryID");
        }
        String Groupid = request.getParameter("groupid");
        if (Groupid == null || Groupid.length() <= 0) {
            this._logHandler.error("WABPEngine.remove_groupmember: Groupid  not present/null");
            throw new PStoreException(6, "WABPEngine.remove_groupmember: no GroupID");
        }
        return pStore.removeGroupMember(Bookid, Groupid, Entryids);
    }

    public String modify_entry(HttpServletRequest request) throws PStoreException {
        String bookID = request.getParameter("bookid");
        String entryID = request.getParameter("entryid");
        if (entryID == null) {
            throw new PStoreException(28, "wabp/modify_entry: entryID is missing");
        }
        if (bookID == null) {
            throw new PStoreException(28, "wabp/modify_entry: bookID is missing");
        }
        String data = request.getParameter("data");
        InputStream inStream = null;
        if (data != null) {
            try {
                data = URLDecoder.decode(data, "UTF-8");
                inStream = new ByteArrayInputStream(data.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ue) {
                throw new PStoreException(2, "wabp/modify_entry: " + ue.getMessage());
            }
        }
        try {
            MultipartHttpServletRequest mRequest = (MultipartHttpServletRequest)request;
            inStream = mRequest.getFileParameter("file");
        }
        catch (Exception e) {
            throw new PStoreException(20, "wabp/modify_entry: error in getting XML file");
        }
        if (inStream == null) {
            throw new PStoreException(20, "wabp/modify_entry: empty XML input");
        }
        PersonalStore pStore = this.loadPS(request);
        Document dummyDoc = null;
        try {
            dummyDoc = this._xmlBuilder.parse(inStream, true);
        }
        catch (Exception e) {
            throw new PStoreException(20, "wabp/modify_entry: " + e.getMessage());
        }
        Element modifyElt = dummyDoc.getDocumentElement();
        if (bookID == null) {
            pStore.modifyEntry(entryID, modifyElt, true);
        } else {
            pStore.modifyEntry(bookID, entryID, modifyElt, true);
        }
        return entryID;
    }

    public Element setACL(HttpServletRequest request) throws PStoreException {
        Logging.trace((int)128, (String)"Entered setACL()");
        String entryID = request.getParameter("entryid");
        Logging.trace((int)128, (String)("setACL for entryID \"" + entryID + "\""));
        if (null == entryID || entryID.trim().equals("")) {
            throw new PStoreException(28, "wabp/set_acl: entryID is missing");
        }
        String mode = request.getParameter("mode");
        if (null == mode) {
            Logging.trace((int)128, (String)"setACL mode is null. Defaulting the mode to replace");
            mode = "replace";
        } else if (!("add".equalsIgnoreCase(mode) || "replace".equalsIgnoreCase(mode) || "replaceall".equalsIgnoreCase(mode) || "delete".equalsIgnoreCase(mode))) {
            StringBuffer sb = new StringBuffer(128);
            sb.append("wabp/set_acl: invalid mode parameter: ");
            sb.append(mode);
            sb.append(". Valid values are: ");
            sb.append("add");
            sb.append(" ");
            sb.append("replaceall");
            sb.append(" ");
            sb.append("replace");
            sb.append(" ");
            sb.append("delete");
            throw new PStoreException(6, sb.toString());
        }
        Logging.trace((int)128, (String)("setACL mode \"" + mode + "\""));
        String data = request.getParameter("data");
        InputStream inStream = null;
        if (null != data) {
            try {
                data = URLDecoder.decode(data, "UTF-8");
                inStream = new ByteArrayInputStream(data.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ue) {
                throw new PStoreException(2, "wabp/set_acl: " + ue.getMessage());
            }
        }
        try {
            MultipartHttpServletRequest mRequest = (MultipartHttpServletRequest)request;
            inStream = mRequest.getFileParameter("file");
        }
        catch (Exception e) {
            throw new PStoreException(20, "wabp/set_acl: error in getting XML file");
        }
        if (null == inStream) {
            throw new PStoreException(20, "wabp/set_acl: empty XML input");
        }
        PersonalStore pStore = this.loadPS(request);
        Document dummyDoc = null;
        try {
            dummyDoc = this._xmlBuilder.parse(inStream, true);
        }
        catch (Exception e) {
            throw new PStoreException(20, "wabp/set_acl: " + e.getMessage());
        }
        Element modifyACLElm = dummyDoc.getDocumentElement();
        pStore.setACL(entryID, mode, modifyACLElm, true);
        Element resultElm = this.getACL(request);
        if (null != resultElm) {
            resultElm.setAttribute("entryid", entryID);
        }
        return resultElm;
    }

    public String modify_book(HttpServletRequest request) throws PStoreException {
        String entryID = request.getParameter("entryid");
        if (entryID == null) {
            throw new PStoreException(20, "wabp/modify_book: entryID is missing");
        }
        String data = request.getParameter("data");
        InputStream inStream = null;
        if (data != null) {
            try {
                data = URLDecoder.decode(data, "UTF-8");
                inStream = new ByteArrayInputStream(data.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ue) {
                throw new PStoreException(2, "wabp/modify_book: " + ue.getMessage());
            }
        }
        try {
            MultipartHttpServletRequest mRequest = (MultipartHttpServletRequest)request;
            inStream = mRequest.getFileParameter("file");
        }
        catch (Exception e) {
            throw new PStoreException(20, "wabp/modify_book: error in getting XML file");
        }
        if (inStream == null) {
            throw new PStoreException(20, "wabp/modify_book: empty XML input");
        }
        PersonalStore pStore = this.loadPS(request);
        Document dummyDoc = null;
        try {
            dummyDoc = this._xmlBuilder.parse(inStream, true);
        }
        catch (Exception e) {
            throw new PStoreException(20, "wabp/modify_book: " + e.getMessage());
        }
        Element modifyElt = dummyDoc.getDocumentElement();
        pStore.modifyBook(entryID, modifyElt, true);
        return entryID;
    }

    public String get_version() throws PStoreException {
        String version = _propertyReader.getStringProperty(WABP_VERSION_PROPERTY, null);
        if (version == null) {
            throw new PStoreException(25, "wabp/get_version: No WABP Version");
        }
        return version;
    }

    public String get_servertime() {
        GregorianCalendar cal = new GregorianCalendar();
        return this._isoFormatter.format(cal.getTime());
    }

    private PersonalStore loadPS(HttpServletRequest request) throws PStoreException {
        HttpSession session = request.getSession(false);
        UserSession userSession = (UserSession)session.getAttribute("com.iplanet.xslui.ui.usersession");
        if (userSession == null) {
            throw new PStoreException(20, "wabp: Null UserSesion - login failed");
        }
        return (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
    }

    private void writeOutToResponse(HttpServletRequest request, HttpServletResponse response, Document wabpDoc, String cmdPage) throws IOException {
        String fmtOut = request.getParameter("fmt-out");
        String contentType = "text/xml";
        if (fmtOut != null && fmtOut.length() > 0) {
            contentType = fmtOut;
        }
        if (!contentType.equalsIgnoreCase("js")) {
            String contentTypeString = contentType + ";" + "charset" + "=UTF-8";
            response.setContentType(contentTypeString);
            ServletOutputStream out = response.getOutputStream();
            try {
                XMLDOMBuilder.dumpNode((Node)wabpDoc, (OutputStream)out);
            }
            catch (Exception e) {
                throw new IOException("WABPEngine.process: Error outputing XML: " + e.getMessage());
            }
            finally {
                out.close();
            }
        } else {
            this.setJSOutput(request, response, wabpDoc, cmdPage);
        }
    }

    private void setJSOutput(HttpServletRequest request, HttpServletResponse response, Document wabpDoc, String cmdPage) throws IOException {
        String contentType = "text/html;charset=UTF-8";
        response.setContentType(contentType);
        ServletOutputStream out = response.getOutputStream();
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null) {
            return;
        }
        out.println("<html> <body> <script>");
        if (userAgent.indexOf("MSIE") == -1) {
            out.println("document.domain = document.domain");
        }
        Element wabpElt = wabpDoc.getDocumentElement();
        out.println("var errno='" + wabpElt.getAttribute("errorcode") + "'");
        out.println("var errmsg='" + wabpElt.getAttribute("rawmsg") + "'");
        NamedNodeMap attrList = wabpElt.getAttributes();
        int len = attrList.getLength();
        for (int i = 0; i < len; ++i) {
            Node attr = attrList.item(i);
            out.println("var " + attr.getNodeName() + "='" + attr.getNodeValue() + "'");
        }
        out.println("parent." + cmdPage.substring(0, cmdPage.indexOf(46)) + "CB();");
        out.println("</script> </body> </html>");
    }

    static {
        _propertyReader = null;
    }
}

