/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslatable;
import com.iplanet.xslui.ui.FormHandler;
import com.iplanet.xslui.ui.FormTranslatableEntry;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SaveUserOptionsFormHandler
extends FormHandler {
    public boolean process(HttpServletRequest request, Element errorRootElt) {
        String[] prefixes = request.getParameterValues("prefix");
        int i = 0;
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("SaveUserOptionsFormHandler.process: Couldn't retreive session.");
            return false;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("SaveUserOptionsFormHandler.process: Error while initialising pstore.");
            return false;
        }
        for (i = 0; i < prefixes.length; ++i) {
            if (this.processPrefs(pStore, prefixes[i], request)) continue;
            this._logHandler.error("SaveUserOptionsFormHandler.process: Error while processing " + prefixes[i]);
            return false;
        }
        return true;
    }

    private boolean processPrefs(PersonalStore pStore, String prefix, HttpServletRequest request) {
        Element modificatorTree = null;
        String prefs = null;
        FormTranslatableEntry formEntry = new FormTranslatableEntry((ServletRequest)request, prefix);
        if (formEntry == null) {
            this._logHandler.error("SaveUserOptionsFormHandler.processPrefs: FormEntry could'nt be created for " + prefix);
        }
        try {
            modificatorTree = this._dbTranslation.translate((DbTranslatable)formEntry);
        }
        catch (DbTransException dte) {
            this._logHandler.error("SaveUserOptionsFormHandler.processPrefs: failed translation" + (Object)((Object)dte) + " : " + dte.getMessage());
        }
        try {
            prefs = XPathTools.getValueByXPath((Node)modificatorTree, (String)"entry/displayname");
        }
        catch (XSLProcessingException xe) {
            this._logHandler.error("SaveUserOptionsFormHandler.processPrefs: Can't find the node :entry/displayname");
            return false;
        }
        if (prefs == null) {
            this._logHandler.error("SaveUserOptionsFormHandler.processPrefs: Didn't find display name");
        }
        Element currentProfile = null;
        try {
            currentProfile = pStore.getProfile(prefs);
        }
        catch (PStoreException pse) {
            this._logHandler.debug("SaveUserOptionsFormHandler.processPrefs: Can't get profile : " + pse.getMessage());
        }
        if (currentProfile == null) {
            try {
                String entryID = pStore.addProfile(modificatorTree);
                if (entryID == null) {
                    this._logHandler.error("SaveUserOptionsFormHandler.processPrefs: Can't create profile: entryID=null after creation.");
                    return false;
                }
            }
            catch (PStoreException pse) {
                this._logHandler.error("SaveUserOptionsFormHandler.processPrefs: Can't create profile : " + pse.getMessage());
                return false;
            }
            return true;
        }
        try {
            pStore.modifyProfile(prefs, modificatorTree);
        }
        catch (PStoreException xe) {
            this._logHandler.error("SaveUserOptionsFormHandler.processPrefs: Modify entry returned an error : " + xe.getMessage());
            return false;
        }
        return true;
    }
}

