/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.ui.ElementHandler;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProfileHandler
extends ElementHandler {
    public void expand(HttpServletRequest request, Element xmlElt, Element errorRootElt) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("ProfileHandler.expand: null session");
            return;
        }
        if (xmlElt == null) {
            this._logHandler.error("ProfileHandler.expand: null XML Element");
            return;
        }
        Document xmlDoc = xmlElt.getOwnerDocument();
        if (xmlDoc == null) {
            this._logHandler.error("ProfileHandler.expand: null XML Doc");
            return;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("ProfileHandler.expand: null pStore");
            return;
        }
        String profileName = xmlElt.getAttribute("name");
        if (profileName == null || profileName.length() <= 0) {
            profileName = "iPlanet Applications";
        }
        String profileType = xmlElt.getAttribute("profiletype");
        String isIntegration = (String)session.getAttribute("integration");
        if (isIntegration != null) {
            profileType = "sessionprofile";
        }
        if (profileType == null || profileType.length() <= 0) {
            profileType = "pstoretype";
        }
        Element profileEntryElement = null;
        if (profileType.equals("sessionprofile")) {
            String doReload = xmlElt.getAttribute("reload");
            profileEntryElement = doReload != null && doReload.length() > 0 ? pStore.getUserProfile(profileName, true) : pStore.getUserProfile(profileName, false);
        } else {
            try {
                profileEntryElement = pStore.getProfile(profileName);
            }
            catch (Exception e) {
                this._logHandler.error("ProfileHandler.expand: returned: " + e.getMessage());
                return;
            }
        }
        if (profileEntryElement == null) {
            return;
        }
        try {
            NodeList nl = profileEntryElement.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node childNode = this._domBuilder.copyNode(nl.item(i), xmlDoc);
                xmlElt.appendChild(childNode);
            }
        }
        catch (XMLProcessingException xpe) {
            this._logHandler.error("ProfileHandler.expand: Error while copying: " + xpe.getMessage());
            return;
        }
    }
}

