/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.tools.MultipartHttpServletRequest;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.FormHandler;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImportFormHandler
extends FormHandler {
    private File _configPathRoot;

    public boolean init(String actionName, PropertyReader propertyReader, XSLXMLLogHandler logHandler) {
        boolean init = super.init(actionName, propertyReader, logHandler);
        if (!init) {
            return false;
        }
        this._configPathRoot = propertyReader.getConfigPath();
        this._logHandler = logHandler;
        if (this._configPathRoot == null) {
            logHandler.error("ImportHandler.init: Could'nt retreive path to import config file");
            return false;
        }
        return true;
    }

    public boolean process(HttpServletRequest request, Element errorRootElt) {
        if (errorRootElt == null) {
            this._logHandler.error("ImportHandler.process: null Error Element");
            return false;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("ImportHandler.process: null Error Doc");
            return false;
        }
        String bookid = request.getParameter("bookid");
        String importFormat = request.getParameter("importformat");
        MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
        InputStream in = multiRequest.getFileParameter("file");
        if (in == null) {
            this._logHandler.error("ImportHandler.process: null import stream");
            return false;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("ImportHandler.process: Couldn't retreive session.");
            return false;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("ImportHandler.process: Error while initialising pstore.");
            return false;
        }
        Element errorElt = errorDoc.createElement("error");
        try {
            pStore.importEntry(bookid, importFormat, in, errorElt);
        }
        catch (Exception e) {
            this._logHandler.error("ImportHandler.Process : problem reading an entry : " + e.getMessage());
            errorElt.setAttribute("errtype", "2");
            errorElt.setAttribute("errnum", "271");
            errorElt.setAttribute("nbimported", "0");
            errorElt.setAttribute("importtype", importFormat);
            errorElt.setAttribute("bookid", bookid);
            errorRootElt.appendChild(errorElt);
            return false;
        }
        errorElt.setAttribute("importtype", importFormat);
        errorElt.setAttribute("bookid", bookid);
        errorRootElt.appendChild(errorElt);
        return true;
    }
}

