/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.Entry;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.ui.FormHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DeleteEntryFormHandler
extends FormHandler {
    public boolean process(HttpServletRequest request, Element errorRootElt) {
        if (errorRootElt == null) {
            this._logHandler.error("DeleteEntryFormHandler.process: null Error Element");
            return false;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("DeleteEntryFormHandler.process: null Error Doc");
            return false;
        }
        Object fte = null;
        String sBookID = request.getParameter("bookid");
        String sEntryID = request.getParameter("entryid");
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("DeleteEntryFormHandler.process: null session");
            return false;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("DeleteEntryFormHandler.process: null pStore");
            return false;
        }
        if (sBookID != null && sEntryID != null) {
            try {
                Entry curEntry = pStore.getEntry(sBookID, sEntryID);
                String sDisplayName = curEntry.getDisplayName();
                pStore.deleteEntry(sBookID, sEntryID);
                Element errorElt = errorDoc.createElement("error");
                errorElt.setAttribute("errtype", "0");
                errorElt.setAttribute("errnum", "5");
                errorElt.setAttribute("displayname", sDisplayName);
                errorElt.setAttribute("bookid", sBookID);
                errorRootElt.appendChild(errorElt);
                return true;
            }
            catch (PStoreException pse) {
                this._logHandler.error("DeleteEntryFormHandler.process: Could not delete Entry : " + pse.getMessage() + " (" + pse.getReason() + ")");
                return false;
            }
        }
        this._logHandler.error("DeleteEntryFormHandler.process: Can not accept null parameter");
        return false;
    }
}

