/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ui;

import com.iplanet.iabs.iabsapi.Entry;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.xslui.ui.FormHandler;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CopyEntryFormHandler
extends FormHandler {
    public boolean process(HttpServletRequest request, Element errorRootElt) {
        Element paramElt;
        if (errorRootElt == null) {
            this._logHandler.error("CopyEntryFormHandler.process: null Error Element");
            return false;
        }
        Document errorDoc = errorRootElt.getOwnerDocument();
        if (errorDoc == null) {
            this._logHandler.error("CopyEntryFormHandler.process: null Error Doc");
            return false;
        }
        Object fte = null;
        String srcBookID = request.getParameter("srcbookid");
        String dstBookID = request.getParameter("dstbookid");
        String srcEntryID = request.getParameter("entryid");
        Element errorElt = null;
        boolean paramIsMissing = false;
        if (srcBookID == null || srcBookID.length() == 0 || dstBookID == null || dstBookID.length() == 0 || srcEntryID == null || srcEntryID.length() == 0) {
            paramIsMissing = true;
            errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            errorElt.setAttribute("errnum", "514");
        }
        if (srcBookID == null || srcBookID.length() == 0) {
            this._logHandler.error("CopyEntryFormHandler.process: HTML Parameter srcbookid is missing");
            paramElt = errorDoc.createElement("parameter");
            paramElt.setAttribute("paramname", "srcbookid");
            errorElt.appendChild(paramElt);
        }
        if (dstBookID == null || dstBookID.length() == 0) {
            this._logHandler.error("CopyEntryFormHandler.process: HTML Parameter dstbookid is missing");
            paramElt = errorDoc.createElement("parameter");
            paramElt.setAttribute("paramname", "dstbookid");
            errorElt.appendChild(paramElt);
        }
        if (srcEntryID == null || srcEntryID.length() == 0) {
            this._logHandler.error("CopyEntryFormHandler.process: HTML Parameter entryid is missing");
            paramElt = errorDoc.createElement("parameter");
            paramElt.setAttribute("paramname", "dstbookid");
            errorElt.appendChild(paramElt);
        }
        if (paramIsMissing) {
            errorRootElt.appendChild(errorElt);
            return false;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("DeleteEntriesFormHandler.process: null session");
            return false;
        }
        PersonalStore pStore = (PersonalStore)session.getAttribute("com.iplanet.iabs.pstore");
        if (pStore == null) {
            this._logHandler.error("DeleteEntriesFormHandler.process: null pStore");
            return false;
        }
        try {
            Node parentNode;
            Entry srcEntry = pStore.getEntry(srcBookID, srcEntryID);
            Element entryElt = srcEntry.getEntryElement();
            Node childNode = XPathTools.getFirstNodeByXPath((Node)entryElt, (String)"entry/creationdate");
            Node node = parentNode = childNode != null ? childNode.getParentNode() : null;
            if (parentNode != null) {
                parentNode.removeChild(childNode);
            }
            Node node2 = parentNode = (childNode = XPathTools.getFirstNodeByXPath((Node)entryElt, (String)"entry/lastmodifieddate")) != null ? childNode.getParentNode() : null;
            if (parentNode != null) {
                parentNode.removeChild(childNode);
            }
            ((Element)XPathTools.getFirstNodeByXPath((Node)entryElt, (String)"entry")).removeAttribute("entryID");
            String[] bookIDs = new String[]{dstBookID};
            String dstEntryID = pStore.addEntry(bookIDs, entryElt);
            Entry dstEntry = pStore.getEntry(dstBookID, dstEntryID);
            this._logHandler.debug("CopyEntryFormHandler.Process: dstEntryID = " + dstEntryID);
            errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "0");
            errorElt.setAttribute("errnum", "9");
            errorElt.setAttribute("elementname", entryElt.getTagName());
            errorElt.setAttribute("displayname", dstEntry.getDisplayName());
            errorElt.setAttribute("bookid", dstBookID);
            errorRootElt.appendChild(errorElt);
            return true;
        }
        catch (PStoreException pse) {
            this._logHandler.error("CopyEntryFormHandler.process: Can't copy entry: " + pse.getMessage());
            errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            errorElt.setAttribute("errnum", "273");
            errorElt.setAttribute("rawmsg", "CopyEntryFormHandler.process: Can't copy entry: " + pse.getMessage());
            errorRootElt.appendChild(errorElt);
            return false;
        }
        catch (XSLProcessingException xse) {
            this._logHandler.error("CopyEntryFormHandler.process: Error while accessing entry element: " + xse.getMessage());
            errorElt = errorDoc.createElement("error");
            errorElt.setAttribute("errtype", "2");
            errorElt.setAttribute("errnum", "256");
            errorElt.setAttribute("rawmsg", "CopyEntryFormHandler.process: Error while accessing entry element: " + xse.getMessage());
            errorRootElt.appendChild(errorElt);
            return false;
        }
    }
}

