/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ldapplug;

import com.iplanet.iabs.dbinterface.DBPlugin;
import com.iplanet.iabs.dbinterface.PS_DBPlugin;
import com.iplanet.iabs.dbinterface.PagedSearch;
import com.iplanet.iabs.dbinterface.piDbException;
import com.iplanet.iabs.iabsutil.ABUtils;
import com.iplanet.iabs.ldapplug.LDAP2XMLTranslatable;
import com.iplanet.iabs.ldapplug.XML2LDAPTranslatable;
import com.iplanet.iabs.ldapplug.iLdapSearch;
import com.iplanet.xslui.auth.ABUserSession;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslatable;
import com.iplanet.xslui.dbtrans.TwoWayDbTranslation;
import com.iplanet.xslui.dbtrans.XML2DbTranslatable;
import com.iplanet.xslui.tools.LDAPConfigReader;
import com.iplanet.xslui.tools.LDAPPool;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.PropertiesException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.LDAPUrl;
import netscape.ldap.controls.LDAPProxiedAuthControl;
import netscape.ldap.controls.LDAPSortControl;
import netscape.ldap.controls.LDAPVirtualListControl;
import netscape.ldap.controls.LDAPVirtualListResponse;
import netscape.ldap.util.DN;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class iLdapDb
implements DBPlugin,
PS_DBPlugin {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String XML_BLOB_PARAM = "pipentryxmldata";
    public static final String LASTPURGEDATE = "lastPurgeDate";
    public static final char LEFT_PAREN = '(';
    public static final char RIGHT_PAREN = ')';
    public static final char LEFT_BRACKET = '[';
    public static final char RIGHT_BRACKET = ']';
    public static final String EQUAL = "=";
    public static final char OR_CHAR = '|';
    public static final char AND_CHAR = '&';
    public static final char NOT_CHAR = '!';
    public static final String COMMA = ",";
    public static final String DEFAULT_SEARCH_FIELD = "entry/displayname";
    private static final String LESS_THAN = "<";
    private static final String GREATER_THAN = ">";
    private static final String LESS_AND_EQUAL = "<=";
    private static final String EQUAL_AND_LESS = "=<";
    private static final String GREATER_AND_EQUAL = ">=";
    private static final String EQUAL_AND_GREATER = "=>";
    private static final String COLON = ":";
    private static final String COLON_EQUAL = ":=";
    private static final String SPACE = " ";
    private static final String STAR = "*";
    private static final int EXIST_OR_BAIL = 1;
    private static final String DEFAULT_AB_ATTR_NAME = "piDefaultAB";
    private String _db_name;
    protected boolean _delete_perm;
    protected boolean _vlv_paging;
    protected String _vlv_index;
    protected String _login_type;
    protected String _base_DN;
    protected String _entry_id_type;
    protected String _search_entry_types;
    protected int _lookthru_limit;
    private String _collationRule;
    private String _searchFields;
    private boolean _allow_unpaged_search;
    private boolean _ret_db_attribs;
    private LDAPPool _ldapConnPool = null;
    private ArrayList _allXMLEntryTypes = null;
    private int _idCount = 0;
    protected HashMap _shared_vars = null;
    private boolean _searchdel = false;
    private HashSet _skipAttrs = null;
    private TwoWayDbTranslation _dbTrans = null;
    private LDAPEntry _base_entry = null;
    private String _entry_dn = null;
    private String _last_purge_date = null;
    private static XMLDOMBuilder _domBuilder = null;
    public static final String DELETED = "deleted";
    public static boolean _purgeInProgress = false;
    public static String _adminGroupDn = null;

    public iLdapDb(File db_config_dir, int flags, String dbKey) throws piDbException {
        this._db_name = new String(db_config_dir.getName());
        File db_config_file = new File(db_config_dir, "db_config.properties");
        PropertyReader config = null;
        try {
            config = new PropertyReader(db_config_file);
        }
        catch (IOException io) {
            throw new piDbException(3, db_config_dir + "db_config.properties");
        }
        this._vlv_paging = config.getBooleanProperty("vlv_paging", "false");
        this._vlv_index = config.getStringProperty("vlv_index", DEFAULT_SEARCH_FIELD);
        this._base_DN = config.getStringProperty("search_dn", "");
        this._entry_id_type = config.getStringProperty("entry_id", "piEntryID");
        this._search_entry_types = config.getStringProperty("search_entry_types", "piEntryID");
        this._skipAttrs = new HashSet();
        this._skipAttrs.add(this._entry_id_type.toLowerCase());
        this._ret_db_attribs = config.getBooleanProperty("retrieve_db_attribs", "false");
        this._lookthru_limit = config.getIntProperty("lookthru_limit", 1000);
        this._delete_perm = config.getBooleanProperty("delete_perm", "true");
        _adminGroupDn = config.getStringProperty("admin_group_dn", null);
        this._collationRule = config.getStringProperty("collation_rule", null);
        this._searchFields = config.getStringProperty("search_fields", null);
        this._allow_unpaged_search = config.getBooleanProperty("allow_unpaged_search", "true");
        this._login_type = config.getStringProperty("login_type", "anon");
        try {
            this._ldapConnPool = LDAPConfigReader.getLDAPPool((PropertyReader)config, (String)(dbKey + "."));
        }
        catch (LDAPException l) {
            if (l.getLDAPResultCode() == 85) {
                throw new piDbException(29, l.toString());
            }
            throw new piDbException(4, this._db_name + " : " + l.getMessage());
        }
        try {
            this._dbTrans = new TwoWayDbTranslation(db_config_dir);
        }
        catch (DbTransException dbx) {
            throw new piDbException(5, dbx.toString());
        }
        String[] allEntryTypes = this._dbTrans.getXMLTypes();
        this._allXMLEntryTypes = new ArrayList<String>(Arrays.asList(allEntryTypes));
    }

    public int expandGroup(UserSession user_session, Element groupElement, Vector ret_fields, Vector sortby_fields, Vector entry_types, Element resElt) throws piDbException {
        CharSequence search_filter;
        String search_base;
        String[] groupocs = null;
        String displayname = null;
        boolean isStatic = false;
        boolean isDynamic = false;
        HashMap ldap_queries = null;
        int member_count = 0;
        try {
            groupocs = XPathTools.getValuesByXPath((Node)groupElement, (String)"groupoc");
            displayname = XPathTools.getValueByXPath((Node)groupElement, (String)DEFAULT_SEARCH_FIELD);
        }
        catch (XSLProcessingException xpe) {
            throw new piDbException(20, xpe.toString());
        }
        if (this.arrayContainsString(groupocs, "groupofuniquenames")) {
            isStatic = true;
        }
        if (this.arrayContainsString(groupocs, "groupofurls")) {
            isDynamic = true;
        }
        if (isStatic) {
            String[] members = null;
            try {
                members = XPathTools.getValuesByXPath((Node)groupElement, (String)"members/member");
            }
            catch (XSLProcessingException xpe) {
                throw new piDbException(20, xpe.toString());
            }
            ldap_queries = this.getStaticGrpLdapQueries(members);
            Set ks = ldap_queries.keySet();
            Iterator itr = ks.iterator();
            search_base = null;
            search_filter = null;
            while (itr.hasNext()) {
                search_base = (String)itr.next();
                search_filter = (StringBuffer)ldap_queries.get(search_base);
                member_count += this.search(user_session, "ldap:///" + search_base, 1, search_filter.toString(), ret_fields, sortby_fields, entry_types, resElt, 0, false);
            }
        }
        if (isDynamic = false) {
            String[] member_urls = null;
            try {
                member_urls = XPathTools.getValuesByXPath((Node)groupElement, (String)"members/memberurl");
            }
            catch (XSLProcessingException xpe) {
                throw new piDbException(20, xpe.toString());
            }
            int double_qm = 0;
            int single_qm = 0;
            search_base = null;
            search_filter = null;
            String scope_str = null;
            int scope = 0;
            for (int i = 0; i < member_urls.length; ++i) {
                if (member_urls == null || (double_qm = member_urls[i].indexOf("??")) < 0) continue;
                search_base = member_urls[i].substring(0, double_qm);
                if (!search_base.startsWith("ldap:///")) {
                    search_base = "ldap:///" + search_base;
                }
                if ((single_qm = member_urls[i].indexOf("?", double_qm + 2)) < 0) continue;
                scope_str = member_urls[i].substring(double_qm + 2, single_qm);
                if (scope_str.equalsIgnoreCase("sub")) {
                    scope = 2;
                } else if (scope_str.equalsIgnoreCase("base")) {
                    scope = 0;
                } else if (scope_str.equalsIgnoreCase("one")) {
                    scope = 1;
                }
                search_filter = member_urls[i].substring(single_qm + 1);
                member_count += this.search(user_session, search_base, scope, (String)search_filter, ret_fields, sortby_fields, entry_types, resElt, 0, false);
            }
        }
        return member_count;
    }

    private HashMap getStaticGrpLdapQueries(String[] members) {
        boolean first = true;
        boolean hasMembers = false;
        int comma = 0;
        String rdn = null;
        String search_base = null;
        String last_search_base = null;
        StringBuffer filter = null;
        HashMap<String, StringBuffer> search_filters = new HashMap<String, StringBuffer>();
        for (int i = 0; i < members.length; ++i) {
            if (members[i] == null || (comma = members[i].indexOf(44)) < 3) continue;
            hasMembers = true;
            rdn = members[i].substring(0, comma);
            search_base = members[i].substring(comma + 1);
            if (first || search_base.equalsIgnoreCase(last_search_base)) {
                if (!first) {
                    filter.append('(' + rdn + ')');
                } else {
                    filter = new StringBuffer("|(" + rdn + ')');
                    first = false;
                }
            } else {
                search_filters.put(last_search_base, filter);
                filter = (StringBuffer)search_filters.get(search_base);
                if (filter == null) {
                    filter = new StringBuffer("|(" + rdn + ')');
                } else {
                    filter.append('(' + rdn + ')');
                }
            }
            last_search_base = search_base;
        }
        if (hasMembers) {
            search_filters.put(last_search_base, filter);
        }
        return search_filters;
    }

    private boolean arrayContainsString(String[] array, String val) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    public int search(UserSession user_session, String search_base_url, String search_filter, Vector ret_fields, Vector sortby_fields, Vector entry_types, Element resElt, int flags) throws piDbException {
        return this.search(user_session, search_base_url, 2, search_filter, ret_fields, sortby_fields, entry_types, resElt, flags, true);
    }

    /*
     * Exception decompiling
     */
    private int search(UserSession user_session, String search_base_url, int scope, String search_filter, Vector ret_fields, Vector sortby_fields, Vector entry_types, Element resElt, int flags, boolean translate_filter) throws piDbException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void searchDeletedEntries(boolean delFlag) {
        this._searchdel = delFlag;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PagedSearch pagedSearch(UserSession user_session, String search_base_url, String search_filter, Vector ret_fields, Vector sortby_fields, Vector entry_types, int entries_per_page, int flags) throws piDbException {
        int entrycount;
        LDAPVirtualListControl vcon;
        LDAPConnection ldapConn;
        boolean have_fields;
        String[] ret_attribs;
        String main_sort_xml;
        LDAPSortKey[] sort_keys;
        String search_base;
        String filter;
        boolean this_search_vlv;
        block33: {
            LDAPVirtualListResponse vrcon;
            LDAPControl[] c;
            block32: {
                int eqindex;
                ArrayList etypes = null;
                if (entry_types == null) {
                    etypes = this._allXMLEntryTypes;
                } else {
                    etypes = new ArrayList(entry_types);
                    this.removeUselessEntryTypes(etypes);
                }
                this_search_vlv = false;
                if (this._vlv_paging && (eqindex = search_filter.indexOf(61)) > 0) {
                    String param_str;
                    int param_index = search_filter.lastIndexOf(43, eqindex);
                    if (param_index < 0 && (param_index = search_filter.lastIndexOf(40, eqindex)) < 0) {
                        param_index = 0;
                    }
                    if ((param_str = search_filter.substring(param_index, eqindex)).equals(this._vlv_index) && search_filter.charAt(eqindex + 1) == '*') {
                        this_search_vlv = true;
                    }
                }
                Logging.trace((int)1, (String)("iLdapDb.pagedSearch(): Using VLV control = " + this_search_vlv));
                filter = this.xlateSearchFilter(search_filter, etypes, this_search_vlv);
                LDAPUrl ldapurl = null;
                try {
                    ldapurl = new LDAPUrl(search_base_url);
                }
                catch (MalformedURLException ex) {
                    throw new piDbException(16, search_base_url + SPACE + ex.getMessage());
                }
                search_base = ldapurl.getDN();
                if ((search_base == null || search_base != null && search_base.length() == 0) && (search_base = user_session.getDN()) == null) {
                    throw new piDbException(16, search_base_url);
                }
                String filter_base = ldapurl.getFilter();
                if (filter_base != null && filter_base.length() > 0) {
                    if (!filter_base.startsWith("(")) {
                        filter_base = "(" + filter_base + ")";
                    }
                    filter = "&(" + filter + ")" + filter_base;
                }
                LDAPSortControl sorter = null;
                sort_keys = null;
                main_sort_xml = (String)sortby_fields.get(0);
                String mainSortLDAP = null;
                int sortby_count = sortby_fields.size();
                if (sortby_count > 0) {
                    sort_keys = new LDAPSortKey[sortby_count];
                    sorter = this.xlateSortbyFields(sortby_fields, sort_keys, etypes);
                    if (sort_keys[0] != null) {
                        mainSortLDAP = sort_keys[0].getKey();
                    }
                }
                ret_attribs = this.xlateRetFields(ret_fields, etypes, mainSortLDAP);
                have_fields = false;
                if (ret_fields != null && ret_fields.size() > 0) {
                    have_fields = true;
                } else if (this._ret_db_attribs) {
                    ret_attribs = this._dbTrans.getDbAttributeList(etypes);
                    if (ret_attribs != null) {
                        Vector<String> tmp_ret_attribs = new Vector<String>(Arrays.asList(ret_attribs));
                        tmp_ret_attribs.add("objectclass");
                        ret_attribs = tmp_ret_attribs.toArray(new String[0]);
                    } else {
                        Logging.trace((int)1, (String)"attribs null");
                    }
                }
                ldapConn = this.getLDAPConn();
                LDAPSearchConstraints cons = (LDAPSearchConstraints)ldapConn.getSearchConstraints().clone();
                LDAPProxiedAuthControl pcntrl = null;
                if (this._login_type.equalsIgnoreCase("PROXY")) {
                    pcntrl = new LDAPProxiedAuthControl(user_session.getDN(), true);
                }
                vcon = null;
                if (this_search_vlv) {
                    vcon = new LDAPVirtualListControl("A", 0, 2);
                } else {
                    cons.setMaxResults(this._lookthru_limit);
                }
                LDAPControl[] controls = null;
                if (vcon != null && pcntrl != null) {
                    controls = new LDAPControl[]{pcntrl, vcon};
                } else if (vcon != null || pcntrl != null) {
                    controls = new LDAPControl[]{vcon != null ? vcon : pcntrl};
                }
                if (controls != null) {
                    cons.setServerControls(controls);
                }
                String[] this_rets = new String[]{new String("objectclass")};
                entrycount = 0;
                filter = this.addDelFlag(filter);
                try {
                    LDAPSearchResults sres = ldapConn.search(search_base, 2, filter, this_rets, false, cons);
                    if (this_search_vlv) {
                        c = ldapConn.getResponseControls();
                        if (c == null) {
                            throw new piDbException(24);
                        }
                        vrcon = null;
                        break block32;
                    }
                    while (sres.hasMoreElements()) {
                        LDAPEntry entry = sres.next();
                        ++entrycount;
                    }
                    break block33;
                }
                catch (LDAPException ex) {
                    this.closeLdapConn(ldapConn);
                    if (ex.getLDAPResultCode() == 85) {
                        throw new piDbException(29, ex.toString());
                    }
                    throw new piDbException(15, ex.toString());
                }
            }
            for (int i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof LDAPVirtualListResponse)) continue;
                vrcon = (LDAPVirtualListResponse)c[i];
                break;
            }
            if (vrcon == null) {
                this.closeLdapConn(ldapConn);
                throw new piDbException(24);
            }
            entrycount = vrcon.getContentCount();
        }
        this.closeLdapConn(ldapConn);
        return new iLdapSearch(entries_per_page, search_base, filter, ret_attribs, have_fields, sort_keys, user_session, entrycount, main_sort_xml, vcon, this_search_vlv, this._dbTrans, this);
    }

    public void getEntry(UserSession user_session, String search_base_url, String entry_id, Element resElt, int flags) throws piDbException {
        LDAPUrl ldapurl = null;
        try {
            ldapurl = new LDAPUrl(search_base_url);
        }
        catch (MalformedURLException ex) {
            throw new piDbException(16, search_base_url + SPACE + ex.getMessage());
        }
        String search_base = ldapurl.getDN();
        if ((search_base == null || search_base != null && search_base.length() == 0) && (search_base = user_session.getDN()) == null) {
            throw new piDbException(16, search_base_url);
        }
        if (resElt == null) {
            throw new piDbException(28, "searchBook: no resElt");
        }
        Document resultTree = resElt.getOwnerDocument();
        if (resultTree == null) {
            throw new piDbException(28, "searchBook: resElt not attached to any doc");
        }
        String[] ret_attribs = null;
        if (this._ret_db_attribs) {
            ret_attribs = this._dbTrans.getAllDbAttributeList();
            Vector<String> tmp_ret_attribs = new Vector<String>(Arrays.asList(ret_attribs));
            tmp_ret_attribs.add("objectclass");
            ret_attribs = tmp_ret_attribs.toArray(new String[0]);
        }
        LDAPConnection ldapConn = this.getLDAPConn();
        LDAPSearchConstraints cons = (LDAPSearchConstraints)ldapConn.getSearchConstraints().clone();
        cons.setMaxResults(this._lookthru_limit);
        if (this._login_type.equalsIgnoreCase("PROXY")) {
            LDAPProxiedAuthControl cntrl = new LDAPProxiedAuthControl(user_session.getDN(), true);
            cons.setServerControls((LDAPControl)cntrl);
        }
        String[] search_types = this._search_entry_types.split(COMMA);
        String entry_str = null;
        if (search_types.length == 1) {
            entry_str = this._entry_id_type + '=' + entry_id;
        } else {
            entry_str = String.valueOf('|');
            for (int idx = 0; idx < search_types.length; ++idx) {
                entry_str = entry_str + '(' + search_types[idx] + '=' + entry_id + ')';
            }
        }
        entry_str = this.addDelFlag(entry_str);
        try {
            LDAPSearchResults res = ldapConn.search(search_base, 2, entry_str, ret_attribs, false, cons);
            if (res.getCount() == 0) {
                this.closeLdapConn(ldapConn);
                throw new piDbException(17, "invalid EntryID = " + entry_id);
            }
            if (res.getCount() > 1) {
                this.closeLdapConn(ldapConn);
                throw new piDbException(18, entry_id);
            }
            LDAPEntry entry = res.next();
            LDAP2XMLTranslatable dbEntry = new LDAP2XMLTranslatable(entry);
            try {
                this._dbTrans.translate((DbTranslatable)dbEntry, resElt);
            }
            catch (DbTransException de) {
                this.closeLdapConn(ldapConn);
                throw new piDbException(22, "Translate failed:" + de.toString());
            }
        }
        catch (LDAPException ex) {
            this.closeLdapConn(ldapConn);
            if (ex.getLDAPResultCode() == 32) {
                throw new piDbException(17, "invalid EntryID = " + entry_id);
            }
            if (ex.getLDAPResultCode() == 85) {
                throw new piDbException(29, ex.toString());
            }
            throw new piDbException(15, ex.toString());
        }
        this.closeLdapConn(ldapConn);
    }

    public void openUserStore(UserSession user_session, Element ps_base, String psRootURL, int flags) throws piDbException {
        boolean nostore = false;
        this._last_purge_date = null;
        if (psRootURL == null) {
            throw new piDbException(16);
        }
        LDAPUrl ldapurl = null;
        try {
            ldapurl = new LDAPUrl(psRootURL);
        }
        catch (MalformedURLException ex) {
            throw new piDbException(16, psRootURL);
        }
        this._entry_dn = ldapurl.getDN();
        LDAPConnection ldapConn = this.getLDAPConn();
        try {
            this._base_entry = ldapConn.read(this._entry_dn);
        }
        catch (LDAPException ex) {
            this.closeLdapConn(ldapConn);
            if (ex.getLDAPResultCode() == 32) {
                nostore = true;
            }
            if (ex.getLDAPResultCode() == 85) {
                throw new piDbException(29, ex.toString());
            }
            throw new piDbException(15, ex.toString());
        }
        this.closeLdapConn(ldapConn);
        if (nostore) {
            if (flags == 1 && ps_base == null) {
                throw new piDbException(40);
            }
            DN dn = new DN(this._entry_dn);
            String[] exploded_dn = dn.explodeDN(false);
            if (exploded_dn == null) {
                throw new piDbException(16, this._entry_dn);
            }
            String partial_dn = exploded_dn[exploded_dn.length - 1];
            ldapConn = this.getLDAPConn();
            for (int i = exploded_dn.length - 1; i > 0; --i) {
                Logging.trace((int)1, (String)("trying patial dn: " + partial_dn));
                boolean add = false;
                String[] attrs = new String[]{new String("objectclass")};
                try {
                    ldapConn.read(partial_dn, attrs);
                }
                catch (LDAPException ex) {
                    this.closeLdapConn(ldapConn);
                    if (ex.getLDAPResultCode() == 32) {
                        add = true;
                    }
                    if (ex.getLDAPResultCode() == 85) {
                        throw new piDbException(29, ex.toString());
                    }
                    throw new piDbException(15, ex.toString());
                }
                if (add) {
                    String componentName;
                    int indx = exploded_dn[i].indexOf(61);
                    if (indx <= 0) {
                        this.closeLdapConn(ldapConn);
                        throw new piDbException(16, "no = sign in dn:" + this._entry_dn);
                    }
                    String objName = componentName = exploded_dn[i].substring(0, indx);
                    if (componentName.equalsIgnoreCase("o")) {
                        objName = "organization";
                    } else if (componentName.equalsIgnoreCase("ou")) {
                        objName = "organizationalunit";
                    }
                    LDAPAttribute[] ldap_attrs = new LDAPAttribute[]{new LDAPAttribute("objectclass", objName), new LDAPAttribute(componentName, exploded_dn[i].substring(indx + 1))};
                    LDAPAttributeSet attr_set = new LDAPAttributeSet(ldap_attrs);
                    LDAPEntry entry = new LDAPEntry(partial_dn, attr_set);
                    try {
                        ldapConn.add(entry);
                    }
                    catch (LDAPException l) {
                        this.closeLdapConn(ldapConn);
                        if (l.getLDAPResultCode() == 85) {
                            throw new piDbException(29, l.toString());
                        }
                        throw new piDbException(15, " Unable to add dn: " + partial_dn + ". " + l.toString());
                    }
                }
                partial_dn = exploded_dn[i - 1] + ',' + partial_dn;
            }
            LDAPAttribute[] ldap_attrs = new LDAPAttribute[3];
            ldap_attrs[0] = new LDAPAttribute("objectclass", "piPStoreRoot");
            ldap_attrs[1] = new LDAPAttribute("piPStoreOwner", user_session.getUserId());
            DateTime dt = new DateTime();
            ldap_attrs[2] = new LDAPAttribute(LASTPURGEDATE, dt.toISOString());
            LDAPAttributeSet attr_set = new LDAPAttributeSet(ldap_attrs);
            LDAPEntry entry = new LDAPEntry(this._entry_dn, attr_set);
            try {
                ldapConn.add(entry);
            }
            catch (LDAPException l) {
                this.closeLdapConn(ldapConn);
                if (l.getLDAPResultCode() == 85) {
                    throw new piDbException(29, l.toString());
                }
                throw new piDbException(15, l.toString());
            }
            this.closeLdapConn(ldapConn);
            this.syncStore(user_session, ps_base, psRootURL);
            this._base_entry = entry;
        } else {
            boolean is_abs = false;
            LDAPAttribute base_ocs = this._base_entry.getAttribute("objectclass");
            Enumeration oc_vals = base_ocs.getStringValues();
            while (oc_vals.hasMoreElements()) {
                String oc_val = (String)oc_vals.nextElement();
                if (!oc_val.equalsIgnoreCase("piPStoreRoot")) continue;
                is_abs = true;
            }
        }
    }

    public void syncStore(UserSession user_session, Element ps_base, String psRootURL) throws piDbException {
        HashMap<String, String> member_ids = new HashMap<String, String>();
        Node ps_entry = null;
        if (ps_base != null) {
            try {
                Document tmpDoc = _domBuilder.newDocument();
                Node tmpElt = _domBuilder.copyNode((Node)ps_base, tmpDoc);
                ps_entry = (Element)tmpElt.getFirstChild();
            }
            catch (XMLProcessingException xpe) {
                throw new piDbException(20, "openUserSt: cant create xml:" + xpe.getMessage());
            }
        }
        while (ps_entry != null) {
            if (!ps_entry.getNodeName().equals("book")) {
                ArrayList found_nodes = new ArrayList(4);
                try {
                    XPathTools.getNodesByXPath((Node)ps_entry, (String)"memberofbook", found_nodes);
                    XPathTools.getNodesByXPath((Node)ps_entry, (String)"memberofgroup", found_nodes);
                }
                catch (XSLProcessingException xpe) {
                    throw new piDbException(20, xpe.toString());
                }
                for (int i = 0; i < found_nodes.size(); ++i) {
                    Node value_node;
                    Node found_node = (Node)found_nodes.get(i);
                    String member_val = null;
                    for (value_node = found_node.getFirstChild(); value_node != null && value_node.getNodeType() != 3; value_node = value_node.getNextSibling()) {
                    }
                    if (value_node == null) {
                        throw new piDbException(41, "empty memberofbook");
                    }
                    member_val = value_node.getNodeValue();
                    if (member_ids.isEmpty()) {
                        throw new piDbException(41, "No book defined before");
                    }
                    String replacement = (String)member_ids.get(member_val);
                    if (replacement == null) {
                        throw new piDbException(41, "memberofbook not matching any book");
                    }
                    value_node.setNodeValue(replacement);
                }
                Node membook = null;
                try {
                    membook = XPathTools.getFirstNodeByXPath((Node)ps_entry, (String)"memberofbook");
                }
                catch (XSLProcessingException x) {
                    throw new piDbException(20, x.toString());
                }
                if (membook == null) {
                    throw new piDbException(42);
                }
            }
            String entryid = this.addEntry(user_session, psRootURL, (Element)ps_entry, 0);
            String entry_type = ps_entry.getNodeName();
            if (entry_type.equals("book") || entry_type.equals("group")) {
                String fake_id = null;
                try {
                    fake_id = XPathTools.getValueByXPath((Node)ps_entry, (String)DEFAULT_SEARCH_FIELD);
                }
                catch (XSLProcessingException x) {
                    throw new piDbException(20, x.toString());
                }
                if (fake_id != null) {
                    member_ids.put(fake_id, entryid);
                }
            }
            ps_entry = (Element)ps_entry.getNextSibling();
        }
    }

    private String addDelFlag(String filter) {
        if (!this._searchdel && !this._delete_perm) {
            filter = "&(" + filter + ")(!(deleted=true))";
        }
        return filter;
    }

    public int getEntriesCount(String search_base) throws piDbException {
        String aVal = "1";
        int intvalue = 0;
        LDAPConnection ld = null;
        LDAPEntry findEntry = null;
        LDAPSearchResults res = null;
        LDAPUrl ldapurl = null;
        try {
            ldapurl = new LDAPUrl(search_base);
        }
        catch (MalformedURLException ex) {
            throw new piDbException(16, search_base + SPACE + ex.getMessage());
        }
        String entrydn = ldapurl.getDN();
        try {
            ld = this.getLDAPConn();
            String[] attrNames = new String[]{"numSubordinates"};
            String filter = this.addDelFlag("(objectclass=*)");
            res = ld.search(entrydn, 0, filter, attrNames, false);
            int count = res.getCount();
            if (count != 1) {
                this.closeLdapConn(ld);
                if (count == 0) {
                    throw new piDbException(17, "getEntriesCount: invalid base = " + entrydn);
                }
                throw new piDbException(18, "getEntriesCount: invalid base = " + entrydn);
            }
            findEntry = res.next();
            LDAPAttribute anAttr = findEntry.getAttribute("numSubordinates");
            Enumeration enumVals = anAttr.getStringValues();
            aVal = (String)enumVals.nextElement();
            intvalue = Integer.valueOf(aVal);
        }
        catch (LDAPException e) {
            this.closeLdapConn(ld);
            if (e.getLDAPResultCode() == 85) {
                throw new piDbException(29, e.toString());
            }
            throw new piDbException(15, e.toString());
        }
        this.closeLdapConn(ld);
        return intvalue;
    }

    public String addEntry(UserSession user_session, String search_base_url, Element abEntry, int flags) throws piDbException {
        return this.addEntry(user_session, search_base_url, abEntry, flags, null, false);
    }

    public String addEntry(UserSession user_session, String search_base_url, Element abEntry, int flags, String entry_id, boolean orderCheck) throws piDbException {
        LDAPUrl ldapurl = null;
        try {
            ldapurl = new LDAPUrl(search_base_url);
        }
        catch (MalformedURLException ex) {
            throw new piDbException(16, search_base_url + SPACE + ex.getMessage());
        }
        String search_base = ldapurl.getDN();
        this.encodePiXMLData(abEntry, "UTF-8");
        if (entry_id == null) {
            Logging.trace((int)1, (String)"iLdapDb.addEntry: No entry_id provided");
        }
        entry_id = entry_id == null ? this.getEntryID() : entry_id;
        Logging.trace((int)1, (String)("iLdapDb.addEntry: entry_id to add: " + entry_id));
        String entry_dn = new String(this._entry_id_type + EQUAL + entry_id + ',' + search_base);
        ArrayList<LDAPAttribute> ldapAttrs = new ArrayList<LDAPAttribute>();
        XML2LDAPTranslatable dbEntry = new XML2LDAPTranslatable(ldapAttrs, this._skipAttrs);
        try {
            this._dbTrans.reverseTranslate(abEntry, (XML2DbTranslatable)dbEntry, orderCheck);
        }
        catch (DbTransException dte) {
            if (dte.getReason() == 11) {
                throw new piDbException(45);
            }
            throw new piDbException(5, "Modify entry: reverseTranslate failed: " + dte.getMessage());
        }
        if (ldapAttrs.size() == 0) {
            throw new piDbException(25);
        }
        LDAPAttribute eid_attr = new LDAPAttribute(this._entry_id_type, entry_id);
        ldapAttrs.add(eid_attr);
        LDAPAttribute[] ldap_attrs = ldapAttrs.toArray(new LDAPAttribute[ldapAttrs.size()]);
        LDAPAttributeSet attr_set = new LDAPAttributeSet(ldap_attrs);
        LDAPEntry entry = new LDAPEntry(entry_dn, attr_set);
        LDAPConnection ldapConn = this.getLDAPConn();
        if (this.check_purge_dup_entry(ldapConn, entry_dn)) {
            Logging.error((int)1, (String)"iLdapDb.addEntry: THIS ENTRY ID ALREADY EXISTS!");
            throw new piDbException(46);
        }
        try {
            ldapConn.add(entry);
        }
        catch (LDAPException l) {
            this.closeLdapConn(ldapConn);
            Logging.error((int)1, (String)("iLdapDb.addEntry: " + l.getMessage()));
            l.printStackTrace();
            if (l.getLDAPResultCode() == 85) {
                throw new piDbException(29, l.toString());
            }
            throw new piDbException(15, l.toString());
        }
        this.closeLdapConn(ldapConn);
        return entry_id;
    }

    private boolean check_purge_dup_entry(LDAPConnection ldapConn, String entry_dn) {
        LDAPEntry existing_entry = null;
        boolean entry_exists = true;
        try {
            existing_entry = ldapConn.read(entry_dn, new String[]{DELETED});
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 32) {
                entry_exists = false;
            }
            Logging.trace((int)1, (String)"iLdapDb.check_purge_dup_entry WARNING: LDAP Exception recieved, but not NO_SUCH_OBJECT");
        }
        if (!entry_exists) {
            return false;
        }
        if (existing_entry == null) {
            Logging.error((int)1, (String)"iLdapDb.check_purge_dup_entry : Entry could not be obtained");
            return false;
        }
        LDAPAttribute deleted_attr = existing_entry.getAttribute(DELETED);
        if (deleted_attr == null) {
            Logging.trace((int)1, (String)"iLdapDb.check_purge_dup_entry: deleted_attr could not be obtained");
            return true;
        }
        String[] deleted_vals = deleted_attr.getStringValueArray();
        if (deleted_vals.length < 1) {
            Logging.error((int)1, (String)"iLdapDb.check_purge_dup_entry: deleted_attr_val could not be obtained");
            return true;
        }
        if (deleted_vals[0].equals("true")) {
            try {
                ldapConn.delete(entry_dn);
            }
            catch (LDAPException e) {
                Logging.error((int)1, (String)"iLdapDb.check_purge_dup_entry: Could not delete duplicate entry");
            }
            Logging.trace((int)1, (String)"iLdapDb.check_purge_dup_entry: Deleted duplicate entry");
            return false;
        }
        Logging.trace((int)1, (String)"iLdapDb.check_purge_dup_entry: Entry not marked deleted");
        return true;
    }

    public void modifyEntry(UserSession user_session, String search_base_url, String entryID, Element abEntry, int flags) throws piDbException {
        this.modifyEntry(user_session, search_base_url, entryID, abEntry, flags, false);
    }

    public void modifyEntry(UserSession user_session, String search_base_url, String entryID, Element abEntry, int flags, boolean orderCheck) throws piDbException {
        int i;
        LDAPUrl ldapurl = null;
        try {
            ldapurl = new LDAPUrl(search_base_url);
        }
        catch (MalformedURLException ex) {
            throw new piDbException(16, search_base_url + SPACE + ex.getMessage());
        }
        String search_base = ldapurl.getDN();
        this.encodePiXMLData(abEntry, "UTF-8");
        String entry_dn = new String(this._entry_id_type + EQUAL + entryID + ',' + search_base);
        LDAPConnection ldapConn = this.getLDAPConn();
        if (this.isMarkedDeleted(ldapConn, entry_dn)) {
            throw new piDbException(17, "invalid EntryID = " + entryID);
        }
        LDAPEntry old_entry = null;
        try {
            old_entry = ldapConn.read(entry_dn);
        }
        catch (LDAPException x) {
            this.closeLdapConn(ldapConn);
            if (x.getLDAPResultCode() == 32) {
                throw new piDbException(17, "invalid EntryID = " + entryID);
            }
            if (x.getLDAPResultCode() == 85) {
                throw new piDbException(29, x.toString());
            }
            throw new piDbException(15, x.toString());
        }
        ArrayList ldapModAttrs = new ArrayList();
        ArrayList ldapRemoveAttrs = new ArrayList();
        XML2LDAPTranslatable dbEntry = new XML2LDAPTranslatable(ldapModAttrs, ldapRemoveAttrs, this._skipAttrs);
        try {
            this._dbTrans.reverseTranslate(abEntry, (XML2DbTranslatable)dbEntry, orderCheck);
        }
        catch (DbTransException dte) {
            this.closeLdapConn(ldapConn);
            if (dte.getReason() == 11) {
                throw new piDbException(45);
            }
            throw new piDbException(5, "Modify entry: reverseTranslate failed: " + dte.getMessage());
        }
        if (ldapModAttrs.size() == 0 && ldapRemoveAttrs.size() == 0) {
            this.closeLdapConn(ldapConn);
            throw new piDbException(25, "modifyEntry: no data to modify");
        }
        LDAPModificationSet mod_set = new LDAPModificationSet();
        LDAPAttribute old_attr = null;
        for (i = 0; i < ldapModAttrs.size(); ++i) {
            boolean attrReadAlready = false;
            LDAPAttribute e_attr = (LDAPAttribute)ldapModAttrs.get(i);
            if (e_attr.size() == 0) {
                old_attr = old_entry.getAttribute(e_attr.getName());
                if (old_attr == null) continue;
                mod_set.add(1, old_attr);
                continue;
            }
            boolean isXMLBlob = e_attr.getName().equalsIgnoreCase(XML_BLOB_PARAM);
            if (old_attr == null || !isXMLBlob) {
                old_attr = old_entry.getAttribute(e_attr.getName());
            }
            if (isXMLBlob) {
                e_attr = this.handleXMLBlobAttr(old_attr, e_attr);
                if (old_attr != null) {
                    old_attr = e_attr;
                }
            }
            if (old_attr != null) {
                if (!isXMLBlob) {
                    old_attr = null;
                }
                mod_set.add(2, e_attr);
                continue;
            }
            mod_set.add(0, e_attr);
        }
        for (i = ldapRemoveAttrs.size() - 1; i >= 0; --i) {
            LDAPAttribute e_attr = (LDAPAttribute)ldapRemoveAttrs.get(i);
            old_attr = old_entry.getAttribute(e_attr.getName());
            if (old_attr == null) continue;
            mod_set.add(1, old_attr);
        }
        try {
            ldapConn.modify(entry_dn, mod_set);
        }
        catch (LDAPException l) {
            this.closeLdapConn(ldapConn);
            if (l.getLDAPResultCode() == 32) {
                throw new piDbException(17, "invalid EntryID = " + entryID);
            }
            if (l.getLDAPResultCode() == 85) {
                throw new piDbException(29, l.toString());
            }
            throw new piDbException(15, l.toString());
        }
        this.closeLdapConn(ldapConn);
    }

    private LDAPAttribute handleXMLBlobAttr(LDAPAttribute old_attr, LDAPAttribute new_attr) throws piDbException {
        String eleName;
        Element ele;
        int i;
        String[] xmlOldAttr = null;
        if (old_attr != null) {
            xmlOldAttr = old_attr.getStringValueArray();
        }
        String[] xmlNewAttr = new_attr.getStringValueArray();
        HashMap<String, Document> oldAttrDOMMap = new HashMap<String, Document>();
        HashMap<String, Document> newAttrDOMMap = new HashMap<String, Document>();
        for (i = 0; xmlOldAttr != null && i < xmlOldAttr.length; ++i) {
            String oldAttr = xmlOldAttr[i];
            Document oldAttrDOM = null;
            try {
                oldAttrDOM = _domBuilder.parse((Reader)new StringReader(oldAttr), true);
            }
            catch (XMLProcessingException xpe) {
                throw new piDbException(22, "Parsing failed[Existing attributes] - " + xpe.getMessage());
            }
            ele = oldAttrDOM.getDocumentElement();
            eleName = ele.getNodeName();
            oldAttrDOMMap.put(eleName, oldAttrDOM);
        }
        for (i = 0; i < xmlNewAttr.length; ++i) {
            String newAttr = xmlNewAttr[i];
            Document newAttrDOM = null;
            try {
                newAttrDOM = _domBuilder.parse((Reader)new StringReader(newAttr), true);
            }
            catch (XMLProcessingException xpe) {
                throw new piDbException(22, "Parsing failed[New attributes] - " + xpe.getMessage());
            }
            ele = newAttrDOM.getDocumentElement();
            eleName = ele.getNodeName();
            newAttrDOMMap.put(ele.getNodeName(), newAttrDOM);
        }
        ArrayList<String> finalAttrList = new ArrayList<String>();
        Set oldAttrKeySet = oldAttrDOMMap.keySet();
        String[] oldAttrkeys = oldAttrKeySet.toArray(EMPTY_STRING_ARRAY);
        for (int i2 = 0; i2 < oldAttrkeys.length; ++i2) {
            String attrName = oldAttrkeys[i2];
            if (newAttrDOMMap == null || newAttrDOMMap.containsKey(attrName)) continue;
            try {
                String dataval = this.getStringFromDoc((Document)oldAttrDOMMap.get(attrName));
                finalAttrList.add(dataval);
                continue;
            }
            catch (Exception xpe) {
                throw new piDbException(22, "Error while getting changed XML[copying existing nodes] ->" + xpe.getMessage());
            }
        }
        Set newAttrKeySet = newAttrDOMMap.keySet();
        String[] newAttrkeys = newAttrKeySet.toArray(EMPTY_STRING_ARRAY);
        for (int i3 = 0; i3 < newAttrkeys.length; ++i3) {
            String attrName = newAttrkeys[i3];
            Document oldAttrDOM = (Document)oldAttrDOMMap.get(attrName);
            Document newAttrDOM = (Document)newAttrDOMMap.get(attrName);
            Element newDocEle = newAttrDOM.getDocumentElement();
            Document docToCopy = null;
            if (oldAttrDOM == null || oldAttrDOM != null && !oldAttrDOMMap.containsKey(attrName)) {
                Logging.trace((int)1, (String)("Olddom is null or it doesn't have so we will add it " + attrName));
                if (newDocEle.getNodeValue() != null || newDocEle.hasChildNodes()) {
                    docToCopy = newAttrDOM;
                }
            } else if (newDocEle.hasChildNodes()) {
                NodeList nList = newDocEle.getChildNodes();
                Node prevNode = null;
                boolean mvOldNodeRemoved = false;
                for (int k = 0; k < nList.getLength(); ++k) {
                    boolean removeNode = false;
                    Node nItem = nList.item(k);
                    if (nItem.getNodeType() == 1) {
                        String nodeValue = nItem.getNodeValue();
                        if (nItem.getNodeValue() == null && !nItem.hasChildNodes()) {
                            removeNode = true;
                        }
                        Logging.trace((int)2, (String)("Remove " + nItem.getNodeName() + "? -> " + removeNode));
                        NodeList oldAttrNodes = oldAttrDOM.getElementsByTagName(nItem.getNodeName());
                        if (oldAttrNodes == null || oldAttrNodes != null && oldAttrNodes.getLength() == 0) {
                            Logging.trace((int)2, (String)"New Node so copying");
                            if (!removeNode) {
                                try {
                                    oldAttrDOM.getDocumentElement().appendChild(_domBuilder.copyNode(nItem, oldAttrDOM));
                                    docToCopy = oldAttrDOM;
                                }
                                catch (XMLProcessingException xpe) {
                                    throw new piDbException(22, "Error while copying node - " + xpe.getMessage());
                                }
                            }
                        } else if (removeNode) {
                            Node oldNode = oldAttrNodes.item(0);
                            oldNode.getParentNode().removeChild(oldNode);
                            while ((oldAttrNodes = oldAttrDOM.getElementsByTagName(nItem.getNodeName())) != null && (oldAttrNodes == null || oldAttrNodes.getLength() != 0)) {
                                oldNode = oldAttrNodes.item(0);
                                oldNode.getParentNode().removeChild(oldNode);
                            }
                            docToCopy = oldAttrDOM;
                        } else {
                            String curNodeName = nItem.getNodeName();
                            try {
                                if (prevNode == null || prevNode != null && !prevNode.getNodeName().equals(curNodeName)) {
                                    Node oldNode = oldAttrNodes.item(0);
                                    oldNode.getParentNode().removeChild(oldNode);
                                    while ((oldAttrNodes = oldAttrDOM.getElementsByTagName(nItem.getNodeName())) != null && (oldAttrNodes == null || oldAttrNodes.getLength() != 0)) {
                                        oldNode = oldAttrNodes.item(0);
                                        oldNode.getParentNode().removeChild(oldNode);
                                    }
                                }
                                oldAttrDOM.getDocumentElement().appendChild(_domBuilder.copyNode(nItem, oldAttrDOM));
                            }
                            catch (XMLProcessingException xpe) {
                                throw new piDbException(22, "Error while replacing node - " + xpe.getMessage());
                            }
                            docToCopy = oldAttrDOM;
                        }
                    }
                    if (prevNode != null && prevNode.getNodeName() == nItem.getNodeName()) {
                        mvOldNodeRemoved = false;
                    }
                    prevNode = nItem;
                }
            } else {
                docToCopy = null;
            }
            try {
                String dataval = this.getStringFromDoc(docToCopy);
                if (dataval == null) continue;
                finalAttrList.add(dataval);
                continue;
            }
            catch (Exception xpe) {
                throw new piDbException(22, "Error while getting changed XML ->" + xpe.getMessage());
            }
        }
        String attr_name = new_attr.getName();
        String[] finalAttrs = finalAttrList.toArray(EMPTY_STRING_ARRAY);
        LDAPAttribute new_attr_list = new LDAPAttribute(attr_name, finalAttrs);
        return new_attr_list;
    }

    private String getStringFromDoc(Node nodeToDump) throws XMLProcessingException {
        if (nodeToDump == null) {
            return null;
        }
        ByteArrayOutputStream ostream = new ByteArrayOutputStream(128);
        XMLDOMBuilder.dumpNode((Node)nodeToDump, (OutputStream)ostream, (boolean)true);
        String dataval = ostream.toString();
        int index1 = dataval.indexOf(10, 2);
        if (index1 < 0) {
            throw new XMLProcessingException("Error - Couldn't dump/analyze Elt");
        }
        dataval = dataval.substring(index1 + 1);
        return dataval;
    }

    public void deleteEntry(UserSession user_session, String search_base_url, String entryID, int flags) throws piDbException {
        LDAPUrl ldapurl = null;
        try {
            ldapurl = new LDAPUrl(search_base_url);
        }
        catch (MalformedURLException ex) {
            throw new piDbException(16, search_base_url + SPACE + ex.getMessage());
        }
        String search_base = ldapurl.getDN();
        Logging.trace((int)1, (String)("Deleting LDAP entry: " + entryID));
        String entry_dn = new String(this._entry_id_type + EQUAL + entryID + ',' + search_base);
        LDAPConnection ldapConn = this.getLDAPConn();
        try {
            LDAPEntry entry = ldapConn.read(entry_dn);
            LDAPAttribute oc = entry.getAttribute("objectclass");
            boolean canBeMarkedAsDeleted = false;
            String[] vals = oc.getStringValueArray();
            for (int i = 0; i < vals.length; ++i) {
                if (!vals[i].equalsIgnoreCase("PITYPEPERSON") && !vals[i].equalsIgnoreCase("PITYPEGROUP")) continue;
                canBeMarkedAsDeleted = true;
                break;
            }
            if (!this._delete_perm && canBeMarkedAsDeleted) {
                this.markAsDeleted(ldapConn, entry_dn, entry);
            } else {
                ldapConn.delete(entry_dn);
            }
        }
        catch (LDAPException x) {
            this.closeLdapConn(ldapConn);
            if (x.getLDAPResultCode() == 32) {
                throw new piDbException(17, "invalid EntryID = " + entryID);
            }
            if (x.getLDAPResultCode() == 85) {
                throw new piDbException(29, x.toString());
            }
            throw new piDbException(15, x.toString());
        }
        this.closeLdapConn(ldapConn);
    }

    private boolean purgeRequired(boolean forcedPurge, int purgeInterval) throws ParseException, PropertiesException {
        boolean purgeCount = false;
        boolean required = false;
        if (forcedPurge || this._last_purge_date == null) {
            required = true;
        } else {
            DateTime currentDate = new DateTime();
            DateTime lpd = new DateTime(this._last_purge_date);
            lpd.add(new Duration(purgeInterval, 0, 0, 0));
            Logging.trace((int)1, (String)("purgerq:" + lpd.toISOString() + " after " + currentDate.toISOString()));
            if (lpd.after((Object)currentDate)) {
                required = true;
            }
        }
        Logging.trace((int)1, (String)("purge required is:" + String.valueOf(required)));
        return required;
    }

    public static synchronized boolean getPurgeState() {
        return _purgeInProgress;
    }

    public static synchronized void setPurgeInProgress(boolean state) {
        _purgeInProgress = state;
    }

    private boolean isAllowedToPurgeAll(UserSession user) throws piDbException {
        LDAPConnection conn;
        boolean isAllowed;
        block4: {
            isAllowed = false;
            conn = null;
            try {
                String[] vals;
                ABUserSession a = (ABUserSession)user;
                conn = this.getLDAPConn();
                LDAPEntry entry = conn.read(a.getUserDN());
                Logging.trace((int)1, (String)a.getUserDN());
                LDAPAttribute mem = entry.getAttribute("memberOf");
                if (mem == null || (vals = mem.getStringValueArray()) == null || vals.length <= 0 || _adminGroupDn == null || _adminGroupDn.length() <= 0) break block4;
                Logging.trace((int)1, (String)("AdmingroupDN:" + _adminGroupDn));
                for (int i = 0; i < vals.length; ++i) {
                    Logging.trace((int)1, (String)("memberOf attribute value:" + vals[0]));
                    if (!_adminGroupDn.equalsIgnoreCase(vals[0])) continue;
                    isAllowed = true;
                    break;
                }
            }
            catch (LDAPException e) {
                if (conn != null) {
                    this.closeLdapConn(conn);
                }
                throw new piDbException(15, e.getMessage());
            }
        }
        this.closeLdapConn(conn);
        return isAllowed;
    }

    public Hashtable purgeAllUserContacts(UserSession user, int expPeriod) throws piDbException {
        if (iLdapDb.getPurgeState()) {
            throw new piDbException(15, "Purge is already in progress...");
        }
        iLdapDb.setPurgeInProgress(true);
        if (!this.isAllowedToPurgeAll(user)) {
            iLdapDb.setPurgeInProgress(false);
            throw new piDbException(15, "You don't have permission to purge all user contacts..");
        }
        this.initLastPurgeDate();
        String baseURL = this._base_entry.getDN();
        Logging.trace((int)1, (String)baseURL);
        baseURL = baseURL.substring(baseURL.indexOf(44) + 1);
        Logging.trace((int)1, (String)baseURL);
        LDAPConnection conn = this.getLDAPConn();
        Hashtable stat = null;
        try {
            stat = this.purgeAll(conn, baseURL, expPeriod);
        }
        catch (LDAPException e) {
            this.closeLdapConn(conn);
            iLdapDb.setPurgeInProgress(false);
            this.dump_stack((Exception)((Object)e));
            Logging.error((int)1, (String)e.getMessage());
            throw new piDbException(15, e.getMessage());
        }
        catch (Exception e) {
            this.closeLdapConn(conn);
            iLdapDb.setPurgeInProgress(false);
            Logging.error((int)1, (String)e.getMessage());
            this.dump_stack(e);
            throw new piDbException(15, e.getMessage());
        }
        this.closeLdapConn(conn);
        iLdapDb.setPurgeInProgress(false);
        return stat;
    }

    private void dump_stack(Exception e) {
        Logging.error((int)1, (String)"*** Start Stack Trace ******");
        StackTraceElement[] frames = e.getStackTrace();
        for (int i = 0; i < frames.length; ++i) {
            StackTraceElement frame = frames[i];
            Logging.error((int)1, (String)(frame.getClassName() + "." + frame.getMethodName() + "@" + frame.getLineNumber()));
        }
        Logging.error((int)1, (String)"****** End Stack Trace ******");
    }

    private Hashtable purgeAll(LDAPConnection conn, String baseURL, int expPeriod) throws LDAPException, piDbException {
        Hashtable<String, String> dns = new Hashtable<String, String>();
        String[] ret_attribs = new String[]{"modifyTimestamp"};
        int purgeCount = 0;
        LDAPSearchResults res = conn.search(baseURL, 2, this.getPurgeFilter(expPeriod), ret_attribs, false);
        String currDate = this.getLdapDate(new DateTime().toISOString());
        String currentDn = null;
        while (res.hasMoreElements()) {
            LDAPEntry entry = res.next();
            String dn = entry.getDN();
            if (!dns.containsKey(dn = dn.substring(dn.indexOf(44) + 1))) {
                if (currentDn != null && purgeCount > 1) {
                    dns.put(currentDn, String.valueOf(purgeCount));
                    Logging.error((int)1, (String)("putting :" + currentDn + COLON + String.valueOf(purgeCount)));
                }
                purgeCount = 1;
                dns.put(dn, String.valueOf(purgeCount));
                Logging.error((int)1, (String)("putting :" + dn + COLON + String.valueOf(purgeCount)));
                this.setLPD(conn, dn, currDate);
                currentDn = dn;
            } else {
                ++purgeCount;
            }
            conn.delete(entry.getDN());
        }
        if (currentDn != null && purgeCount > 1) {
            dns.put(currentDn, String.valueOf(purgeCount));
            Logging.error((int)1, (String)("putting :" + currentDn + COLON + String.valueOf(purgeCount)));
        }
        return dns;
    }

    private void initLastPurgeDate() throws piDbException {
        String[] vals;
        if (this._base_entry == null) {
            throw new piDbException(15, "entry not found");
        }
        LDAPAttribute lp = this._base_entry.getAttribute(LASTPURGEDATE);
        if (lp != null && (vals = lp.getStringValueArray()) != null && vals.length > 0) {
            this._last_purge_date = this.getISODate(vals[0]);
        }
    }

    public int purgeEntries(UserSession user, String baseURL, boolean forcedPurge, int purgeInterval, int expirePeriod) throws piDbException {
        int purgeCount = 0;
        boolean p = false;
        this.initLastPurgeDate();
        try {
            p = this.purgeRequired(forcedPurge, purgeInterval);
        }
        catch (ParseException e) {
            throw new piDbException(15, e.getMessage());
        }
        catch (PropertiesException e) {
            throw new piDbException(15, e.getMessage());
        }
        if (p) {
            LDAPConnection conn = this.getLDAPConn();
            try {
                purgeCount = this.purge(conn, user, expirePeriod, baseURL);
            }
            catch (LDAPException e) {
                this.closeLdapConn(conn);
                throw new piDbException(15, e.toString());
            }
            this.closeLdapConn(conn);
        }
        return purgeCount;
    }

    private String getLdapDate(String d) {
        if (d != null) {
            return d.substring(0, 8) + d.substring(9);
        }
        return null;
    }

    private String getISODate(String d) {
        if (d != null) {
            return d.substring(0, 8) + "T" + d.substring(8);
        }
        return null;
    }

    private String getPurgeFilter(int expirePeriod) throws piDbException {
        String cd = null;
        try {
            DateTime currDate = new DateTime();
            Duration d = new Duration(expirePeriod, 0, 0, 0);
            d.setSign(-1);
            currDate.add(d);
            cd = this.getLdapDate(currDate.toISOString());
        }
        catch (PropertiesException p) {
            throw new piDbException(15, p.getMessage());
        }
        String filter = "&(objectclass=*)(deleted=true)(modifyTimestamp<=" + cd + ")";
        Logging.trace((int)1, (String)("purge filter:" + filter));
        return filter;
    }

    private int purge(LDAPConnection conn, UserSession user_session, int expirePeriod, String baseURL) throws LDAPException, piDbException {
        LDAPUrl ldapurl = null;
        Logging.trace((int)1, (String)"in ildapdb purge");
        try {
            ldapurl = new LDAPUrl(baseURL);
        }
        catch (MalformedURLException ex) {
            throw new piDbException(16, baseURL + SPACE + ex.getMessage());
        }
        String search_base = ldapurl.getDN();
        if ((search_base == null || search_base != null && search_base.length() == 0) && (search_base = user_session.getDN()) == null) {
            throw new piDbException(16, baseURL);
        }
        String[] ret_attribs = new String[]{"modifyTimestamp"};
        int purgeCount = 0;
        LDAPSearchResults res = conn.search(search_base, 2, this.getPurgeFilter(expirePeriod), ret_attribs, false);
        while (res.hasMoreElements()) {
            LDAPEntry entry = res.next();
            conn.delete(entry.getDN());
            ++purgeCount;
        }
        this.setLPD(conn, this._base_entry.getDN(), this.getLdapDate(new DateTime().toISOString()));
        return purgeCount;
    }

    private void setLPD(LDAPConnection conn, String dn, String lpd) throws LDAPException {
        LDAPEntry entry = conn.read(dn);
        LDAPAttribute lp = entry.getAttribute(LASTPURGEDATE);
        LDAPAttribute lastPurgeDate = new LDAPAttribute(LASTPURGEDATE, lpd);
        LDAPModificationSet modSet = new LDAPModificationSet();
        if (lp == null) {
            modSet.add(0, lastPurgeDate);
        } else {
            modSet.add(2, lastPurgeDate);
        }
        conn.modify(dn, modSet);
        this._last_purge_date = lpd;
    }

    public String getLastPurgeDate() {
        try {
            if (this._last_purge_date == null) {
                this.initLastPurgeDate();
            }
        }
        catch (piDbException e) {
            Logging.trace((int)32, (String)e.getMessage());
        }
        return this.getLdapDate(this._last_purge_date);
    }

    private void markAsDeleted(LDAPConnection ldapConn, String entryDn, LDAPEntry entry) throws LDAPException {
        LDAPModificationSet modSet = new LDAPModificationSet();
        LDAPAttribute setAsDeleted = new LDAPAttribute(DELETED, "true");
        LDAPAttribute delStatus = entry.getAttribute(DELETED);
        if (delStatus == null) {
            modSet.add(0, setAsDeleted);
        } else {
            modSet.add(2, setAsDeleted);
        }
        ldapConn.modify(entryDn, modSet);
    }

    private boolean isMarkedDeleted(LDAPConnection ldapConn, String entry_dn) {
        LDAPEntry existing_entry = null;
        boolean entry_exists = true;
        try {
            existing_entry = ldapConn.read(entry_dn, new String[]{DELETED});
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 32) {
                entry_exists = false;
            }
            Logging.trace((int)1, (String)"iLdapDb.isMarkedDeleted WARNING: LDAP Exception recieved, but not NO_SUCH_OBJECT");
        }
        if (!entry_exists) {
            return false;
        }
        if (existing_entry == null) {
            Logging.error((int)1, (String)"iLdapDb.isMarkedDeleted : Entry could not be obtained");
            return false;
        }
        LDAPAttribute deleted_attr = existing_entry.getAttribute(DELETED);
        if (deleted_attr == null) {
            Logging.trace((int)1, (String)"iLdapDb.check_purge_dup_entry: deleted_attr could not be obtained");
            return false;
        }
        String[] deleted_vals = deleted_attr.getStringValueArray();
        if (deleted_vals.length < 1) {
            Logging.error((int)1, (String)"iLdapDb.check_purge_dup_entry: deleted_attr_val could not be obtained");
            return true;
        }
        return deleted_vals[0].equals("true");
    }

    private void removeUselessEntryTypes(ArrayList entry_types) throws piDbException {
        int i = 0;
        while (i < entry_types.size()) {
            if (this._dbTrans.getDbTypeForXMLType((String)entry_types.get(i)) == null) {
                entry_types.remove(i);
                continue;
            }
            ++i;
        }
        if (entry_types.size() <= 0) {
            throw new piDbException(26);
        }
    }

    protected LDAPConnection getLDAPConn() throws piDbException {
        LDAPConnection ldapConn = null;
        try {
            ldapConn = this._ldapConnPool.getConnection();
        }
        catch (LDAPException ex) {
            throw new piDbException(12, ex.getMessage());
        }
        if (ldapConn == null) {
            throw new piDbException(12, "request for a connection from pool time out");
        }
        return ldapConn;
    }

    protected void closeLdapConn(LDAPConnection ldapConn) {
        this._ldapConnPool.close(ldapConn);
    }

    private String xlateSearchFilter(String search_filter, ArrayList entry_types, boolean is_vlv) throws piDbException {
        StringBuffer ret_str_buf;
        block45: {
            int level = 0;
            boolean[] action_and = new boolean[10];
            action_and[0] = false;
            int end_index = 0;
            ret_str_buf = new StringBuffer(search_filter);
            String parse_str = new String(search_filter);
            while (true) {
                char char_at;
                if ((char_at = parse_str.charAt(0)) == '(') {
                    ++level;
                    parse_str = parse_str.substring(1);
                    continue;
                }
                if (char_at == '&') {
                    action_and[level] = true;
                    parse_str = parse_str.substring(1);
                    continue;
                }
                if (char_at == '|' || char_at == '!') {
                    parse_str = parse_str.substring(1);
                    continue;
                }
                if (char_at == ')') {
                    if (action_and[level]) {
                        // empty if block
                    }
                    parse_str = parse_str.substring(1);
                    if (--level < 0) {
                        throw new piDbException(11, search_filter);
                    }
                    if (level != 0 || parse_str.length() != 0) continue;
                    break block45;
                }
                String field = null;
                boolean breakout = false;
                String rest_of_expr = null;
                end_index = parse_str.indexOf(EQUAL);
                int alt_end = -1;
                int tempCount = 0;
                for (tempCount = 0; tempCount < parse_str.length(); ++tempCount) {
                    if (parse_str.charAt(tempCount) != ')' || parse_str.charAt(tempCount - 1) == '\\') continue;
                    alt_end = tempCount;
                    break;
                }
                if (parse_str.charAt(0) == '[') {
                    int xend = parse_str.indexOf(93);
                    String tmp_str = parse_str.substring(xend);
                    end_index = tmp_str.indexOf(EQUAL);
                }
                if (end_index > 0) {
                    if (parse_str.charAt(end_index - 1) == '>' || parse_str.charAt(end_index - 1) == '<' || parse_str.charAt(end_index - 1) == '~') {
                        --end_index;
                    }
                    field = parse_str.substring(0, end_index);
                    rest_of_expr = alt_end < 0 ? parse_str.substring(end_index, parse_str.length()) : parse_str.substring(end_index, alt_end);
                }
                if (alt_end < 0) {
                    breakout = true;
                    if (end_index < 0) {
                        end_index = parse_str.length();
                        field = parse_str.substring(0, end_index);
                    }
                } else if (alt_end < end_index || end_index < 0) {
                    rest_of_expr = null;
                    end_index = alt_end;
                    field = parse_str.substring(0, end_index);
                }
                if (alt_end > 0) {
                    parse_str = parse_str.substring(alt_end);
                }
                if (field != null && field.length() > 0) {
                    ArrayList rep_fields = null;
                    try {
                        rep_fields = this._dbTrans.xlateXPathField(field, false, entry_types);
                    }
                    catch (DbTransException dtx) {
                        throw new piDbException(19, "error while prcessing field: " + field + COLON + dtx.toString());
                    }
                    if (rep_fields == null || rep_fields.size() == 0) {
                        throw new piDbException(19, "error while prcessing field: " + field + "(no translation)");
                    }
                    if (rep_fields.size() == 1) {
                        String tStr = ret_str_buf.substring(ret_str_buf.indexOf(field) + field.length());
                        ret_str_buf = new StringBuffer(ret_str_buf.substring(0, ret_str_buf.indexOf(field)) + rep_fields.get(0));
                        boolean getCollationRule = false;
                        if (this._collationRule != null) {
                            if (this._searchFields != null) {
                                String[] searchFieldsArray = this._searchFields.split(COMMA);
                                if (this.arrayContainsString(searchFieldsArray, field)) {
                                    getCollationRule = true;
                                }
                            } else if (DEFAULT_SEARCH_FIELD.equalsIgnoreCase(field)) {
                                getCollationRule = true;
                            }
                        }
                        if (getCollationRule) {
                            ret_str_buf.append(this.getFilterWCollationRule(tStr));
                        } else {
                            ret_str_buf.append(tStr);
                        }
                    } else {
                        int tmpint = ret_str_buf.indexOf(field);
                        String tmp_str = ret_str_buf.substring(0, tmpint) + '|';
                        ArrayList<String> old_str = new ArrayList<String>();
                        int nbFilters = 0;
                        for (int i = 0; i < rep_fields.size(); ++i) {
                            if (old_str.indexOf((String)rep_fields.get(i)) == -1) {
                                tmp_str = tmp_str + '(' + rep_fields.get(i);
                                boolean getCollationRule = false;
                                if (this._collationRule != null) {
                                    if (this._searchFields != null) {
                                        String[] searchFieldsArray = this._searchFields.split(COMMA);
                                        if (this.arrayContainsString(searchFieldsArray, field)) {
                                            getCollationRule = true;
                                        }
                                    } else if (DEFAULT_SEARCH_FIELD.equalsIgnoreCase(field)) {
                                        getCollationRule = true;
                                    }
                                }
                                tmp_str = getCollationRule ? tmp_str + this.getFilterWCollationRule(rest_of_expr) : tmp_str + rest_of_expr;
                                tmp_str = tmp_str + ')';
                                ++nbFilters;
                            }
                            old_str.add((String)rep_fields.get(i));
                        }
                        if (nbFilters <= 1) {
                            tmp_str = tmp_str.substring(0, tmpint) + tmp_str.substring(tmpint + 2, tmp_str.length() - 1);
                        }
                        String tStr = ret_str_buf.substring(ret_str_buf.indexOf(field) + field.length() + rest_of_expr.length());
                        ret_str_buf = new StringBuffer(tmp_str);
                        ret_str_buf.append(tStr);
                    }
                }
                if (breakout) break;
            }
            if (level != 0) {
                throw new piDbException(11, search_filter);
            }
            if (!action_and[0]) {
                // empty if block
            }
        }
        if (is_vlv) {
            return ret_str_buf.substring(0);
        }
        String tmp_str = null;
        if (entry_types.size() == 1) {
            tmp_str = "objectclass=" + this._dbTrans.getDbTypeForXMLType((String)entry_types.get(0));
        } else {
            tmp_str = "|";
            for (int i = 0; i < entry_types.size(); ++i) {
                tmp_str = tmp_str + '(' + "objectclass=" + this._dbTrans.getDbTypeForXMLType((String)entry_types.get(i)) + ')';
            }
        }
        if (ret_str_buf == null) {
            ret_str_buf.append(tmp_str);
        } else {
            StringBuffer tStrBuf = ret_str_buf;
            ret_str_buf = new StringBuffer("&(");
            ret_str_buf.append(tStrBuf);
            ret_str_buf.append(")(");
            ret_str_buf.append(tmp_str);
            ret_str_buf.append(')');
        }
        return ret_str_buf.substring(0);
    }

    public String getFilterWCollationRule(String fieldExpr) {
        StringBuffer tStrBuf = new StringBuffer(COLON);
        tStrBuf.append(this._collationRule);
        tStrBuf.append(COLON_EQUAL);
        if (fieldExpr.startsWith(GREATER_AND_EQUAL) || fieldExpr.startsWith(EQUAL_AND_GREATER)) {
            tStrBuf.append(GREATER_AND_EQUAL);
            tStrBuf.append(SPACE);
            tStrBuf.append(fieldExpr.substring(2));
        } else if (fieldExpr.startsWith(LESS_AND_EQUAL) || fieldExpr.startsWith(EQUAL_AND_LESS)) {
            tStrBuf.append(LESS_AND_EQUAL);
            tStrBuf.append(SPACE);
            tStrBuf.append(fieldExpr.substring(2));
        } else if (fieldExpr.startsWith(LESS_THAN)) {
            tStrBuf.append(LESS_THAN);
            tStrBuf.append(SPACE);
            tStrBuf.append(fieldExpr.substring(1));
        } else if (fieldExpr.startsWith(GREATER_THAN)) {
            tStrBuf.append(GREATER_THAN);
            tStrBuf.append(SPACE);
            tStrBuf.append(fieldExpr.substring(1));
        } else {
            tStrBuf.append(STAR);
            tStrBuf.append(SPACE);
            tStrBuf.append(fieldExpr.substring(1));
        }
        return tStrBuf.substring(0);
    }

    LDAPSortControl xlateSortbyFields(Vector sortby_fields, LDAPSortKey[] sort_keys, ArrayList entryTypes) throws piDbException {
        int sortby_count = sortby_fields.size();
        for (int s = 0; s < sortby_count; ++s) {
            boolean reverse = false;
            String sortby = (String)sortby_fields.get(s);
            if (sortby.charAt(0) == '-') {
                sortby = sortby.substring(1);
                reverse = true;
            } else if (sortby.charAt(0) == '+') {
                sortby = sortby.substring(1);
            }
            ArrayList sortByAttrs = null;
            try {
                sortByAttrs = this._dbTrans.xlateXPathField(sortby, false, entryTypes);
            }
            catch (DbTransException dtx) {
                throw new piDbException(19, "error while prcessing field: " + sortby + COLON + dtx.toString());
            }
            if (sortByAttrs == null || sortByAttrs.size() == 0) {
                throw new piDbException(19, "error while prcessing field: " + sortby + "(no translation)");
            }
            sort_keys[s] = new LDAPSortKey((String)sortByAttrs.get(0), reverse);
        }
        LDAPSortControl ret = new LDAPSortControl(sort_keys, false);
        return ret;
    }

    private String[] xlateRetFields(Vector ret_fields, ArrayList entryTypes, String sortAttr) throws piDbException {
        String[] ret_attribs = null;
        ArrayList<String> ret_LDAP_attrs = null;
        if (ret_fields != null && ret_fields.size() != 0) {
            int ret_count = ret_fields.size();
            ret_LDAP_attrs = new ArrayList<String>(10);
            if (sortAttr != null) {
                ret_LDAP_attrs.add(sortAttr);
            }
            for (int rc = 0; rc < ret_count; ++rc) {
                try {
                    this._dbTrans.xlateXPathField((String)ret_fields.get(rc), true, entryTypes, ret_LDAP_attrs);
                    continue;
                }
                catch (DbTransException dx) {
                    throw new piDbException(20, dx.toString());
                }
            }
            ret_LDAP_attrs.add("objectclass");
            int size = ret_LDAP_attrs.size();
            ret_attribs = new String[size];
            ret_LDAP_attrs.toArray(ret_attribs);
        }
        return ret_attribs;
    }

    private synchronized String getEntryID() {
        Date date = new Date();
        return "e" + Long.toHexString(date.getTime()) + Integer.toHexString(this._idCount++);
    }

    public static void dump(Node node, int depth) {
        if (2 == node.getNodeType()) {
            String value = node.getNodeValue();
            Logging.trace((int)32, (String)("node:(" + depth + ")Attr> " + node.getNodeName() + " (" + node.getPrefix() + "|" + node.getNamespaceURI() + "|" + node.getLocalName() + ") [" + value + "]"));
        } else {
            Node n;
            int i;
            Logging.trace((int)32, (String)("node:(" + depth + ")Name> " + node.getNodeName() + " (" + node.getPrefix() + "|" + node.getNamespaceURI() + "|" + node.getLocalName() + ")"));
            Logging.trace((int)32, (String)("node:(" + depth + ")Class> " + node.getClass().getName() + " Type > " + node.getNodeType()));
            String value = node.getNodeValue();
            if (null != value) {
                Logging.trace((int)32, (String)("node:(" + depth + ")Value> " + value));
            }
            if (node.hasAttributes()) {
                NamedNodeMap map = node.getAttributes();
                for (i = 0; i < map.getLength(); ++i) {
                    n = map.item(i);
                    iLdapDb.dump(n, depth + 2);
                }
            }
            if (node.hasChildNodes()) {
                NodeList nl = node.getChildNodes();
                for (i = 0; i < nl.getLength(); ++i) {
                    n = nl.item(i);
                    iLdapDb.dump(n, depth + 1);
                }
            }
        }
    }

    private String getBaseEntryDN(String psRootURL) throws piDbException {
        if (psRootURL == null) {
            throw new piDbException(16);
        }
        LDAPUrl ldapurl = null;
        try {
            ldapurl = new LDAPUrl(psRootURL);
        }
        catch (MalformedURLException ex) {
            throw new piDbException(16, psRootURL);
        }
        return ldapurl.getDN();
    }

    public String getDefaultBookID(String psRootURL) throws piDbException {
        Enumeration vals;
        String defaultBookID = null;
        String base_entry_dn = this.getBaseEntryDN(psRootURL);
        LDAPEntry base_entry = null;
        LDAPConnection ldapConn = this.getLDAPConn();
        try {
            base_entry = ldapConn.read(base_entry_dn);
        }
        catch (LDAPException ex) {
            this.closeLdapConn(ldapConn);
            throw new piDbException(15, ex.toString());
        }
        LDAPAttribute piDefaultAB = base_entry.getAttribute(DEFAULT_AB_ATTR_NAME);
        if (piDefaultAB != null && (vals = piDefaultAB.getStringValues()).hasMoreElements()) {
            defaultBookID = (String)vals.nextElement();
        }
        this.closeLdapConn(ldapConn);
        return defaultBookID;
    }

    public void setDefaultBookID(String entryID, String psRootURL) throws piDbException {
        String base_entry_dn = this.getBaseEntryDN(psRootURL);
        LDAPConnection ldapConn = null;
        try {
            ldapConn = this.getLDAPConn();
        }
        catch (piDbException e) {
            Logging.error((int)1, (String)"iLdapDB.setDefaultBookID(): got exception while getting connection fom LDAPPool ");
            Logging.errorPrintStackTrace((Exception)e);
            this.closeLdapConn(ldapConn);
            return;
        }
        try {
            LDAPAttribute attr = new LDAPAttribute(DEFAULT_AB_ATTR_NAME, entryID);
            LDAPModification mod = null;
            mod = new LDAPModification(0, attr);
            ldapConn.modify(base_entry_dn, mod);
        }
        catch (LDAPException e) {
            Logging.error((int)1, (String)("iLdapDB.setDefaultBookID(): got exception while setting piDefaultAB for " + this._entry_dn));
            Logging.errorPrintStackTrace((Exception)((Object)e));
            this.closeLdapConn(ldapConn);
            return;
        }
        this.closeLdapConn(ldapConn);
    }

    public boolean doDeletePerm() {
        return this._delete_perm;
    }

    public void encodePiXMLData(Element elt, String encoding) {
        try {
            Node newNode;
            Node oldNode;
            String encodeValue;
            String value;
            int i;
            String[] GALMembersr = XPathTools.getValuesByXPath((Node)elt, (String)"extended/oli/GroupGALMember");
            String[] GALGroup = XPathTools.getValuesByXPath((Node)elt, (String)"extended/oli/GroupGALGroup");
            String[] ExMembers = XPathTools.getValuesByXPath((Node)elt, (String)"extended/oli/GroupExMember");
            String[] NestedGroup = XPathTools.getValuesByXPath((Node)elt, (String)"extended/oli/NestedGroup");
            Element oliEle = (Element)XPathTools.getFirstNodeByXPath((Node)elt, (String)"extended/oli");
            for (i = 0; i < ExMembers.length; ++i) {
                value = ExMembers[i];
                if (value == null || value.length() == 0 || value.indexOf("%") != -1) continue;
                encodeValue = URLEncoder.encode(value, encoding);
                oldNode = ABUtils.getExistingNode(oliEle, "GroupExMember", value);
                newNode = ABUtils.getNewNode(oliEle, "GroupExMember", encodeValue);
                if (oldNode == null || newNode == null) continue;
                oliEle.replaceChild(newNode, oldNode);
            }
            for (i = 0; i < GALMembersr.length; ++i) {
                value = GALMembersr[i];
                if (value == null || value.length() == 0 || value.indexOf("%") != -1) continue;
                encodeValue = URLEncoder.encode(value, encoding);
                oldNode = ABUtils.getExistingNode(oliEle, "GroupGALMember", value);
                newNode = ABUtils.getNewNode(oliEle, "GroupGALMember", encodeValue);
                if (oldNode == null || newNode == null) continue;
                oliEle.replaceChild(newNode, oldNode);
            }
            for (i = 0; i < GALGroup.length; ++i) {
                value = GALGroup[i];
                if (value == null || value.length() == 0 || value.indexOf("%") != -1) continue;
                encodeValue = URLEncoder.encode(value, encoding);
                oldNode = ABUtils.getExistingNode(oliEle, "GroupGALGroup", value);
                newNode = ABUtils.getNewNode(oliEle, "GroupGALGroup", encodeValue);
                if (oldNode == null || newNode == null) continue;
                oliEle.replaceChild(newNode, oldNode);
            }
            for (i = 0; i < NestedGroup.length; ++i) {
                value = NestedGroup[i];
                if (value == null || value.length() == 0 || value.indexOf("%") != -1) continue;
                encodeValue = URLEncoder.encode(value, encoding);
                oldNode = ABUtils.getExistingNode(oliEle, "NestedGroup", value);
                newNode = ABUtils.getNewNode(oliEle, "NestedGroup", encodeValue);
                if (oldNode == null || newNode == null) continue;
                oliEle.replaceChild(newNode, oldNode);
            }
        }
        catch (UnsupportedEncodingException ue) {
        }
        catch (XSLProcessingException xSLProcessingException) {
            // empty catch block
        }
    }

    static {
        try {
            _domBuilder = new XMLDOMBuilder(Logging.getLogHandler());
        }
        catch (XMLProcessingException xpe) {
            Logging.error((int)1, (String)("Cant create XMLDOMBuilder: " + xpe.getMessage()));
        }
    }
}

