/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.ldapplug;

import com.iplanet.iabs.dbinterface.DBPlugin;
import com.iplanet.iabs.dbinterface.DBPluginFactory;
import com.iplanet.iabs.dbinterface.piDbException;
import com.iplanet.iabs.ldapplug.iLdapDb;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;

public class iLDAP
implements DBPluginFactory {
    private static final String LDAPHOST = "ldaphost";
    private static final String LDAPPORT = "ldapport";
    private static final String LDAP_PREFIX = "ldap://";
    private static final String DEFAULT_KEY = "defaultserver";
    private static final String DEFAULT_LDAPHOST = "defaultserver.ldaphost";
    private static final String DEFAULT_LDAPPORT = "defaultserver.ldapport";
    private static final char COLON = ':';
    private static final String DBCONFIG_FILE = "db_config.properties";

    public DBPlugin initConnection(String db_config_dir, int flags) throws piDbException {
        return this.initConnection(db_config_dir, flags, DEFAULT_KEY);
    }

    public DBPlugin initConnection(String db_config_dir, int flags, String dbKey) throws piDbException {
        File dir = new File(db_config_dir);
        if (!dir.isDirectory()) {
            throw new piDbException(1, db_config_dir);
        }
        iLdapDb db = new iLdapDb(dir, flags, dbKey);
        return db;
    }

    public String getDbKeyFromPSRoot(String db_config_dir, String psRoot) throws piDbException {
        File db_config_file = new File(db_config_dir, DBCONFIG_FILE);
        PropertyReader config = null;
        String dbKeyMatch = DEFAULT_KEY;
        try {
            config = new PropertyReader(db_config_file);
        }
        catch (IOException io) {
            throw new piDbException(3, db_config_dir + DBCONFIG_FILE);
        }
        int firstColon = psRoot.indexOf(58);
        if (!psRoot.startsWith(LDAP_PREFIX)) {
            Logging.error((int)256, (String)"getDbKeyFromPSRoot(): psRoot DOES NOT start with ldap://");
            throw new piDbException(3, "The psRoot '" + psRoot + "' is malformed. It should be of the form ldap://<Host>:<port>/<DN>");
        }
        int secondColon = psRoot.indexOf(58, 7);
        if (secondColon <= 0) {
            return dbKeyMatch;
        }
        int lastColon = psRoot.lastIndexOf(58);
        if (secondColon != lastColon) {
            throw new piDbException(3, "The psRoot '" + psRoot + "' is malformed. It should be of the form ldap://<Host>:<port>/<DN>");
        }
        int thirdSlash = psRoot.indexOf(47, 7);
        if (thirdSlash < lastColon) {
            Logging.error((int)256, (String)("The psRoot '" + psRoot + "' is malformed"));
            throw new piDbException(3, "The psRoot '" + psRoot + "' is malformed. It should be of the form ldap://<Host>:<port>/<DN>");
        }
        String psRootHost = psRoot.substring(firstColon + 3, lastColon);
        String psRootPort = psRoot.substring(lastColon + 1, thirdSlash);
        Logging.trace((int)256, (String)("Host & Port to match " + psRootHost + ":" + psRootPort));
        Enumeration enumeration = config.getKeyPropertyBySuffix(LDAPHOST);
        while (enumeration.hasMoreElements()) {
            String dbKey = (String)enumeration.nextElement();
            String host = config.getStringProperty(dbKey + "." + LDAPHOST, null);
            String port = config.getStringProperty(dbKey + "." + LDAPPORT, null);
            Logging.trace((int)256, (String)("Evaluating " + host + ":" + port));
            if (host == null || port == null || !host.equalsIgnoreCase(psRootHost) || !port.equalsIgnoreCase(psRootPort)) continue;
            dbKeyMatch = dbKey;
            break;
        }
        Logging.trace((int)256, (String)("Returning dbKey ==" + dbKeyMatch));
        return dbKeyMatch;
    }

    public String getDefaultPsRoot(String db_config_dir, String psRootPattern) throws piDbException {
        Logging.trace((int)256, (String)"Inside DBHandler.getDefaultPsRoot() method");
        File db_config_file = new File(db_config_dir, DBCONFIG_FILE);
        PropertyReader config = null;
        try {
            config = new PropertyReader(db_config_file);
        }
        catch (IOException ioe) {
            throw new piDbException(3, db_config_dir + "/" + DBCONFIG_FILE);
        }
        String defaultHost = config.getStringProperty(DEFAULT_LDAPHOST, null);
        String defaultPort = config.getStringProperty(DEFAULT_LDAPPORT, null);
        if (null == defaultHost || null == defaultPort) {
            throw new piDbException(3, "Could not obtain default connection paraemters");
        }
        if (!psRootPattern.startsWith(LDAP_PREFIX)) {
            Logging.error((int)256, (String)"psRoot pattern does NOT start with ldap://");
            throw new piDbException(44, "The psRoot pattern '" + psRootPattern + "' is malformed. It should start with ldap://");
        }
        String dn = psRootPattern.substring(7);
        StringBuffer sb = new StringBuffer(LDAP_PREFIX).append(defaultHost).append(':').append(defaultPort).append(dn);
        Logging.trace((int)256, (String)("DbPluginMap.getDefaultPsRoot(): returning default psRoot as " + sb));
        return sb.toString();
    }
}

