/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.importexport;

import com.iplanet.iabs.importexport.ImportTranslatableEntry;
import com.iplanet.iabs.importexport.ImportedABParser;
import com.iplanet.xslui.tools.StringUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFRecord;

public class ImportedLdifParser
implements ImportedABParser {
    private LDIF _parser;
    private String _xlate;
    private boolean _isGroup;
    private Hashtable _tableToTranslate;
    private ArrayList _groupMembers;

    public void ImportedLdif() {
        this._parser = null;
    }

    public void init(File config_path, String userlang) throws IOException {
    }

    public void loadFile(InputStream in, String xlateSuffix, String encoding, Hashtable defaultFields) throws IOException {
        DataInputStream s = new DataInputStream(in);
        this._xlate = xlateSuffix;
        Object key = null;
        this._tableToTranslate = defaultFields != null && !defaultFields.isEmpty() ? new Hashtable(defaultFields) : new Hashtable();
        try {
            this._parser = new LDIF(s);
        }
        catch (IOException e) {
            throw new IOException("Error while creating LDIF component : " + e.toString() + " " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImportTranslatableEntry getNextEntry() throws IOException {
        LDIFRecord nextRec = null;
        ImportTranslatableEntry entry = null;
        Enumeration values = null;
        Object key = null;
        String entryType = this._xlate;
        Hashtable<String, String> hTable = null;
        hTable = new Hashtable<String, String>(this._tableToTranslate);
        this._isGroup = false;
        this._groupMembers = new ArrayList();
        try {
            nextRec = this._parser.nextRecord();
        }
        catch (IOException e) {
            throw new IOException("Error while getting Ldif next Entry : " + e.toString() + " " + e.getMessage());
        }
        int i = 0;
        if (this._parser == null) return null;
        ++i;
        if (nextRec == null) return null;
        switch (nextRec.getContent().getType()) {
            case 0: {
                LDIFAttributeContent attrContent = (LDIFAttributeContent)nextRec.getContent();
                LDAPAttribute[] attr = attrContent.getAttributes();
                for (int j = 0; j < attr.length; ++j) {
                    values = attr[j].getStringValues();
                    String name = attr[j].getBaseName();
                    while (values.hasMoreElements()) {
                        String attrValue = (String)values.nextElement();
                        attrValue = StringUtils.replaceSubstring((String)attrValue, (String)"\r\n", (String)"\n");
                        if (name.equals("objectclass") && attrValue.equals("groupOfNames")) {
                            entryType = "group-" + this._xlate;
                            this._isGroup = true;
                        }
                        if (this._isGroup && name.equals("member")) {
                            this._groupMembers.add(attrValue);
                        }
                        hTable.put(name, attrValue);
                    }
                }
                break;
            }
        }
        entry = new ImportTranslatableEntry(entryType, hTable);
        entry.setGroupStatus(this._isGroup);
        entry.setGroupMembers(this._groupMembers);
        return entry;
    }

    private String stripCR(String s) {
        int begin = 0;
        int indexCR = 0;
        int indexLF = 0;
        while (begin < s.length() && indexCR != -1) {
            indexCR = s.indexOf(13, begin);
            indexLF = s.indexOf(10, begin);
            if (indexCR != -1 && indexLF == indexCR + 1) {
                s = s.substring(begin, indexCR) + s.substring(indexCR + 1, s.length());
                begin = indexCR + 1;
                continue;
            }
            begin = indexCR + 1;
        }
        return s;
    }
}

