/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.importexport;

import com.iplanet.iabs.importexport.ImportTranslatableEntry;
import com.iplanet.iabs.importexport.ImportedABParser;
import com.iplanet.xslui.tools.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ImportedCsvParser
implements ImportedABParser {
    private InputStream _s;
    private char _separator;
    private static final String COLON = ":";
    private static final String ABS_TYPE = "iabs";
    private BufferedReader _reader = null;
    private Vector _fields = null;
    private Hashtable _tableToTranslate = null;
    private String _xlate;
    private static Properties _headrXlation;
    private static Hashtable _langTransTable;
    private static boolean _isInited;
    private static final transient String HEADER_XLATION_FILE = "import/headrXlations";
    private static HashMap charsetMap;
    private String _lang;
    private static final transient String EN_LANG = "en";

    public void ImportedCsvParser() {
    }

    public void init(File config_path, String userLang) throws IOException {
        if (!_isInited) {
            FileInputStream fis = new FileInputStream(new File(config_path, HEADER_XLATION_FILE));
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            String line = null;
            _headrXlation = new Properties();
            while ((line = reader.readLine()) != null) {
                String[] tokens;
                String ustr = URLEncoder.encode(line, "UTF-8");
                if (ustr.trim().length() == 0 || (tokens = ustr.split("%3D")).length <= 1) continue;
                _headrXlation.setProperty(tokens[0].replaceAll("%24", "\\$"), URLDecoder.decode(tokens[1], "UTF-8"));
            }
            if (_headrXlation.isEmpty()) {
                throw new IOException("ImportedCsvParser: Couldn't get the header translation file");
            }
            _langTransTable = new Hashtable(3);
            _isInited = true;
        }
        this._lang = userLang;
    }

    public void loadFile(InputStream is, String xlateSuffix, String encoding, Hashtable defaultFields) throws IOException {
        block19: {
            if (is == null) {
                throw new IOException("Empty CSV inputstream !");
            }
            this._xlate = xlateSuffix;
            if (this._lang == null) {
                this._lang = EN_LANG;
            }
            boolean doTranslate = true;
            if (this._lang.equals(EN_LANG)) {
                doTranslate = false;
                this._reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            } else {
                this._reader = new BufferedReader(new InputStreamReader(is, (String)charsetMap.get(this._lang)));
            }
            String firstLine = null;
            String ThCSVHeader = "First Name,Last Name,Display Name,Nickname,Primary Email,Secondry Email,Work Phone,Home Phone,Fax Number,Pager Number,Mobile Number,Home Address1,Home Address2,Home City,Home State,Home ZipCode,Home Country,Work Address1,Work Address2,Work City,Work State,Work ZipCode,Work Country,Job Title,Department,Organisation,Web Page1,Web Page2,Birth Year,Birth Month,Birth Day,Custom 1,Custom 2,Custom 3,Custom 4,Notes";
            firstLine = this._xlate.equalsIgnoreCase("csvth") ? ThCSVHeader : ImportedCsvParser.readLine(this._reader);
            if (firstLine == null || firstLine.length() == 0) {
                throw new IOException("ImportedCsvParser: File is empty");
            }
            int csvTypeSeparatorIdx = firstLine.indexOf(COLON);
            if (csvTypeSeparatorIdx > -1) {
                String csvTypeIndicator = firstLine.substring(0, csvTypeSeparatorIdx);
                if (csvTypeIndicator != null && !csvTypeIndicator.equalsIgnoreCase(xlateSuffix)) {
                    throw new IOException("Checking for iABS type but found Microsoft US format");
                }
                firstLine = firstLine.substring(csvTypeSeparatorIdx + 1);
            } else if (xlateSuffix.equalsIgnoreCase(ABS_TYPE)) {
                throw new IOException("Checking for Microsoft US format but found ABS");
            }
            this._separator = this.getSeparator(firstLine);
            if (this._separator == ' ') {
                throw new IOException("ImportedCsvParser: No csv separator found !");
            }
            try {
                Vector t;
                int i = 0;
                Object key = null;
                this._tableToTranslate = defaultFields != null && !defaultFields.isEmpty() ? new Hashtable(defaultFields) : new Hashtable();
                if (doTranslate) {
                    firstLine = URLEncoder.encode(firstLine, "UTF-8");
                    firstLine = firstLine.replaceAll("%2C", ",");
                    firstLine = firstLine.replaceAll("%22", "");
                }
                if ((t = this.getEntryValues(null, firstLine, false, false)) != null) {
                    this._fields = new Vector();
                    String tmpObj = null;
                    for (i = 0; i < t.size(); ++i) {
                        if (t.get(i) != null && ((String)t.get(i)).length() > 0) {
                            tmpObj = (String)t.get(i);
                            if (this._fields.indexOf(tmpObj) == -1) {
                                if (doTranslate) {
                                    String tStr = tmpObj;
                                    String transHdr = _headrXlation.getProperty(tStr = tStr.replaceAll("\\+", "\\$"));
                                    if (transHdr != null) {
                                        this._fields.add(transHdr);
                                        continue;
                                    }
                                    this._fields.add(URLDecoder.decode(tmpObj, "UTF-8"));
                                    continue;
                                }
                                this._fields.add(tmpObj);
                                continue;
                            }
                            this._fields.add(" ");
                            continue;
                        }
                        this._fields.add(" ");
                    }
                    break block19;
                }
                throw new IOException("Could'nt read file");
            }
            catch (IOException xe) {
                throw new IOException("Couldn't get CSV field names" + xe);
            }
        }
    }

    public ImportTranslatableEntry getNextEntry() throws IOException {
        Hashtable hTable;
        ImportTranslatableEntry entry;
        block5: {
            entry = null;
            Object values = null;
            Vector t = null;
            String tmp = null;
            boolean jumpNextLine = false;
            boolean numNull = false;
            boolean lineNumber = false;
            boolean oldLineNumber = false;
            Object key = null;
            hTable = null;
            hTable = new Hashtable(this._tableToTranslate);
            try {
                t = this.getEntryValues(null, null, false, false);
                if (t != null) {
                    int i;
                    for (i = 0; i < this._fields.size() && i < t.size(); ++i) {
                        tmp = (String)t.get(i);
                        if (t.get(i) == null || tmp.length() <= 0 || tmp == " ") continue;
                        tmp = StringUtils.replaceSubstring((String)tmp, (String)"\r", (String)"");
                        hTable.put(this._fields.get(i), tmp);
                    }
                    if (i == 0) {
                        return null;
                    }
                    break block5;
                }
                return null;
            }
            catch (IOException xe) {
                throw new IOException("Couldn't get CSV next value" + xe);
            }
        }
        entry = new ImportTranslatableEntry(this._xlate, hTable);
        return entry;
    }

    public Vector getEntryValues(Vector precValues, String optLine, boolean inquote, boolean quoteInquote) throws IOException {
        Vector values = precValues;
        boolean endChar = false;
        boolean merge = false;
        if (inquote) {
            merge = true;
        }
        if (values == null) {
            values = new Vector();
        }
        String line = null;
        Object tmp = null;
        boolean done = false;
        int begin = 0;
        boolean crlfEnd = false;
        if (optLine != null) {
            line = optLine;
            line = StringUtils.replaceSubstring((String)line, (String)"\r", (String)"");
        } else {
            line = ImportedCsvParser.readLine(this._reader);
            if (line == null) {
                return null;
            }
            if ((line = StringUtils.replaceSubstring((String)line, (String)"\r", (String)"")) == "\n" && !inquote) {
                return this.getEntryValues(null, null, false, false);
            }
            while (line == "\n" && inquote) {
                this.mergeStringToVector("", values);
                line = ImportedCsvParser.readLine(this._reader);
            }
        }
        int strLength = line.length();
        int i = 0;
        char ch = ' ';
        char ch1 = ' ';
        char ch2 = ' ';
        while (i < line.length()) {
            ch = line.charAt(i);
            if (i + 1 < strLength) {
                ch1 = line.charAt(i + 1);
            }
            if (i + 2 < strLength) {
                ch2 = line.charAt(i + 2);
            }
            if (ch == this._separator || i + 1 == strLength) {
                if (!inquote) {
                    if (i + 1 == strLength) {
                        if (ch1 == this._separator) {
                            values.add(line.substring(begin, i));
                        } else if (ch1 == '\"') {
                            inquote = true;
                            values.add(line.substring(begin + 1, i + 1));
                        } else {
                            values.add(line.substring(begin, i + 1));
                        }
                        ++i;
                        continue;
                    }
                    if (i - 1 >= 0) {
                        if (line.charAt(i - 1) == '\"') {
                            if (merge) {
                                values = this.mergeStringToVector(line.substring(begin, i - 1), values);
                                merge = false;
                            } else {
                                values.add(line.substring(begin + 1, i - 1));
                            }
                            begin = i + 1;
                            ++i;
                            continue;
                        }
                        if (line.charAt(i - 1) == this._separator) {
                            values.add(" ");
                            begin = i + 1;
                            ++i;
                            continue;
                        }
                        if (merge) {
                            values = this.mergeStringToVector(line.substring(begin, i), values);
                            merge = false;
                        } else {
                            values.add(line.substring(begin, i));
                        }
                        begin = i + 1;
                        ++i;
                        continue;
                    }
                    if (i != 0) continue;
                    if (merge) {
                        values = this.mergeStringToVector(" ", values);
                        merge = false;
                    } else {
                        values.add(" ");
                    }
                    begin = i + 1;
                    ++i;
                    continue;
                }
                if (i + 1 == strLength) {
                    if (!quoteInquote && inquote && ch == '\"') {
                        if (merge) {
                            values = this.mergeStringToVector(line.substring(begin + 1, i), values);
                            merge = false;
                        } else {
                            values.add(line.substring(begin + 1, i));
                        }
                        inquote = false;
                    } else if (inquote) {
                        if (merge) {
                            values = this.mergeStringToVector(line.substring(begin, i + 1), values);
                            merge = false;
                        } else {
                            values.add(line.substring(begin + 1, i + 1));
                        }
                    } else {
                        values.add(line.substring(begin + 1, i + 1));
                    }
                }
                ++i;
                continue;
            }
            if (ch == '\"') {
                if (ch1 == '\"') {
                    if (inquote) {
                        if (!quoteInquote) {
                            line = line.substring(0, i + 1) + line.substring(i + 2);
                            strLength = line.length();
                            quoteInquote = true;
                            ++i;
                        } else if (quoteInquote) {
                            line = line.substring(0, i + 1) + line.substring(i + 2);
                            strLength = line.length();
                            quoteInquote = false;
                            ++i;
                        }
                        if (i != strLength) continue;
                        values.add(line.substring(begin + 1, i));
                        continue;
                    }
                    if (ch2 == this._separator || i + 2 >= strLength || ch2 == '\r') {
                        while (ch2 == '\r' && i + 2 < strLength) {
                            ch2 = line.charAt(i + 2);
                            ++i;
                        }
                        i += 2;
                        continue;
                    }
                    if (inquote) continue;
                    inquote = true;
                    continue;
                }
                if (inquote) {
                    inquote = false;
                    ++i;
                    continue;
                }
                if (inquote) continue;
                inquote = true;
                ++i;
                continue;
            }
            ++i;
        }
        if (inquote) {
            values = this.getEntryValues(values, null, inquote, quoteInquote);
        }
        return values;
    }

    private Vector mergeStringToVector(String val, Vector vect) {
        String tmp = (String)vect.lastElement();
        tmp = tmp + "\n";
        tmp = tmp + val;
        vect.remove(vect.size() - 1);
        vect.add(tmp);
        return vect;
    }

    private char getSeparator(String line) throws IOException {
        int pos = 0;
        pos = line.indexOf(44);
        if (pos != -1) {
            return ',';
        }
        pos = line.indexOf(59);
        if (pos != -1) {
            return ';';
        }
        return ' ';
    }

    private static String readLine(BufferedReader reader) throws IOException {
        int ch = 0;
        String line = null;
        Object tmp = null;
        char[] cbuf = new char[2048];
        int i = 0;
        boolean end = false;
        try {
            while (ch != -1 && !end) {
                ch = reader.read(cbuf, i, 1);
                if (cbuf[i] == '\n') {
                    end = true;
                }
                if (cbuf[i] == '\r') {
                    // empty if block
                }
                ++i;
            }
        }
        catch (IOException ex) {
            throw new IOException("Unable to read one character ! : " + ex);
        }
        line = new String(cbuf, 0, i);
        if ((line = StringUtils.replaceSubstring((String)line, (String)"\r", (String)"")) != "\n" && line.length() > 1) {
            line = line.substring(0, line.length() - 1);
        }
        if (line.length() == 1) {
            line = "\n";
        }
        if (ch == -1 && line.length() == 1) {
            return null;
        }
        return line;
    }

    static {
        _isInited = false;
        charsetMap = new HashMap();
        charsetMap.put(EN_LANG, "ISO8859-1");
        charsetMap.put("de", "ISO8859-1");
        charsetMap.put("fr", "ISO8859-1");
        charsetMap.put("es", "ISO8859-1");
        charsetMap.put("nl", "ISO8859-1");
        charsetMap.put("it", "ISO8859-1");
        charsetMap.put("hu", "ISO8859-2");
        charsetMap.put("cz", "ISO8859-2");
        charsetMap.put("pl", "ISO8859-2");
        charsetMap.put("ru", "ISO8859-5");
        charsetMap.put("ja", "EUC-JP");
        charsetMap.put("ko", "EUC-KR");
        charsetMap.put("zh-cn", "EUC-CN");
        charsetMap.put("zh-tw", "BIG5");
    }
}

