/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.iabsutil;

import com.iplanet.iabs.iabsapi.AddressBookACL;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ABUtils {
    public static final transient int INITIAL_DEPTH = 1;
    public static final transient String LINE_FEED = "\n";
    public static final transient String ATTR_SPACE = " ";
    public static final transient String EQUALS = "=";
    public static final transient String DOUBLE_QUOTE = "\"";
    public static final transient String TAG_INDENTATION = "   ";
    private static XMLDOMBuilder _domBuilder = null;

    public static void printStackTrace(Exception exception) {
        if (null == exception) {
            Logging.trace((int)4, (String)"printStackTrace: Exception is null");
            return;
        }
        String string = ABUtils.getStackTraceString(exception.getStackTrace());
        if (null == string) {
            Logging.trace((int)4, (String)"printStackTrace: StackTrace is not available");
        } else {
            Logging.trace((int)4, (String)"***** Printing Stack Trace *****");
            Logging.trace((int)4, (String)LINE_FEED);
            Logging.trace((int)4, (String)string);
            Logging.trace((int)4, (String)LINE_FEED);
        }
        Throwable throwable = exception.getCause();
        String string2 = string = null == throwable ? null : ABUtils.getStackTraceString(throwable.getStackTrace());
        if (null != string) {
            Logging.trace((int)4, (String)"***** Printing Root Cause *****");
            Logging.trace((int)4, (String)LINE_FEED);
            Logging.trace((int)4, (String)string);
            Logging.trace((int)4, (String)LINE_FEED);
        }
    }

    public static String getStackTraceString(StackTraceElement[] stackTraceElementArray) {
        if (null == stackTraceElementArray) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(stackTraceElementArray.length * 64);
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuffer.append(stackTraceElementArray[i].toString());
            stringBuffer.append(LINE_FEED);
        }
        return stringBuffer.toString();
    }

    public static void dump(Node node) {
        ABUtils.dump(node, 1);
    }

    public static void dump(Node node, String string) {
        ABUtils.dump(node, 1, string);
    }

    public static void dump(Node node, int n, String string) {
        if (null == node) {
            Logging.trace((int)4, (String)(string + ": Node is null"));
        } else {
            Logging.trace((int)4, (String)(string + ": "));
            Logging.trace((int)4, (String)("***** Started dumping the node for: " + string + " *****"));
            ABUtils.dump(node, n);
            Logging.trace((int)4, (String)("***** End of dumping the node for: " + string + " *****"));
        }
    }

    public static void dump(Node node, int n) {
        StringBuffer stringBuffer = new StringBuffer(256);
        ABUtils.dump(stringBuffer, node, n);
        Logging.trace((int)4, (String)stringBuffer.toString());
    }

    public static void dump(StringBuffer stringBuffer, Node node, int n) {
        if (null == node) {
            return;
        }
        if (2 == node.getNodeType()) {
            String string = node.getNodeName();
            String string2 = node.getNodeValue();
            stringBuffer.append(ATTR_SPACE);
            stringBuffer.append(string);
            stringBuffer.append(EQUALS);
            stringBuffer.append(DOUBLE_QUOTE);
            stringBuffer.append(string2);
            stringBuffer.append(DOUBLE_QUOTE);
        } else if (3 == node.getNodeType()) {
            String string = node.getNodeValue();
            ABUtils.indentDepth(stringBuffer, n);
            if (null != string) {
                stringBuffer.append(string);
            }
        } else {
            int n2;
            Object object;
            String string = node.getNodeName();
            String string3 = node.getNodeValue();
            ABUtils.indentDepth(stringBuffer, n);
            stringBuffer.append("<");
            stringBuffer.append(string);
            if (node.hasAttributes() && null != (object = node.getAttributes())) {
                n2 = object.getLength();
                for (int i = 0; i < n2; ++i) {
                    Node node2 = object.item(i);
                    ABUtils.dump(stringBuffer, node2, n + 1);
                }
            }
            stringBuffer.append(">");
            if (null != string3) {
                ABUtils.indentDepth(stringBuffer, n + 1);
                stringBuffer.append(string3);
            }
            if (node.hasChildNodes()) {
                object = node.getChildNodes();
                for (n2 = 0; n2 < object.getLength(); ++n2) {
                    Node node3 = object.item(n2);
                    ABUtils.dump(stringBuffer, node3, n + 1);
                }
            }
            ABUtils.indentDepth(stringBuffer, n);
            stringBuffer.append("</");
            stringBuffer.append(string);
            stringBuffer.append(">");
        }
    }

    public static void indentDepth(StringBuffer stringBuffer, int n) {
        if (null == stringBuffer) {
            return;
        }
        stringBuffer.append(LINE_FEED);
        stringBuffer.append(n);
        stringBuffer.append(TAG_INDENTATION);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(TAG_INDENTATION);
        }
    }

    public static void dumpInDetail(Node node, int n) {
        if (null == node) {
            return;
        }
        if (2 == node.getNodeType()) {
            String string = node.getNodeValue();
            Logging.trace((int)4, (String)("node:(" + n + ")Attr> " + node.getNodeName() + " (" + node.getPrefix() + "|" + node.getNamespaceURI() + "|" + node.getLocalName() + ") [" + string + "]"));
        } else {
            Node node2;
            int n2;
            Object object;
            Logging.trace((int)4, (String)("node:(" + n + ")Name> " + node.getNodeName() + " (" + node.getPrefix() + "|" + node.getNamespaceURI() + "|" + node.getLocalName() + ")"));
            Logging.trace((int)4, (String)("node:(" + n + ")Class> " + node.getClass().getName() + " Type > " + node.getNodeType()));
            String string = node.getNodeValue();
            if (null != string) {
                Logging.trace((int)4, (String)("node:(" + n + ")Value> " + string));
            }
            if (node.hasAttributes()) {
                object = node.getAttributes();
                for (n2 = 0; n2 < object.getLength(); ++n2) {
                    node2 = object.item(n2);
                    ABUtils.dumpInDetail(node2, n + 2);
                }
            }
            if (node.hasChildNodes()) {
                object = node.getChildNodes();
                for (n2 = 0; n2 < object.getLength(); ++n2) {
                    node2 = object.item(n2);
                    ABUtils.dumpInDetail(node2, n + 1);
                }
            }
        }
    }

    public static void replaceACLWithRights(Element element, String string, String string2) throws PStoreException {
        NodeList nodeList = element.getElementsByTagName("acl");
        String string3 = "";
        if (nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            AddressBookACL addressBookACL = new AddressBookACL((Element)node);
            boolean bl = addressBookACL.isUserPermExists(string);
            string3 = addressBookACL.getPermissions(string);
            if (string3 == null || string3 != null && string3.length() == 0 || !bl) {
                string3 = addressBookACL.getPermissions(string2);
            }
            element.removeChild(node);
        }
        ABUtils.insertNode(element, "rights", string3);
    }

    public static void insertNode(Element element, String string, String string2) throws PStoreException {
        Document document = element.getOwnerDocument();
        Element element2 = ABUtils.getNode(document, string, string2);
        if (element2 == null) {
            throw new PStoreException(9, "Could not create <" + string + "> tag");
        }
        try {
            element.appendChild(_domBuilder.copyNode((Node)element2, document));
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new PStoreException(9, xMLProcessingException.getMessage());
        }
    }

    public static Element getNode(Document document, String string, String string2) throws PStoreException {
        Element element = null;
        try {
            element = document.createElement(string);
        }
        catch (DOMException dOMException) {
            throw new PStoreException(9, dOMException.getMessage());
        }
        Text text = document.createTextNode(string2);
        try {
            element.appendChild(_domBuilder.copyNode((Node)text, document));
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new PStoreException(9, xMLProcessingException.getMessage());
        }
        return element;
    }

    public static Node getExistingNode(Element element, String string, String string2) {
        NodeList nodeList = element.getElementsByTagName(string);
        Element element2 = null;
        Element element3 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element2 = (Element)nodeList.item(i);
            Node node = element2.getFirstChild();
            if (node == null || !node.getNodeValue().equalsIgnoreCase(string2)) continue;
            element3 = element2;
            break;
        }
        return element3;
    }

    public static Node getNewNode(Element element, String string, String string2) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement(string);
        Text text = document.createTextNode(string2);
        element2.appendChild(text);
        return element2;
    }

    static {
        try {
            _domBuilder = new XMLDOMBuilder(Logging.getLogHandler());
        }
        catch (XMLProcessingException xMLProcessingException) {
            // empty catch block
        }
    }
}

