/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.iabsapi;

import com.iplanet.iabs.iabsapi.Entry;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Book
extends Entry {
    public static final String ELT_BOOK = "book";
    public static final String ATTR_BOOKTYPE = "booktype";
    public static final String ATTR_WILDCARDSEARCH = "wildcardsearch";
    public static final String ATTR_CORPORATE_DIRECTORY = "corporatedir";
    public static final String ATTR_SUBSCRIBED = "subscribed";
    public static final String XPATH_BOOKTYPE = "@booktype";
    public static final String BOOKTYPE_ABOOK = "abook";
    public static final String BOOKTYPE_PBOOK = "pbook";
    public static final String ATTR_BOOKURL = "bookurl";
    public static final String XPATH_BOOKURL = "@bookurl";
    public static final String ATTR_BOOKREMOTEURL = "bookremoteurl";
    public static final String XPATH_BOOKREMOTEURL = "@bookremoteurl";
    public static final String XPATH_CORPORATE_DIR = "@corporatedir";
    public static final String ELT_LAYOUTINFO = "layoutinfo";
    public static final String ATTR_ENTRIESPERPAGE = "entriesperpage";
    public static final String XPATH_ENTRIESPERPAGE = "layoutinfo/@entriesperpage";
    public static final String XPATH_ENTRYID = "entry/@entryID";
    public static final String XPATH_DISPLAYNAME = "entry/displayname";
    public static final String XPATH_SUBSCRIBED = "@subscribed";
    public static final String XPATH_ACL_READ = "read";
    public static final String XPATH_ACL_WRITE = "write";
    public static final String XPATH_ACL_DELETE = "delete";
    public static final String XPATH_ACL_CREATE = "create";
    public static final String SUBSCRIBED_STORE_PREFIX = "ps:///";
    private String _bookType = null;
    private String _bookRemoteURL = null;
    private String _bookURL = null;
    private String _entryID = null;
    private boolean _subscribed = false;
    private boolean _isRemoteBook = false;
    private String _displayName = null;
    private int _entriesPerPage = 0;
    private Properties _extraInfo;
    private String _subscribedURL;

    public Book(Element element) throws PStoreException {
        super(element);
        try {
            this._bookRemoteURL = XPathTools.getValueByXPath((Node)element, (String)XPATH_BOOKREMOTEURL);
            String string = XPathTools.getValueByXPath((Node)element, (String)XPATH_SUBSCRIBED);
            this._subscribed = string != null && string.equals("1");
            this._isRemoteBook = null != this._bookRemoteURL && !this._subscribed;
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new PStoreException(3, "wrong XPATH:" + xSLProcessingException.getMessage());
        }
        this.updateBook(element);
    }

    public void updateBook(Element element) throws PStoreException {
        String string = null;
        try {
            this._bookType = XPathTools.getValueByXPath((Node)element, (String)XPATH_BOOKTYPE);
            this._bookURL = XPathTools.getValueByXPath((Node)element, (String)XPATH_BOOKURL);
            string = XPathTools.getValueByXPath((Node)element, (String)XPATH_ENTRIESPERPAGE);
            this._entryID = XPathTools.getValueByXPath((Node)element, (String)XPATH_ENTRYID);
            this._displayName = XPathTools.getValueByXPath((Node)element, (String)XPATH_DISPLAYNAME);
            this._entriesPerPage = string != null ? Integer.parseInt(string) : 25;
        }
        catch (NumberFormatException numberFormatException) {
            throw new PStoreException(3, "wrong entriesperpage:" + string);
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new PStoreException(3, "wrong XPATH:" + xSLProcessingException.getMessage());
        }
        if (this._bookType == null || this._bookType.length() <= 0) {
            this._bookType = BOOKTYPE_ABOOK;
        }
    }

    public String getBookType() {
        return this._bookType;
    }

    public String getBookURL() {
        return this._bookURL;
    }

    public String getBookRemoteURL() {
        if (this._subscribed && this._subscribedURL != null) {
            return this._subscribedURL;
        }
        return this._bookRemoteURL;
    }

    public int getEntriesPerPage() {
        return this._entriesPerPage;
    }

    public String getEntryID() {
        return this._entryID;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public boolean isSubscribedBook() {
        return this._subscribed;
    }

    public void setExtraInfo(Properties properties) {
        this._extraInfo = properties;
    }

    public Properties getExtraInfo() {
        return this._extraInfo;
    }

    public void setSubscribedUrl(String string) {
        this._subscribedURL = string;
    }

    public String getSubscribedUrl() {
        return this._subscribedURL;
    }

    public boolean isRemoteBook() {
        return this._isRemoteBook;
    }
}

