/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.coresrv;

import com.iplanet.iabs.dbinterface.DBPlugin;
import com.iplanet.iabs.dbinterface.DBPluginFactory;
import com.iplanet.iabs.dbinterface.PS_DBPlugin;
import com.iplanet.iabs.dbinterface.piDbException;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.File;
import java.util.HashMap;

public class DBPluginMap {
    public static final String CONFIG_DB_CLASS = "class";
    public static final String CONFIG_DB_URLMATCH = "urlmatch";
    public static final String CONFIG_DB_CONFIGPATH = "configpath";
    public static final String CONFIG_DB_WILDCARDSEARCH = "wildcardsearch";
    public static final String CONFIG_DB_RANDOMPAGING = "randompaging";
    public static final String CONFIG_DB_CORPORATE_DIR = "corporatedir";
    private String _urlMatch = null;
    private File _configPath = null;
    private DBPluginFactory _dbFactory = null;
    private String _defaultPsRoot = null;
    private HashMap _dbPluginMap = null;
    private DBPlugin _defaultDbPlugin = null;
    private int _minWildcardSearch = 0;
    private boolean _randomPaging = true;
    private boolean _corporatedir = false;
    private String _className = null;

    public DBPluginMap(PropertyReader propertyReader, String string) throws PStoreException, piDbException {
        this._urlMatch = propertyReader.getLowerCaseStringProperty(string + CONFIG_DB_URLMATCH, "");
        if (this._urlMatch.length() <= 0) {
            throw new PStoreException(1, "DBPluginMap: couldn't get urlMatch name for " + string);
        }
        this._configPath = propertyReader.getFileProperty(string + CONFIG_DB_CONFIGPATH, "");
        if (this._configPath == null) {
            throw new PStoreException(1, "DBPluginMap: couldn't get configpath for " + string);
        }
        this._className = propertyReader.getStringProperty(string + CONFIG_DB_CLASS, "");
        if (this._className.length() <= 0) {
            throw new PStoreException(1, "DBPluginMap: couldn't get class name for " + string);
        }
        try {
            Class<?> clazz = Class.forName(this._className);
            this._dbFactory = (DBPluginFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new PStoreException(1, "DBPluginMap: couldn't load" + this._className + " : " + exception.getMessage());
        }
        this._minWildcardSearch = propertyReader.getIntProperty(string + CONFIG_DB_WILDCARDSEARCH, 0);
        this._randomPaging = propertyReader.getBooleanProperty(string + CONFIG_DB_RANDOMPAGING, "true");
        this._corporatedir = propertyReader.getBooleanProperty(string + CONFIG_DB_CORPORATE_DIR, "fasle");
        this._dbPluginMap = new HashMap();
    }

    public String getURLMatch() {
        return this._urlMatch;
    }

    public PS_DBPlugin getPSDBPlugin() throws PStoreException {
        Logging.trace((int)32, (String)"Entered DBPluginMap.getPSDBPlugin");
        return (PS_DBPlugin)this.getDBPlugin(null);
    }

    public DBPlugin getDBPlugin() throws PStoreException {
        Logging.trace((int)32, (String)"Entered DBPluginMap.getDBPlugin");
        return this.getDBPlugin(null);
    }

    public PS_DBPlugin getPSDBPlugin(String string) throws PStoreException {
        Logging.trace((int)32, (String)("Entered DBPluginMap.getPSDBPlugin(" + string + ")"));
        return (PS_DBPlugin)this.getDBPlugin(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBPlugin getDBPlugin(String string) throws PStoreException {
        Logging.trace((int)32, (String)("Entered DBPluginMap.getDBPlugin(" + string + ")"));
        if (string == null) {
            DBPluginMap dBPluginMap = this;
            synchronized (dBPluginMap) {
                if (null != this._defaultDbPlugin) {
                    return this._defaultDbPlugin;
                }
                try {
                    Logging.trace((int)32, (String)"Constructing default DBPlugin through Factory");
                    this._defaultDbPlugin = this._dbFactory.initConnection(this._configPath.getAbsolutePath(), 0);
                }
                catch (Exception exception) {
                    throw new PStoreException(1, "DBPluginMap.getDBPlugin: Exception while creating default DbPlugin for " + this._className + " " + exception.getMessage());
                }
                if (this._defaultDbPlugin == null) {
                    throw new PStoreException(1, "DBPluginMap.getDBPlugin : Couldn't get default dbPlugin. Factory: " + this._className);
                }
                return this._defaultDbPlugin;
            }
        }
        String string2 = null;
        try {
            string2 = this._dbFactory.getDbKeyFromPSRoot(this._configPath.getAbsolutePath(), string);
        }
        catch (Exception exception) {
            throw new PStoreException(1, "Exception while reading dbKey for psRoot = " + string + ", " + exception.getMessage());
        }
        Logging.trace((int)32, (String)("DBPluginMap.getDBPlugin: DBKey = " + string2));
        DBPlugin dBPlugin = null;
        DBPluginMap dBPluginMap = this;
        synchronized (dBPluginMap) {
            if (this._dbPluginMap.containsKey(string2)) {
                Logging.trace((int)32, (String)"DBPluginMap.getDBPlugin: Found DbPlugin already exisitng in table");
                return (DBPlugin)this._dbPluginMap.get(string2);
            }
            try {
                Logging.trace((int)32, (String)"DBPluginMap.getDBPlugin: DBPlugin not in table, need to construct through Factory");
                dBPlugin = this._dbFactory.initConnection(this._configPath.getAbsolutePath(), 0, string2);
            }
            catch (Exception exception) {
                throw new PStoreException(1, "DBPluginMap.getDBPlugin: DBPluginMap: InitConnection for " + this._className + " : " + exception.getMessage());
            }
            if (dBPlugin == null) {
                throw new PStoreException(1, "DBPluginMap.getDBPlugin: DBPluginMap: couldn't get dbPlugin");
            }
            this._dbPluginMap.put(string2, dBPlugin);
        }
        return dBPlugin;
    }

    public int getMinWildcardSearch() {
        return this._minWildcardSearch;
    }

    public boolean allowsRandomPaging() {
        return this._randomPaging;
    }

    public boolean isCorporateDir() {
        return this._corporatedir;
    }

    public String getDefaultPsRoot(String string) throws piDbException {
        String string2 = this._dbFactory.getDefaultPsRoot(this._configPath.getAbsolutePath(), string);
        return string2;
    }
}

