/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.coresrv;

import com.iplanet.iabs.coresrv.BookCache;
import com.iplanet.iabs.coresrv.CoreSearchResult;
import com.iplanet.iabs.coresrv.DBHandler;
import com.iplanet.iabs.coresrv.DBPluginMap;
import com.iplanet.iabs.coresrv.Session2XMLTranslatable;
import com.iplanet.iabs.coresrv.UserPrefs2XMLTranslatable;
import com.iplanet.iabs.dbinterface.DBPlugin;
import com.iplanet.iabs.dbinterface.PS_DBPlugin;
import com.iplanet.iabs.dbinterface.PagedSearch;
import com.iplanet.iabs.dbinterface.piDbException;
import com.iplanet.iabs.iabsapi.AddressBookACL;
import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.Entry;
import com.iplanet.iabs.iabsapi.Group;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsapi.PersonalStore;
import com.iplanet.iabs.iabsapi.Profile;
import com.iplanet.iabs.iabsutil.ABUtils;
import com.iplanet.iabs.iabsutil.ValMailAddress;
import com.iplanet.iabs.importexport.ImportExport;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.dbtrans.DbTranslatable;
import com.iplanet.xslui.dbtrans.DbTranslation;
import com.iplanet.xslui.dbtrans.DbTranslationTable;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class CorePersonalStore
implements PersonalStore {
    private static XMLDOMBuilder _domBuilder = null;
    private DBHandler _dbHandler = null;
    private HashMap _profileTable = null;
    private HashMap _searchDbMap = new HashMap();
    private String _psRoot = null;
    private PS_DBPlugin _userDB = null;
    private Book _profileBook = null;
    private int _nbPagedSearch = 0;
    private int _maxPagedSearch = 0;
    private HashMap _pagedSearchTable = null;
    private DBPluginMap _localDBPluginMap = null;
    private UserSession _user;
    private String _userID;
    private String _fullyQualifiedUserID;
    private BookCache _bookCache;
    private File _configPath;
    private int _currentEntryCount = -1;
    private int _maxEntryQuota = -1;
    private boolean _entryCache = true;
    private boolean justLoggedIn = true;
    private Profile _userProfile = null;
    private Element _prefElement = null;
    private static final transient String _userXlatePath = "htmlforms/entryform";
    private Book _defaultBook = null;
    private boolean searchdel = false;

    public CorePersonalStore(UserSession userSession, DBHandler dBHandler) throws PStoreException {
        Object object;
        Book[] bookArray;
        if (userSession == null) {
            throw new PStoreException(1, "PersonalStore: UserSession is null");
        }
        this._user = userSession;
        if (dBHandler == null) {
            throw new PStoreException(1, "CorePersonalStore: no dbHandler defined");
        }
        this._dbHandler = dBHandler;
        String string = this._dbHandler.getPsRootAttributeName();
        Logging.trace((int)32, (String)("CorePersonalStore: If Using psRoot ==" + this._dbHandler.useUserPsRoot()));
        if (this._dbHandler.useUserPsRoot()) {
            this._psRoot = userSession.getUserAttrib(string);
            Logging.trace((int)32, (String)("Using User's " + string + " == " + this._psRoot));
        }
        if (this._psRoot == null) {
            this._psRoot = this._dbHandler.getDefaultPsRootPattern(userSession);
            if (this._psRoot == null) {
                throw new PStoreException(1, "CorePersonalStore: couldn't get " + string + " attribute for user " + userSession.getUserId() + "@" + userSession.getDomain());
            }
        }
        Logging.trace((int)32, (String)("Opening psroot " + this._psRoot));
        this._localDBPluginMap = this._dbHandler.getDBPluginMapFromURL(this._psRoot);
        if (this._localDBPluginMap == null) {
            Logging.error((int)32, (String)"about to throw exception 1");
            throw new PStoreException(1, "CorePersonalStore: couldn't get DB for " + this._psRoot);
        }
        this._userDB = this._localDBPluginMap.getPSDBPlugin(this._psRoot);
        Document document = this._dbHandler.getDefaultPS(userSession);
        if (document == null) {
            throw new PStoreException(1, "CorePersonalStore: couldn't get defaultPS for " + userSession.getUserId() + "@" + userSession.getDomain());
        }
        try {
            this._userDB.openUserStore(userSession, document.getDocumentElement(), this._psRoot, 0);
        }
        catch (piDbException piDbException2) {
            throw new PStoreException(1, "openUserStore failed:" + piDbException2.getReason() + ":" + piDbException2.getMessage());
        }
        this._pagedSearchTable = new HashMap();
        this._nbPagedSearch = 0;
        this._maxPagedSearch = this._dbHandler.getMaxPagedSearch();
        this._bookCache = new BookCache(this._user, this._psRoot, this._dbHandler);
        int n = this._dbHandler.getnoRetries();
        int n2 = this._dbHandler.getldapDelay();
        if (n > 0 && (bookArray = this._bookCache.listBooks("pbook")) == null) {
            while (n-- > 0) {
                try {
                    Thread.sleep(n2);
                    this._bookCache.loadBookList();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((bookArray = this._bookCache.listBooks("pbook")) == null) continue;
            }
        }
        if ((bookArray = this._bookCache.getMissingDBPluginMaps()) != null && bookArray.size() > 0) {
            object = _domBuilder.newDocument();
            Element element = object.createElement(document.getDocumentElement().getNodeName());
            Iterator iterator = bookArray.iterator();
            NodeList nodeList = document.getElementsByTagName("book");
            block10: for (int i = 0; i < bookArray.size(); ++i) {
                String string2 = ((String)iterator.next()).trim();
                if (nodeList == null) break;
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    Element element2 = (Element)nodeList.item(j);
                    try {
                        String string3 = XPathTools.getValueByXPath((Node)element2, (String)"@bookremoteurl");
                        if (string3 == null || !string2.equalsIgnoreCase(string3 = string3.trim())) continue;
                        element.appendChild(_domBuilder.copyNode((Node)element2, (Document)object));
                        continue block10;
                    }
                    catch (XMLProcessingException xMLProcessingException) {
                        Logging.error((int)32, (String)"Can't obtain a valid XML for the missing books");
                        continue;
                    }
                    catch (XSLProcessingException xSLProcessingException) {
                        Logging.error((int)32, (String)"Can't obtain a valid XML for the missing books");
                    }
                }
            }
            try {
                this._userDB.syncStore(userSession, element, this._psRoot);
            }
            catch (piDbException piDbException3) {
                Logging.error((int)32, (String)"Failed to sync store for missing books");
            }
        }
        this._entryCache = this._dbHandler.getEntryCachePolicy().equals("1");
        object = this._user.getUserAttrib("piMaxStoreEntries");
        this._maxEntryQuota = object != null ? Integer.parseInt((String)object) : this._dbHandler.getEntriesLimit();
        this._profileTable = new HashMap();
        this._profileBook = this.getPSProfileBook();
        if (this._profileBook == null) {
            Logging.error((int)32, (String)"failed to load profile book");
        }
    }

    public int getQuotaWarning() {
        int n = -1;
        double d = 0.0;
        if (this._maxEntryQuota == -1) {
            return n;
        }
        try {
            d = (double)this.getEntriesCount() / (double)this._maxEntryQuota * 100.0;
            if (d > (double)this._dbHandler.getQuotaWarnLimit()) {
                n = (int)d;
            }
        }
        catch (PStoreException pStoreException) {
            Logging.trace((int)32, (String)("failed to get usage" + pStoreException));
        }
        catch (ArithmeticException arithmeticException) {
            Logging.trace((int)32, (String)("failed to get usage" + arithmeticException));
        }
        return n;
    }

    public int getEntriesCount() throws PStoreException {
        if (this._currentEntryCount == -1 || !this._entryCache) {
            try {
                this._currentEntryCount = this._userDB.getEntriesCount(this._psRoot);
            }
            catch (piDbException piDbException2) {
                throw new PStoreException(6, "getEntryCountFailed:");
            }
        }
        return this._currentEntryCount;
    }

    private boolean checkQuotaFull() throws PStoreException {
        boolean bl = false;
        int n = -1;
        n = this.getEntriesCount();
        if (n >= this._maxEntryQuota) {
            bl = true;
        }
        return bl;
    }

    public Book[] listBooks(String string) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "listBooks: no bookType");
        }
        return this._bookCache.listBooks(string);
    }

    public void init(File file) {
        this._configPath = file;
    }

    public void importEntry(String string, String string2, InputStream inputStream, Element element) throws PStoreException {
        try {
            ImportExport importExport = this._dbHandler.getImportExportObj(this._configPath);
            String string3 = this._user.getUserAttrib("userlang");
            importExport.importEntry(this, string, string2, inputStream, string3, element);
        }
        catch (Exception exception) {
            throw new PStoreException(20, "CorePersonalStore/importEntry: " + exception.getMessage());
        }
    }

    public void exportEntry(String string, String string2, String string3, String string4, OutputStream outputStream) throws PStoreException {
        try {
            ImportExport importExport = this._dbHandler.getImportExportObj(this._configPath);
            importExport.exportEntry(this, string, string2, string3, string4, outputStream);
        }
        catch (IOException iOException) {
            throw new PStoreException(20, "exportBook: " + iOException.getMessage());
        }
    }

    public Book getBook(String string) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(4, "getBook: no bookEntryID");
        }
        return this._bookCache.getBook(string);
    }

    public void loadBook(String string, String string2, Properties properties) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(4, "getBook: no bookEntryID");
        }
        this._bookCache.loadBook(string, string2, properties);
    }

    public String addBook(Element element) throws PStoreException {
        return this.addBook(element, false);
    }

    public String addBook(Element element, boolean bl) throws PStoreException {
        String string;
        if (element == null) {
            throw new PStoreException(6, "addBook: null bookElement");
        }
        boolean bl2 = false;
        if (this._maxEntryQuota != -1 && (bl2 = this.checkQuotaFull())) {
            throw new PStoreException(17, "addBook failed.Max allowed: " + this._maxEntryQuota);
        }
        String string2 = null;
        try {
            string2 = XPathTools.getValueByXPath((Node)element, (String)"entry/displayname");
            if (string2 == null || string2.length() <= 0) {
                throw new PStoreException(2, "addBook: Empty/null Display Name");
            }
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new PStoreException(3, "addBook: wrong XPATH:" + xSLProcessingException.getMessage());
        }
        try {
            string = XPathTools.getValueByXPath((Node)element, (String)"@booktype");
            Book[] bookArray = this.listBooks(string);
            for (int i = 0; i < bookArray.length; ++i) {
                if (!bookArray[i].getDisplayName().equals(string2)) continue;
                throw new PStoreException(2, "addBook: Duplicate display name.");
            }
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new PStoreException(3, "addBook: wrong XPATH:" + xSLProcessingException.getMessage());
        }
        string = null;
        try {
            string = XPathTools.getValueByXPath((Node)element, (String)"entry/@entryID");
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new PStoreException(3, "addBook: wrong XPATH:" + xSLProcessingException.getMessage());
        }
        Logging.trace((int)1, (String)("entryID: " + string));
        try {
            string = this._userDB.addEntry(this._user, this._psRoot, element, 0, string, bl);
        }
        catch (piDbException piDbException2) {
            if (piDbException2.getReason() == 45) {
                throw new PStoreException(26);
            }
            if (piDbException2.getReason() == 46) {
                throw new PStoreException(27);
            }
            throw new PStoreException(8, "addBook failed:" + piDbException2.getMessage());
        }
        if (string == null || string.length() <= 0) {
            throw new PStoreException(8, "addBook returned null entryID");
        }
        ++this._currentEntryCount;
        this._bookCache.reset();
        return string;
    }

    public void modifyBook(String string, Element element) throws PStoreException {
        this.modifyBook(string, element, false);
    }

    public void modifyBook(String string, Element element, boolean bl) throws PStoreException {
        String string2;
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "modifyBook: null bookEntryID");
        }
        if (element == null) {
            throw new PStoreException(6, "modifyBook: null bookElement");
        }
        Element element2 = null;
        try {
            element2 = (Element)XPathTools.getFirstNodeByXPath((Node)element, (String)"entry");
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new PStoreException(3, "modifyBook: wrong XPATH:" + xSLProcessingException.getMessage());
        }
        if (element2 != null) {
            string2 = null;
            try {
                string2 = XPathTools.getValueByXPath((Node)element, (String)"entry/@entryID");
            }
            catch (XSLProcessingException xSLProcessingException) {
                throw new PStoreException(3, "modifyBook: wrong XPATH:" + xSLProcessingException.getMessage());
            }
            if (string2 == null || string2.length() <= 0) {
                element2.setAttribute("entryID", string);
            }
        }
        string2 = null;
        try {
            NodeList nodeList = element.getElementsByTagName("displayname");
            if (nodeList != null && nodeList.getLength() > 0 && ((string2 = XPathTools.getValueByXPath((Node)element, (String)"entry/displayname")) == null || string2 != null && string2.length() == 0)) {
                throw new PStoreException(2, "modifyBook: Null/Empty Display Name");
            }
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new PStoreException(3, "modifyBook: wrong XPATH:" + xSLProcessingException.getMessage());
        }
        try {
            this._userDB.modifyEntry(this._user, this._psRoot, string, element, 0, bl);
        }
        catch (piDbException piDbException2) {
            if (piDbException2.getReason() == 45) {
                throw new PStoreException(26);
            }
            throw new PStoreException(8, "modifyBook failed:" + piDbException2.getMessage());
        }
        this._bookCache.reset();
    }

    public void setACL(String string, String string2, Element element, boolean bl) throws PStoreException {
        Object object;
        if (null == string || string.trim().equals("")) {
            throw new PStoreException(28, "<entryid> parameter is required");
        }
        if (null == string2) {
            Logging.trace((int)32, (String)"setACL: <mode> parameter is null. Defaulting the mode to replace");
            string2 = "replace";
        } else if (!("add".equalsIgnoreCase(string2) || "replace".equalsIgnoreCase(string2) || "replaceall".equalsIgnoreCase(string2) || "delete".equalsIgnoreCase(string2))) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("Invalid <mode> parameter: ");
            stringBuffer.append(string2);
            stringBuffer.append(". Valid values are: ");
            stringBuffer.append("add");
            stringBuffer.append(" ");
            stringBuffer.append("replace");
            stringBuffer.append(" ");
            stringBuffer.append("replaceall");
            stringBuffer.append(" ");
            stringBuffer.append("delete");
            Logging.error((int)32, (String)stringBuffer.toString());
            throw new PStoreException(6, stringBuffer.toString());
        }
        if (null == element) {
            return;
        }
        Entry entry = this.getEntry(string);
        if (null == entry) {
            throw new PStoreException(4, string);
        }
        if (entry instanceof Book) {
            object = this.getBook(string);
            if (null == object) {
                throw new PStoreException(33, string);
            }
            if (((Book)object).isSubscribedBook()) {
                Logging.error((int)32, (String)"setACL: Entry is a subscribed book, can't perform set acl");
                throw new PStoreException(30, string);
            }
            if (((Book)object).isRemoteBook()) {
                Logging.error((int)32, (String)"setACL: Entry is a remote book, can't perform set acl");
                throw new PStoreException(31, string);
            }
        }
        Element element2 = null == (object = entry.getACLObj()) ? null : ((AddressBookACL)object).toXml();
        Element element3 = null;
        if (null == object || null == element2) {
            Logging.trace((int)32, (String)"setACL: No acl is defined in the entry");
            if ("delete".equalsIgnoreCase(string2)) {
                Logging.trace((int)32, (String)"setACL: Returning without doing any thing because delete operation won't have any effect on an entry with no acl defined");
                return;
            }
            element3 = element;
        } else {
            ((AddressBookACL)object).setPermissions(element, string2);
            element3 = ((AddressBookACL)object).toXml();
        }
        Element element4 = null;
        if (entry instanceof Book) {
            Document document = _domBuilder.newDocument();
            element4 = document.createElement("book");
            Element element5 = document.createElement("bookoc");
            Text text = document.createTextNode("piLocalBook");
            try {
                element5.appendChild(_domBuilder.copyNode((Node)text, document));
                element4.appendChild(_domBuilder.copyNode((Node)element5, document));
                element4.appendChild(_domBuilder.copyNode((Node)element3, document));
            }
            catch (XMLProcessingException xMLProcessingException) {
                throw new PStoreException(20, "Couldn't construct xml input with required objectclasses: " + xMLProcessingException.getMessage());
            }
        } else {
            throw new PStoreException(32, "Set acl is not supported for this entry. Currently set acl is only supported for book entries.");
        }
        this.modifyBook(string, element4, bl);
    }

    public void deleteBook(String string) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "deleteBook: no bookEntryID");
        }
        Book book = this.getBook(string);
        if (book == null) {
            throw new PStoreException(4, "deleteBook: invalid bookEntryID");
        }
        if (!book.isSubscribedBook()) {
            Document document = _domBuilder.newDocument();
            Element element = document.createElement("dummyElement");
            document.appendChild(element);
            Vector<String> vector = new Vector<String>();
            vector.add("memberofbook");
            vector.add("entry");
            this.searchBook(string, "entry/displayname=*", vector, null, "entry/displayname", element);
            try {
                ArrayList arrayList = XPathTools.getNodesByXPath((Node)element, (String)("*[memberofbook='" + string + "']"));
                String[] stringArray = XPathTools.getValuesByXPath((Node)document, (String)"entry/@entryID");
                Object var8_10 = null;
                Node node = null;
                for (int i = 0; i < arrayList.size(); ++i) {
                    node = (Node)arrayList.get(i);
                    if (XPathTools.getValuesByXPath((Node)node, (String)"memberofbook").length != 1) continue;
                    this.deleteEntry(string, XPathTools.getValueByXPath((Node)node, (String)"entry/@entryID"));
                }
            }
            catch (XSLProcessingException xSLProcessingException) {
                throw new PStoreException(3, "deleteBook: " + xSLProcessingException.getMessage());
            }
            this.removeMembers(string, book);
        }
        try {
            this._userDB.deleteEntry(this._user, this._psRoot, string, 0);
        }
        catch (piDbException piDbException2) {
            if (piDbException2.getReason() == 17) {
                throw new PStoreException(4, "deleteBook: No such entryID:" + piDbException2.getMessage());
            }
            throw new PStoreException(8, "deleteBook failed:" + piDbException2.getMessage());
        }
        --this._currentEntryCount;
        this._bookCache.reset();
    }

    public Book getDefaultBook(String string) throws PStoreException {
        if (string == null || string.length() <= 0) {
            string = "abook";
        }
        if (this._defaultBook != null) {
            return this._defaultBook;
        }
        String string2 = null;
        try {
            string2 = this._userDB.getDefaultBookID(this._psRoot);
        }
        catch (piDbException piDbException2) {
            Logging.trace((int)32, (String)"getDefaultBook: Error while getting the defaultBookID attribute");
        }
        if (string2 != null && string2.length() != 0) {
            this._defaultBook = this.getBook(string2);
        } else {
            Book[] bookArray = this.listBooks(string);
            if (bookArray == null) {
                Logging.trace((int)32, (String)("getDefaultBook: no book of this type: " + string));
                return null;
            }
            for (int i = 0; i < bookArray.length; ++i) {
                this._defaultBook = bookArray[i];
                if (this._defaultBook.getBookRemoteURL() == null) break;
            }
            if (this._defaultBook == null) {
                Logging.trace((int)32, (String)"getDefaultBook: no Local book found");
                return null;
            }
            String string3 = this._defaultBook.getEntryID();
            Logging.trace((int)32, (String)("Setting Default Book ID in Store (" + this._psRoot + ") to " + string3));
            try {
                this._userDB.setDefaultBookID(string3, this._psRoot);
            }
            catch (piDbException piDbException3) {
                Logging.trace((int)32, (String)"getDefaultBook: Error while setting the defaultBookID attribute");
            }
        }
        return this._defaultBook;
    }

    public void searchBook(String string, String string2, Vector vector, Vector vector2, String string3, Element element) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "searchBook: no bookEntryID");
        }
        if (string2 == null || string2.length() <= 0) {
            throw new PStoreException(6, "searchBook: no filter");
        }
        if (element == null) {
            throw new PStoreException(6, "searchBook: no resElt");
        }
        Document document = element.getOwnerDocument();
        if (document == null) {
            throw new PStoreException(6, "searchBook: resElt not attached to any doc");
        }
        Logging.trace((int)32, (String)("searchBook: bookEntryID=" + string + ", filter=" + string2 + ",sortBy=" + string3));
        int n = 0;
        Vector<String> vector3 = null;
        if (string3 != null) {
            vector3 = new Vector<String>(1);
            vector3.add(string3);
        }
        boolean bl = string.equals("*");
        Book book = null;
        if (!bl) {
            book = this.getBook(string);
            if (book == null) {
                throw new PStoreException(2, "searchBook: invalid bookEntryID: " + string);
            }
            if (book.isSubscribedBook() && !this.checkPermissions(book, "r")) {
                throw new PStoreException(34, "searchBook: Failed due to user don't have read permission on this subscribed book");
            }
        }
        DBPluginMap dBPluginMap = null;
        String string4 = null;
        String string5 = null;
        if (!bl) {
            string5 = book.getBookRemoteURL();
        }
        try {
            string2 = URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PStoreException(6, "searchBook - character encoding for the filter is invalid");
        }
        DBPlugin dBPlugin = null;
        boolean bl2 = false;
        dBPlugin = (DBPlugin)this._searchDbMap.get(string);
        boolean bl3 = false;
        if (string5 != null) {
            dBPluginMap = this._dbHandler.getDBPluginMapFromURL(string5);
            if (dBPluginMap == null) {
                Logging.trace((int)32, (String)("psearchBook: couldn't get DBPluginMap for " + string5));
                throw new PStoreException(1, "psearchBook: couldn't get DB for " + string5);
            }
            if (book.isSubscribedBook()) {
                string4 = "&(" + string2 + ")(" + "memberofbook" + "=" + string + ")";
            } else {
                string4 = string2;
                bl3 = true;
            }
            if (null == dBPlugin) {
                dBPlugin = dBPluginMap.getDBPlugin();
                bl2 = true;
            }
        } else {
            dBPluginMap = this._localDBPluginMap;
            string5 = this._psRoot;
            string4 = "&(" + string2 + ")(" + "memberofbook" + "=" + string + ")";
            if (null == dBPlugin) {
                dBPlugin = dBPluginMap.getDBPlugin(this._psRoot);
                bl2 = true;
            }
        }
        if (null != dBPlugin) {
            if (bl2) {
                this._searchDbMap.put(string, dBPlugin);
            }
        } else {
            Logging.error((int)32, (String)("psearchBook: couldn't get DB for " + string));
            throw new PStoreException(1, "psearchBook: couldn't get DB for " + string);
        }
        int n2 = dBPluginMap.getMinWildcardSearch();
        boolean bl4 = dBPluginMap.isCorporateDir();
        CorePersonalStore.checkFilter(string2, n2);
        try {
            if (!bl3) {
                dBPlugin.searchDeletedEntries(this.searchdel);
            }
            this.searchdel = false;
            n = dBPlugin.search(this._user, string5, string4, vector, vector3, vector2, element, 0);
        }
        catch (piDbException piDbException2) {
            if (piDbException2.getReason() == 29) {
                throw new PStoreException(21, "searchBook: search failed:" + piDbException2.getMessage());
            }
            throw new PStoreException(3, "searchBook: search failed:" + piDbException2.getMessage());
        }
        element.setAttribute("bookid", string);
        element.setAttribute("filter", string2);
        element.setAttribute("sortby", string3);
        if (n > 0) {
            element.setAttribute("firstentry", "1");
            element.setAttribute("lastentry", String.valueOf(n));
        } else {
            element.setAttribute("firstentry", "0");
            element.setAttribute("lastentry", "0");
        }
        element.setAttribute("totalentries", String.valueOf(n));
        String string6 = dBPlugin.getLastPurgeDate();
        if (string6 != null) {
            element.setAttribute("lastPurgeDate", string6);
        }
        Logging.trace((int)32, (String)("searchBook: nb total entries found=" + n));
    }

    public String searchBook(String string, String string2, Vector vector, Vector vector2, String string3, int n) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "psearchBook: no bookEntryID");
        }
        if (string2 == null || string2.length() <= 0) {
            throw new PStoreException(6, "psearchBook: no filter");
        }
        if (n <= 0) {
            throw new PStoreException(6, "psearchBook: invalid entries per page:" + n);
        }
        Logging.trace((int)32, (String)("psearchBook: bookEntryID=" + string + ", filter=" + string2 + ", sortBy=" + string3 + ",entriesPerPage=" + n));
        if (this._pagedSearchTable.size() > this._maxPagedSearch) {
            throw new PStoreException(7, "psearchBook: too many psearch: " + this._pagedSearchTable.size());
        }
        PagedSearch pagedSearch = null;
        boolean bl = false;
        boolean bl2 = false;
        Vector<String> vector3 = null;
        if (string3 != null) {
            vector3 = new Vector<String>(1);
            vector3.add(string3);
        }
        boolean bl3 = string.equals("*");
        Book book = null;
        if (!bl3) {
            book = this.getBook(string);
            if (book == null) {
                throw new PStoreException(2, "psearchBook: invalid bookEntryID");
            }
            if (book.isSubscribedBook() && !this.checkPermissions(book, "r")) {
                throw new PStoreException(34, "searchBook: Failed due to user don't have read permission on this subscribed book");
            }
        }
        DBPluginMap dBPluginMap = null;
        String string4 = null;
        String string5 = null;
        if (!bl3) {
            string5 = book.getBookRemoteURL();
        }
        try {
            string2 = URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PStoreException(6, "searchBook - character encoding for the filter is invalid");
        }
        DBPlugin dBPlugin = null;
        boolean bl4 = false;
        dBPlugin = (DBPlugin)this._searchDbMap.get(string);
        if (string5 != null) {
            dBPluginMap = this._dbHandler.getDBPluginMapFromURL(string5);
            if (dBPluginMap == null) {
                Logging.trace((int)32, (String)("psearchBook: couldn't get DBPluginMap for " + string5));
                throw new PStoreException(1, "psearchBook: couldn't get DB for " + string5);
            }
            string4 = book.isSubscribedBook() ? "&(" + string2 + ")(" + "memberofbook" + "=" + string + ")" : string2;
            if (null == dBPlugin) {
                dBPlugin = dBPluginMap.getDBPlugin();
                bl4 = true;
            }
        } else {
            dBPluginMap = this._localDBPluginMap;
            string5 = this._psRoot;
            string4 = "&(" + string2 + ")(" + "memberofbook" + "=" + string + ")";
            if (null == dBPlugin) {
                dBPlugin = dBPluginMap.getDBPlugin(this._psRoot);
                bl4 = true;
            }
        }
        if (null != dBPlugin) {
            if (bl4) {
                this._searchDbMap.put(string, dBPlugin);
            }
        } else {
            Logging.error((int)32, (String)("psearchBook: couldn't get DB for " + string));
            throw new PStoreException(1, "psearchBook: couldn't get DB for " + string);
        }
        int n2 = dBPluginMap.getMinWildcardSearch();
        CorePersonalStore.checkFilter(string2, n2);
        try {
            pagedSearch = dBPlugin.pagedSearch(this._user, string5, string4, vector, vector3, vector2, n, 0);
        }
        catch (piDbException piDbException2) {
            if (piDbException2.getReason() == 29) {
                throw new PStoreException(21, "psearch failed:" + piDbException2.getMessage());
            }
            throw new PStoreException(8, "psearch failed:" + piDbException2.getMessage());
        }
        ++this._nbPagedSearch;
        if (this._nbPagedSearch == this._maxPagedSearch) {
            this._nbPagedSearch = 0;
            while (this._nbPagedSearch < this._maxPagedSearch && this._pagedSearchTable.containsKey(Integer.toString(this._nbPagedSearch))) {
                ++this._nbPagedSearch;
            }
        }
        String string6 = Integer.toString(this._nbPagedSearch);
        CoreSearchResult coreSearchResult = new CoreSearchResult(string, string2, string3, n, dBPluginMap.allowsRandomPaging(), pagedSearch);
        this._pagedSearchTable.put(string6, coreSearchResult);
        Logging.trace((int)32, (String)("psearchBook: new searchID=" + string6));
        return string6;
    }

    public void expandGroup(String string, Element element, Vector vector, Vector vector2, String string2, Element element2) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "expandGroup: no bookEntryID");
        }
        if (element2 == null) {
            throw new PStoreException(6, "expandGroup: no resElt");
        }
        Document document = element2.getOwnerDocument();
        if (document == null) {
            throw new PStoreException(6, "expandGroup: resElt not attached to any doc");
        }
        Logging.trace((int)32, (String)("expandGroup, sortBy=" + string2));
        int n = 0;
        Vector<String> vector3 = null;
        if (string2 != null) {
            vector3 = new Vector<String>(1);
            vector3.add(string2);
        }
        boolean bl = string.equals("*");
        Book book = null;
        if (!bl && (book = this.getBook(string)) == null) {
            throw new PStoreException(2, "expandGroup: invalid bookEntryID: " + string);
        }
        String string3 = null;
        DBPluginMap dBPluginMap = null;
        DBPlugin dBPlugin = null;
        boolean bl2 = false;
        dBPlugin = (DBPlugin)this._searchDbMap.get(string);
        if (dBPlugin != null) {
            if (!bl) {
                string3 = book.getBookRemoteURL();
            }
            if (string3 != null) {
                dBPluginMap = this._dbHandler.getDBPluginMapFromURL(string3);
                if (dBPluginMap == null) {
                    Logging.trace((int)32, (String)("expandGroup: couldn't get DBPluginMap for " + string3));
                    throw new PStoreException(1, "expandGroup: couldn't get DB for " + string3);
                }
                if (null == dBPlugin) {
                    dBPlugin = dBPluginMap.getDBPlugin();
                    bl2 = true;
                }
            } else {
                dBPluginMap = this._localDBPluginMap;
                if (null == dBPlugin) {
                    dBPlugin = dBPluginMap.getDBPlugin(this._psRoot);
                    bl2 = true;
                }
            }
        }
        if (null != dBPlugin) {
            if (bl2) {
                this._searchDbMap.put(string, dBPlugin);
            }
        } else {
            Logging.error((int)32, (String)("expandGroup: couldn't get DB for " + string));
            throw new PStoreException(1, "expandGroup: couldn't get DB for " + string);
        }
        try {
            n = dBPlugin.expandGroup(this._user, element, vector, vector3, vector2, element2);
        }
        catch (piDbException piDbException2) {
            Logging.error((int)32, (String)("Failed to expand group " + piDbException2.getMessage()));
            if (piDbException2.getReason() == 29) {
                throw new PStoreException(21, "expandGroup: search failed:" + piDbException2.getMessage());
            }
            throw new PStoreException(8, "expandGroup: search failed:" + piDbException2.getMessage());
        }
        element2.setAttribute("bookid", string);
        element2.setAttribute("sortby", string2);
        if (n > 0) {
            element2.setAttribute("firstentry", "1");
            element2.setAttribute("lastentry", String.valueOf(n));
        } else {
            element2.setAttribute("firstentry", "0");
            element2.setAttribute("lastentry", "0");
        }
        element2.setAttribute("totalentries", String.valueOf(n));
    }

    public void getResult(String string, int n, Element element) throws PStoreException {
        if (string == null) {
            throw new PStoreException(6, "getResult: null searchID");
        }
        Logging.trace((int)32, (String)("getResult: searchID=" + string + "firstentry=" + n));
        CoreSearchResult coreSearchResult = (CoreSearchResult)this._pagedSearchTable.get(string);
        if (coreSearchResult == null) {
            throw new PStoreException(6, "getResult: invalid searchID: " + string);
        }
        if (element == null) {
            throw new PStoreException(6, "getResult: no resElt");
        }
        Document document = element.getOwnerDocument();
        if (document == null) {
            throw new PStoreException(6, "getResult: resElt not attached to any doc");
        }
        coreSearchResult.getResult(n, element);
        element.setAttribute("searchid", string);
    }

    public void stopSearch(String string) throws PStoreException {
        if (string == null) {
            throw new PStoreException(6, "stopSearch: null searchID");
        }
        CoreSearchResult coreSearchResult = null;
        if (!string.equals("all")) {
            coreSearchResult = (CoreSearchResult)this._pagedSearchTable.get(string);
            if (coreSearchResult == null) {
                throw new PStoreException(6, "stopSearch: invalid searchID: " + string);
            }
            coreSearchResult.stopSearch();
            this._pagedSearchTable.remove(string);
        } else {
            Iterator iterator = this._pagedSearchTable.values().iterator();
            while (iterator.hasNext()) {
                coreSearchResult = (CoreSearchResult)iterator.next();
                coreSearchResult.stopSearch();
            }
            this._pagedSearchTable.clear();
        }
    }

    public Entry getEntry(String string, String string2, Element element) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "getEntry: no bookEntryID");
        }
        if (string2 == null || string2.length() <= 0) {
            throw new PStoreException(6, "getEntry: no entryID");
        }
        if (element == null) {
            throw new PStoreException(6, "getEntry: no resElt");
        }
        Document document = element.getOwnerDocument();
        if (document == null) {
            throw new PStoreException(6, "getEntry: resElt not attached to any doc");
        }
        Book book = this.getBook(string);
        if (book == null) {
            throw new PStoreException(4, "getEntry: invalid bookEntryID");
        }
        if (book.isSubscribedBook() && !this.checkPermissions(book, "r")) {
            throw new PStoreException(34, "getEntry: Failed due to user don't have read permission on this subscribed book");
        }
        DBPlugin dBPlugin = null;
        String string3 = book.getBookRemoteURL();
        if (string3 != null) {
            dBPlugin = this._dbHandler.getDBFromURL(string3);
            if (dBPlugin == null) {
                Logging.trace((int)32, (String)("psearchBook: couldn't get DB for " + string3));
                throw new PStoreException(1, "getEntry: couldn't get DB for " + string3);
            }
        } else {
            string3 = this._psRoot;
            dBPlugin = this._userDB;
        }
        return this.getEntry(dBPlugin, string3, string2, element);
    }

    public Entry getEntry(String string, Element element) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "getEntry: no entryID");
        }
        return this.getEntry(this._userDB, this._psRoot, string, element);
    }

    public Entry getEntry(String string, String string2) throws PStoreException {
        Document document = null;
        Element element = null;
        document = _domBuilder.newDocument();
        if (document == null) {
            throw new PStoreException(9, "Failed to create dummyDoc");
        }
        try {
            element = document.createElement("dummyElement");
            document.appendChild(element);
        }
        catch (DOMException dOMException) {
            throw new PStoreException(9, "Failed to append dummyElement to dummyDoc : " + dOMException.getMessage());
        }
        return this.getEntry(string, string2, element);
    }

    public Entry getEntry(String string) throws PStoreException {
        Document document = null;
        Element element = null;
        document = _domBuilder.newDocument();
        if (document == null) {
            throw new PStoreException(9, "Failed to create dummyDoc");
        }
        try {
            element = document.createElement("dummyElement");
            document.appendChild(element);
        }
        catch (DOMException dOMException) {
            throw new PStoreException(9, "Failed to append dummyElement to dummyDoc : " + dOMException.getMessage());
        }
        return this.getEntry(string, element);
    }

    public String addEntry(String[] stringArray, Element element) throws PStoreException {
        return this.addEntry(stringArray, element, null, false);
    }

    public String addEntry(String[] stringArray, Element element, String string, boolean bl) throws PStoreException {
        if (stringArray == null || stringArray.length <= 0) {
            throw new PStoreException(6, "addEntry: no bookEntryID");
        }
        if (element == null) {
            throw new PStoreException(6, "addEntry: null entryElement");
        }
        if (!this._bookCache.isBookMembershipValid(stringArray)) {
            throw new PStoreException(4, "addEntry: invalid bookEntryID");
        }
        boolean bl2 = false;
        if (this._maxEntryQuota != -1 && (bl2 = this.checkQuotaFull())) {
            throw new PStoreException(17, "addEntry failed.Max allowed : " + this._maxEntryQuota);
        }
        Book book = this.getBook(stringArray[0]);
        if (book == null) {
            throw new PStoreException(2, "createEntry: invalid bookEntryID");
        }
        if (book.isSubscribedBook()) {
            if (!this.checkPermissions(book, "c")) {
                throw new PStoreException(34, "addEntry: Failed due to user don't have create permission on this subscribed book");
            }
        } else if (book.isRemoteBook()) {
            throw new PStoreException(35, "addEntry: Failed due to addEntry operation is not allowed on a remote book");
        }
        PS_DBPlugin pS_DBPlugin = null;
        String string2 = book.getBookRemoteURL();
        if (string2 != null) {
            pS_DBPlugin = this.getPS_DBPluginFromURL(book.getEntryID(), string2);
        } else {
            string2 = this._psRoot;
            pS_DBPlugin = this._userDB;
        }
        if (pS_DBPlugin == null) {
            throw new PStoreException(1, "addEntry: couldn't get DB for " + string2);
        }
        CorePersonalStore.removeMembershipElement(element, "memberofbook");
        CorePersonalStore.addMembershipElement(element, "memberofbook", stringArray);
        String string3 = null;
        try {
            string3 = pS_DBPlugin.addEntry(this._user, string2, element, 0, string, bl);
        }
        catch (piDbException piDbException2) {
            if (piDbException2.getReason() == 45) {
                throw new PStoreException(26);
            }
            if (piDbException2.getReason() == 46) {
                throw new PStoreException(27);
            }
            throw new PStoreException(8, "addEntry failed:" + piDbException2.getReason() + ":" + piDbException2.getMessage());
        }
        if (string3 == null || string3.length() <= 0) {
            throw new PStoreException(8, "addEntry returned null entryID");
        }
        ++this._currentEntryCount;
        return string3;
    }

    public void modifyEntry(String string, String string2, Element element) throws PStoreException {
        this.modifyEntry(string, string2, element, false);
    }

    public void modifyEntry(String string, String string2, Element element, boolean bl) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "modifyEntry: no bookEntryID");
        }
        if (string2 == null || string2.length() <= 0) {
            throw new PStoreException(6, "modifyEntry: no entryID");
        }
        if (element == null) {
            throw new PStoreException(6, "modifyEntry: null modifyElt");
        }
        Book book = this.getBook(string);
        if (book == null) {
            throw new PStoreException(4, "modifyEntry: invalid bookEntryID");
        }
        if (book.isSubscribedBook()) {
            if (!this.checkPermissions(book, "w")) {
                throw new PStoreException(34, "modifyEntry: Failed due to user don't have write permission on this subscribed book");
            }
        } else if (book.isRemoteBook()) {
            throw new PStoreException(35, "modifyEntry: Failed due to modifyEntry operation is not allowed on a remote book");
        }
        PS_DBPlugin pS_DBPlugin = null;
        String string3 = book.getBookRemoteURL();
        if (string3 != null) {
            pS_DBPlugin = this.getPS_DBPluginFromURL(string, string3);
        } else {
            string3 = this._psRoot;
            pS_DBPlugin = this._userDB;
        }
        if (pS_DBPlugin == null) {
            throw new PStoreException(1, "modifyEntry: couldn't get DB for " + string3);
        }
        this.modifyEntry(pS_DBPlugin, string3, string2, element, bl);
    }

    public void modifyEntry(String string, Element element) throws PStoreException {
        this.modifyEntry(string, element, false);
    }

    public void modifyEntry(String string, Element element, boolean bl) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "modifyEntry: no entryID");
        }
        if (element == null) {
            throw new PStoreException(6, "modifyEntry: null modifyElt");
        }
        this.modifyEntry(this._userDB, this._psRoot, string, element, bl);
    }

    public void deleteEntry(String string, String string2) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "deleteEntry: no bookEntryID");
        }
        if (string2 == null || string2.length() <= 0) {
            throw new PStoreException(6, "deleteEntry: no entryID");
        }
        Book book = this.getBook(string);
        if (book == null) {
            throw new PStoreException(4, "deleteEntry: invalid bookEntryID");
        }
        if (book.isSubscribedBook()) {
            if (!this.checkPermissions(book, "d")) {
                throw new PStoreException(34, "deleteEntry: Failed due to user don't have delete permission on this subscribed book");
            }
        } else if (book.isRemoteBook()) {
            throw new PStoreException(35, "deleteEntry: Failed due to deleteEntry operation is not allowed on a remote book");
        }
        PS_DBPlugin pS_DBPlugin = null;
        String string3 = book.getBookRemoteURL();
        if (string3 != null) {
            pS_DBPlugin = this.getPS_DBPluginFromURL(string, string3);
        } else {
            string3 = this._psRoot;
            pS_DBPlugin = this._userDB;
        }
        Entry entry = this.getEntry(string, string2);
        if (entry == null) {
            throw new PStoreException(4, "deleteEntry: getEntry didn't return any entry for " + string2 + ", book: " + string);
        }
        if (entry instanceof Group) {
            this.removeMembers(string, entry);
        }
        try {
            pS_DBPlugin.deleteEntry(this._user, string3, string2, 0);
        }
        catch (piDbException piDbException2) {
            if (piDbException2.getReason() == 17) {
                throw new PStoreException(4, "No such entryID:" + piDbException2.getMessage());
            }
            if (piDbException2.getReason() == 29) {
                throw new PStoreException(21, "delete Entry failed:" + piDbException2.getMessage());
            }
            throw new PStoreException(8, "deleteEntry failed:" + piDbException2.getMessage());
        }
        --this._currentEntryCount;
    }

    public String getServerTime() {
        return "ServerTime";
    }

    public String getVersion() {
        return "VersionNumber";
    }

    public Element getUserPrefs() {
        if (this._prefElement != null) {
            return this._prefElement;
        }
        this._prefElement = this.loadUserPrefs(this._user);
        return this._prefElement;
    }

    public Element loadUserPrefs(UserSession userSession) {
        UserPrefs2XMLTranslatable userPrefs2XMLTranslatable = new UserPrefs2XMLTranslatable(userSession);
        if (userPrefs2XMLTranslatable == null) {
            Logging.error((int)32, (String)"CorePersonalStore:loadUserPrefs - Couldn't create Session2XMLTranslatable");
            return null;
        }
        Element element = null;
        try {
            DbTranslationTable dbTranslationTable = DbTranslationTable.getInstance();
            DbTranslation dbTranslation = dbTranslationTable.getDbTransObj(new File(this._configPath, _userXlatePath));
            if (dbTranslation == null) {
                Logging.error((int)32, (String)"CorePersonalStore:loadUserPrefs - Translator is not initialized");
                return null;
            }
            element = dbTranslation.translate((DbTranslatable)userPrefs2XMLTranslatable);
        }
        catch (Exception exception) {
            Logging.error((int)32, (String)"CorePersonalStore:loadUserPrefs - Failure during translation from session -> xml");
            return null;
        }
        return element;
    }

    public Element getUserProfile(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        Element element = (Element)this._profileTable.get(string);
        if (element != null && !bl) {
            return element;
        }
        element = this.loadUserProfile(this._user);
        if (element != null) {
            this._profileTable.put(string, element);
        }
        return element;
    }

    public Element loadUserProfile(UserSession userSession) {
        Session2XMLTranslatable session2XMLTranslatable = new Session2XMLTranslatable(userSession);
        if (session2XMLTranslatable == null) {
            Logging.error((int)32, (String)"CorePersonalStore:loadUserProfile - Couldn't create Session2XMLTranslatable");
            return null;
        }
        Element element = null;
        try {
            DbTranslationTable dbTranslationTable = DbTranslationTable.getInstance();
            DbTranslation dbTranslation = dbTranslationTable.getDbTransObj(new File(this._configPath, _userXlatePath));
            if (dbTranslation == null) {
                Logging.error((int)32, (String)"CorePersonalStore:loadUserProfile - Translator is not initialized");
                return null;
            }
            element = dbTranslation.translate((DbTranslatable)session2XMLTranslatable);
        }
        catch (Exception exception) {
            Logging.error((int)32, (String)"CorePersonalStore:loadUserProfile - Failure during translation from session -> xml");
            return null;
        }
        return element;
    }

    public Element getProfile(String string) throws PStoreException {
        if (string == null) {
            throw new PStoreException(6, "getProfile: invalid profileName (null)");
        }
        Element element = (Element)this._profileTable.get(string);
        if (element != null) {
            return element;
        }
        if (this._profileBook == null) {
            return null;
        }
        element = this.loadProfile(this._profileBook, string);
        if (element != null) {
            this._profileTable.put(string, element);
        }
        return element;
    }

    public void modifyProfile(String string, Element element) throws PStoreException {
        if (string == null) {
            throw new PStoreException(6, "setProfile: invalid profileName (null)");
        }
        if (element == null) {
            throw new PStoreException(6, "setProfile: invalid profileElement (null)");
        }
        Element element2 = this.getProfile(string);
        if (element2 == null) {
            throw new PStoreException(6, "setProfile: invalid profileName (doesn't exist)");
        }
        String string2 = null;
        try {
            string2 = XPathTools.getValueByXPath((Node)element2, (String)"entry/@entryID");
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new PStoreException(3, "modifyProfile: wrong XPATH:" + xSLProcessingException.getMessage());
        }
        Element element3 = null;
        try {
            element3 = (Element)XPathTools.getFirstNodeByXPath((Node)element, (String)"entry");
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new PStoreException(3, "modifyProfile: Could not get element entry :" + xSLProcessingException.getMessage());
        }
        if (element3 != null) {
            try {
                element3.setAttribute("entryID", string2);
            }
            catch (DOMException dOMException) {
                throw new PStoreException(9, "modifyProfile: Could not append entryid attribute : " + dOMException.getMessage());
            }
        }
        this.modifyEntry(this._profileBook.getEntryID(), string2, element);
        this._profileTable.remove(string);
    }

    public boolean addBookMember(String string, String string2) throws PStoreException {
        Object object;
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "addBookMember: no bookEntryID");
        }
        if (string2 == null || string2.length() <= 0) {
            throw new PStoreException(6, "addBookMember: no memberEntryID");
        }
        Book book = this.getBook(string);
        if (book == null) {
            throw new PStoreException(4, "addBookMember: getBook returned null for book " + string);
        }
        if (book.getBookRemoteURL() != null) {
            throw new PStoreException(10, "addBookMember: can't add a remote book membership: " + string);
        }
        if (book.isSubscribedBook()) {
            Logging.error((int)32, (String)"addBookMember: Book is a subscribed book, can't add entry to Book");
            throw new PStoreException(36, "addBookMember: Book is a subscribed book, can't add entry to Book" + string);
        }
        Entry entry = this.getEntry(string2);
        if (entry == null) {
            throw new PStoreException(4, "addBookMember: getEntry returned null for " + string2 + " book: " + string);
        }
        String[] stringArray = entry.getBookMembership();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.equalsIgnoreCase(stringArray[i])) {
                    Logging.trace((int)32, (String)("addBookMember: entryID=" + string2 + " is already a member of " + string));
                    return false;
                }
                object = this.getBook(stringArray[i]);
                if (!((Book)object).isSubscribedBook()) continue;
                Logging.trace((int)32, (String)("addBookMember: entryID=" + string2 + " Entry belongs to subscribed book, can't add to Book" + string));
                throw new PStoreException(37, "addBookMember: Entry belongs to subscribed book, can't add to Book" + string);
            }
        }
        if (string2.equals(string)) {
            throw new PStoreException(13, "addBookMember: loop detected: member:" + string2 + " is same as book");
        }
        String[] stringArray2 = entry.getBookMembership();
        object = null;
        if (stringArray2 != null) {
            object = new String[stringArray2.length + 1];
            for (int i = 0; i < stringArray2.length; ++i) {
                if (string.equals(stringArray2[i])) {
                    Logging.trace((int)32, (String)("addBookMember: entryID=" + string2 + " is already a member of " + string));
                    return false;
                }
                object[i] = stringArray2[i];
            }
            object[stringArray2.length] = string;
        } else {
            object = new String[]{string};
        }
        Element element = this.buildMembershipElement(entry, "memberofbook", (String[])object);
        this.modifyEntry(string2, element);
        return true;
    }

    public boolean removeBookMember(String string, String string2) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "removeBookMember: no bookEntryID");
        }
        if (string2 == null || string2.length() <= 0) {
            throw new PStoreException(6, "removeBookMember: no memberEntryID");
        }
        Book book = this.getBook(string);
        if (book == null) {
            throw new PStoreException(4, "removeBookMember: getBook returned null for book " + string);
        }
        if (book.isSubscribedBook()) {
            Logging.error((int)32, (String)"removeBookMember: Book is a subscribed book, can't remove entry from Book");
            throw new PStoreException(36, "removeBookMember: Book is a subscribed book, can't remove entry from Book" + string);
        }
        Entry entry = this.getEntry(string2);
        if (string2 == null) {
            throw new PStoreException(4, "removeBookMember: getEntry returned null for " + string2 + " book: " + string);
        }
        String[] stringArray = entry.getBookMembership();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Book book2 = this.getBook(stringArray[i]);
                if (!book2.isSubscribedBook()) continue;
                Logging.trace((int)32, (String)("addBookMember: entryID=" + string2 + " Entry belongs to subscribed book, can't remove from Book" + string));
                throw new PStoreException(37, "removeBookMember: Entry belongs to subscribed book, can't remove from Book" + string);
            }
        }
        return this.removeMember(string, book, entry);
    }

    public boolean addGroupMember(String string, String string2, String[] stringArray) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "addGroupMember: no bookEntryID");
        }
        if (string2 == null || string2.length() <= 0) {
            throw new PStoreException(6, "addGroupMember: no groupEntryID");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new PStoreException(6, "addGroupMember: no memberEntryIDs");
        }
        Book book = this.getBook(string);
        Entry entry = this.getEntry(string, string2);
        if (entry == null && !book.isSubscribedBook()) {
            throw new PStoreException(4, "addGroupMember: getEntry returned null for group " + string2 + " book: " + string);
        }
        if (entry == null && book.isSubscribedBook()) {
            throw new PStoreException(41, "addGroupMember: getEntry returned null for group " + string2 + " book: " + string);
        }
        if (!(entry instanceof Group)) {
            throw new PStoreException(12, "addGroupMember: the group entry is not a group:" + string2 + ",book:" + string);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            String string3 = stringArray[i];
            Entry entry2 = this.getEntry(string, string3);
            if (entry2 == null && !book.isSubscribedBook()) {
                throw new PStoreException(4, "addGroupMember: there is no entry for " + string3 + " in  book: " + string);
            }
            if (entry2 == null && book.isSubscribedBook()) {
                throw new PStoreException(41, "addGroupMember: there is no entry for " + string3 + " in  book: " + string);
            }
            String[] stringArray3 = entry2.getBookMembership();
            if (stringArray3 != null) {
                for (int j = 0; j < stringArray3.length; ++j) {
                    stringArray2 = this.getBook(stringArray3[j]);
                    if (book.isSubscribedBook() && !stringArray2.isSubscribedBook()) {
                        Logging.trace((int)32, (String)("addGroupMember: entryID=" + string3 + "Book is a subscribed book but entry doesn't belongs to Subscribed Book" + string));
                        throw new PStoreException(36, "addGroupMember: Book is a subscribed book, can't add entry in group" + string2 + "of the Book" + string);
                    }
                    if (!book.isSubscribedBook() && stringArray2.isSubscribedBook()) {
                        Logging.trace((int)32, (String)("addGroupMember: entryID=" + string3 + " Book is not a subscribed book but entry belongs to Subscribed Book" + string));
                        throw new PStoreException(37, "addGroupMember: Entry belongs to Subscribed Book, can't add to group" + string2 + "of Book" + string);
                    }
                    if (book.isSubscribedBook() && stringArray2.isSubscribedBook() && !stringArray2.getEntryID().equalsIgnoreCase(string)) {
                        Logging.trace((int)32, (String)("addGroupMember: entryID=" + string3 + " entry belongs to other Subscribed Book" + string));
                        throw new PStoreException(36, "addGroupMember: Book is a subscribed book, can't add entry in group" + string2 + "of the Book" + string);
                    }
                    if (!book.isSubscribedBook() || !stringArray2.isSubscribedBook() || !stringArray2.getEntryID().equalsIgnoreCase(string) || this.checkPermissions(book, "w")) continue;
                    throw new PStoreException(34, "addGroupMember: Failed due to user don't have write permission on this subscribed book");
                }
            }
            if (entry2 instanceof Group) {
                if (string3.equals(string2)) {
                    throw new PStoreException(13, "addGroupMember: loop detected: member=" + string3 + " is same as group" + ",book: " + string);
                }
                if (this.isMemberOfGroup(string, (Group)entry2, entry)) {
                    throw new PStoreException(11, "addGroupMember: loop detected: member=" + string3 + ",group=" + string2 + ",book: " + string);
                }
            }
            String[] stringArray4 = entry2.getGroupMembership();
            stringArray2 = null;
            if (stringArray4 != null) {
                stringArray2 = new String[stringArray4.length + 1];
                for (int j = 0; j < stringArray4.length; ++j) {
                    if (string2.equals(stringArray4[j])) {
                        Logging.trace((int)32, (String)("addGroupMember: entryID=" + string3 + " is already a member of " + string2));
                        return false;
                    }
                    stringArray2[j] = stringArray4[j];
                }
                stringArray2[stringArray4.length] = string2;
            } else {
                stringArray2 = new String[]{string2};
            }
            Element element = this.buildMembershipElement(entry2, "memberofgroup", stringArray2);
            this.modifyEntry(string, string3, element);
        }
        Element element = entry.getEntryElement();
        if (element == null) {
            Logging.trace((int)32, (String)"Group Element is null ");
        }
        this.modifyEntry(string, string2, element);
        return true;
    }

    public boolean removeGroupMember(String string, String string2, String[] stringArray) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "removeGroupMember: no bookEntryID");
        }
        if (string2 == null || string2.length() <= 0) {
            throw new PStoreException(6, "removeGroupMember: no groupEntryID");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new PStoreException(6, "removeGroupMember: no memberEntryID");
        }
        Book book = this.getBook(string);
        if (book.isSubscribedBook() && !this.checkPermissions(book, "w")) {
            throw new PStoreException(34, "removeGroupMember: Failed due to user don't have write permission on this subscribed book");
        }
        Entry entry = this.getEntry(string, string2);
        if (entry == null) {
            throw new PStoreException(4, "removeGroupMember: getEntry returned null for group " + string2 + " book: " + string);
        }
        if (!entry.getEntryElement().getTagName().equalsIgnoreCase("group")) {
            throw new PStoreException(4, "removeGroupMember: no such group " + string2 + "in book: " + string);
        }
        int n = 0;
        if (n < stringArray.length) {
            String string3 = stringArray[n];
            Entry entry2 = this.getEntry(string, string3);
            if (entry2 == null) {
                throw new PStoreException(4, "removeGroupMember: there is no entry for " + string3 + " book: " + string);
            }
            String[] stringArray2 = entry2.getBookMembership();
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    Book book2 = this.getBook(stringArray2[i]);
                }
            }
            Logging.trace((int)2, (String)("memberEntry to be removed - " + string3));
            return this.removeMember(string, entry, entry2);
        }
        Element element = entry.getEntryElement();
        if (element == null) {
            Logging.trace((int)32, (String)"Group Element is null ");
        }
        this.modifyEntry(string, string2, element);
        return true;
    }

    public void expandGroup(String string, String string2, Vector vector, String string3, String string4, Element element) throws PStoreException {
        if (string == null || string.length() <= 0) {
            throw new PStoreException(6, "expandGroup: no bookEntryID");
        }
        if (string2 == null || string2.length() <= 0) {
            throw new PStoreException(6, "expandGroup: no entryID");
        }
        if (element == null) {
            throw new PStoreException(6, "expandGroup: no resElt");
        }
        Document document = element.getOwnerDocument();
        if (document == null) {
            throw new PStoreException(6, "expandGroup: resElt not attached to any doc");
        }
        Entry entry = this.getEntry(string, string2, element);
        if (entry == null) {
            Logging.error((int)32, (String)("expandGroup: group entry " + string2 + " could not be found in " + string));
            return;
        }
        this.checkAndExpandGroups(entry.getEntryElement(), string, null, vector, string3, string4, element, document);
        if (element.getAttribute("bookid").length() > 0) {
            element.removeAttribute("bookid");
        }
        if (element.getAttribute("filter").length() > 0) {
            element.removeAttribute("filter");
        }
        if (element.getAttribute("sortby").length() > 0) {
            element.removeAttribute("sortby");
        }
        if (element.getAttribute("firstentry").length() > 0) {
            element.removeAttribute("firstentry");
        }
        if (element.getAttribute("lastentry").length() > 0) {
            element.removeAttribute("lastentry");
        }
        if (element.getAttribute("totalentries").length() > 0) {
            element.removeAttribute("totalentries");
        }
    }

    public void expandGroups(Element element, Vector vector, String string, String string2) throws PStoreException {
        if (element == null) {
            throw new PStoreException(6, "expandGroups: invalid parentElement (null)");
        }
        Document document = element.getOwnerDocument();
        if (document == null) {
            throw new PStoreException(6, "expandGroups: resElt not attached to any doc");
        }
        this.checkAndExpandGroups(null, null, null, vector, string, string2, element, document);
        if (element.getAttribute("bookid").length() > 0) {
            element.removeAttribute("bookid");
        }
        if (element.getAttribute("filter").length() > 0) {
            element.removeAttribute("filter");
        }
        if (element.getAttribute("sortby").length() > 0) {
            element.removeAttribute("sortby");
        }
        if (element.getAttribute("firstentry").length() > 0) {
            element.removeAttribute("firstentry");
        }
        if (element.getAttribute("lastentry").length() > 0) {
            element.removeAttribute("lastentry");
        }
        if (element.getAttribute("totalentries").length() > 0) {
            element.removeAttribute("totalentries");
        }
    }

    private void checkAndExpandGroups(Element element, String string, HashMap hashMap, Vector vector, String string2, String string3, Element element2, Document document) throws PStoreException {
        Object object;
        Object object2;
        Node node = null;
        String string4 = null;
        Vector<Node> vector2 = new Vector<Node>();
        if (hashMap == null) {
            hashMap = new HashMap<String, Node>();
        }
        if (element != null) {
            object2 = string;
            if (this.hasXPathValue(element, string3)) {
                return;
            }
            object = element2.getLastChild();
            try {
                string4 = XPathTools.getValueByXPath((Node)element, (String)"entry/@entryID");
                if (string4 == null || string4.length() <= 0) {
                    throw new PStoreException(6, "checkAndExpandGroup: no entryID for group");
                }
                if (object2 == null && ((object2 = XPathTools.getValueByXPath((Node)element, (String)"memberofbook")) == null || ((String)object2).length() <= 0)) {
                    throw new PStoreException(6, "checkAndExpandGroup: no bookID for group:" + string4);
                }
            }
            catch (XSLProcessingException xSLProcessingException) {
                throw new PStoreException(6, "checkExpandGroup: getValueByXPath returned " + xSLProcessingException.getMessage());
            }
            Book book = null;
            book = this.getBook((String)object2);
            if (book == null) {
                throw new PStoreException(6, "checkAndExpandGroups: invalid bookID: " + (String)object2);
            }
            String string5 = null;
            string5 = book.getBookRemoteURL();
            if (string5 != null) {
                if (book.isSubscribedBook()) {
                    this.searchBook((String)object2, "memberofgroup=" + string4, null, vector, string2, element2);
                } else {
                    this.expandGroup((String)object2, element, null, vector, string2, element2);
                }
            } else {
                this.searchBook("*", "memberofgroup=" + string4, null, vector, string2, element2);
            }
            node = object.getNextSibling();
        } else {
            node = element2.getFirstChild();
        }
        while (node != null) {
            try {
                string4 = XPathTools.getValueByXPath((Node)node, (String)"entry/@entryID");
                if (string4 == null || string4.length() <= 0) {
                    throw new PStoreException(6, "checkAndExpandGroup: no entryID for entry");
                }
            }
            catch (XSLProcessingException xSLProcessingException) {
                throw new PStoreException(6, "checkExpandGroup: getValueByXPath returned " + xSLProcessingException.getMessage());
            }
            if (hashMap.get(string4) != null) {
                object2 = node;
                node = node.getNextSibling();
                element2.removeChild((Node)object2);
                continue;
            }
            hashMap.put(string4, node);
            if (((Element)node).getTagName().equals("group")) {
                object2 = null;
                object = null;
                try {
                    object2 = XPathTools.getValueByXPath((Node)node, (String)"email");
                    object = XPathTools.getValueByXPath((Node)node, (String)"entry/displayname");
                }
                catch (XSLProcessingException xSLProcessingException) {
                    throw new PStoreException(6, "checkExpandGroup: getValueByXPath returned " + xSLProcessingException.getMessage());
                }
                if (!this.hasXPathValue(node, string3)) {
                    vector2.add(node);
                }
            }
            node = node.getNextSibling();
        }
        object2 = null;
        object = vector2.elements();
        while (object.hasMoreElements()) {
            node = (Node)object.nextElement();
            if (string != null) {
                object2 = string;
            } else {
                try {
                    object2 = XPathTools.getValueByXPath((Node)node, (String)"memberofbook");
                    if (object2 == null || ((String)object2).length() <= 0) {
                        throw new PStoreException(6, "checkAndExpandGroup: no bookID for nested group:");
                    }
                }
                catch (XSLProcessingException xSLProcessingException) {
                    throw new PStoreException(6, "checkExpandGroup: getValueByXPath returned " + xSLProcessingException.getMessage());
                }
            }
            this.checkAndExpandGroups((Element)node, (String)object2, hashMap, vector, string2, string3, element2, document);
        }
    }

    private Entry getEntry(DBPlugin dBPlugin, String string, String string2, Element element) throws PStoreException {
        Logging.trace((int)32, (String)("getEntry : Got baseURL=" + string + "; entryID=" + string2 + ". Let's get it."));
        Document document = element.getOwnerDocument();
        try {
            dBPlugin.getEntry(this._user, string, string2, element, 0);
        }
        catch (piDbException piDbException2) {
            if (piDbException2.getReason() == 17) {
                throw new PStoreException(4, "getEntry No such entryID: " + piDbException2.getMessage());
            }
            if (piDbException2.getReason() == 29) {
                throw new PStoreException(21, "getEntry failed:" + piDbException2.getMessage());
            }
            throw new PStoreException(8, "getEntry failed: " + piDbException2.getMessage());
        }
        Element element2 = (Element)element.getLastChild();
        if (element2 == null) {
            return null;
        }
        Entry entry = null;
        String string3 = element2.getTagName();
        entry = "book".equals(string3) ? new Book(element2) : ("group".equals(string3) ? new Group(element2) : new Entry(element2));
        if (!string2.equals(((Entry)entry).getEntryID())) {
            return null;
        }
        Logging.trace((int)32, (String)"getEntry : Returning entry");
        return entry;
    }

    private void modifyEntry(PS_DBPlugin pS_DBPlugin, String string, String string2, Element element) throws PStoreException {
        this.modifyEntry(pS_DBPlugin, string, string2, element, false);
    }

    private void modifyEntry(PS_DBPlugin pS_DBPlugin, String string, String string2, Element element, boolean bl) throws PStoreException {
        Element element2 = null;
        try {
            element2 = (Element)XPathTools.getFirstNodeByXPath((Node)element, (String)"entry");
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new PStoreException(3, "modifyEntry: wrong XPATH:" + xSLProcessingException.getMessage());
        }
        if (element2 != null) {
            String string3 = null;
            try {
                string3 = XPathTools.getValueByXPath((Node)element, (String)"entry/@entryID");
            }
            catch (XSLProcessingException xSLProcessingException) {
                throw new PStoreException(3, "modifyEntry: wrong XPATH:" + xSLProcessingException.getMessage());
            }
            if (string3 == null || string3.length() <= 0) {
                element2.setAttribute("entryID", string2);
            }
        }
        try {
            pS_DBPlugin.modifyEntry(this._user, string, string2, element, 0, bl);
        }
        catch (piDbException piDbException2) {
            if (piDbException2.getReason() == 17) {
                throw new PStoreException(4, "modifyEntry: No such entryID:" + piDbException2.getMessage());
            }
            if (piDbException2.getReason() == 29) {
                throw new PStoreException(21, "modifyEntry failed:" + piDbException2.getMessage());
            }
            if (piDbException2.getReason() == 45) {
                throw new PStoreException(26);
            }
            throw new PStoreException(8, "modifyEntry failed:" + piDbException2.getMessage());
        }
    }

    private boolean removeMember(String string, Entry entry, Entry entry2) throws PStoreException {
        String[] stringArray = null;
        String string2 = null;
        String string3 = entry.getEntryID();
        boolean bl = false;
        if (entry instanceof Group) {
            stringArray = entry2.getGroupMembership();
            string2 = "memberofgroup";
        } else if (entry instanceof Book) {
            stringArray = entry2.getBookMembership();
            string2 = "memberofbook";
        } else {
            throw new PStoreException(6, "removeMember: unknown entry type for container:" + entry.getEntryID());
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string3.equals(stringArray[i])) continue;
                stringArray[i] = null;
                bl = true;
            }
        } else {
            Logging.trace((int)32, (String)("removeMember: entryID=" + entry2.getEntryID() + " has no membership of " + string3));
            return bl;
        }
        Element element = this.buildMembershipElement(entry2, string2, stringArray);
        this.modifyEntry(string, entry2.getEntryID(), element);
        return bl;
    }

    private void removeMembers(String string, Entry entry) throws PStoreException {
        String string2 = null;
        String string3 = entry.getEntryID();
        if (entry instanceof Group) {
            string2 = "memberofgroup";
        } else if (entry instanceof Book) {
            string2 = "memberofbook";
        } else {
            throw new PStoreException(6, "removeMembers: unknown entry type for container:" + entry.getEntryID());
        }
        Vector<String> vector = new Vector<String>();
        vector.add("entry");
        vector.add(string2);
        Document document = null;
        Element element = null;
        document = _domBuilder.newDocument();
        if (document == null) {
            throw new PStoreException(9, "removeMembers: Failed to create dummyDoc");
        }
        try {
            element = document.createElement("dummyElement");
            document.appendChild(element);
        }
        catch (DOMException dOMException) {
            throw new PStoreException(9, "removeMembers: Failed to append dummyElement to dummyDoc : " + dOMException.getMessage());
        }
        this.searchBook(string, string2 + "=" + string3, vector, null, null, element);
        for (Element element2 = (Element)element.getFirstChild(); element2 != null; element2 = (Element)element2.getNextSibling()) {
            Entry entry2 = new Entry(element2);
            this.removeMember(string, entry, entry2);
        }
    }

    private Element buildMembershipElement(Entry entry, String string, String[] stringArray) throws PStoreException {
        Document document = null;
        Element element = null;
        document = _domBuilder.newDocument();
        if (document == null) {
            throw new PStoreException(9, "buildMember: Failed to create dummyDoc");
        }
        Element element2 = entry.getEntryElement();
        if (element2 == null) {
            throw new PStoreException(9, "buildMember:Failed to get entry element");
        }
        try {
            element = document.createElement(element2.getTagName());
            document.appendChild(element);
        }
        catch (DOMException dOMException) {
            throw new PStoreException(9, "buildMember: Failed append tag " + element2.getTagName() + " : " + dOMException.getMessage());
        }
        CorePersonalStore.addMembershipElement(element, string, stringArray);
        return element;
    }

    private static void addMembershipElement(Element element, String string, String[] stringArray) throws PStoreException {
        Document document = element.getOwnerDocument();
        Node node = element.getFirstChild();
        try {
            Element element2 = null;
            Text text = null;
            boolean bl = false;
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                    bl = true;
                    element2 = document.createElement(string);
                    element.insertBefore(element2, node);
                    text = document.createTextNode(stringArray[i]);
                    element2.appendChild(text);
                }
            }
            if (!bl) {
                element2 = document.createElement(string);
                element.insertBefore(element2, node);
            }
        }
        catch (DOMException dOMException) {
            throw new PStoreException(9, "addMember: Failed append tag " + string + " : " + dOMException.getMessage());
        }
    }

    private static void removeMembershipElement(Element element, String string) throws PStoreException {
        try {
            ArrayList arrayList = XPathTools.getNodesByXPath((Node)element, (String)string);
            for (int i = 0; i < arrayList.size(); ++i) {
                Node node = (Node)arrayList.get(i);
                element.removeChild(node);
            }
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new PStoreException(3, "removeMember: Failed XPATH for " + string + " : " + xSLProcessingException.getMessage());
        }
        catch (DOMException dOMException) {
            throw new PStoreException(9, "removeMember: Failed removeChild " + string + " : " + dOMException.getMessage());
        }
    }

    private boolean isMemberOfGroup(String string, Group group, Entry entry) {
        String[] stringArray = entry.getGroupMembership();
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        String string2 = group.getEntryID();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equals(stringArray[i])) continue;
            return true;
        }
        Entry entry2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                entry2 = this.getEntry(string, stringArray[i]);
            }
            catch (PStoreException pStoreException) {
                continue;
            }
            if (!this.isMemberOfGroup(string, group, entry2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasXPathValue(Node node, String string) throws PStoreException {
        String string2 = null;
        if (string == null) {
            return false;
        }
        try {
            string2 = XPathTools.getValueByXPath((Node)node, (String)string);
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new PStoreException(3, "wrong XPATH: " + string + ":" + xSLProcessingException.getMessage());
        }
        return string2 != null && string2.length() > 0;
    }

    private Book getPSProfileBook() {
        Book[] bookArray = this._bookCache.listBooks("pbook");
        if (bookArray == null) {
            Logging.trace((int)32, (String)"no profile book defined");
            return null;
        }
        for (int i = 0; i < bookArray.length; ++i) {
            if (!"iPlanet Applications".equals(bookArray[i].getDisplayName())) continue;
            return bookArray[i];
        }
        Logging.trace((int)32, (String)"no iplanet profile book");
        return null;
    }

    private Element loadProfile(Book book, String string) throws PStoreException {
        Document document = _domBuilder.newDocument();
        Element element = document.createElement("docHanger");
        document.appendChild(element);
        Vector<String> vector = new Vector<String>(1);
        vector.add("profileinfo");
        String string2 = "entry/displayname=" + string;
        this.searchBook(book.getEntryID(), string2, (Vector)null, vector, null, element);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            return (Element)nodeList.item(i);
        }
        return null;
    }

    public String addProfile(Element element) throws PStoreException {
        if (this._profileBook == null) {
            return null;
        }
        String[] stringArray = new String[]{this._profileBook.getEntryID()};
        return this.addEntry(stringArray, element);
    }

    private static void checkFilter(String string, int n) throws PStoreException {
        int n2 = string.lastIndexOf("=");
        if (n2 == -1 || n2 == 0 || n2 == string.length() - 1) {
            throw new PStoreException(5, "checkFilter: bad filter: " + string);
        }
        String string2 = string.substring(n2 + 1);
        if (string2.equals("*") && n > 0) {
            throw new PStoreException(14, "checkFilter: wildcard not allowed in filter:" + string + ",Min char =" + n);
        }
        int n3 = string2.length();
        int n4 = string2.indexOf("*");
        int n5 = string2.lastIndexOf("*");
        if (n4 == -1 && n5 == -1) {
            return;
        }
        if (n4 == n5 && n4 == n3 - 1) {
            if (n3 - 1 < n) {
                throw new PStoreException(14, "checkFilter: wildcard not precise in filter:" + string + ",Min char =" + n);
            }
            return;
        }
        if (n4 == n5 && n4 == 0) {
            if (n3 - 1 < n) {
                throw new PStoreException(14, "checkFilter: wildcard not precise in filter:" + string + ",Min char =" + n);
            }
            return;
        }
        if (n4 == 0 && n5 == n3 - 1) {
            if (n3 - 2 < n) {
                throw new PStoreException(14, "checkFilter: wildcard not precise in filter:" + string + ",Min char =" + n);
            }
            return;
        }
    }

    private void checkDuplicate(String string, Element element, String string2) throws PStoreException {
        try {
            ArrayList arrayList;
            String string3 = XPathTools.getValueByXPath((Node)element, (String)"entry/displayname");
            if (string3 == null) {
                return;
            }
            String string4 = element.getNodeName();
            String[] stringArray = XPathTools.getValuesByXPath((Node)element, (String)"email");
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() <= 0 || this.isValidEmailAddress(stringArray[i])) continue;
                throw new PStoreException(22, "Invalid Email Address Encountered");
            }
            string3 = this.encodeString(string3, true);
            Vector<String> vector = new Vector<String>();
            vector.add("entry");
            vector.add("email");
            String string5 = null;
            String string6 = null;
            if (string3 != null) {
                string5 = "entry/displayname=" + string3;
                if (string4.equals("abperson") && (string6 = XPathTools.getValueByXPath((Node)element, (String)"email")) != null && string6.length() > 0 && string2.equals("ADD")) {
                    string5 = "&(" + string5 + ")(" + "email" + "=" + string6 + ")";
                }
            }
            Document document = _domBuilder.newDocument();
            Element element2 = document.createElement("dummyElement");
            document.appendChild(element2);
            try {
                string5 = URLEncoder.encode(string5, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new PStoreException(6, "Invalid filter character encoding");
            }
            this.searchBook("*", string5, vector, null, null, element2);
            String string7 = XPathTools.getValueByXPath((Node)element2, (String)"@totalentries");
            String string8 = XPathTools.getValueByXPath((Node)element2, (String)(string4 + "/entry/@entryID"));
            int n = Integer.parseInt(string7);
            if (n == 0) {
                return;
            }
            boolean bl = false;
            String string9 = element2.getFirstChild().getNodeName();
            if (n == 1 && string2.equals("MOD") && string != null && string.equals(string8)) {
                return;
            }
            if (n > 0 && string4.equals("abperson")) {
                arrayList = XPathTools.getNodesByXPath((Node)element2, (String)"abperson");
                for (int i = 0; i < arrayList.size(); ++i) {
                    Element element3 = (Element)arrayList.get(i);
                    String string10 = XPathTools.getValueByXPath((Node)element3, (String)"email[@priority='1']");
                    if (!this.isEqual(string6, string10)) continue;
                    if (string2.equals("MOD")) {
                        String string11 = XPathTools.getValueByXPath((Node)element3, (String)"entry/@entryID");
                        if (this.isEqual(string11, string)) continue;
                        bl = true;
                        break;
                    }
                    bl = true;
                    break;
                }
            }
            if (n > 0 && !string4.equals("abperson") && (arrayList = XPathTools.getNodesByXPath((Node)element2, (String)"group")) != null && (arrayList.size() > 0 && string2.equals("ADD") || arrayList.size() > 1 && string2.equals("MOD"))) {
                bl = true;
            }
            if (bl) {
                throw new PStoreException(19, string3, string8);
            }
        }
        catch (XSLProcessingException xSLProcessingException) {
            throw new PStoreException(3, "entry update failed:" + xSLProcessingException.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PStoreException(20, "entry update failed:" + numberFormatException.getMessage());
        }
    }

    public boolean isValidEmailAddress(String string) {
        if (null == string) {
            return false;
        }
        return new ValMailAddress().validate(string);
    }

    public void searchDeletedEntries(boolean bl) {
        this.searchdel = bl;
    }

    private boolean isEqual(String string, String string2) {
        return string != null && string.trim().length() > 0 && string2 != null && string2.trim().length() > 0 && string2.equalsIgnoreCase(string) || string == null && string2 == null || string != null && string.trim().length() == 0 && string2 == null || string2 != null && string2.trim().length() == 0 && string == null || string != null && string.trim().length() == 0 && string2 != null && string2.trim().length() == 0;
    }

    public String getUserID() {
        if (null == this._userID) {
            if (null == this._user) {
                Logging.error((int)32, (String)"UserSession is null");
            } else {
                Logging.trace((int)32, (String)"Getting userid from UserSession");
                this._userID = this._user.getUserId();
            }
        }
        Logging.trace((int)32, (String)("getUserID() = \"" + this._userID + "\""));
        return this._userID;
    }

    public String getFullyQualifiedUserID() {
        if (null == this._fullyQualifiedUserID) {
            if (null == this._user) {
                Logging.error((int)32, (String)"UserSession is null");
            } else {
                this._fullyQualifiedUserID = this.getUserID();
                Logging.trace((int)32, (String)"Getting user domain from UserSession");
                String string = this._user.getDomain();
                if (null != this._fullyQualifiedUserID && this._fullyQualifiedUserID.lastIndexOf("@") == -1 && null != string) {
                    this._fullyQualifiedUserID = this._fullyQualifiedUserID + "@" + string;
                }
            }
        }
        Logging.trace((int)32, (String)("getFullyQualifiedUserID() = \"" + this._fullyQualifiedUserID + "\""));
        return this._fullyQualifiedUserID;
    }

    public boolean checkPermissions(Entry entry, String string) {
        AddressBookACL addressBookACL;
        String string2 = this.getFullyQualifiedUserID();
        String string3 = this.getUserID();
        boolean bl = false;
        if (!(null == entry || null == (addressBookACL = entry.getACLObj()) || (bl = addressBookACL.checkPermissions(string3, string)) && addressBookACL.isUserPermExists(string3))) {
            bl = addressBookACL.checkPermissions(string2, string);
        }
        Logging.trace((int)32, (String)("checkPermissions(" + string3 + ", " + string + ")? " + bl));
        return bl;
    }

    public Element getACL(String string, String string2) throws PStoreException {
        Book book;
        if (string == null || string != null && string.length() == 0) {
            throw new PStoreException(28, " <entryid>");
        }
        Entry entry = this.getEntry(string);
        if (entry == null) {
            throw new PStoreException(4, string);
        }
        AddressBookACL addressBookACL = entry.getACLObj();
        Document document = _domBuilder.newDocument();
        Element element = document.createElement("docHanger");
        if (entry instanceof Book && (book = this.getBook(string)).isSubscribedBook()) {
            try {
                element.appendChild(_domBuilder.copyNode((Node)this.getPermission(book, string2), document));
            }
            catch (XMLProcessingException xMLProcessingException) {
                throw new PStoreException(9, xMLProcessingException.getMessage());
            }
            return element;
        }
        if (addressBookACL == null) {
            try {
                ABUtils.insertNode(element, "acl", "");
            }
            catch (DOMException dOMException) {
                throw new PStoreException(9, dOMException.getMessage());
            }
        }
        try {
            element.appendChild(_domBuilder.copyNode((Node)addressBookACL.toXml(), document));
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new PStoreException(9, xMLProcessingException.getMessage());
        }
        ABUtils.insertNode(element, "rights", "rwdca");
        return element;
    }

    public Element getPermission(Entry entry, String string) throws PStoreException {
        if (entry == null) {
            throw new PStoreException(4);
        }
        AddressBookACL addressBookACL = entry.getACLObj();
        Document document = _domBuilder.newDocument();
        Element element = null;
        String string2 = entry.getEntryID();
        String string3 = null;
        String string4 = string;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        if (null == this._user) {
            Logging.error((int)32, (String)"UserSession is null");
        }
        string7 = this._user.getDomain();
        if (string4.lastIndexOf("@") != -1) {
            string6 = string4.substring(0, string4.indexOf("@"));
            string5 = string4.substring(string4.indexOf("@") + 1);
        }
        if (string5 == null) {
            string3 = string4 + "@" + string7;
        }
        if (entry instanceof Book) {
            Book book = this.getBook(string2);
            if (addressBookACL != null) {
                String string8 = null;
                if (string4.lastIndexOf("@") != -1) {
                    string8 = addressBookACL.getPermissions(string4);
                    if ((string8 == null || string8 != null && string8.length() == 0 || !addressBookACL.isUserPermExists(string4)) && string5.equals(string7)) {
                        string8 = addressBookACL.getPermissions(string6);
                    }
                } else if (string4.lastIndexOf("@") == -1 && ((string8 = addressBookACL.getPermissions(string4)) == null || string8 != null && string8.length() == 0 || !addressBookACL.isUserPermExists(string4))) {
                    string8 = addressBookACL.getPermissions(string3);
                }
                if (string8 != null) {
                    element = ABUtils.getNode(document, "rights", string8);
                    return element;
                }
            }
            element = ABUtils.getNode(document, "rights", "");
        }
        return element;
    }

    public Hashtable purgeAll(int n) throws PStoreException {
        Hashtable hashtable = null;
        try {
            hashtable = this._userDB.purgeAllUserContacts(this._user, n);
        }
        catch (piDbException piDbException2) {
            throw new PStoreException(8, "purgeAll failed:" + piDbException2.getMessage());
        }
        return hashtable;
    }

    public int purgeEntries(String string, boolean bl, int n, int n2) throws PStoreException {
        int n3 = 0;
        Book book = this.getBook(string);
        if (book == null) {
            throw new PStoreException(6, "purgeEntries: invalid bookEntryID");
        }
        PS_DBPlugin pS_DBPlugin = null;
        String string2 = book.getBookRemoteURL();
        if (string2 != null) {
            throw new PStoreException(16, "purgeEntries: readonly book for " + string2);
        }
        string2 = this._psRoot;
        pS_DBPlugin = this._userDB;
        try {
            n3 = pS_DBPlugin.purgeEntries(this._user, string2, bl, n, n2);
        }
        catch (piDbException piDbException2) {
            if (piDbException2.getReason() == 17) {
                throw new PStoreException(4, "No such entryID:" + piDbException2.getMessage());
            }
            if (piDbException2.getReason() == 29) {
                throw new PStoreException(21, "purge Entries failed:" + piDbException2.getMessage());
            }
            throw new PStoreException(8, "purgeEntries failed:" + piDbException2.getMessage());
        }
        return n3;
    }

    private String encodeString(String string, boolean bl) {
        String string2 = new String();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '(': {
                    string2 = string2 + "\\(";
                    continue block7;
                }
                case ')': {
                    string2 = string2 + "\\)";
                    continue block7;
                }
                case '\\': {
                    string2 = string2 + "\\\\";
                    continue block7;
                }
                case '*': {
                    string2 = string2 + "\\2a";
                    continue block7;
                }
                case '=': {
                    string2 = string2 + "\\3d";
                    continue block7;
                }
                default: {
                    string2 = string2 + c;
                }
            }
        }
        return string2;
    }

    public void disconnect() throws PStoreException {
    }

    private PS_DBPlugin getPS_DBPluginFromURL(String string, String string2) throws PStoreException {
        DBPlugin dBPlugin = null;
        DBPluginMap dBPluginMap = null;
        boolean bl = false;
        dBPlugin = (DBPlugin)this._searchDbMap.get(string);
        if (string2 == null) {
            return null;
        }
        dBPluginMap = this._dbHandler.getDBPluginMapFromURL(string2);
        if (dBPluginMap == null) {
            Logging.trace((int)32, (String)("couldn't get DBPluginMap for " + string2));
            throw new PStoreException(1, "couldn't get DB for " + string2);
        }
        if (null == dBPlugin) {
            dBPlugin = dBPluginMap.getDBPlugin();
            bl = true;
        }
        if (null != dBPlugin) {
            if (bl) {
                this._searchDbMap.put(string, dBPlugin);
            }
        } else {
            Logging.error((int)32, (String)("couldn't get DB for " + string));
            throw new PStoreException(1, "couldn't get DB for " + string);
        }
        return (PS_DBPlugin)dBPlugin;
    }

    static {
        try {
            _domBuilder = new XMLDOMBuilder(Logging.getLogHandler());
        }
        catch (XMLProcessingException xMLProcessingException) {
            // empty catch block
        }
    }
}

