/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.coresrv;

import com.iplanet.iabs.coresrv.DBHandler;
import com.iplanet.iabs.coresrv.DBPluginMap;
import com.iplanet.iabs.dbinterface.PS_DBPlugin;
import com.iplanet.iabs.dbinterface.piDbException;
import com.iplanet.iabs.iabsapi.Book;
import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.iabs.iabsutil.ABUtils;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.tools.Comparer;
import com.iplanet.xslui.tools.QuickSort;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BookCache {
    private static XMLDOMBuilder _domBuilder = null;
    private DBHandler _dbHandler = null;
    private HashMap _bookTable = null;
    private HashMap _listBookTable = null;
    private Set _missingBooks;
    private String _psRoot = null;
    private PS_DBPlugin _userDB = null;
    private DBPluginMap _localDBPluginMap = null;
    private UserSession _user;
    private boolean _requireSync = false;
    private static final transient String LOCAL_STORE_URL = "ldap://";

    public BookCache(UserSession userSession, String string, DBHandler dBHandler) throws PStoreException {
        this._user = userSession;
        this._psRoot = string;
        this._dbHandler = dBHandler;
        this._localDBPluginMap = this._dbHandler.getDBPluginMapFromURL(this._psRoot);
        this._userDB = this._localDBPluginMap.getPSDBPlugin(this._psRoot);
        this.loadBookList();
        this._listBookTable = new HashMap();
    }

    public Book[] listBooks(String string) {
        Book[] bookArray = (Book[])this._listBookTable.get(string);
        if (bookArray != null) {
            return bookArray;
        }
        ArrayList<Book> arrayList = new ArrayList<Book>();
        Book book = null;
        Iterator iterator = this._bookTable.values().iterator();
        while (iterator.hasNext()) {
            book = (Book)iterator.next();
            if (!string.equals(book.getBookType())) continue;
            arrayList.add(book);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        QuickSort.sort(arrayList, (Comparer)new BookComparer(), null);
        bookArray = arrayList.toArray(new Book[0]);
        this._listBookTable.put(string, bookArray);
        return bookArray;
    }

    public Book getBook(String string) {
        return (Book)this._bookTable.get(string);
    }

    public void reset() throws PStoreException {
        this.loadBookList();
        this._listBookTable.clear();
    }

    public boolean isBookMembershipValid(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this._bookTable.get(stringArray[i]) != null) continue;
            return false;
        }
        return true;
    }

    public void loadBookList() throws PStoreException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Hashtable hashtable = (Hashtable)this._dbHandler.getDBPluginMaps().clone();
        if (hashtable != null) {
            this._missingBooks = hashtable.keySet();
        }
        if (this._missingBooks.contains(LOCAL_STORE_URL)) {
            this._missingBooks.remove(LOCAL_STORE_URL);
        }
        Document document = _domBuilder.newDocument();
        Element element = document.createElement("docHanger");
        document.appendChild(element);
        Vector<String> vector = new Vector<String>(1);
        vector.add("book");
        try {
            this._userDB.search(this._user, this._psRoot, "entry/displayname=*", null, null, vector, element, 0);
        }
        catch (piDbException piDbException2) {
            throw new PStoreException(8, "BookCache: search failed:" + piDbException2.getMessage());
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element2 = (Element)nodeList.item(i);
            String string = null;
            String string2 = null;
            try {
                string2 = XPathTools.getValueByXPath((Node)element2, (String)"entry/@entryID");
                string = XPathTools.getValueByXPath((Node)element2, (String)"@bookremoteurl");
            }
            catch (XSLProcessingException xSLProcessingException) {
                throw new PStoreException(3, "BookCache: wrong XPATH: " + xSLProcessingException.getMessage());
            }
            if (string2 == null || string2.length() <= 0) {
                throw new PStoreException(3, "BookCache:no entryID found in book");
            }
            if (string == null) {
                String string3 = this.getBookURL(this._user, string2);
                element2.setAttribute("bookurl", string3);
                object = document.createElement("owner");
                String string4 = this._user.getUserAttrib("cn");
                String string5 = this._user.getUserAttrib("uid");
                String string6 = "rwdca";
                ABUtils.insertNode((Element)object, "displayname", string4);
                ABUtils.insertNode((Element)object, "uid", string5);
                String string7 = this._user.getUserAttrib("email");
                ABUtils.insertNode((Element)object, "email", string7);
                element2.appendChild((Node)object);
                ABUtils.insertNode(element2, "rights", string6);
            }
            int n = this._localDBPluginMap.getMinWildcardSearch();
            if (string != null) {
                if (string.startsWith("ps:///")) {
                    element2.setAttribute("subscribed", "1");
                } else {
                    object = this._dbHandler.getDBPluginMapFromURL(string);
                    if (object == null) continue;
                    n = ((DBPluginMap)object).getMinWildcardSearch();
                    boolean bl = ((DBPluginMap)object).isCorporateDir();
                    if (bl) {
                        element2.setAttribute("corporatedir", "true");
                    }
                }
                if (this._missingBooks.contains(string)) {
                    this._missingBooks.remove(string);
                }
            }
            element2.setAttribute("wildcardsearch", String.valueOf(n));
            object = new Book(element2);
            hashMap.put(string2, object);
        }
        this._bookTable = hashMap;
    }

    public void loadBook(String string, String string2, Properties properties) throws PStoreException {
        Book book = (Book)this._bookTable.get(string);
        if (string2 == null) {
            this._bookTable.remove(string);
        } else {
            Object object;
            String string3;
            Vector<String> vector = new Vector<String>(1);
            vector.add("book");
            DBPluginMap dBPluginMap = this._dbHandler.getDBPluginMapFromURL(string2);
            if (dBPluginMap == null) {
                throw new PStoreException(1, "CorePersonalStore: couldn't get DB for " + string2);
            }
            PS_DBPlugin pS_DBPlugin = dBPluginMap.getPSDBPlugin(string2);
            Document document = _domBuilder.newDocument();
            Element element = document.createElement("docHanger");
            try {
                pS_DBPlugin.search(this._user, string2, "entry/@entryID=" + string, null, null, vector, element, 0);
            }
            catch (piDbException piDbException2) {
                throw new PStoreException(8, "BookCache: search failed:" + piDbException2.getMessage());
            }
            NodeList nodeList = element.getElementsByTagName("book");
            if (nodeList.getLength() == 0) {
                throw new PStoreException(33, "<" + string + ">");
            }
            Element element2 = (Element)nodeList.item(0);
            Element element3 = book.getEntryElement();
            try {
                _domBuilder.copyAttributes(element3, element2);
            }
            catch (XMLProcessingException xMLProcessingException) {
                throw new PStoreException(9, "Can't obtain the actual book entry");
            }
            String string4 = this._user.getUserId();
            String string5 = this._user.getDomain();
            String string6 = string4;
            if (null != string5) {
                string6 = string4 + "@" + string5;
            }
            String string7 = string3 = properties != null ? properties.getProperty("uid@domain") : null;
            if (string3 != null && !string6.equalsIgnoreCase(string3)) {
                String string8;
                object = document.createElement("owner");
                String string9 = string8 = properties != null ? properties.getProperty("cn") : null;
                if (string8 != null) {
                    ABUtils.insertNode((Element)object, "displayname", string8);
                }
                String string10 = properties != null ? properties.getProperty("uid") : null;
                ABUtils.insertNode((Element)object, "uid", string10);
                String string11 = properties != null ? properties.getProperty("mail") : null;
                ABUtils.insertNode((Element)object, "email", string11);
                element2.appendChild((Node)object);
            }
            book = new Book(element2);
            ABUtils.replaceACLWithRights(element2, string4, string6);
            object = null;
            if (properties != null) {
                book.setExtraInfo(properties);
                object = properties.getProperty("psroot");
                if (object != null) {
                    book.setSubscribedUrl((String)object);
                }
            }
            this._bookTable.put(string, book);
        }
        this._listBookTable.clear();
        this.listBooks("abook");
    }

    public Set getMissingDBPluginMaps() {
        return this._missingBooks;
    }

    private String getBookURL(UserSession userSession, String string) {
        String string2 = this._dbHandler.getPsURLPrefix() + ":///" + userSession.getDomain() + "/" + userSession.getUserId() + "/" + string;
        return string2;
    }

    static {
        try {
            _domBuilder = new XMLDOMBuilder(Logging.getLogHandler());
        }
        catch (XMLProcessingException xMLProcessingException) {
            Logging.error((int)32, (String)("Couldn't create XMLDOMBuilder: " + xMLProcessingException.getMessage()));
        }
    }

    private class BookComparer
    implements Comparer {
        private BookComparer() {
        }

        public int compare(Object object, Object object2, Object object3) {
            Book book = (Book)object2;
            Book book2 = (Book)object3;
            String string = book.getDisplayName();
            String string2 = book2.getDisplayName();
            if (string != null) {
                return string.compareTo(string2);
            }
            return -1;
        }
    }
}

