/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.Attach;
import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.PropertiesException;
import com.sun.comclient.calendar.RecurrencePattern;
import com.sun.comclient.calendar.socs.SOCSAlarm;
import com.sun.comclient.calendar.socs.SOCSAttendee;
import com.sun.comclient.calendar.socs.SOCSOrganizer;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TimeZone;

public class SOCSUtils {
    private static final int MINUTE_2_SECONDS = 60;
    private static final int HOUR_2_MINUTES = 60;
    private static final int HOUR_2_SECONDS = 3600;
    private static final int DAY_2_HOURS = 24;
    private static final int DAY_2_MINUTES = 1440;
    private static final int DAY_2_SECONDS = 86400;
    private static final int WEEK_2_DAYS = 7;
    private static final int WEEK_2_HOURS = 168;
    private static final int WEEK_2_MINUTES = 10080;
    private static final int WEEK_2_SECONDS = 604800;
    private static final int NEGATIVE_SIGN = -1;
    private static final int POSITIVE_SIGN = 1;
    static BitSet dontEncode;
    static final int caseDiff = 32;

    public static long toSeconds(Duration duration) {
        if (null == duration) {
            return 0L;
        }
        return duration.getSign() * (duration.getSeconds() + duration.getMinutes() * 60 + duration.getHours() * 3600 + duration.getDays() * 86400 + duration.getWeeks() * 604800);
    }

    public static Duration toDuration(long l) throws PropertiesException {
        int n = 1;
        if (0L > l) {
            l = -1L * l;
            n = -1;
        }
        int n2 = (int)l % 60;
        int n3 = (int)((l -= (long)n2) % 3600L) / 60;
        int n4 = (int)((l -= (long)(n3 * 60)) % 86400L) / 3600;
        int n5 = (int)(l -= (long)(n4 * 3600)) / 86400;
        Duration duration = new Duration(n5, n4, n3, n2);
        duration.setSign(n);
        return duration;
    }

    public static DateTime toEndDate(DateTime dateTime, Duration duration) {
        if (null == dateTime || null == duration) {
            return null;
        }
        DateTime dateTime2 = (DateTime)dateTime.clone();
        int n = duration.getSign();
        dateTime2.add(3, n * duration.getWeeks());
        dateTime2.add(6, n * duration.getDays());
        dateTime2.add(11, n * duration.getHours());
        dateTime2.add(12, n * duration.getMinutes());
        dateTime2.add(13, n * duration.getSeconds());
        return dateTime2;
    }

    public static Duration toDuration(DateTime dateTime, DateTime dateTime2) throws PropertiesException {
        if (null == dateTime || null == dateTime2) {
            return null;
        }
        long l = dateTime.getTime().getTime() - dateTime2.getTime().getTime();
        long l2 = l / 1000L;
        return SOCSUtils.toDuration(l2);
    }

    public static String urlEncode(String string) {
        String string2 = null;
        if (string == null) {
            return string;
        }
        try {
            string2 = SOCSUtils.URLEncodeField(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
        return string2;
    }

    public static Attach parseToAttach(Properties properties) {
        Attach attach = new Attach();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string.equals("FMTTYPE")) {
                attach.setFileType(string2);
                continue;
            }
            if (!string.equals("VALUE")) continue;
            attach.setValue(string2);
        }
        return attach;
    }

    public static Attendee parseToAttendee(Properties properties) throws PropertiesException {
        SOCSAttendee sOCSAttendee = new SOCSAttendee();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string.equals("ROLE")) {
                sOCSAttendee.setRole(string2);
                continue;
            }
            if (string.equals("CUTYPE")) {
                sOCSAttendee.setUserType(string2);
                continue;
            }
            if (string.equals("PARTSTAT")) {
                sOCSAttendee.setParticipantStatus(string2);
                continue;
            }
            if (string.equals("CN")) {
                sOCSAttendee.setCommonName(string2);
                continue;
            }
            if (string.equals("RSVP")) {
                if (string2.equalsIgnoreCase("TRUE")) {
                    sOCSAttendee.setRSVPRequired(true);
                    continue;
                }
                sOCSAttendee.setRSVPRequired(false);
                continue;
            }
            if (string.equals("DELEGATED-FROM")) {
                sOCSAttendee.setDelegatedFrom(string2);
                continue;
            }
            if (string.equals("DELEGATED-TO")) {
                sOCSAttendee.setDelegatedTo(string2);
                continue;
            }
            if (string.equals("LANGUAGE")) {
                sOCSAttendee.setLanguage(string2);
                continue;
            }
            if (string.equals("SENTBY")) {
                sOCSAttendee.setSentBy(string2);
                continue;
            }
            if (string.equals("DIR")) {
                sOCSAttendee.setDir(string2);
                continue;
            }
            if (string.equals("MEMBER")) {
                sOCSAttendee.setMember(string2);
                continue;
            }
            if (string.equals("ATTENDEE")) {
                sOCSAttendee.setValue(string2);
                continue;
            }
            if (!string.equals("X-S1CS-EMAIL")) continue;
            sOCSAttendee.setEmail(string2);
        }
        return sOCSAttendee;
    }

    public static String parseAttendeeToSOCS(Attendee attendee) throws PropertiesException {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = attendee.getRole();
        if (null != string) {
            stringBuffer.append("ROLE=" + string + "^");
        }
        if (null != (string = attendee.getUserType())) {
            stringBuffer.append("CUTYPE=" + string + "^");
        }
        if (null == (string = attendee.getParticipantStatus())) {
            PropertiesException propertiesException = new PropertiesException(3);
            throw propertiesException;
        }
        stringBuffer.append("PARTSTAT=" + string + "^");
        string = attendee.getCommonName();
        if (null != string) {
            stringBuffer.append("CN=" + SOCSUtils.urlEncode(string) + "^");
        }
        if (attendee.isRSVPRequired()) {
            stringBuffer.append("RSVP=TRUE^");
        } else {
            stringBuffer.append("RSVP=FALSE^");
        }
        string = attendee.getDelegatedFrom();
        if (null != string) {
            stringBuffer.append("DELEGATED-FROM=" + SOCSUtils.urlEncode(string) + "^");
        }
        if (null != (string = attendee.getDelegatedTo())) {
            stringBuffer.append("DELEGATED-TO=" + SOCSUtils.urlEncode(string) + "^");
        }
        if (null != (string = attendee.getLanguage())) {
            stringBuffer.append("LANGUAGE=" + SOCSUtils.urlEncode(string) + "^");
        }
        if (null != (string = attendee.getSentBy())) {
            stringBuffer.append("SENTBY=" + SOCSUtils.urlEncode(string) + "^");
        }
        if (null != (string = attendee.getDir())) {
            stringBuffer.append("DIR=" + SOCSUtils.urlEncode(string) + "^");
        }
        if (null != (string = attendee.getMember())) {
            stringBuffer.append("MEMBER=" + SOCSUtils.urlEncode(string) + "^");
        }
        if (null == (string = attendee.getValue())) {
            PropertiesException propertiesException = new PropertiesException(3);
            throw propertiesException;
        }
        stringBuffer.append(SOCSUtils.urlEncode(string));
        return stringBuffer.toString();
    }

    public static Organizer parseToOrganizer(Properties properties) {
        SOCSOrganizer sOCSOrganizer = new SOCSOrganizer();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string.equals("CN")) {
                sOCSOrganizer.setCommonName(string2);
                continue;
            }
            if (string.equals("LANGUAGE")) {
                sOCSOrganizer.setLanguage(string2);
                continue;
            }
            if (string.equals("X-NSCP-ORGANIZER-SENT-BY-UID")) {
                sOCSOrganizer.setSentBy(string2);
                continue;
            }
            if (string.equals("X-NSCP-ORGANIZER-UID")) {
                sOCSOrganizer.setDir(string2);
                continue;
            }
            if (string.equals("X-S1CS-EMAIL")) {
                sOCSOrganizer.setEmail(string2);
                continue;
            }
            if (!string.equals("ORGANIZER")) continue;
            sOCSOrganizer.setValue(string2);
        }
        return sOCSOrganizer;
    }

    public static SOCSAlarm parseToVAlarm(Properties properties) throws PropertiesException {
        SOCSAlarm sOCSAlarm = new SOCSAlarm();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            Cloneable cloneable;
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string.equals("DESC")) {
                sOCSAlarm.setDescription(string2);
                continue;
            }
            if (string.equals("ACTION")) {
                sOCSAlarm.setAction(string2);
                continue;
            }
            if (string.equals("ATTENDEE")) {
                Object object2 = properties.get(string);
                if (!(object2 instanceof ArrayList)) continue;
                cloneable = (ArrayList)object2;
                int n = ((ArrayList)cloneable).size();
                for (int i = 0; i < n; ++i) {
                    object = (Properties)((ArrayList)cloneable).get(i);
                    Attendee attendee = SOCSUtils.parseToAttendee((Properties)object);
                    sOCSAlarm.addAttendee(attendee);
                }
                continue;
            }
            if (!string.equals("TRIGGER")) continue;
            boolean bl = false;
            cloneable = (Properties)properties.get(string);
            Enumeration<?> enumeration2 = ((Properties)cloneable).propertyNames();
            while (enumeration2.hasMoreElements()) {
                String string3 = (String)enumeration2.nextElement();
                object = ((Properties)cloneable).getProperty(string3);
                if (string3.equals("VALUE")) {
                    if (((String)object).equals("DATE-TIME")) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (!string3.equals("TRIGGER")) continue;
                if (bl) {
                    sOCSAlarm.setAbsTrigger((String)object);
                    continue;
                }
                sOCSAlarm.setTrigger(new Duration((String)object));
            }
        }
        return sOCSAlarm;
    }

    public static String parseRecurrencePatternToSOCS(RecurrencePattern recurrencePattern) {
        String string = "\"" + SOCSUtils.urlEncode(recurrencePattern.generatePattern()) + "\"";
        return string;
    }

    public static boolean isDateAllDay(String string) {
        int n = string.indexOf("T");
        return n <= 0;
    }

    public static boolean isUserOrganizer(String string, Organizer organizer) {
        if (organizer == null) {
            return true;
        }
        String string2 = organizer.getValue().trim();
        return string.trim().equals(string2);
    }

    public static boolean isBitSet(int n, int n2) {
        return 0 != (n & n2);
    }

    public static int getSOCSStatus(String string) {
        if ((string = string.toUpperCase()).equals("CONFIRMED")) {
            return 0;
        }
        if (string.equals("CANCELLED")) {
            return 1;
        }
        if (string.equals("TENTATIVE")) {
            return 2;
        }
        if (string.equals("NEEDS-ACTION")) {
            return 3;
        }
        if (string.equals("COMPLETED")) {
            return 4;
        }
        if (string.equals("IN-PROCESS")) {
            return 5;
        }
        if (string.equals("DRAFT")) {
            return 6;
        }
        if (string.equals("FINAL")) {
            return 7;
        }
        return 0;
    }

    public static int getSOCSTransp(String string) {
        if ((string = string.toUpperCase()).equals("OPAQUE")) {
            return 0;
        }
        if (string.equals("TRANSPARENT")) {
            return 1;
        }
        return 0;
    }

    public static String URLEncodeField(String string, String string2) throws UnsupportedEncodingException {
        int n = string.length();
        byte[] byArray = string.getBytes(string2);
        StringBuffer stringBuffer = new StringBuffer(n * 4);
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i] & 0xFF;
            if (dontEncode.get(n2)) {
                if (n2 == 32) {
                    n2 = 43;
                }
                stringBuffer.append((char)n2);
                continue;
            }
            stringBuffer.append('%');
            char c = Character.forDigit(n2 >> 4 & 0xF, 16);
            if ('a' <= c && c <= 'f') {
                c = (char)(c - 32);
            }
            stringBuffer.append(c);
            c = Character.forDigit(n2 & 0xF, 16);
            if ('a' <= c && c <= 'f') {
                c = (char)(c - 32);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static DateTime parseToAllDayDateTime(String string, TimeZone timeZone) {
        if (string == null || timeZone == null) {
            return null;
        }
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(4, 6)) - 1;
        int n3 = Integer.parseInt(string.substring(6, 8));
        DateTime dateTime = new DateTime(timeZone);
        dateTime.set(n, n2, n3);
        return dateTime;
    }

    public static String parseAllDayDateTimeToSOCS(DateTime dateTime) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = dateTime.getYear();
        int n2 = dateTime.getMonth() + 1;
        int n3 = dateTime.getDay();
        stringBuffer.append(n);
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3);
        return stringBuffer.toString();
    }

    public static String trim(String string) {
        if (string == null) {
            return string;
        }
        for (string = string.trim(); string != null && string.startsWith("\n"); string = string.substring(1)) {
        }
        while (string != null && string.endsWith("\n")) {
            string = string.substring(0, string.length());
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int versionToInt(String string) throws NumberFormatException {
        int n = 0;
        if (string == null) throw new NumberFormatException();
        if (string.length() <= 0) throw new NumberFormatException();
        char[] cArray = string.toCharArray();
        if (cArray == null) throw new NumberFormatException();
        if (cArray.length <= 0) throw new NumberFormatException();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '.') continue;
            ++n;
        }
        char[] cArray2 = new char[cArray.length - n];
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '.') continue;
            cArray2[n2] = cArray[i];
            ++n2;
        }
        if (cArray2 == null) throw new NumberFormatException();
        if (cArray2.length <= 0) throw new NumberFormatException();
        String string2 = String.valueOf(cArray2);
        string2.trim();
        return Integer.parseInt(string2);
    }

    static {
        int n;
        dontEncode = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            dontEncode.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            dontEncode.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            dontEncode.set(n);
        }
        dontEncode.set(32);
        dontEncode.set(45);
        dontEncode.set(95);
        dontEncode.set(46);
        dontEncode.set(42);
    }
}

