/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.comclient.calendar.socs.SOCSCalendarStore;
import com.sun.comclient.calendar.socs.SOCSException;
import com.sun.comclient.calendar.socs.SOCSRequest;
import com.sun.comclient.calendar.socs.SOCSResponse;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class SOCSSession {
    private SOCSCalendarStore calStore;
    private String sessionID;
    private String userID;
    private String calendarID;
    private Properties userPrefs;
    private Properties serverPrefs;
    private TimeZone timezone;
    private String userName;
    private String password;
    private String proxyUser;
    private String applyAuthFilter;

    public static SOCSSession getInstance(SOCSCalendarStore sOCSCalendarStore) {
        return new SOCSSession(sOCSCalendarStore, null, null, null, null, null, null);
    }

    private SOCSSession(SOCSCalendarStore sOCSCalendarStore, String string, String string2, String string3, String string4, String string5, String string6) {
        this.calStore = sOCSCalendarStore;
        this.sessionID = string;
        this.userID = string2;
        this.calendarID = string3;
        this.userName = string4;
        this.password = string5;
        this.proxyUser = string6;
    }

    private SOCSSession(SOCSCalendarStore sOCSCalendarStore, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.calStore = sOCSCalendarStore;
        this.sessionID = string;
        this.userID = string2;
        this.calendarID = string3;
        this.userName = string4;
        this.password = string5;
        this.proxyUser = string6;
        this.applyAuthFilter = string7;
    }

    public static SOCSSession login(SOCSCalendarStore sOCSCalendarStore, String string, String string2, String string3) throws CalendarException {
        SOCSSession sOCSSession;
        SOCSRequest sOCSRequest = new SOCSRequest(sOCSCalendarStore);
        try {
            SOCSResponse sOCSResponse = sOCSRequest.login(string, string2, string3);
            Properties properties = sOCSResponse.getProperties(0);
            sOCSSession = new SOCSSession(sOCSCalendarStore, properties.getProperty("SESSION-ID"), properties.getProperty("USER-ID"), properties.getProperty("CALENDAR-ID"), string, string2, string3);
            sOCSSession.refresh();
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        return sOCSSession;
    }

    public static SOCSSession login(SOCSCalendarStore sOCSCalendarStore, String string, String string2, String string3, String string4) throws CalendarException {
        SOCSSession sOCSSession;
        SOCSRequest sOCSRequest = new SOCSRequest(sOCSCalendarStore);
        try {
            SOCSResponse sOCSResponse = sOCSRequest.login(string, string2, string3, string4);
            Properties properties = sOCSResponse.getProperties(0);
            sOCSSession = new SOCSSession(sOCSCalendarStore, properties.getProperty("SESSION-ID"), properties.getProperty("USER-ID"), properties.getProperty("CALENDAR-ID"), string, string2, string3, string4);
            sOCSSession.refresh();
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        return sOCSSession;
    }

    void validate() throws SOCSException {
        URL uRL = this.calStore.getServiceURL();
        SOCSRequest sOCSRequest = new SOCSRequest(uRL, this);
        SOCSResponse sOCSResponse = this.applyAuthFilter != null ? sOCSRequest.login(this.userName, this.password, this.proxyUser, this.applyAuthFilter) : sOCSRequest.login(this.userName, this.password, this.proxyUser);
        Properties properties = sOCSResponse.getProperties(0);
        this.sessionID = properties.getProperty("SESSION-ID");
    }

    public void logout() {
        SOCSRequest sOCSRequest = new SOCSRequest(this);
        try {
            SOCSResponse sOCSResponse = sOCSRequest.logout();
        }
        catch (SOCSException sOCSException) {
            return;
        }
        this.calStore = null;
        this.sessionID = null;
        this.userID = null;
        this.calendarID = null;
        this.userPrefs = null;
        this.serverPrefs = null;
        this.userName = null;
        this.password = null;
        this.proxyUser = null;
    }

    public boolean isValid() {
        SOCSResponse sOCSResponse;
        SOCSRequest sOCSRequest = new SOCSRequest(this);
        try {
            sOCSResponse = sOCSRequest.isSOCSSessionValid();
        }
        catch (SOCSException sOCSException) {
            return false;
        }
        String string = null;
        Properties properties = sOCSResponse.getProperties(0);
        if (properties == null || properties.isEmpty()) {
            return false;
        }
        string = properties.getProperty("CHECK-ID");
        if (string == null) {
            return false;
        }
        return string.equals("1");
    }

    public void refresh() throws CalendarException {
        SOCSResponse sOCSResponse;
        if (this.calStore == null) {
            throw new IllegalStateException("SOCSSession has been closed");
        }
        SOCSRequest sOCSRequest = new SOCSRequest(this);
        try {
            sOCSResponse = sOCSRequest.getUserPrefs();
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
        this.userPrefs = sOCSResponse.getProperties(2);
        this.serverPrefs = sOCSResponse.getProperties(3);
        if (this.getPreference("icsTimezone") != null) {
            TimeZone timeZone = TimeZone.getTimeZone(this.getPreference("icsTimezone").trim());
            this.setTimeZone(timeZone);
        }
    }

    public void update() throws CalendarException {
        if (this.calStore == null) {
            throw new IllegalStateException("SOCSSession has been closed");
        }
        SOCSRequest sOCSRequest = new SOCSRequest(this);
        try {
            SOCSResponse sOCSResponse = sOCSRequest.setUserPrefs(this.userPrefs);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarException(sOCSException.getMessage(), sOCSException.getError());
        }
    }

    public String getDefaultCalendar() {
        return this.calendarID;
    }

    public SOCSCalendarStore getCalStore() {
        return this.calStore;
    }

    public String getID() {
        return this.sessionID;
    }

    public String getUserName() {
        return this.userID;
    }

    public String getCalendarID() {
        return this.calendarID;
    }

    public String getPreference(String string) {
        return this.userPrefs == null ? null : this.userPrefs.getProperty(string);
    }

    public Properties getPreferences() {
        return this.userPrefs;
    }

    public void setPreferences(Properties properties) {
        this.userPrefs = properties;
    }

    public String getServerPreference(String string) {
        return this.serverPrefs == null ? null : this.serverPrefs.getProperty(string);
    }

    public Properties getServerPreferences() {
        return this.serverPrefs;
    }

    public void setServerPreferences(Properties properties) {
        this.serverPrefs = properties;
    }

    public TimeZone getTimeZone() {
        if (this.timezone == null) {
            this.timezone = TimeZone.getDefault();
        }
        return this.timezone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timezone = timeZone;
    }

    public String toString() {
        return "SOCSSession[sessionID=" + this.sessionID + " userID=" + this.userID + " calendarID=" + this.calendarID + "]";
    }

    public Vector getSubscribedCalendars() {
        Vector<SOCSCalendar> vector = new Vector<SOCSCalendar>();
        if (this.userPrefs == null) {
            return vector;
        }
        String string = this.userPrefs.getProperty("icsSubscribed");
        if (string == null) {
            return vector;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            SOCSCalendar sOCSCalendar = null;
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "$");
            String string3 = "";
            Object var9_9 = null;
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string4 = stringTokenizer2.nextToken();
            if (stringTokenizer2.hasMoreTokens()) {
                string3 = stringTokenizer2.nextToken();
            }
            sOCSCalendar = new SOCSCalendar(this.getCalStore(), string4, string3);
            vector.addElement(sOCSCalendar);
        }
        return vector;
    }

    public Vector getSubscribedGroups() {
        Vector<SOCSCalendar> vector = new Vector<SOCSCalendar>();
        try {
            if (this.userPrefs == null) {
                return vector;
            }
            String string = this.userPrefs.getProperty("icsSet");
            if (string == null) {
                return vector;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3;
                Object object;
                String string4;
                SOCSCalendar sOCSCalendar = null;
                String string5 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string5, "$");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while (stringTokenizer2.hasMoreTokens()) {
                    string4 = stringTokenizer2.nextToken();
                    object = new StringTokenizer(string4, "=");
                    string3 = null;
                    string2 = null;
                    if (!((StringTokenizer)object).hasMoreTokens()) continue;
                    string3 = ((StringTokenizer)object).nextToken();
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        string2 = ((StringTokenizer)object).nextToken();
                    }
                    hashMap.put(string3, string2);
                }
                try {
                    string4 = null;
                    object = null;
                    string3 = null;
                    string2 = null;
                    String string6 = null;
                    String string7 = null;
                    Object v = hashMap.get("name");
                    if (v != null) {
                        string4 = v.toString();
                    }
                    if ((v = hashMap.get("calendar")) != null) {
                        object = v.toString();
                    }
                    if ((v = hashMap.get("tzmode")) != null) {
                        string3 = v.toString();
                    }
                    if ((v = hashMap.get("tz")) != null) {
                        string2 = v.toString();
                    }
                    if ((v = hashMap.get("mergeInDayView")) != null) {
                        string6 = v.toString();
                    }
                    if ((v = hashMap.get("description")) != null) {
                        string7 = v.toString();
                    }
                    sOCSCalendar = new SOCSCalendar(null, (String)object, string4);
                    vector.addElement(sOCSCalendar);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    public Vector searchForCalendars(String string, int n, int n2) throws CalendarStoreException {
        return this.searchForCalendars(string, n, n2, null);
    }

    public Vector searchForCalendars(String string, int n, int n2, Properties properties) throws CalendarStoreException {
        SOCSResponse sOCSResponse;
        SOCSRequest sOCSRequest = new SOCSRequest(this);
        Vector vector = new Vector();
        try {
            sOCSResponse = sOCSRequest.searchCalendars(string, n, n2, properties);
        }
        catch (SOCSException sOCSException) {
            if (sOCSException.getError() == 1) {
                try {
                    this.validate();
                    sOCSResponse = sOCSRequest.searchCalendars(string, n, n2, properties);
                }
                catch (SOCSException sOCSException2) {
                    throw new CalendarStoreException(sOCSException2.getMessage(), sOCSException2.getError());
                }
            }
            throw new CalendarStoreException(sOCSException.getMessage(), sOCSException.getError());
        }
        vector = sOCSResponse.getCalendars();
        return vector;
    }

    public SOCSCalendar createCalendar(String string, Properties properties) throws CalendarStoreException {
        SOCSResponse sOCSResponse;
        SOCSRequest sOCSRequest = new SOCSRequest(this);
        SOCSCalendar sOCSCalendar = null;
        try {
            sOCSResponse = sOCSRequest.createCalendar(string, properties);
        }
        catch (SOCSException sOCSException) {
            if (sOCSException.getError() == 1) {
                try {
                    this.validate();
                    sOCSResponse = sOCSRequest.createCalendar(string, properties);
                }
                catch (SOCSException sOCSException2) {
                    throw new CalendarStoreException(sOCSException2.getMessage(), sOCSException2.getError());
                }
            }
            throw new CalendarStoreException(sOCSException.getMessage(), sOCSException.getError());
        }
        sOCSCalendar = sOCSResponse.getFirstCalendar();
        return sOCSCalendar;
    }

    public void deleteCalendar(String string) throws CalendarStoreException {
        SOCSRequest sOCSRequest = new SOCSRequest(this);
        try {
            SOCSResponse sOCSResponse = sOCSRequest.deleteCalendar(string);
        }
        catch (SOCSException sOCSException) {
            if (sOCSException.getError() == 1) {
                try {
                    this.validate();
                    SOCSResponse sOCSResponse = sOCSRequest.deleteCalendar(string);
                }
                catch (SOCSException sOCSException2) {
                    throw new CalendarStoreException(sOCSException2.getMessage(), sOCSException2.getError());
                }
            }
            throw new CalendarStoreException(sOCSException.getMessage(), sOCSException.getError());
        }
    }
}

