/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.Attach;
import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.PropertiesException;
import com.sun.comclient.calendar.VAlarm;
import java.io.BufferedReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SOCSAlarm
extends VAlarm {
    private CalendarComponent container;
    private String description;
    private String summary;
    private String action;
    private Duration trigger;
    private String related;
    private int repeatCount;
    private Duration repeatDuration;
    private String absTrigger;
    private Attach attachment;
    private ArrayList attendeeList;
    public static final String EMAIL = "EMAIL";
    public static final String AUDIO = "AUDIO";
    public static final String DISPLAY = "DISPLAY";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String START = "START";
    public static final String END = "END";
    private static final Hashtable _actionValues = new Hashtable();
    private static final Hashtable _relatedValues = new Hashtable();

    public SOCSAlarm() {
        this.related = START;
        this.attendeeList = new ArrayList();
    }

    public SOCSAlarm(CalendarComponent calendarComponent, String string, Duration duration) throws PropertiesException {
        this.related = START;
        this.attendeeList = new ArrayList();
        this.container = calendarComponent;
        this.setAction(string);
        this.trigger = duration;
    }

    public SOCSAlarm(CalendarComponent calendarComponent, String string, String string2) throws PropertiesException {
        this.related = START;
        this.attendeeList = new ArrayList();
        this.container = calendarComponent;
        this.setAction(string);
        this.absTrigger = string2;
    }

    private String[] _split(String string, char c, int n) {
        String[] stringArray = new String[n];
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != c) continue;
            if (n4 >= n - 1) break;
            stringArray[n4] = string.substring(n3, i);
            n3 = i + 1;
            ++n4;
        }
        if (n4 < n) {
            stringArray[n4] = string.substring(n3, n2);
        }
        return stringArray;
    }

    public SOCSAlarm(CalendarComponent calendarComponent, String string) throws IllegalArgumentException, PropertiesException {
        block28: {
            this.related = START;
            this.attendeeList = new ArrayList();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            StreamTokenizer streamTokenizer = null;
            boolean bl = false;
            try {
                String string2 = bufferedReader.readLine();
                streamTokenizer = new StreamTokenizer(new StringReader(string2));
                if (streamTokenizer.nextToken() != -3 || !streamTokenizer.sval.equalsIgnoreCase("BEGIN")) {
                    throw new IllegalArgumentException("Invalid VALARM format,incorrect BEGIN block(RFC2445)");
                }
                if ((char)streamTokenizer.nextToken() != ':') {
                    throw new IllegalArgumentException("Invalid VALARM format,incorrect BEGIN block(RFC2445)");
                }
                if (streamTokenizer.nextToken() != -3 || !streamTokenizer.sval.equalsIgnoreCase("VALARM")) {
                    throw new IllegalArgumentException("Invalid VALARM format,incorrect BEGIN block(RFC2445)");
                }
                while ((string2 = bufferedReader.readLine()) != null) {
                    streamTokenizer = new StreamTokenizer(new StringReader(string2));
                    streamTokenizer.nextToken();
                    String string3 = streamTokenizer.sval.toUpperCase();
                    if (string3.equals("ACTION")) {
                        if ((char)streamTokenizer.nextToken() != ':') {
                            throw new IllegalArgumentException("Invalid VALARM format(check ACTION tag)");
                        }
                        streamTokenizer.nextToken();
                        this.setAction(streamTokenizer.sval);
                        if (!streamTokenizer.sval.equalsIgnoreCase(EMAIL)) continue;
                        bl = true;
                        continue;
                    }
                    if (string3.equals("TRIGGER")) {
                        Object object;
                        String string4;
                        char c = (char)streamTokenizer.nextToken();
                        if (c != ';' && c != ':') {
                            throw new IllegalArgumentException("Invalid VALARM format(check TRIGGER tag)");
                        }
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == -3 && streamTokenizer.sval.toUpperCase().equals("VALUE")) {
                            string4 = "";
                            streamTokenizer.nextToken();
                            streamTokenizer.wordChars(45, 45);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            block7: while (streamTokenizer.nextToken() != -1) {
                                switch (streamTokenizer.ttype) {
                                    case -3: {
                                        string4 = string4 + streamTokenizer.sval;
                                        continue block7;
                                    }
                                    case -2: {
                                        string4 = string4 + String.valueOf((int)streamTokenizer.nval);
                                        continue block7;
                                    }
                                }
                                object = new char[1];
                                object[0] = (char)streamTokenizer.ttype;
                                string4 = string4 + new String((char[])object);
                            }
                            this.absTrigger = string4;
                            continue;
                        }
                        string4 = "";
                        if ((char)streamTokenizer.ttype == '-') {
                            string4 = "-";
                            streamTokenizer.nextToken();
                        }
                        object = "DURATION:" + string4 + streamTokenizer.sval;
                        this.trigger = new Duration((String)object);
                        continue;
                    }
                    if (string3.equals("DURATION")) {
                        this.repeatDuration = new Duration(string2);
                        continue;
                    }
                    if (string3.equals("ATTACH")) {
                        this.attachment = new Attach("RFC", string2);
                        continue;
                    }
                    if (string3.equals("ATTENDEE")) {
                        if (!bl) {
                            throw new IllegalArgumentException("Invalid VALARM format(ATTENDEE tag irrelevant)");
                        }
                        Attendee attendee = new Attendee(string2);
                        this.attendeeList.add(attendee);
                        continue;
                    }
                    if (string3.equals("DESCRIPTION")) {
                        String[] stringArray = this._split(string2, ':', 2);
                        if (stringArray.length != 2) {
                            throw new IllegalArgumentException("Invalid VALARM format(check DESCRIPTION tag)");
                        }
                        this.description = stringArray[1];
                        continue;
                    }
                    if (string3.equals("SUMMARY")) {
                        String[] stringArray = this._split(string2, ':', 2);
                        if (stringArray.length != 2) {
                            throw new IllegalArgumentException("Invalid VALARM format(check SUMMARY tag)");
                        }
                        this.summary = stringArray[1];
                        continue;
                    }
                    if (!string3.equals("REPEAT")) continue;
                    if ((char)streamTokenizer.nextToken() != ':') {
                        throw new IllegalArgumentException("Invalid VALARM format(check REPEAT tag)");
                    }
                    if (streamTokenizer.nextToken() != -2) {
                        throw new IllegalArgumentException("Invalid VALARM format(check REPEAT tag)");
                    }
                    this.setRepeatCount((int)streamTokenizer.nval);
                }
            }
            catch (Exception exception) {
                if (exception instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)exception;
                }
                if (!(exception instanceof PropertiesException)) break block28;
                throw (PropertiesException)exception;
            }
        }
    }

    public CalendarComponent getContainer() {
        return this.container;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAction() {
        return this.action;
    }

    public Duration getTrigger() {
        return this.trigger;
    }

    public String getAbsTrigger() {
        return this.absTrigger;
    }

    public String getRelated() {
        return this.related;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setAction(String string) throws PropertiesException {
        if (_actionValues.get(string.toUpperCase()) == null) {
            PropertiesException propertiesException = new PropertiesException(PropertiesException.errorMessages[1]);
            throw propertiesException;
        }
        this.action = string;
    }

    public void setTrigger(Duration duration) {
        this.trigger = duration;
        this.absTrigger = null;
    }

    public void setAbsTrigger(String string) {
        this.absTrigger = string;
        this.trigger = null;
    }

    public void setRelated(String string) throws PropertiesException {
        if (_relatedValues.get(string.toUpperCase()) == null) {
            PropertiesException propertiesException = new PropertiesException(PropertiesException.errorMessages[1]);
            throw propertiesException;
        }
        this.related = string;
    }

    public void setRepeatCount(int n) {
        this.repeatCount = n;
    }

    public void setRepeat(int n, Duration duration) {
        this.repeatCount = n;
        this.repeatDuration = duration;
    }

    public void addAttendee(Attendee attendee) {
        this.attendeeList.add(attendee);
    }

    public Attendee[] getAttendees() {
        if (this.attendeeList == null || this.attendeeList.size() == 0) {
            return null;
        }
        Attendee[] attendeeArray = new Attendee[this.attendeeList.size()];
        return this.attendeeList.toArray(attendeeArray);
    }

    public void removeAttendee(Attendee attendee) {
        if (this.attendeeList == null || this.attendeeList.size() == 0 || attendee == null) {
            return;
        }
        for (int i = 0; i < this.attendeeList.size(); ++i) {
            String string = attendee.getValue();
            if (string == null || !string.equals(((Attendee)this.attendeeList.get(i)).getValue())) continue;
            this.attendeeList.remove(i);
            break;
        }
    }

    public String toRFC2445() {
        Object object;
        String string = "BEGIN:VALARM\n";
        string = string + "ACTION:" + this.action + "\n";
        if (this.absTrigger != null) {
            string = string + "TRIGGER;VALUE=DATE-TIME:" + this.absTrigger + "\n";
        } else {
            object = new StringTokenizer(this.trigger.toRFC2445(), ":");
            ((StringTokenizer)object).nextToken();
            string = string + "TRIGGER:" + ((StringTokenizer)object).nextToken() + "\n";
        }
        if (this.description != null) {
            string = string + "DESCRIPTION:" + this.description + "\n";
        }
        if (this.summary != null) {
            string = string + "SUMMARY:" + this.summary + "\n";
        }
        if (!this.related.equals(START)) {
            string = string + "RELATED:" + this.related + "\n";
        }
        if (this.repeatCount > 0) {
            string = string + "REPEAT:" + this.repeatCount + "\n";
        }
        if (this.repeatDuration != null) {
            string = string + this.repeatDuration.toRFC2445() + "\n";
        }
        if (this.attachment != null) {
            string = string + this.attachment.toRFC2445() + "\n";
        }
        if (this.attendeeList.size() > 0) {
            object = this.attendeeList.iterator();
            while (object.hasNext()) {
                string = string + ((Attendee)object.next()).toRFC2445() + "\n";
            }
        }
        string = string + "END:VALARM";
        return string;
    }

    static {
        _actionValues.put(EMAIL, "Dummy1");
        _actionValues.put(AUDIO, "Dummy2");
        _actionValues.put(DISPLAY, "Dummy3");
        _actionValues.put(PROCEDURE, "Dummy4");
        _relatedValues.put(START, "Dummy1");
        _relatedValues.put(END, "Dummy2");
    }
}

