/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import java.util.Properties;
import java.util.TimeZone;

public abstract class ICalendar {
    private CalendarStore store;
    protected String calId;
    public static final int VEVENT = 1;
    public static final int VTODO = 2;
    public static final int VFREEBUSY = 4;
    public static final int VALL = 7;

    protected ICalendar(CalendarStore calendarStore, String string) {
        this.store = calendarStore;
        this.calId = string;
    }

    public String getCalID() {
        return this.calId;
    }

    public CalendarStore getStore() {
        return this.store;
    }

    public abstract VEvent createEvent() throws CalendarException, OperationNotSupportedException;

    public abstract VTodo createTodo() throws CalendarException, OperationNotSupportedException;

    public boolean isUserTheOwner() throws CalendarException, OperationNotSupportedException {
        return this.isUserTheOwner(false);
    }

    public boolean isUserTheOwner(boolean bl) throws CalendarException, OperationNotSupportedException {
        return this.isUserTheOwner(this.getStore().getSession().getProperty("cal.user"), bl);
    }

    public boolean isUserTheOwner(String string) throws CalendarException, OperationNotSupportedException {
        return this.isUserTheOwner(string, false);
    }

    public abstract boolean isUserTheOwner(String var1, boolean var2) throws CalendarException, OperationNotSupportedException;

    public abstract TimeZone getTimeZone() throws CalendarException, OperationNotSupportedException;

    public abstract void setTimeZone(TimeZone var1) throws CalendarException, OperationNotSupportedException;

    public abstract String getDisplayName() throws CalendarException, OperationNotSupportedException;

    public CalendarComponent[] fetchComponents(int n) throws CalendarException {
        TimeZone timeZone = this.getStore().getSession().getTimeZone();
        DateTime dateTime = null;
        dateTime = null == timeZone ? new DateTime() : new DateTime(timeZone);
        return this.fetchComponents(dateTime, n);
    }

    public CalendarComponent[] fetchComponents(DateTime dateTime, int n) throws CalendarException {
        if (null == dateTime) {
            throw new CalendarException("Illegal Argument: null day");
        }
        DateTime dateTime2 = (DateTime)dateTime.clone();
        DateTime dateTime3 = (DateTime)dateTime.clone();
        dateTime2.setTime(0, 0, 0);
        dateTime3.setTime(23, 59, 59);
        return this.fetchComponents(dateTime2, dateTime3, n);
    }

    public CalendarComponent[] fetchComponents(DateTime dateTime, Duration duration, int n) throws CalendarException {
        if (null == dateTime) {
            throw new CalendarException("Illegal Argument: null start");
        }
        if (null == duration) {
            throw new CalendarException("Illegal Argument: null duration");
        }
        DateTime dateTime2 = (DateTime)dateTime.clone();
        dateTime2.add(duration);
        return this.fetchComponents(dateTime, dateTime2, n);
    }

    public abstract CalendarComponent[] fetchComponents(DateTime var1, DateTime var2, int var3) throws CalendarException;

    public CalendarComponent[] fetchComponents(String string) throws CalendarException, OperationNotSupportedException {
        return this.fetchComponents(string, null, null);
    }

    public abstract CalendarComponent[] fetchComponents(String var1, String var2, String var3) throws CalendarException, OperationNotSupportedException;

    public VEvent[] fetchEvents(String string) throws CalendarException, OperationNotSupportedException {
        return this.fetchEvents(string, null, null);
    }

    public abstract VEvent[] fetchEvents(String var1, String var2, String var3) throws CalendarException, OperationNotSupportedException;

    public VTodo[] fetchTodos(String string) throws CalendarException, OperationNotSupportedException {
        return this.fetchTodos(string, null, null);
    }

    public abstract VTodo[] fetchTodos(String var1, String var2, String var3) throws CalendarException, OperationNotSupportedException;

    public abstract Properties getCalProps() throws CalendarException, OperationNotSupportedException;

    public abstract void setCalProps(Properties var1) throws CalendarException, OperationNotSupportedException;

    public abstract void addEvent(VEvent var1, boolean var2) throws CalendarException;

    public abstract void addTodo(VTodo var1, boolean var2) throws CalendarException;

    public abstract void modifyEvent(VEvent var1, String var2, boolean var3) throws CalendarException;

    public abstract void modifyTodo(VTodo var1, String var2, boolean var3) throws CalendarException;

    public abstract void deleteEvent(VEvent var1, String var2, boolean var3) throws CalendarException;

    public abstract void deleteTodo(VTodo var1, String var2, boolean var3) throws CalendarException;

    public void update() {
    }

    public abstract String toRFC2445();

    public abstract String toString();
}

