/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.FreeBusyException;
import com.sun.comclient.calendar.PropertiesException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class FreeBusy {
    private static final String FREEBUSY = "FREEBUSY";
    private static final String FBTYPE = "FBTYPE";
    private static final String DURATION = "DURATION";
    private String fbtype = "BUSY";
    private DateTime dtstart = null;
    private DateTime dtend = null;
    private Duration duration = null;
    private boolean hasDuration = false;
    private static final int rfcDurationPrefixLength = new String("DURATION:").length();

    public FreeBusy(String string, DateTime dateTime, DateTime dateTime2) throws IllegalArgumentException {
        if (null == string) {
            throw new IllegalArgumentException("input given for \"fbtype\" argument was found to be null");
        }
        if (null == dateTime) {
            throw new IllegalArgumentException("input given for \"dtstart\" argument was found to be null");
        }
        if (null == dateTime2) {
            throw new IllegalArgumentException("input given for \"dtend\" argument was found to be null");
        }
        this.fbtype = string;
        this.dtstart = dateTime;
        this.dtend = dateTime2;
        this.duration = null;
        this.hasDuration = false;
    }

    public FreeBusy(String string, DateTime dateTime, Duration duration) throws IllegalArgumentException {
        if (null == string) {
            throw new IllegalArgumentException("input given for \"fbtype\" argument was found to be null");
        }
        if (null == dateTime) {
            throw new IllegalArgumentException("input given for \"dtstart\" argument was found to be null");
        }
        if (null == duration) {
            throw new IllegalArgumentException("input given for \"duration\" argument was found to be null");
        }
        this.fbtype = string;
        this.dtstart = dateTime;
        this.dtend = null;
        this.duration = duration;
        this.hasDuration = true;
    }

    public static FreeBusy[] fromRFC2445(String string) throws IllegalArgumentException, FreeBusyException, ParseException, PropertiesException {
        return FreeBusy.fromRFC2445(string, null);
    }

    public static FreeBusy[] fromRFC2445(String string, TimeZone timeZone) throws IllegalArgumentException, FreeBusyException, ParseException, PropertiesException {
        FreeBusy[] freeBusyArray;
        int n;
        if (null == string) {
            throw new IllegalArgumentException("input given for \"rfcForm\" argument was found to be null");
        }
        String string2 = new String(string.toUpperCase());
        String string3 = "FREEBUSY:";
        String string4 = "FREEBUSY;FBTYPE=";
        String string5 = "BUSY";
        if (string2.startsWith(string3)) {
            string2 = string2.substring(string3.length(), string2.length());
        } else if (string2.startsWith(string4)) {
            n = (string2 = string2.substring(string4.length(), string2.length())).indexOf(":");
            if (-1 == n || string2.startsWith(":")) {
                throw FreeBusy.getInvalidFormatException(string);
            }
            string5 = string2.substring(0, n);
            string2 = string2.substring(n + 1, string2.length());
        } else {
            throw FreeBusy.getInvalidFormatException(string);
        }
        if (0 == string2.length()) {
            throw FreeBusy.getInvalidFormatException(string);
        }
        ArrayList<FreeBusy> arrayList = new ArrayList<FreeBusy>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            DateTime dateTime;
            freeBusyArray = (FreeBusy[])stringTokenizer.nextElement();
            n = freeBusyArray.indexOf("/");
            if (-1 == n) {
                throw FreeBusy.getInvalidFormatException(string);
            }
            String string6 = freeBusyArray.substring(0, n);
            String string7 = freeBusyArray.substring(n + 1, freeBusyArray.length());
            if (0 == string6.length() || 0 == string7.length()) {
                throw FreeBusy.getInvalidFormatException(string);
            }
            FreeBusy freeBusy = null;
            DateTime dateTime2 = dateTime = null == timeZone ? new DateTime(string6) : new DateTime(string6, timeZone);
            if (string7.startsWith("P") || string7.startsWith("p")) {
                object = new Duration(string7);
                freeBusy = new FreeBusy(string5, dateTime, (Duration)object);
            } else {
                object = null == timeZone ? new DateTime(string7) : new DateTime(string7, timeZone);
                freeBusy = new FreeBusy(string5, dateTime, (DateTime)object);
            }
            arrayList.add(freeBusy);
        }
        freeBusyArray = new FreeBusy[arrayList.size()];
        arrayList.toArray(freeBusyArray);
        return freeBusyArray;
    }

    public String toRFC2445() {
        return "FREEBUSY;FBTYPE=" + this.getFBtype() + ":" + this.getStart().toISOString() + "/" + (this.hasDuration() ? this.getDuration().toRFC2445().substring(rfcDurationPrefixLength) : this.getEnd().toISOString());
    }

    public String toString() {
        return "FreeBusy[fbtype=" + this.getFBtype() + "; start=" + this.getStart().toISOString() + "; hasDuration=" + this.hasDuration() + "; end=" + (null == this.getEnd() ? null : this.getEnd().toISOString()) + "; duration=" + (null == this.getDuration() ? null : this.getDuration().toRFC2445().substring(rfcDurationPrefixLength)) + "]";
    }

    public String getFBtype() {
        return this.fbtype;
    }

    public DateTime getStart() {
        return this.dtstart;
    }

    public DateTime getEnd() {
        return this.dtend;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public boolean hasDuration() {
        return this.hasDuration;
    }

    private static FreeBusyException getInvalidFormatException(String string) {
        return new FreeBusyException("Cannot parse the input string <" + string + "> -- does not confirm to \"FREEBUSY\" property format as specified in RFC 2445");
    }
}

