/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.PropertiesException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.StringTokenizer;

public class Duration {
    private static final int MINUTE_2_SECONDS = 60;
    private static final int HOUR_2_MINUTES = 60;
    private static final int HOUR_2_SECONDS = 3600;
    private static final int DAY_2_HOURS = 24;
    private static final int DAY_2_MINUTES = 1440;
    private static final int DAY_2_SECONDS = 86400;
    private static final int WEEK_2_DAYS = 7;
    private static final int WEEK_2_HOURS = 168;
    private static final int WEEK_2_MINUTES = 10080;
    private static final int WEEK_2_SECONDS = 604800;
    private static final int NEGATIVE_SIGN = -1;
    private static final int POSITIVE_SIGN = 1;
    private int weeks = 0;
    private int days = 0;
    private int hours = 0;
    private int minutes = 0;
    private int seconds = 0;
    private int sign = 1;

    public Duration() {
    }

    public Duration(int n) throws PropertiesException {
        if (n < 1) {
            throw new PropertiesException("Invalid weeks value", 2);
        }
        this.weeks = n;
    }

    public Duration(int n, int n2) throws PropertiesException {
        this._init(0, n, n2, 0);
    }

    public Duration(int n, int n2, int n3, int n4) throws PropertiesException {
        this._init(n, n2, n3, n4);
    }

    private void _init(int n, int n2, int n3, int n4) throws PropertiesException {
        if (n < 0 || n > 366) {
            throw new PropertiesException("Invalid days value", 2);
        }
        if (n2 < 0 || n2 > 23) {
            throw new PropertiesException("Invalid hours value", 2);
        }
        if (n3 < 0 || n3 > 59) {
            throw new PropertiesException("Invalid minutes value", 2);
        }
        if (n4 < 0 || n4 > 59) {
            throw new PropertiesException("Invalid seconds value", 2);
        }
        this.days = n;
        this.hours = n2;
        this.minutes = n3;
        this.seconds = n4;
        this.sign = 1;
        this.weeks = 0;
    }

    private void _init(long l) throws PropertiesException {
        int n = 1;
        if (0L > l) {
            l = -1L * l;
            n = -1;
        }
        int n2 = (int)l % 60;
        int n3 = (int)((l -= (long)n2) % 3600L) / 60;
        int n4 = (int)((l -= (long)(n3 * 60)) % 86400L) / 3600;
        int n5 = (int)(l -= (long)(n4 * 3600)) / 86400;
        this._init(n5, n4, n3, n2);
        this.setSign(n);
    }

    public Duration(long l) throws PropertiesException {
        this._init(l);
    }

    public Duration(DateTime dateTime, DateTime dateTime2) throws PropertiesException, IllegalArgumentException {
        if (null == dateTime) {
            throw new IllegalArgumentException("null startDate");
        }
        if (null == dateTime2) {
            throw new IllegalArgumentException("null endDate");
        }
        long l = dateTime.getTime().getTime() - dateTime2.getTime().getTime();
        long l2 = l / 1000L;
        this._init(l2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Duration(String string) throws PropertiesException, IllegalArgumentException {
        if (null == string) {
            throw new IllegalArgumentException("null rfcFormat");
        }
        String string2 = "";
        String string3 = string;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (string.startsWith("DURATION")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            if (stringTokenizer.countTokens() != 2) {
                throw new PropertiesException("Duration:Invalid format.");
            }
            stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string3));
        try {
            streamTokenizer.ordinaryChar(68);
            streamTokenizer.ordinaryChar(87);
            streamTokenizer.ordinaryChar(72);
            streamTokenizer.ordinaryChar(77);
            streamTokenizer.ordinaryChar(83);
            streamTokenizer.ordinaryChar(80);
            streamTokenizer.ordinaryChar(84);
            char c = (char)streamTokenizer.nextToken();
            if (c != 'P' && c != '-' && c != '+') {
                throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
            }
            if (c == '-') {
                this.sign = -1;
                c = (char)streamTokenizer.nextToken();
                if (c != 'P') {
                    throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
                }
            }
            boolean bl3 = false;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -2) {
                n = (int)streamTokenizer.nval;
                c = (char)streamTokenizer.nextToken();
                if (c == 'W') {
                    this.weeks = n;
                    return;
                }
                if (c != 'D') throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
                this.days = n;
                bl3 = true;
                c = (char)streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -1 && c != 'T') {
                    throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
                }
            } else if ((char)streamTokenizer.ttype != 'T') {
                throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
            }
            boolean bl4 = false;
            int n2 = 0;
            block5: while (streamTokenizer.nextToken() != -1) {
                switch (streamTokenizer.ttype) {
                    case -2: {
                        n = (int)streamTokenizer.nval;
                        bl4 = true;
                        ++n2;
                        continue block5;
                    }
                }
                c = (char)streamTokenizer.ttype;
                if (c != 'H' && c != 'M' && c != 'S') throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
                ++n2;
                if (!bl4) {
                    throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
                }
                bl4 = false;
                if (c == 'H') {
                    this.hours = n;
                    continue;
                }
                if (c == 'M') {
                    this.minutes = n;
                    continue;
                }
                if (c != 'S') continue;
                this.seconds = n;
            }
            if (bl3 || n2 >= 2) return;
            throw new PropertiesException("Duration:" + PropertiesException.errorMessages[2]);
        }
        catch (Exception exception) {
            if (exception instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)exception;
            }
            if (!(exception instanceof PropertiesException)) return;
            throw (PropertiesException)exception;
        }
    }

    public int getSign() {
        return this.sign < 0 ? -1 : 1;
    }

    public int getWeeks() {
        return this.weeks;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setSign(int n) {
        this.sign = n;
    }

    public String toRFC2445() {
        String string = "DURATION:";
        if (this.sign < 0) {
            string = string + "-";
        }
        string = string + "P";
        if (this.weeks > 0) {
            string = string + this.weeks + "W";
            return string;
        }
        if (this.days > 0) {
            string = string + this.days + "D";
        }
        if (this.hours + this.minutes + this.seconds > 0) {
            string = string + "T";
            if (this.hours > 0) {
                string = string + this.hours + "H";
            }
            if (this.minutes > 0) {
                string = string + this.minutes + "M";
            }
            if (this.seconds > 0) {
                string = string + this.seconds + "S";
            }
        }
        return string;
    }

    public long toSeconds() {
        return this.getSign() * (this.getSeconds() + this.getMinutes() * 60 + this.getHours() * 3600 + this.getDays() * 86400 + this.getWeeks() * 604800);
    }
}

