/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.PropertiesException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Attendee
extends Organizer {
    public static final String ROLE = "ROLE";
    public static final String USERTYPE = "CUTYPE";
    public static final String PARTICIPANT_STATUS = "PARTSTAT";
    public static final String RSVP = "RSVP";
    public static final String MEMBER = "MEMBER";
    public static final String DELEGATED_TO = "DELEGATED-TO";
    public static final String DELEGATED_FROM = "DELEGATED-FROM";
    public static final String VALUE = "ATTENDEE";
    public static final String INDIVIDUAL = "INDIVIDUAL";
    public static final String GROUP = "GROUP";
    public static final String RESOURCE = "RESOURCE";
    public static final String ROOM = "ROOM";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String CHAIR = "CHAIR";
    public static final String REQ_PARTICIPANT = "REQ-PARTICIPANT";
    public static final String OPT_PARTICIPANT = "OPT-PARTICIPANT";
    public static final String NON_PARTICIPANT = "NON-PARTICIPANT";
    public static final String NEEDS_ACTION = "NEEDS-ACTION";
    public static final String ACCEPTED = "ACCEPTED";
    public static final String DECLINED = "DECLINED";
    public static final String TENTATIVE = "TENTATIVE";
    public static final String COMPLETED = "COMPLETED";
    public static final String IN_PROCESS = "IN-PROCESS";
    public static final String DELEGATED = "DELEGATED";
    private static final Hashtable _userTypeValues = new Hashtable();
    private static final Hashtable _roleValues = new Hashtable();
    private static final Hashtable _partStatValues = new Hashtable();
    private String userType;
    private String role;
    private String participantStatus;
    private boolean isRSVP;
    private String memberOf;
    private String delegatedTo;
    private String delegatedFrom;

    public Attendee() {
        this.userType = INDIVIDUAL;
        this.role = REQ_PARTICIPANT;
        this.participantStatus = NEEDS_ACTION;
        this.isRSVP = false;
    }

    public Attendee(String string, String string2) throws PropertiesException {
        this.userType = INDIVIDUAL;
        this.role = REQ_PARTICIPANT;
        this.participantStatus = NEEDS_ACTION;
        this.isRSVP = false;
        this.setUserType(string);
        this.myValue = string2;
    }

    public Attendee(String string, String string2, String string3) throws PropertiesException {
        this.userType = INDIVIDUAL;
        this.role = REQ_PARTICIPANT;
        this.participantStatus = NEEDS_ACTION;
        this.isRSVP = false;
        this.setUserType(string);
        this.role = string2;
        this.myValue = string3;
    }

    public Attendee(String string) throws IllegalArgumentException, PropertiesException {
        block11: {
            this.userType = INDIVIDUAL;
            this.role = REQ_PARTICIPANT;
            this.participantStatus = NEEDS_ACTION;
            this.isRSVP = false;
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.wordChars(32, 32);
            streamTokenizer.wordChars(64, 64);
            streamTokenizer.ordinaryChars(48, 57);
            streamTokenizer.ordinaryChar(46);
            String string2 = "";
            try {
                if (streamTokenizer.nextToken() != -3 || !streamTokenizer.sval.equalsIgnoreCase(VALUE)) {
                    throw new IllegalArgumentException("Invalid ATTENDEE definition format(see RFC2445)");
                }
                char c = (char)streamTokenizer.nextToken();
                String string3 = "";
                while (c == ';') {
                    streamTokenizer.nextToken();
                    string3 = string3 + streamTokenizer.sval;
                    streamTokenizer.nextToken();
                    string3 = string3 + "=";
                    streamTokenizer.nextToken();
                    string3 = string3 + streamTokenizer.sval;
                    this.processParams(string3);
                    string3 = "";
                    c = (char)streamTokenizer.nextToken();
                }
                if (c != ':') {
                    throw new IllegalArgumentException("Missing ATTENDEE value(see RFC2445)");
                }
                block7: while (streamTokenizer.nextToken() != -1) {
                    switch (streamTokenizer.ttype) {
                        case -3: {
                            string2 = string2 + streamTokenizer.sval;
                            continue block7;
                        }
                        case -2: {
                            string2 = string2 + String.valueOf(streamTokenizer.nval);
                            continue block7;
                        }
                    }
                    char[] cArray = new char[]{(char)streamTokenizer.ttype};
                    string2 = string2 + new String(cArray);
                }
                this.myValue = string2;
            }
            catch (Exception exception) {
                if (exception instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)exception;
                }
                if (!(exception instanceof PropertiesException)) break block11;
                throw (PropertiesException)exception;
            }
        }
    }

    public String getUserType() {
        return this.userType;
    }

    public String getRole() {
        return this.role;
    }

    public String getParticipantStatus() {
        return this.participantStatus;
    }

    public String getMember() {
        return this.memberOf;
    }

    public boolean isRSVPRequired() {
        return this.isRSVP;
    }

    public String getDelegatedTo() {
        return this.delegatedTo;
    }

    public String getDelegatedFrom() {
        return this.delegatedFrom;
    }

    public void setDelegatedTo(String string) {
        this.delegatedTo = string;
    }

    public void setDelegatedFrom(String string) {
        this.delegatedFrom = string;
    }

    public void setUserType(String string) throws PropertiesException {
        if (_userTypeValues.get(string.toUpperCase()) == null) {
            PropertiesException propertiesException = new PropertiesException(PropertiesException.errorMessages[1]);
            throw propertiesException;
        }
        this.userType = string.toUpperCase();
    }

    public void setRole(String string) throws PropertiesException {
        if (_roleValues.get(string.toUpperCase()) == null) {
            PropertiesException propertiesException = new PropertiesException(PropertiesException.errorMessages[1]);
            throw propertiesException;
        }
        this.role = string.toUpperCase();
    }

    public void setRSVPRequired(boolean bl) {
        this.isRSVP = bl;
    }

    public void setParticipantStatus(String string) throws PropertiesException {
        if (_partStatValues.get(string.toUpperCase()) == null) {
            PropertiesException propertiesException = new PropertiesException(PropertiesException.errorMessages[1]);
            throw propertiesException;
        }
        this.participantStatus = string.toUpperCase();
    }

    public void setMember(String string) {
        this.memberOf = string;
    }

    protected void processParams(String string) throws IllegalArgumentException, PropertiesException {
        super.processParams(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (stringTokenizer.countTokens() <= 1) {
            throw new IllegalArgumentException("Syntax error in Recurrence Pattern");
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        if ((string2 = string2.toUpperCase()).equals(USERTYPE)) {
            this.setUserType(string3);
        } else if (string2.equals(ROLE)) {
            this.setRole(string3);
        } else if (string2.equals(PARTICIPANT_STATUS)) {
            this.setParticipantStatus(string3);
        } else if (string2.equals(RSVP) && string3.equalsIgnoreCase("TRUE")) {
            this.isRSVP = true;
        } else if (string2.equals(MEMBER)) {
            this.memberOf = string3;
        } else if (string2.equals(DELEGATED_TO)) {
            this.delegatedTo = string3;
        } else if (string2.equals(DELEGATED_FROM)) {
            this.delegatedFrom = string3;
        }
    }

    public String toRFC2445() {
        String string = VALUE;
        string = string + ";CUTYPE=" + this.userType;
        string = string + ";ROLE=" + this.role;
        string = string + ";PARTSTAT=" + this.participantStatus;
        string = string + ";RSVP=" + (this.isRSVP ? "TRUE" : "FALSE");
        if (this.commonName != null) {
            string = string + ";CN=" + this.commonName;
        }
        if (this.memberOf != null) {
            string = string + ";MEMBER=" + this.memberOf;
        }
        if (this.dirURL != null) {
            string = string + ";DIR=" + this.dirURL;
        }
        if (this.delegatedTo != null) {
            string = string + ";DELEGATED-TO=" + this.delegatedTo;
        }
        if (this.delegatedFrom != null) {
            string = string + ";DELEGATED-FROM=" + this.delegatedFrom;
        }
        if (this.sentBy != null) {
            string = string + ";SENT-BY=" + this.sentBy;
        }
        if (this.lang != null) {
            string = string + ";LANGUAGE=" + this.lang;
        }
        if (this.myValue != null) {
            string = string + ":" + this.myValue;
        }
        return string;
    }

    static {
        _userTypeValues.put(INDIVIDUAL, "Dummy1");
        _userTypeValues.put(GROUP, "Dummy2");
        _userTypeValues.put(RESOURCE, "Dummy3");
        _userTypeValues.put(ROOM, "Dummy4");
        _userTypeValues.put(UNKNOWN, "Dummy5");
        _roleValues.put(CHAIR, "Dummy1");
        _roleValues.put(REQ_PARTICIPANT, "Dummy2");
        _roleValues.put(OPT_PARTICIPANT, "Dummy3");
        _roleValues.put(NON_PARTICIPANT, "Dummy4");
        _partStatValues.put(NEEDS_ACTION, "Dummy1");
        _partStatValues.put(ACCEPTED, "Dummy2");
        _partStatValues.put(DECLINED, "Dummy3");
        _partStatValues.put(TENTATIVE, "Dummy4");
        _partStatValues.put(IN_PROCESS, "Dummy5");
        _partStatValues.put(DELEGATED, "Dummy6");
    }
}

