#!/bin/csh -f

#    SAM-QFS_notice_begin
#
#      Solaris 2.x Sun Storage & Archiving Management File System
#
#      Copyright (c) 2004 Sun Microsystems, Inc.
#      All Rights Reserved.
#
#      Government Rights Notice
#      Use, duplication, or disclosure by the U.S. Government is
#      subject to restrictions set forth in the Sun Microsystems,
#      Inc. license agreements and as provided in DFARS 227.7202-1(a)
#      and 227.7202-3(a) (1995), DRAS 252.227-7013(c)(ii) (OCT 1988),
#      FAR 12.212(a)(1995), FAR 52.227-19, or FAR 52.227-14 (ALT III),
#      as applicable.  Sun Microsystems, Inc.
#
#    SAM-QFS_notice_end

# save_core.sh - template shell for processing exceptional events.
# $Id: save_core.sh,v 1.4 2004/03/02 20:28:16 cp129962 Exp $
#
# args:
#	1) calling program name (Not the notify wrapper!).
#	2) calling program pid (again, not the notify wrapper!).
#	3) keyword identifying the 'syslog' level of the event.
# 		The keywords are:
# 		emerg, alert, crit, err, warning, notice, info, debug
#	4) message number from the message catalog.
#	5) the actual message.
#
#

#  Save the core in /var/opt/SUNWsamfs/cores/core.<program>-<eq>.<date>

set SAMFSDIR=/var/opt/SUNWsamfs/amld
set SAMCOREDIR=/var/opt/SUNWsamfs/cores

if ( ! -d ${SAMCOREDIR} ) then
    mkdir -p ${SAMCOREDIR}
endif

set msg=($5)
set program=$msg[1]
set eq=$msg[2]
set date=`date +%m%d%y-%H:%M`

mv ${SAMFSDIR}/core ${SAMCOREDIR}/core.${program}-${eq}.${date}

