#!/bin/sh
#
# Script to ftp/upload patch system files to a target DSP system
#
#pragma ident   "@(#)DSP.sh           03/08/12 SMI"
# 
#
# Algorithm:
#
#  o Prompt User for required information
#    - Prompt for $TARGET_SYSTEM (hostname or IP Address)
#      Ping $TARGET_SYSTEM user entered
#      -> Exit if ping fails (system unreachable)
#    - Prompt For $HOME_DIRECTORY Location 
#      -> Exit if can't write a file in home directory
#    - Prompt for top level directory of patch image ($PATCH_DIR)
#      -> Need to locate files.tar within that directory tree
#	 set $PATCH_DIR
#      -> copy files.tar image to /tmp/$PID
#	 set $PATCH_DIR /tmp/$PID
#      -> Exit if can't find patch location or reprompt
#    - Warn User they must set root password on target DSP
#
#  o Set interrupts so cleanup routine is used
#   Cleanup Routine:
#      -> rm  ~/.netrc 
#      -> rm -r /tmp/$PID 
#
#  o Create ~/.netrc
#    Check for existing ~/.netrc and preserve if one exists
#    Dump the following into ~/.netrc:
#      machine $TARGET_SYSTEM
#      macdef init
#      bin
#      prompt
#      lcd /etc
#      cd $PATCHDIR
#      cd etc
#      mput *
#      lcd /web
#      cd ../web
#      mput *
#      mkdir snmp
#      lcd snmp
#      cd snmp
#      mput *
#      quit
#
#    Remove read permissions from ~/.netrc
#
#  o Start ftp process
#    exec 'ftp TARGET_DSP'
#
#  o Perform File Validation ?
#    -> Perhaps snapshot a long filelisting and cmp with
#       local image?
#
#  o Cleanup Local Files
# 
#  o Restore preserved ~/.netrc if applicable 
#
#  o Exit

# Script Variables
TOC=patchtoc		  # Patch Table Of Contents File
TARGET=                   # DSP To Be Upgraded 
TRUE=1                    # Boolean true
FALSE=0                   # Boolean false
PATCHDIR=.		  # Patch Directory Location
RESP=' '
ERR=0			  # Error Counter
TMPDIR=/tmp/upload.$$     # Temporary Directory
TMPNETRC=/tmp/netrc.$$    # Backup copy of existing .netrc
HOMEDIR=$HOME		  # User's default home directory.


netrc_gen() {
  #  Routine to Create ~/.netrc
  echo "Enter Your Home Directory Path [$HOMEDIR]: \c"
  read NEW_HOME
  if [ "X$NEW_HOME" != 'X' ];then
     HOME=$NEW_HOME
     HOMEDIR=$HOME
     export HOME
  else
     # Check to see if $HOME exist
     if [ "X$HOME" = 'X' ]; then
        UID=`id | cut -b5`
        if [ "$UID" = 0 ]; then
           HOME='/'
           HOMEDIR=$HOME
           export HOME
        fi
     fi
  fi
  if [ -f $HOMEDIR/.netrc ]; then
    mv $HOMEDIR/.netrc $TMPNETRC    # Preserve existing .netrc
  fi
  if [ "$Patchpro_contract" -eq $TRUE ]; then
    echo "Enter ftp user: \c"
    read FTPUSER
    echo "Enter ftp password: \c"
    read FTPPW
    echo "Creating Auto ftp File In [$HOMEDIR/.netrc]..."
    if [ "X$FTPPW" != 'X' ];then
      echo "machine $TARGET login $FTPUSER password $FTPPW" > $HOMEDIR/.netrc
    else
      echo "machine $TARGET login $FTPUSER password \\r" > $HOMEDIR/.netrc
    fi
  else
    echo "Creating Auto ftp File In [$HOMEDIR/.netrc]..."
    echo "machine $TARGET"  > $HOMEDIR/.netrc
  fi
  echo "macdef init" >> $HOMEDIR/.netrc
  echo "bin"  >> $HOMEDIR/.netrc
  echo "prompt"  >> $HOMEDIR/.netrc

  echo "lcd $PATCHDIR" >> $HOMEDIR/.netrc

  # Controller/lpc/ep firmware

  # Load Controller and loopcard firmware
  echo "put dist.par"  >> $HOMEDIR/.netrc

  echo "quit\n\n"  >> $HOMEDIR/.netrc
  chmod 600 $HOMEDIR/.netrc
}

cleanup() {
  echo "\nCleaning Up Temporary Files..."
  cd $HOMEDIR
  rm -rf $TMPDIR 		# Cleanup Archive File
  rm -f $HOMEDIR/.netrc		# Remove .netrc file
  if [ -f $TMPNETRC ]; then
    mv $TMPNETRC $HOMEDIR/.netrc  # Restore previous .netrc
  fi
}

error_exit_code() {
  cleanup
  echo "Exiting $0...."
  exit 1
}

trap "error_exit_code" 1 2 3

# Mainline code starts here
Patchpro_contract=$FALSE
if [ "$#" -eq 1 ]; then
  if [ "$#"="ppro" ]; then
    Patchpro_contract=$TRUE
  fi
fi

echo  'Please Enter Hostname or IP Address Of DSP To Be Ugpraded: \c'
read TARGET    
ping $TARGET
ERRCODE=$?      
if [ $ERRCODE -ne $FALSE ]; then
  echo 'Target System Unreachable.'
  error_exit_code;
fi

# Get Location of DSP System Files To Upload
echo  "Please Enter Patch Location Pathname [$PATCHDIR]: \c"
read TMP    

if [ "999$TMP" != "999" ]; then
  PATCHDIR=$TMP
fi

# Verify Patch Contents
echo "Looking For Patch Contents In [$PATCHDIR]..."
# 
mkdir $TMPDIR   # Create /tmp directory With File Contents To Upload
ERR=0
FILENAME=patchtoc
PATCHTOC=$PATCHDIR/$FILENAME
echo "----------------- $PATCHTOC -------------------"
if [ -f "${PATCHTOC}" ]; then
  for file in `cat $PATCHDIR/$TOC`
  do
   if [ -s $PATCHDIR/$file ]; then
    echo "$file image located"
    cp $PATCHDIR/$file $TMPDIR
   else
    echo "$file image missing"
    ERR=`expr $ERR + 1`
   fi
  done
else
  echo "Patch TOC Not Found*** $PATCHDIR/$TOC ***"
  ERR=`expr $ERR + 1`
fi

if [ $ERR -gt 0 ]; then
  error_exit_code
fi


netrc_gen			# Generate netrc file

# Start ftp process
echo "Invoking ftp"
ftp $TARGET 

cleanup				# Remove temp directories

exit 0
