/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.remitters.crosscontext;

import com.sun.symon.base.beans.BcTreeNode;
import com.sun.symon.base.server.common.ScPortAllocator;
import com.sun.symon.base.server.common.ScRequestDispatchException;
import com.sun.symon.base.server.common.ScRequestSink;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.events.SvRequestEvent;
import com.sun.symon.base.server.remitters.SmRemitter;
import com.sun.symon.base.server.remitters.crosscontext.Handoff;
import com.sun.symon.base.server.remitters.crosscontext.Requester;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcURL;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SmCrossContextRemitter
extends SmRemitter {
    private String trapHost = null;
    private int trapPort = -1;
    private String contextSubpath = "sym/base/info/system/trapaddr#0";
    private String ourContext = null;
    private Hashtable table = new Hashtable();
    private Vector ipAddresses = null;
    private ScPortAllocator portAllocator;
    public static SmCrossContextRemitter theRemitter;

    public SmCrossContextRemitter() {
        super("snmp");
        theRemitter = this;
        this.portAllocator = ScPortAllocator.getInstance();
        this.ipAddresses = this.portAllocator.getIpAddresses();
    }

    public synchronized boolean canHandle(SvRequestEvent svRequestEvent) {
        return true;
    }

    protected ScRequestSink newSink(SvRequestEvent svRequestEvent) throws ScRequestDispatchException {
        Object object;
        Handoff handoff;
        boolean bl = true;
        String[] stringArray = svRequestEvent.getURL();
        int n = 0;
        while (n < stringArray.length) {
            handoff = new UcURL(stringArray[n]);
            if (handoff.getScheme().compareTo("snmp") != 0) {
                bl = false;
                break;
            }
            object = null;
            try {
                object = InetAddress.getByName(handoff.getHost());
            }
            catch (UnknownHostException unknownHostException) {
                throw new ScRequestDispatchException("Unknown host: " + handoff.getHost());
            }
            String string = handoff.getPort();
            String string2 = ((InetAddress)object).getHostAddress();
            String string3 = ((InetAddress)object).getHostAddress() + ":" + string;
            if (this.table.containsKey(string3)) {
                if (((String)this.table.get(string3)).equals("1")) {
                    bl = false;
                    break;
                }
            } else {
                String string4 = null;
                try {
                    string4 = this.requestContext(string3, svRequestEvent.getSecurity());
                }
                catch (ScRequestDispatchException scRequestDispatchException) {
                    throw new ScRequestDispatchException("Error Requesting context of agent at " + string3, scRequestDispatchException.getStatus());
                }
                if (string4 != null) {
                    this.updateScPortAllocator(string2, string, string4);
                    this.table.put(string3, "0");
                    int n2 = 0;
                    while (n2 < this.ipAddresses.size()) {
                        String string5 = this.ipAddresses.elementAt(n2) + ":" + Integer.toString(this.trapPort);
                        if (string4.equals(string5)) {
                            this.table.put(string3, "1");
                            bl = false;
                            break;
                        }
                        ++n2;
                    }
                } else {
                    throw new ScRequestDispatchException("Failed to find server context of agent at " + string3);
                }
            }
            ++n;
        }
        if (bl) {
            int n3 = 0;
            while (n3 < stringArray.length) {
                object = new UcURL(stringArray[n3]);
                stringArray[n3] = "snmppublic://" + object.getHost() + ":" + object.getPort() + "/" + object.getPath();
                ++n3;
            }
        }
        if (!(handoff = new Handoff()).dispatchNewEvent(this.getRequestDispatcher(), svRequestEvent, stringArray)) {
            handoff = null;
        }
        return handoff;
    }

    public String requestContext(String string, ScSecurityCredential scSecurityCredential) throws ScRequestDispatchException {
        String[] stringArray = new String[]{"snmppublic://" + string + "/" + this.contextSubpath};
        Requester requester = new Requester();
        StObject[][] stObjectArray = null;
        try {
            stObjectArray = requester.waitForResponse(this.getRequestDispatcher(), stringArray, null, scSecurityCredential);
        }
        catch (ScRequestDispatchException scRequestDispatchException) {
            UcDDL.logErrorMessage((String)("Error requesting context for agent at " + string + ": " + scRequestDispatchException));
            throw scRequestDispatchException;
        }
        if (stObjectArray == null || stObjectArray.length != 1 || stObjectArray[0].length != 1) {
            UcDDL.logErrorMessage((String)("Invalid context returned for agent at " + string));
            return null;
        }
        String string2 = ((StString)stObjectArray[0][0]).toString();
        int n = string2.indexOf(":");
        if (n > 0) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            try {
                String string5 = InetAddress.getByName(string3).getHostAddress();
                string2 = string5 + ":" + string4;
            }
            catch (UnknownHostException unknownHostException) {
                UcDDL.logErrorMessage((String)("Unable to resolve host: " + string3));
            }
        }
        UcDDL.logInfoMessage((String)("requestContext: " + string + " -> " + string2));
        return string2;
    }

    private void updateScPortAllocator(String string, String string2, String string3) {
        String string4;
        String string5 = null;
        int n = Integer.parseInt(string2);
        int n2 = string3.indexOf(58);
        string5 = n2 != -1 ? string3.substring(0, n2) : string3;
        InetAddress inetAddress = null;
        try {
            inetAddress = this.portAllocator.getAgentTrapAddress(string, n);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (inetAddress != null && !(string4 = inetAddress.getHostAddress()).equals(string5)) {
            this.portAllocator.addAgent(string + ":" + string2, string5);
        }
    }

    public String getSnmpUrlValue(ScSecurityCredential scSecurityCredential, String string) throws ScRequestDispatchException {
        String[] stringArray = new String[]{string};
        Requester requester = new Requester();
        StObject[][] stObjectArray = null;
        try {
            stObjectArray = requester.waitForResponse(this.getRequestDispatcher(), stringArray, null, scSecurityCredential);
        }
        catch (ScRequestDispatchException scRequestDispatchException) {
            UcDDL.logErrorMessage((String)("Error requesting license for agent at " + string + ": " + scRequestDispatchException));
            throw scRequestDispatchException;
        }
        if (stObjectArray == null || stObjectArray.length != 1 || stObjectArray[0].length != 1) {
            UcDDL.logErrorMessage((String)("Invalid value returned for agent at " + string));
            return null;
        }
        return ((StString)stObjectArray[0][0]).toString();
    }

    public void setTrapHost(String string) {
        this.trapHost = string;
        if (this.trapPort != -1) {
            String string2 = null;
            try {
                string2 = InetAddress.getByName(string).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                UcDDL.logErrorMessage((String)("Unknown trap handler host: " + string));
                string2 = string;
            }
            this.ourContext = string2 + ":" + Integer.toString(this.trapPort);
        }
    }

    public void setTrapPort(int n) {
        this.trapPort = n;
        if (this.trapHost != null) {
            String string = null;
            try {
                string = InetAddress.getByName(this.trapHost).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                UcDDL.logErrorMessage((String)("Unknown trap handler host: " + this.trapHost));
                string = this.trapHost;
            }
            this.ourContext = string + ":" + Integer.toString(n);
        }
    }

    public void clearCache(String string, String string2) throws Exception {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new Exception("Unknown Host: " + string);
        }
        String string3 = inetAddress.getHostAddress() + ":" + string2;
        UcDDL.logInfoMessage((String)("Received request to remove context of agent at " + string3 + " from context table."));
        if (!this.table.containsKey(string3)) {
            throw new Exception("Agent at " + string3 + " was not found in context table.");
        }
        this.table.remove(string3);
        UcDDL.logInfoMessage((String)("Agent at " + string3 + " successfully removed from context table."));
    }

    public void clearCache(String string) throws Exception {
        boolean bl = false;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new Exception("Unknown Host: " + string);
        }
        String string2 = inetAddress.getHostAddress();
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string2)) continue;
            bl = true;
            this.table.remove(string3);
            UcDDL.logInfoMessage((String)("Agent at " + string3 + " successfully removed from context table."));
        }
        if (!bl) {
            throw new Exception("Agent at " + string2 + " was not found in context table.");
        }
    }

    public void clearCache() throws Exception {
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.table.remove(string);
            UcDDL.logInfoMessage((String)("Agent at " + string + " successfully removed from context table."));
        }
    }

    public void clearCache(BcTreeNode bcTreeNode, String[] stringArray) {
        PrintWriter printWriter = bcTreeNode.getOut();
        String string = "usage: clearCache [hostname] [port]";
        if (stringArray.length == 0) {
            try {
                this.clearCache();
            }
            catch (Exception exception) {
                printWriter.println("failed: " + exception);
            }
        } else if (stringArray.length == 1 && stringArray[0] != null) {
            try {
                this.clearCache(stringArray[0]);
            }
            catch (Exception exception) {
                printWriter.println("failed: " + exception);
            }
        } else if (stringArray.length == 2 && stringArray[0] != null && stringArray[1] != null) {
            try {
                this.clearCache(stringArray[0], stringArray[1]);
            }
            catch (Exception exception) {
                printWriter.println("failed: " + exception);
            }
        } else {
            printWriter.println(string);
        }
    }

    public void dumpCache(BcTreeNode bcTreeNode, String[] stringArray) {
        PrintWriter printWriter = bcTreeNode.getOut();
        printWriter.println(this.dumpCache());
    }

    public String dumpCache() {
        String string = "Agent IP:port            Server Context\n";
        Enumeration enumeration = this.table.keys();
        Enumeration enumeration2 = this.table.elements();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            StringBuffer stringBuffer = new StringBuffer((String)enumeration.nextElement());
            StringBuffer stringBuffer2 = new StringBuffer((String)enumeration2.nextElement());
            int n = stringBuffer.length();
            while (n < 24) {
                stringBuffer.append(" ");
                ++n;
            }
            int n2 = stringBuffer2.length();
            while (n2 < 24) {
                stringBuffer2.append(" ");
                ++n2;
            }
            string = string + stringBuffer + " " + stringBuffer2 + "\n";
        }
        return string;
    }
}

