/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.remitters.cache;

import com.sun.symon.base.beans.BcTreeNode;
import com.sun.symon.base.server.common.ScRequestDispatchException;
import com.sun.symon.base.server.common.ScRequestJoiner;
import com.sun.symon.base.server.common.ScRequestSink;
import com.sun.symon.base.server.events.SvRequestEvent;
import com.sun.symon.base.server.remitters.SmRemitter;
import com.sun.symon.base.utility.UcDDL;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SmCacheRemitter
extends SmRemitter {
    private static final String JOB_PREFIX = "J";
    private static final String KEY_PREFIX = "K";
    private Hashtable Cache;
    private DelayEmitter DelayEmitter = new DelayEmitter();

    public SmCacheRemitter() {
        super(null);
        this.Cache = new Hashtable();
    }

    public boolean canHandle(SvRequestEvent svRequestEvent) {
        if (svRequestEvent.getCommand() == 6) {
            return svRequestEvent.getPeriod() != null;
        }
        return svRequestEvent.getCommand() == 1 && svRequestEvent.getData() == null && svRequestEvent.getPeriod() != null;
    }

    protected void jobAdded() {
    }

    protected void cacheEmpty() {
    }

    public synchronized void dumpCache(BcTreeNode bcTreeNode, String[] stringArray) {
        PrintWriter printWriter = bcTreeNode.getOut();
        printWriter.println("Cache jobs:");
        int n = 0;
        Enumeration enumeration = this.Cache.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(JOB_PREFIX)) continue;
            Job job = (Job)this.Cache.get(string);
            printWriter.println("  Job #" + ++n + ":");
            job.dump(printWriter);
        }
    }

    public void emit(Matcher matcher) {
        UcDDL.logDebugMessage((String)"Cache: emit()");
        Hashtable hashtable = new Hashtable();
        int n = KEY_PREFIX.length();
        SmCacheRemitter smCacheRemitter = this;
        synchronized (smCacheRemitter) {
            Enumeration enumeration = this.Cache.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith(KEY_PREFIX) || !matcher.doEmit(string.substring(n))) continue;
                Vector vector = (Vector)this.Cache.get(string);
                int n2 = vector.size();
                int n3 = 0;
                while (n3 < n2) {
                    if (!hashtable.contains(vector.elementAt(n3))) {
                        hashtable.put(vector.elementAt(n3), vector.elementAt(n3));
                    }
                    ++n3;
                }
            }
        }
        int n4 = hashtable.size();
        if (n4 == 0) {
            UcDDL.logDebugMessage((String)"Cache: nothing emitted");
        } else {
            long l = System.currentTimeMillis();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Job job;
                Job job2 = job = (Job)enumeration.nextElement();
                synchronized (job2) {
                    if (l - job.getTimeLastFired() > (long)this.DelayEmitter.getDelayMilliseconds()) {
                        job.emit();
                        job.setTimeLastFired(l);
                    } else {
                        job.incrementRapidFireCount();
                        if (!job.isInDelayQueue()) {
                            this.DelayEmitter.add(job);
                        }
                    }
                }
            }
        }
    }

    protected ScRequestSink newSink(SvRequestEvent svRequestEvent) throws ScRequestDispatchException {
        boolean bl;
        Job job;
        String[] stringArray = svRequestEvent.getURL();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(JOB_PREFIX);
        stringBuffer.append(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append("\u0000");
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        stringBuffer.append("\u0000\u0000");
        stringBuffer.append(svRequestEvent.getPeriod());
        String string = stringBuffer.toString();
        SmCacheRemitter smCacheRemitter = this;
        synchronized (smCacheRemitter) {
            job = (Job)this.Cache.get(string);
            if (job == null) {
                job = new Job(string);
                this.Cache.put(string, job);
                this.jobAdded();
                bl = true;
            } else {
                bl = false;
            }
        }
        UcDDL.logInfoMessage((String)("Cache: " + (bl ? "new entry" : "got hit") + " for '" + svRequestEvent.getURL()[0] + "', '" + svRequestEvent.getPeriod() + "'"));
        return (ScRequestSink)job.createSink(svRequestEvent);
    }

    class DelayEmitter
    extends Thread {
        private static final int INITIAL_DELAY_MS = 2000;
        private Vector list_ = new Vector();
        private boolean haveJobs_ = false;
        private int highestRapidFireCount_ = 0;

        DelayEmitter() {
            this.start();
        }

        public int getDelayMilliseconds() {
            if (this.highestRapidFireCount_ > 50) {
                return 25000;
            }
            if (this.highestRapidFireCount_ > 20) {
                return 10000;
            }
            if (this.highestRapidFireCount_ > 10) {
                return 5000;
            }
            return 2000;
        }

        public void add(Job job) {
            job.setInDelayQueue(true);
            this.list_.addElement(job);
            this.haveJobs_ = true;
            if (this.list_.size() == 1) {
                int n = this.getDelayMilliseconds();
                String string = "SmCacheRemitter.DelayEmitter: Delaying busy jobs by " + n + " ms";
                if (n > 2000) {
                    UcDDL.logWarningMessage((String)string);
                } else {
                    UcDDL.logInfoMessage((String)string);
                }
            }
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.getDelayMilliseconds());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.haveJobs_) continue;
                Vector vector = this.list_;
                synchronized (vector) {
                    Object object;
                    int n = this.list_.size();
                    if (n == 0) {
                        this.haveJobs_ = false;
                        continue;
                    }
                    int n2 = this.getDelayMilliseconds();
                    int n3 = 0;
                    this.highestRapidFireCount_ = 0;
                    int n4 = 0;
                    while (n4 < n) {
                        Job job = (Job)this.list_.elementAt(n4);
                        object = job;
                        synchronized (object) {
                            if (job.getRapidFireCount() > this.highestRapidFireCount_) {
                                this.highestRapidFireCount_ = job.getRapidFireCount();
                            }
                            n3 += job.getRapidFireCount();
                            job.emit();
                            job.setTimeLastFired(System.currentTimeMillis());
                            job.setInDelayQueue(false);
                            job.clearRapidFireCount();
                        }
                        ++n4;
                    }
                    object = "SmCacheRemitter.DelayEmitter: Fired " + n + " delayed jobs " + "(Number of job firing during " + n2 + " ms: Highest: " + this.highestRapidFireCount_ + " Average: " + (n3 /= n) + " Next delay of busy jobs: " + this.getDelayMilliseconds() + " ms)";
                    if (n2 > 2000) {
                        UcDDL.logWarningMessage((String)object);
                    } else {
                        UcDDL.logInfoMessage((String)object);
                    }
                    this.list_.clear();
                    this.haveJobs_ = false;
                }
            }
        }
    }

    private class Job
    extends ScRequestJoiner {
        private String FullKey;
        private String[][] Keys;
        private boolean InDelayQueue = false;
        private long TimeLastFired = 0L;
        private int RapidFireCount = 0;

        Job(String string) {
            super(SmCacheRemitter.this.getRequestDispatcher());
            this.FullKey = string;
            this.Keys = null;
        }

        protected void sinkDelete(ScRequestSink scRequestSink) {
            SmCacheRemitter smCacheRemitter = SmCacheRemitter.this;
            synchronized (smCacheRemitter) {
                super.sinkDelete(scRequestSink);
                if (SmCacheRemitter.this.Cache.size() == 0) {
                    SmCacheRemitter.this.cacheEmpty();
                }
            }
        }

        protected void allDeleted() {
            SmCacheRemitter.this.Cache.remove(this.FullKey);
            if (this.Keys != null) {
                int n = 0;
                while (n < this.Keys.length) {
                    int n2 = 0;
                    while (n2 < this.Keys[n].length) {
                        this.removeKey(this.Keys[n][n2]);
                        ++n2;
                    }
                    ++n;
                }
            }
            super.allDeleted();
        }

        protected void ready() {
            this.Keys = this.getCacheKeys();
            if (this.Keys != null) {
                int n = 0;
                while (n < this.Keys.length) {
                    int n2 = 0;
                    while (n2 < this.Keys[n].length) {
                        this.addKey(this.Keys[n][n2]);
                        ++n2;
                    }
                    ++n;
                }
            }
        }

        private void addKey(String string) {
            string = SmCacheRemitter.KEY_PREFIX + string;
            Vector<Job> vector = (Vector<Job>)SmCacheRemitter.this.Cache.get(string);
            if (vector == null) {
                vector = new Vector<Job>();
                SmCacheRemitter.this.Cache.put(string, vector);
            }
            vector.addElement(this);
        }

        private void removeKey(String string) {
            string = SmCacheRemitter.KEY_PREFIX + string;
            Vector vector = (Vector)SmCacheRemitter.this.Cache.get(string);
            vector.removeElement(this);
            if (vector.size() == 0) {
                SmCacheRemitter.this.Cache.remove(string);
            }
        }

        void setInDelayQueue(boolean bl) {
            this.InDelayQueue = bl;
        }

        boolean isInDelayQueue() {
            return this.InDelayQueue;
        }

        void setTimeLastFired(long l) {
            this.TimeLastFired = l;
        }

        long getTimeLastFired() {
            return this.TimeLastFired;
        }

        void incrementRapidFireCount() {
            ++this.RapidFireCount;
        }

        void clearRapidFireCount() {
            this.RapidFireCount = 0;
        }

        int getRapidFireCount() {
            return this.RapidFireCount;
        }

        void dump(PrintWriter printWriter) {
            printWriter.println("    # originating requests=" + this.getNumSinks());
            String string = this.FullKey.substring(1);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
            int n = stringTokenizer.countTokens() - 1;
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (n2 == n) {
                    printWriter.println("    period=" + string2);
                    continue;
                }
                printWriter.println("    url[" + n2 + "]=" + string2);
                ++n2;
            }
            if (this.Keys == null) {
                printWriter.println("    keys=null");
            } else {
                int n3 = 0;
                while (n3 < this.Keys.length) {
                    int n4 = 0;
                    while (n4 < this.Keys[n3].length) {
                        printWriter.println("    keys[" + n3 + "][" + n4 + "]='" + this.Keys[n3][n4] + "'");
                        ++n4;
                    }
                    ++n3;
                }
            }
        }
    }

    public static interface Matcher {
        public boolean doEmit(String var1);
    }
}

