/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.rmi;

import com.sun.symon.base.security.SyCoderInterface;
import com.sun.symon.base.security.SyEndInsecureInterface;
import com.sun.symon.base.security.SySecurity;
import com.sun.symon.base.security.SySecurityException;
import com.sun.symon.base.server.common.ScRequestConstants;
import com.sun.symon.base.server.common.ScResponseException;
import com.sun.symon.base.server.lookup.SlRMILookup;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1BulkResponse;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1Exception;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1Response;
import com.sun.symon.base.server.receptors.rmi.RMIConnectionLostEvent;
import com.sun.symon.base.server.receptors.rmi.RMIConnectionLostListener;
import com.sun.symon.base.server.receptors.rmi.RMIDataComposer;
import com.sun.symon.base.server.receptors.rmi.RMIDataDecomposer;
import com.sun.symon.base.server.receptors.rmi.RMILoginException;
import com.sun.symon.base.server.receptors.rmi.RMIProbeInterface;
import com.sun.symon.base.server.receptors.rmi.RMIResponseException;
import com.sun.symon.base.server.receptors.rmi.RMIResponseInterface;
import com.sun.symon.base.server.receptors.rmi.RMISecurityException;
import com.sun.symon.base.server.receptors.rmi.RMIServiceCollectorInterface;
import com.sun.symon.base.server.receptors.rmi.RMISessionServiceInterface;
import com.sun.symon.base.server.types.StInteger;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcPeriodicException;
import com.sun.symon.base.utility.UcTickerTimer;
import com.sun.symon.base.utility.UcTickerTimerResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Vector;

public class RMIClientLevel1
extends UnicastRemoteObject
implements RMIResponseInterface,
ScRequestConstants {
    private static final int PINGINTERVAL = 60;
    private static final int MAXRETRIES = 5;
    private static BigInteger One = new BigInteger("1");
    private BigInteger CurrentHandle;
    private Hashtable ClientCallbackHandle2Originator;
    private Hashtable Originator2ClientCallbackHandle;
    private RMISessionServiceInterface server;
    private String UserId = null;
    private SyEndInsecureInterface insecureEndpoint;
    private int pingCounter = 0;
    private int serverPingInterval = 0;
    private int maxPingRetries = 0;
    private String serverHost = null;
    private UcTickerTimer pingTicker = null;
    private Vector connectionLostListeners = new Vector();

    public RMIClientLevel1(String string, int n) throws RMIClientLevel1Exception, IOException, ClassNotFoundException {
        this.CurrentHandle = new BigInteger("0");
        this.ClientCallbackHandle2Originator = new Hashtable();
        this.Originator2ClientCallbackHandle = new Hashtable();
        RMIServiceCollectorInterface rMIServiceCollectorInterface = null;
        try {
            if (string == null) {
                string = "";
            }
            if (string.trim().equals("localhost")) {
                string = InetAddress.getLocalHost().getHostName();
            }
            String string2 = n == 0 ? string : string + ":" + n;
            SlRMILookup slRMILookup = new SlRMILookup(string, n);
            rMIServiceCollectorInterface = (RMIServiceCollectorInterface)slRMILookup.lookup("RMIClientServerV3");
            this.serverHost = string;
        }
        catch (UnknownHostException unknownHostException) {
            UcDDL.logErrorMessage((String)("Error in connection -- unknown host: " + unknownHostException.getMessage()));
            throw unknownHostException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            UcDDL.logErrorMessage((String)("Error in connection -- " + classNotFoundException.getMessage()));
            throw classNotFoundException;
        }
        catch (IOException iOException) {
            UcDDL.logErrorMessage((String)("Error in connection -- " + iOException.getMessage() + ": a server or network failure"));
            throw iOException;
        }
        try {
            this.server = rMIServiceCollectorInterface.getSessionObject(this);
        }
        catch (Throwable throwable) {
            UcDDL.logWarningMessage((String)"getSessionObject() failed", (Throwable)throwable);
            throw new RMIClientLevel1Exception(3, throwable.toString());
        }
        if (this.server == null) {
            throw new RMIClientLevel1Exception(4);
        }
    }

    public void authenticate(String string, String string2, String string3) throws RMILoginException, RemoteException {
        SySecurity sySecurity = new SySecurity();
        this.authenticate(string, string2, string3, sySecurity.getDefaultScheme(), false);
    }

    public void authenticate(String string, String string2, String string3, String string4, boolean bl) throws RMILoginException, RemoteException {
        byte[] byArray;
        byte[] byArray2;
        Object object;
        try {
            object = new SySecurity();
            UcDDL.logInfoMessage((String)("Using security scheme '" + string4 + "'"));
            this.insecureEndpoint = object.endInsecureLookup(string3, string4);
            byArray2 = this.insecureEndpoint.negotiateStart(bl);
            byArray = this.server.negotiate(string4, bl, byArray2);
            this.insecureEndpoint.negotiateEnd(byArray);
        }
        catch (SySecurityException sySecurityException) {
            UcDDL.logErrorMessage((String)"security negotiation failed", (Throwable)sySecurityException);
            throw new RMILoginException(4, "unable to authenticate Server");
        }
        object = new RMIDataComposer((SyCoderInterface)this.insecureEndpoint, true);
        ((RMIDataComposer)object).writeObject(string);
        ((RMIDataComposer)object).writeObject(string2);
        byArray2 = ((RMIDataComposer)object).getBytes();
        byArray = this.server.authenticate(byArray2);
        this.checkForLoginException(byArray);
        this.UserId = string;
        this.serverPingInterval = 60;
        this.maxPingRetries = 5;
        this.createPingTimer();
    }

    public synchronized void addRMIConnectionLostListener(RMIConnectionLostListener rMIConnectionLostListener) {
        if (!this.connectionLostListeners.contains(rMIConnectionLostListener)) {
            this.connectionLostListeners.add(rMIConnectionLostListener);
        }
    }

    public synchronized void removeRMIConnectionLostListener(RMIConnectionLostListener rMIConnectionLostListener) {
        this.connectionLostListeners.remove(rMIConnectionLostListener);
    }

    public void disconnect() {
        this.connectionLostListeners.removeAllElements();
        if (this.pingTicker != null) {
            this.pingTicker.stop();
            this.pingTicker = null;
        }
    }

    private void createPingTimer() {
        int n = this.getServerPingInterval();
        try {
            this.pingTicker = new UcTickerTimer((long)n, new UcTickerTimerResponse(){

                public void processTick() {
                    if (!RMIClientLevel1.this.isServerAlive()) {
                        RMIClientLevel1.this.verifyServerConnection();
                    }
                }

                public void processTickEnd() {
                }
            });
        }
        catch (UcPeriodicException ucPeriodicException) {
            // empty catch block
        }
        this.pingTicker.start();
    }

    private void verifyServerConnection() {
        try {
            this.server.isSunHostOnly();
        }
        catch (Exception exception) {
            this.fireConnectionLost();
        }
    }

    protected void fireConnectionLost() {
        Vector vector;
        Vector vector2 = this.connectionLostListeners;
        synchronized (vector2) {
            vector = (Vector)this.connectionLostListeners.clone();
        }
        RMIConnectionLostEvent rMIConnectionLostEvent = new RMIConnectionLostEvent(this);
        int n = 0;
        while (n < vector.size()) {
            RMIConnectionLostListener rMIConnectionLostListener = (RMIConnectionLostListener)vector.elementAt(n);
            rMIConnectionLostListener.connectionLost(rMIConnectionLostEvent);
            ++n;
        }
    }

    private void checkForLoginException(byte[] byArray) throws RemoteException, RMILoginException {
        RMIDataDecomposer rMIDataDecomposer = new RMIDataDecomposer(byArray, (SyCoderInterface)this.insecureEndpoint, false);
        RMILoginException rMILoginException = (RMILoginException)rMIDataDecomposer.readObject();
        if (rMILoginException != null) {
            throw rMILoginException;
        }
    }

    private void checkForSecurityException(byte[] byArray) throws RemoteException, RMISecurityException {
        RMIDataDecomposer rMIDataDecomposer = new RMIDataDecomposer(byArray, (SyCoderInterface)this.insecureEndpoint, false);
        RMISecurityException rMISecurityException = (RMISecurityException)rMIDataDecomposer.readObject();
        if (rMISecurityException != null) {
            throw rMISecurityException;
        }
    }

    private synchronized String createCallbackHandle(RMIClientLevel1Response rMIClientLevel1Response, boolean bl) {
        String string = (bl ? "S" : "M") + this.CurrentHandle;
        this.CurrentHandle = this.CurrentHandle.add(One);
        this.ClientCallbackHandle2Originator.put(string, rMIClientLevel1Response);
        this.Originator2ClientCallbackHandle.put(rMIClientLevel1Response, string);
        return string;
    }

    private synchronized void deleteCallbackHandle(String string, RMIClientLevel1Response rMIClientLevel1Response) {
        this.ClientCallbackHandle2Originator.remove(string);
        this.Originator2ClientCallbackHandle.remove(rMIClientLevel1Response);
    }

    public void deleteRequest(RMIClientLevel1Response rMIClientLevel1Response) throws RemoteException, RMISecurityException {
        String string = this.lookupCallbackHandle(rMIClientLevel1Response);
        if (string != null) {
            this.deleteCallbackHandle(string, rMIClientLevel1Response);
            RMIDataComposer rMIDataComposer = new RMIDataComposer((SyCoderInterface)this.insecureEndpoint, false);
            rMIDataComposer.writeObject(string);
            byte[] byArray = rMIDataComposer.getBytes();
            byte[] byArray2 = this.server.deleteRequest(byArray);
            this.checkForSecurityException(byArray2);
        }
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public String getConfigurationBaseURL() throws RemoteException, RMISecurityException {
        return this.getUrl(0);
    }

    public String getEventBaseURL() throws RemoteException, RMISecurityException {
        return this.getUrl(1);
    }

    public String getTopologyBaseURL() throws RemoteException, RMISecurityException {
        return this.getUrl(2);
    }

    public String getMDRBaseURL() throws RemoteException, RMISecurityException {
        return this.getUrl(5);
    }

    public String getCSTBaseURL() throws RemoteException, RMISecurityException {
        return this.getUrl(6);
    }

    public String getESDIR() throws RemoteException, RMISecurityException {
        return this.getUrl(3);
    }

    public String getImageSubpath() throws RemoteException, RMISecurityException {
        return this.getUrl(4);
    }

    public boolean isSunHostOnly() throws RemoteException, RMISecurityException {
        return this.server.isSunHostOnly();
    }

    public int getServerPingInterval() {
        return this.serverPingInterval;
    }

    private String getUrl(int n) throws RemoteException, RMISecurityException {
        RMIDataComposer rMIDataComposer = new RMIDataComposer((SyCoderInterface)this.insecureEndpoint, false);
        rMIDataComposer.writeInt(n);
        byte[] byArray = this.server.getURL(rMIDataComposer.getBytes());
        RMIDataDecomposer rMIDataDecomposer = new RMIDataDecomposer(byArray, (SyCoderInterface)this.insecureEndpoint, false);
        RMISecurityException rMISecurityException = (RMISecurityException)rMIDataDecomposer.readObject();
        if (rMISecurityException != null) {
            throw rMISecurityException;
        }
        String string = (String)rMIDataDecomposer.readObject();
        return string;
    }

    public String getUserId() {
        return this.UserId;
    }

    private boolean isOneShot(String string) {
        return string.charAt(0) == 'S';
    }

    private synchronized String lookupCallbackHandle(RMIClientLevel1Response rMIClientLevel1Response) {
        return (String)this.Originator2ClientCallbackHandle.get(rMIClientLevel1Response);
    }

    private synchronized RMIClientLevel1Response lookupOriginator(String string) {
        return (RMIClientLevel1Response)this.ClientCallbackHandle2Originator.get(string);
    }

    public void newRequest(int n, String[] stringArray, StObject[][] stObjectArray, String string, RMIClientLevel1Response rMIClientLevel1Response) throws RemoteException, RMISecurityException {
        String string2 = this.createCallbackHandle(rMIClientLevel1Response, string == null);
        RMIDataComposer rMIDataComposer = new RMIDataComposer((SyCoderInterface)this.insecureEndpoint, false);
        rMIDataComposer.writeInt(n);
        rMIDataComposer.writeObject(stringArray);
        rMIDataComposer.writeObject(stObjectArray);
        rMIDataComposer.writeObject(string);
        rMIDataComposer.writeObject(string2);
        byte[] byArray = rMIDataComposer.getBytes();
        byte[] byArray2 = this.server.newRequest(byArray);
        this.checkForSecurityException(byArray2);
    }

    public void newBulkRequest(int n, int n2, String[] stringArray, String string, RMIClientLevel1BulkResponse rMIClientLevel1BulkResponse) throws RemoteException, RMISecurityException {
        int n3;
        int n4 = stringArray[0].substring(7).indexOf(":");
        if (n4 == -1 | (n3 = stringArray[0].substring(7).indexOf("/")) == -1) {
            throw new RemoteException("Invalid get bulk request");
        }
        String string2 = stringArray[0].substring(7, n4 + 7);
        String string3 = stringArray[0].substring(n4 + 8, n3 + 7);
        int n5 = 1;
        while (n5 < stringArray.length) {
            int n6;
            int n7 = stringArray[n5].substring(7).indexOf(":");
            if (n7 == -1 | (n6 = stringArray[n5].substring(7).indexOf("/")) == -1) {
                throw new RemoteException("Invalid get bulk request");
            }
            String string4 = stringArray[n5].substring(7, n7 + 7);
            String string5 = stringArray[n5].substring(n7 + 8, n6 + 7);
            if (!(string4.compareTo(string2) == 0 & string5.compareTo(string3) == 0)) {
                throw new RemoteException("Invalid get bulk request");
            }
            ++n5;
        }
        int n8 = 6;
        StObject[][] stObjectArray = new StObject[1][2];
        stObjectArray[0][0] = new StInteger(new Integer(n).toString());
        stObjectArray[0][1] = new StInteger(new Integer(n2).toString());
        class Wrapper
        implements RMIClientLevel1Response {
            RMIClientLevel1BulkResponse originator;
            private final /* synthetic */ RMIClientLevel1 this$0;

            private Wrapper(RMIClientLevel1 rMIClientLevel1, RMIClientLevel1BulkResponse rMIClientLevel1BulkResponse) {
                this.this$0 = rMIClientLevel1;
                this.originator = rMIClientLevel1BulkResponse;
            }

            public boolean receiveDataResult(StObject[][] stObjectArray) {
                return this.originator.receiveDataResult(stObjectArray[0], stObjectArray[1]);
            }

            public boolean receiveException(RMIResponseException rMIResponseException, String string) {
                return this.originator.receiveException(rMIResponseException, string);
            }

            /* synthetic */ Wrapper(RMIClientLevel1 rMIClientLevel1, RMIClientLevel1BulkResponse rMIClientLevel1BulkResponse, 1 var3_3) {
                this(rMIClientLevel1, rMIClientLevel1BulkResponse);
            }
        }
        Wrapper wrapper2 = new Wrapper(this, rMIClientLevel1BulkResponse, null);
        this.newRequest(6, stringArray, stObjectArray, string, wrapper2);
    }

    public Socket probeConnect(String string, String[] stringArray) throws IOException, RemoteException, RMISecurityException {
        Socket socket;
        String string2 = this.getProbeCookie(string, stringArray);
        int n = string2.indexOf(58);
        if (n == -1) {
            throw new RemoteException("invalid fields from SET request: '" + string2 + "'");
        }
        String string3 = string2.substring(0, n);
        if (string3.equals("Error")) {
            throw new RemoteException(string2);
        }
        int n2 = string2.indexOf(58, n + 1);
        if (n2 == -1) {
            throw new RemoteException("invalid fields from SET request: '" + string2 + "'");
        }
        int n3 = Integer.parseInt(string2.substring(n + 1, n2));
        String string4 = string2.substring(n2 + 1) + "\n";
        try {
            socket = new Socket(string3, n3);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RemoteException("invalid host returned SET request: '" + string3 + "'");
        }
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(string4.getBytes());
        outputStream.flush();
        return socket;
    }

    public String getProbeCookie(String string, String[] stringArray) throws RemoteException, RMISecurityException {
        String string2 = stringArray == null ? "" : UcListUtil.composeList((String[])stringArray);
        return this.getProbeCookie(string, string2);
    }

    protected String getProbeCookie(String string, String string2) throws RemoteException, RMISecurityException {
        class Response
        implements RMIClientLevel1Response {
            boolean ready;
            StObject[][] responseResults;
            Exception responseException;
            private final /* synthetic */ RMIClientLevel1 this$0;

            Response(RMIClientLevel1 rMIClientLevel1) {
                this.this$0 = rMIClientLevel1;
                this.ready = false;
                this.responseResults = null;
                this.responseException = null;
            }

            public synchronized boolean receiveDataResult(StObject[][] stObjectArray) {
                this.ready = true;
                this.responseResults = stObjectArray;
                this.notify();
                return false;
            }

            public synchronized boolean receiveException(RMIResponseException rMIResponseException, String string) {
                this.ready = true;
                this.responseException = rMIResponseException;
                this.notify();
                return false;
            }
        }
        Response response = new Response(this);
        this.newRequest(0, new String[]{string}, new StString[][]{{new StString(string2)}}, null, response);
        try {
            Response response2 = response;
            synchronized (response2) {
                if (!response.ready) {
                    response.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RemoteException("unexpected interruption", interruptedException);
        }
        if (response.responseException != null) {
            throw new RemoteException("initial SET request failed", response.responseException);
        }
        if (response.responseResults == null || response.responseResults.length != 1 || response.responseResults[0].length != 1) {
            throw new RemoteException("invalid response from SET request");
        }
        return ((StString)response.responseResults[0][0]).getValue();
    }

    public String getProbeErrCookie(String string, String[] stringArray) throws RemoteException, RMISecurityException {
        String string2;
        if (stringArray == null) {
            String[] stringArray2 = new String[]{"-se", ""};
            string2 = UcListUtil.composeList((String[])stringArray2);
        } else {
            String[] stringArray3 = new String[]{"-se", UcListUtil.composeList((String[])stringArray)};
            string2 = UcListUtil.composeList((String[])stringArray3);
        }
        return this.getProbeCookie(string, string2);
    }

    public Socket[] probeConnectWithStderr(String string, String[] stringArray) throws IOException, RemoteException, RMISecurityException {
        String string2 = this.getProbeErrCookie(string, stringArray);
        int n = string2.indexOf(58);
        if (n == -1) {
            throw new RemoteException("invalid fields from SET request: '" + string2 + "'");
        }
        String string3 = string2.substring(0, n);
        if (string3.equals("Error")) {
            throw new RemoteException(string2);
        }
        int n2 = string2.indexOf(58, n + 1);
        if (n2 == -1) {
            throw new RemoteException("invalid fields from SET request: '" + string2 + "'");
        }
        int n3 = Integer.parseInt(string2.substring(n + 1, n2));
        String string4 = string2.substring(n2 + 1) + "\n";
        Socket[] socketArray = new Socket[2];
        try {
            socketArray[0] = new Socket(string3, n3);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RemoteException("invalid host returned SET request: '" + string3 + "'");
        }
        OutputStream outputStream = socketArray[0].getOutputStream();
        outputStream.write(string4.getBytes());
        outputStream.flush();
        try {
            socketArray[1] = new Socket(string3, n3);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RemoteException("invalid host returned SET request: '" + string3 + "'");
        }
        OutputStream outputStream2 = socketArray[1].getOutputStream();
        outputStream2.write(string4.getBytes());
        outputStream2.flush();
        return socketArray;
    }

    public byte[] receiveDataResult(byte[] byArray) throws RemoteException {
        boolean bl = false;
        RMIDataDecomposer rMIDataDecomposer = new RMIDataDecomposer(byArray, (SyCoderInterface)this.insecureEndpoint, false);
        String string = (String)rMIDataDecomposer.readObject();
        StObject[][] stObjectArray = (StObject[][])rMIDataDecomposer.readObject();
        RMIClientLevel1Response rMIClientLevel1Response = this.lookupOriginator(string);
        if (rMIClientLevel1Response == null) {
            bl = false;
        } else {
            try {
                bl = rMIClientLevel1Response.receiveDataResult(stObjectArray);
            }
            catch (Throwable throwable) {
                UcDDL.logErrorMessage((String)"receiveDataResult callback failed", (Throwable)throwable);
            }
            if (!bl || this.isOneShot(string)) {
                this.deleteCallbackHandle(string, rMIClientLevel1Response);
            }
        }
        RMIDataComposer rMIDataComposer = new RMIDataComposer((SyCoderInterface)this.insecureEndpoint, false);
        rMIDataComposer.writeBoolean(bl);
        byte[] byArray2 = rMIDataComposer.getBytes();
        return byArray2;
    }

    public byte[] receiveException(byte[] byArray) throws RemoteException {
        boolean bl = false;
        RMIDataDecomposer rMIDataDecomposer = new RMIDataDecomposer(byArray, (SyCoderInterface)this.insecureEndpoint, false);
        String string = (String)rMIDataDecomposer.readObject();
        ScResponseException scResponseException = (ScResponseException)rMIDataDecomposer.readObject();
        String string2 = (String)rMIDataDecomposer.readObject();
        RMIResponseException rMIResponseException = new RMIResponseException(scResponseException.getMessage(), scResponseException.getStatus());
        RMIClientLevel1Response rMIClientLevel1Response = this.lookupOriginator(string);
        if (rMIClientLevel1Response == null) {
            bl = false;
        } else {
            try {
                bl = rMIClientLevel1Response.receiveException(rMIResponseException, string2);
            }
            catch (Throwable throwable) {
                UcDDL.logErrorMessage((String)"receiveException callback failed", (Throwable)throwable);
            }
            if (!bl || this.isOneShot(string)) {
                this.deleteCallbackHandle(string, rMIClientLevel1Response);
            }
        }
        RMIDataComposer rMIDataComposer = new RMIDataComposer((SyCoderInterface)this.insecureEndpoint, false);
        rMIDataComposer.writeBoolean(bl);
        byte[] byArray2 = rMIDataComposer.getBytes();
        return byArray2;
    }

    public synchronized void ping() throws RemoteException {
        this.pingCounter = 0;
    }

    public synchronized boolean isServerAlive() {
        if (this.pingCounter >= this.maxPingRetries) {
            return false;
        }
        ++this.pingCounter;
        return true;
    }

    public int getModuleLicense() throws RemoteException {
        return this.server.getModuleLicense();
    }

    public int getServiceLicense(String string) throws RemoteException {
        return this.server.getServiceLicense(string);
    }

    public Boolean isLicenseAvailable(String string) throws RemoteException {
        return this.server.isLicenseAvailable(string);
    }

    public String[] getServices() throws RemoteException {
        String[] stringArray = null;
        try {
            stringArray = this.server.getServices();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            UcDDL.logInfoMessage((String)("RMILevel1: getService: " + remoteException.getMessage()));
            throw remoteException;
        }
    }

    public RMIProbeInterface getProbeService() throws RemoteException {
        try {
            return this.server.getProbeService();
        }
        catch (RemoteException remoteException) {
            UcDDL.logInfoMessage((String)("RMILevel1: getProbeService: " + remoteException.getMessage()));
            throw remoteException;
        }
    }

    public Object getService(String string, String[] stringArray) throws RemoteException {
        Object object = null;
        try {
            object = this.server.getService(string, stringArray);
            return object;
        }
        catch (RemoteException remoteException) {
            UcDDL.logInfoMessage((String)("RMILevel1: getService: " + remoteException.getMessage()));
            throw remoteException;
        }
    }
}

