/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.local;

import com.sun.symon.base.server.common.ScRequestConstants;
import com.sun.symon.base.server.common.ScResponseException;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.lookup.SlLocalLookupService;
import com.sun.symon.base.server.receptors.local.LocalClientLevel1;
import com.sun.symon.base.server.receptors.local.LocalReceptor;
import com.sun.symon.base.server.receptors.local.LocalSession;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1Response;
import com.sun.symon.base.server.receptors.rmi.RMILoginException;
import com.sun.symon.base.server.receptors.rmi.RMIResponseException;
import com.sun.symon.base.server.receptors.rmi.RMISecurityException;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcListUtil;
import java.math.BigInteger;
import java.util.Hashtable;

public class LocalClientLevel1
implements ScRequestConstants {
    private static BigInteger One = new BigInteger("1");
    private BigInteger currentHandle = new BigInteger("0");
    private Hashtable clientCallbackHandle2Originator = new Hashtable();
    private Hashtable originator2ClientCallbackHandle = new Hashtable();
    private LocalSession session;
    private String userId;

    public LocalClientLevel1(ScSecurityCredential scSecurityCredential) {
        this.userId = scSecurityCredential.getUser();
        this.session = LocalReceptor.getReceptor().getSession(scSecurityCredential);
        this.session.setOriginator(this);
    }

    public LocalClientLevel1() {
        this.userId = null;
        this.session = LocalReceptor.getReceptor().getSession();
        this.session.setOriginator(this);
    }

    public void authenticate(String string, String string2) throws RMILoginException {
        this.session.authenticate(string, string2);
        this.userId = string;
    }

    public String getUserId() {
        return this.userId;
    }

    public void newRequest(int n, String[] stringArray, StObject[][] stObjectArray, String string, RMIClientLevel1Response rMIClientLevel1Response) throws RMISecurityException {
        String string2 = this.createCallbackHandle(rMIClientLevel1Response, string == null);
        this.session.newRequest(n, stringArray, stObjectArray, string, string2);
    }

    private synchronized String createCallbackHandle(RMIClientLevel1Response rMIClientLevel1Response, boolean bl) {
        String string = (bl ? "S" : "M") + this.currentHandle;
        this.currentHandle = this.currentHandle.add(One);
        this.clientCallbackHandle2Originator.put(string, rMIClientLevel1Response);
        this.originator2ClientCallbackHandle.put(rMIClientLevel1Response, string);
        return string;
    }

    private synchronized RMIClientLevel1Response lookupOriginator(String string) {
        return (RMIClientLevel1Response)this.clientCallbackHandle2Originator.get(string);
    }

    public boolean receiveException(String string, String string2, Exception exception) {
        boolean bl = false;
        RMIClientLevel1Response rMIClientLevel1Response = this.lookupOriginator(string);
        if (rMIClientLevel1Response != null) {
            ScResponseException scResponseException = (ScResponseException)exception;
            RMIResponseException rMIResponseException = new RMIResponseException(scResponseException.getMessage(), scResponseException.getStatus());
            bl = rMIClientLevel1Response.receiveException(rMIResponseException, string2);
            if (this.isOneShot(string)) {
                this.deleteCallbackHandle(string, rMIClientLevel1Response);
            }
        }
        return bl;
    }

    public boolean receiveDataResult(String string, StObject[][] stObjectArray) {
        boolean bl = false;
        RMIClientLevel1Response rMIClientLevel1Response = this.lookupOriginator(string);
        if (rMIClientLevel1Response != null && (!(bl = rMIClientLevel1Response.receiveDataResult(stObjectArray)) || this.isOneShot(string))) {
            this.deleteCallbackHandle(string, rMIClientLevel1Response);
        }
        return bl;
    }

    private boolean isOneShot(String string) {
        return string.charAt(0) == 'S';
    }

    private synchronized void deleteCallbackHandle(String string, RMIClientLevel1Response rMIClientLevel1Response) {
        if (this.clientCallbackHandle2Originator != null) {
            this.clientCallbackHandle2Originator.remove(string);
        }
        if (this.originator2ClientCallbackHandle != null) {
            this.originator2ClientCallbackHandle.remove(rMIClientLevel1Response);
        }
    }

    public void deleteRequest(RMIClientLevel1Response rMIClientLevel1Response) throws RMISecurityException {
        String string = this.lookupCallbackHandle(rMIClientLevel1Response);
        if (string != null) {
            this.deleteCallbackHandle(string, rMIClientLevel1Response);
            this.session.requestDeleteByHandle(string);
        }
    }

    private synchronized String lookupCallbackHandle(RMIClientLevel1Response rMIClientLevel1Response) {
        return (String)this.originator2ClientCallbackHandle.get(rMIClientLevel1Response);
    }

    public String getConfigurationBaseURL() {
        return LocalReceptor.getReceptor().getConfigurationBaseURL();
    }

    public String getEventBaseURL() {
        return LocalReceptor.getReceptor().getEventBaseURL();
    }

    public String getTopologyBaseURL() {
        return LocalReceptor.getReceptor().getTopologyBaseURL();
    }

    public String getMDRBaseURL() {
        return LocalReceptor.getReceptor().getMDRBaseURL();
    }

    public String getESDIR() {
        return LocalReceptor.getReceptor().getESDIR();
    }

    public String getProbeCookie(String string, String[] stringArray) throws Exception {
        String string2 = stringArray == null ? "" : UcListUtil.composeList((String[])stringArray);
        return this.getProbeCookie(string, string2);
    }

    public String getProbeCookie(String string, String string2) throws Exception {
        class Response
        implements RMIClientLevel1Response {
            boolean ready;
            StObject[][] responseResults;
            Exception responseException;
            private final /* synthetic */ LocalClientLevel1 this$0;

            Response(LocalClientLevel1 localClientLevel1) {
                this.this$0 = localClientLevel1;
                this.ready = false;
                this.responseResults = null;
                this.responseException = null;
            }

            public synchronized boolean receiveDataResult(StObject[][] stObjectArray) {
                this.ready = true;
                this.responseResults = stObjectArray;
                this.notify();
                return false;
            }

            public synchronized boolean receiveException(RMIResponseException rMIResponseException, String string) {
                this.ready = true;
                this.responseException = rMIResponseException;
                this.notify();
                return false;
            }
        }
        Response response = new Response(this);
        this.newRequest(0, new String[]{string}, new StString[][]{{new StString(string2)}}, null, response);
        try {
            Response response2 = response;
            synchronized (response2) {
                if (!response.ready) {
                    response.wait();
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("base.client.ClientApiMessages:ProbeConnection.InvalidFieldsFromSetRequest");
        }
        if (response.responseException != null) {
            throw new Exception("base.client.ClientApiMessages:ProbeConnection.InvalidFieldsFromSetRequest");
        }
        if (response.responseResults == null || response.responseResults.length != 1 || response.responseResults[0].length != 1) {
            throw new Exception("base.client.ClientApiMessages:ProbeConnection.InvalidFieldsFromSetRequest");
        }
        return ((StString)response.responseResults[0][0]).getValue();
    }

    public String getProbeErrCookie(String string, String[] stringArray) throws Exception {
        String string2;
        if (stringArray == null) {
            String[] stringArray2 = new String[]{"-se", ""};
            string2 = UcListUtil.composeList((String[])stringArray2);
        } else {
            String[] stringArray3 = new String[]{"-se", UcListUtil.composeList((String[])stringArray)};
            string2 = UcListUtil.composeList((String[])stringArray3);
        }
        return this.getProbeCookie(string, string2);
    }

    public void disconnect() {
        this.session.clientDied();
        this.clientCallbackHandle2Originator = null;
        this.originator2ClientCallbackHandle = null;
        this.session = null;
    }

    public Object getService(String string, String[] stringArray) throws Exception {
        try {
            SlLocalLookupService.getInstance();
            return SlLocalLookupService.lookup(string, stringArray, this.session);
        }
        catch (Exception exception) {
            UcDDL.logInfoMessage((String)("LocalClientLevel1: getService: " + exception.getMessage()));
            throw exception;
        }
    }
}

