/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.emitters.snmp;

import com.sun.symon.base.beans.BcTreeNode;
import com.sun.symon.base.server.common.ScRequestDispatchException;
import com.sun.symon.base.server.common.ScRequestSink;
import com.sun.symon.base.server.common.ScRequestSinkInterface;
import com.sun.symon.base.server.common.ScResponseException;
import com.sun.symon.base.server.emitters.SeEmitter;
import com.sun.symon.base.server.emitters.snmp.SeSnmpEmitter;
import com.sun.symon.base.server.emitters.snmp.SeSnmpException;
import com.sun.symon.base.server.emitters.snmp.SeSnmpFinder;
import com.sun.symon.base.server.emitters.snmp.SeSnmpMessenger;
import com.sun.symon.base.server.emitters.snmp.SeSnmpPrivCache;
import com.sun.symon.base.server.emitters.snmp.SeSnmpRequestor;
import com.sun.symon.base.server.emitters.snmp.tooBigSink;
import com.sun.symon.base.server.events.SvRequestEvent;
import com.sun.symon.base.server.remitters.splitter.SmSplitterLocationRemitter;
import com.sun.symon.base.server.remitters.ticker.SmTickerRemitter;
import com.sun.symon.base.server.snmp.jni.SsPacket;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcDDL;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.SocketException;

public class SeSnmpEmitter
extends SeEmitter {
    public static String DESCBC_OID = "1.3.6.1.6.3.10.1.2.2";
    private static boolean desd = false;
    private boolean initd;
    private SeSnmpRequestor requestor;
    private SeSnmpFinder finder;
    private SeSnmpPrivCache privCache;
    private SeSnmpMessenger messenger;
    private int maxPacketSize = 65536;
    private String finderOid = "1.3.6.1.4.1.1242.1.1.1.1.0";
    private String privreqOid = "1.3.6.1.4.1.42.2.12.2.1.2.2.1.7";
    private long timeout = 10L;
    private int securityLevel = 1;
    private int securityModel = 1;
    private String publicId = "public";
    private String publicPassword = "public";
    private String publicAuthProtocol = "1.3.6.1.6.3.6.1.3.1";
    private String publicPrivProtocol = "0.0";
    private String privateId = "private";
    private String privatePassword = "maplesyrup";
    private String privateAuthProtocol = "1.3.6.1.6.3.6.1.3.1";
    private String privatePrivProtocol = "0.0";
    private boolean fixedCommunities = false;
    private String readCommunity = "public";
    private String writeCommunity = "private";
    private boolean autoNegotiate = false;
    private long finderCacheScanFreq = 0L;
    private int finderCacheMaxAge = 0;

    public SeSnmpEmitter() {
        super("snmp", false, true);
        this.pushRemitter(new SmSplitterLocationRemitter());
        this.pushRemitter(new SmTickerRemitter());
        this.initd = false;
    }

    public String getFinderOid() {
        return this.finderOid;
    }

    public int getPacketSize() {
        return this.maxPacketSize;
    }

    public long getTimeOut() {
        return this.timeout;
    }

    private void loadDes(String string) {
        if (desd) {
            return;
        }
        if (string.equals(DESCBC_OID)) {
            try {
                SsPacket.loadDes();
            }
            catch (LinkageError linkageError) {
                UcDDL.logErrorMessage((String)"Link error ", (Throwable)linkageError);
                System.exit(-1);
            }
            desd = true;
        }
    }

    private void init() throws ScRequestDispatchException {
        SsPacket.add(this.privateId, this.privatePassword, this.privateAuthProtocol, this.privatePrivProtocol);
        SsPacket.add(this.publicId, this.publicPassword, this.publicAuthProtocol, this.publicPrivProtocol);
        try {
            this.messenger = new SeSnmpMessenger(this.timeout, this.maxPacketSize);
        }
        catch (SocketException socketException) {
            UcDDL.logErrorMessage((String)"snmp socket creation error", (Throwable)socketException);
            throw new ScRequestDispatchException("snmp socket creation error: " + socketException.getMessage());
        }
        this.requestor = new SeSnmpRequestor(this.messenger, this.publicId);
        this.finder = new SeSnmpFinder(this.finderOid, this.finderCacheScanFreq, this.finderCacheMaxAge, this.requestor);
        this.requestor.setFinder(this.finder);
        this.privCache = this.requestor.setPrivFeatures(this.autoNegotiate, this.privreqOid);
    }

    protected ScRequestSink newSink(SvRequestEvent svRequestEvent) throws ScRequestDispatchException {
        StObject[] stObjectArray;
        SeSnmpEmitter seSnmpEmitter = this;
        synchronized (seSnmpEmitter) {
            if (!this.initd) {
                this.initd = true;
                this.init();
            }
        }
        StObject[][] stObjectArray2 = svRequestEvent.getData();
        if (svRequestEvent.getCommand() == 6) {
            if (stObjectArray2 == null) {
                throw new ScRequestDispatchException("bad data: data == null");
            }
            if (stObjectArray2.length != 1) {
                throw new ScRequestDispatchException("bad data: data.length != 1");
            }
            if (stObjectArray2[0].length != 2) {
                throw new ScRequestDispatchException("bad data: data[0].length != 2");
            }
            stObjectArray = new StObject[]{stObjectArray2[0][0], stObjectArray2[0][1]};
        } else if (stObjectArray2 == null) {
            stObjectArray = null;
        } else {
            stObjectArray = new StObject[stObjectArray2.length];
            int n = 0;
            while (n < stObjectArray2.length) {
                if (stObjectArray2[n] == null) {
                    stObjectArray[n] = null;
                } else if (stObjectArray2[n].length == 1) {
                    stObjectArray[n] = stObjectArray2[n][0];
                } else {
                    throw new ScRequestDispatchException("bad data: data[" + n + "].length != 1");
                }
                ++n;
            }
        }
        try {
            return this.createSink(svRequestEvent, stObjectArray);
        }
        catch (SeSnmpException seSnmpException) {
            String string = seSnmpException.getFullMessage();
            int n = seSnmpException.getUrlOrOidIndex();
            String string2 = svRequestEvent.getURL()[n];
            throw new ScRequestDispatchException(string, string2);
        }
    }

    private ScRequestSink createSink(SvRequestEvent svRequestEvent, StObject[] stObjectArray) throws SeSnmpException {
        class Sink
        extends ScRequestSink
        implements SeSnmpRequestor.ResultCallback {
            private ScRequestSinkInterface requestSink;
            public SeSnmpRequestor Req;
            public int SLevel;
            public int SModel;
            private final /* synthetic */ SvRequestEvent val$event;
            private final /* synthetic */ StObject[] val$data;
            private final /* synthetic */ SeSnmpEmitter this$0;

            Sink(SeSnmpEmitter seSnmpEmitter, SvRequestEvent svRequestEvent, StObject[] stObjectArray, SeSnmpRequestor seSnmpRequestor, int n, int n2) throws SeSnmpException {
                this.this$0 = seSnmpEmitter;
                this.val$event = svRequestEvent;
                this.val$data = stObjectArray;
                this.Req = seSnmpRequestor;
                this.SLevel = n;
                this.SModel = n2;
                String string = svRequestEvent.getSecurity().getUser();
                if (SeSnmpEmitter.access$000(seSnmpEmitter)) {
                    string = svRequestEvent.getCommand() == 0 ? SeSnmpEmitter.access$100(seSnmpEmitter) : SeSnmpEmitter.access$200(seSnmpEmitter);
                }
                this.requestSink = seSnmpRequestor.createRequestByUrl(svRequestEvent.getCommand(), string, n, n2, svRequestEvent.getURL(), stObjectArray, this);
            }

            public void handleResult(StObject[] stObjectArray) {
                StObject[][] stObjectArray2 = new StObject[stObjectArray.length][1];
                int n = 0;
                while (n < stObjectArray.length) {
                    stObjectArray2[n][0] = stObjectArray[n];
                    ++n;
                }
                this.respond(stObjectArray2);
            }

            public void handleResultBulk(StObject[][] stObjectArray) {
                this.respond(stObjectArray);
            }

            public void handleException(SeSnmpException seSnmpException) {
                int n = seSnmpException.getUrlOrOidIndex();
                String string = this.val$event.getURL()[n];
                int n2 = seSnmpException.getErrorIndex();
                ScResponseException scResponseException = null;
                switch (n2) {
                    case 1: {
                        StObject[] stObjectArray = this.handleTooBig();
                        if (stObjectArray != null) {
                            this.handleResult(stObjectArray);
                            return;
                        }
                    }
                    case 6: {
                        scResponseException = new ScResponseException(seSnmpException.getFullMessage(), 1);
                        break;
                    }
                    case 17: {
                        scResponseException = new ScResponseException(seSnmpException.getFullMessage(), 6);
                        break;
                    }
                    case 7: {
                        scResponseException = new ScResponseException(seSnmpException.getFullMessage(), 5);
                        break;
                    }
                    case 1000: {
                        scResponseException = new ScResponseException(seSnmpException.getFullMessage(), 2);
                        break;
                    }
                    case 1001: {
                        scResponseException = new ScResponseException(seSnmpException.getFullMessage(), 4);
                        break;
                    }
                    default: {
                        scResponseException = new ScResponseException(seSnmpException.getFullMessage(), 3);
                    }
                }
                this.respond(string, scResponseException);
            }

            public StObject[] handleTooBig() {
                if (this.val$event.getURL().length > 1 && this.val$event.getCommand() == 1) {
                    try {
                        tooBigSink tooBigSink2 = new tooBigSink(this.Req, this.SLevel, this.SModel, this.val$event, SeSnmpEmitter.access$000(this.this$0), SeSnmpEmitter.access$200(this.this$0), SeSnmpEmitter.access$100(this.this$0));
                        return tooBigSink2.getResults();
                    }
                    catch (SeSnmpException seSnmpException) {
                        return null;
                    }
                }
                return null;
            }

            protected void doDelete() {
                this.requestSink.delete();
            }

            protected void doEmit() {
                this.requestSink.emit();
            }

            public String[][] getCacheKeys() {
                return this.requestSink.getCacheKeys();
            }
        }
        return new Sink(this, svRequestEvent, stObjectArray, this.requestor, this.securityLevel, this.securityModel);
    }

    public void setPrivReqOid(String string) {
        this.privreqOid = string;
    }

    public void setFinderOid(String string) {
        this.finderOid = string;
    }

    public void setFinderCacheMaxAge(int n) {
        this.finderCacheMaxAge = n;
    }

    public void setFinderCacheScanFreq(long l) {
        this.finderCacheScanFreq = l;
    }

    public void setFixedCommunities(boolean bl) {
        this.fixedCommunities = bl;
    }

    public void setAutoNegotiate(boolean bl) {
        this.autoNegotiate = bl;
    }

    public void setPacketSize(int n) {
        this.maxPacketSize = this.maxPacketSize;
    }

    public void setPublicId(String string) {
        this.publicId = string;
    }

    public void setPublicPassword(String string) {
        this.publicPassword = string;
    }

    public void setPublicAuthProtocol(String string) {
        this.publicAuthProtocol = string;
    }

    public void setPublicPrivProtocol(String string) {
        this.publicPrivProtocol = string;
        this.loadDes(string);
    }

    public void setPrivateId(String string) {
        this.privateId = string;
    }

    public String getPrivateId() {
        return this.privateId;
    }

    public void setPrivatePassword(String string) {
        this.privatePassword = string;
    }

    public void setPrivateAuthProtocol(String string) {
        this.privateAuthProtocol = string;
    }

    public void setPrivatePrivProtocol(String string) {
        this.privatePrivProtocol = string;
        this.loadDes(string);
    }

    public void setReadCommunity(String string) {
        this.readCommunity = string;
    }

    public void setSecurityLevel(String string) {
        if (string.equals("NoAuthenticationNoPrivacy")) {
            this.securityLevel = 1;
        } else if (string.equals("AuthenticationNoPrivacy")) {
            this.securityLevel = 2;
        } else if (string.equals("AuthenticationPrivacy")) {
            this.securityLevel = 3;
        } else {
            UcDDL.logErrorMessage((String)("invalid security level: '" + string + "'"));
            this.securityLevel = 1;
        }
    }

    public void setSecurityModel(String string) {
        if (string.equals("AnySecurity")) {
            this.securityModel = 1;
        } else if (string.equals("V1CommunitySecurity")) {
            this.securityModel = 2;
        } else if (string.equals("V2CommunitySecurity")) {
            this.securityModel = 3;
        } else if (string.equals("V2UserSecurity")) {
            this.securityModel = 4;
        } else {
            UcDDL.logErrorMessage((String)("invalid security model: '" + string + "'"));
            this.securityModel = 1;
        }
    }

    public void setTimeOut(long l) {
        this.timeout = l;
    }

    public void setWriteCommunity(String string) {
        this.writeCommunity = string;
    }

    public String dumpFinderCache() {
        if (this.finder != null) {
            return this.finder.dumpCaches();
        }
        return "No Finder Cache Exists for this emitter.";
    }

    public void dumpFinderCache(BcTreeNode bcTreeNode, String[] stringArray) {
        PrintWriter printWriter = bcTreeNode.getOut();
        if (this.finder != null) {
            printWriter.println(this.finder.dumpCaches());
        } else {
            printWriter.println("No Finder Cache Exists for this emitter.");
        }
    }

    public void clearFinderCache() throws Exception {
        try {
            if (this.finder != null) {
                this.finder.wipeCaches();
                UcDDL.logInfoMessage((String)"Cleared finder caches");
            }
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("Failed to clear finder cache: " + exception));
            throw new Exception("Failed to clear finder cache: " + exception);
        }
    }

    public void clearFinderCache(String string) throws Exception {
        String string2 = null;
        try {
            string2 = InetAddress.getByName(string).getHostAddress();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("Failed to clear host from finder cache: Unknown Host: " + string));
            throw new Exception("Failed to clear host from finder cache: Unknown Host: " + string);
        }
        try {
            if (this.finder != null) {
                this.finder.clearHostOidsFromCache(string2);
                UcDDL.logInfoMessage((String)("Host " + string2 + " cleared from finder cache"));
            }
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("Failed to clear host from finder cache: " + exception));
            throw new Exception("Failed to clear host from finder cache: " + exception);
        }
    }

    public void clearFinderCache(String string, String string2) throws Exception {
        String string3 = null;
        try {
            string3 = InetAddress.getByName(string).getHostAddress();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("Failed to clear host from finder cache: Unknown Host: " + string));
            throw new Exception("Failed to clear host from finder cache: Unknown Host: " + string);
        }
        try {
            string3 = string3 + ":" + string2;
            if (this.finder != null) {
                this.finder.clearHostOidsFromCache(string3);
                UcDDL.logInfoMessage((String)("Host:Port " + string3 + " cleared from finder cache"));
            }
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("Failed to clear host from finder cache: " + exception));
            throw new Exception("Failed to clear host from finder cache: " + exception);
        }
    }

    public void clearFinderCache(BcTreeNode bcTreeNode, String[] stringArray) {
        PrintWriter printWriter = bcTreeNode.getOut();
        String string = "usage: clearFinderCache [hostname] [port]";
        String string2 = null;
        if (stringArray.length > 0 && stringArray[0] != null) {
            try {
                string2 = InetAddress.getByName(stringArray[0]).getHostAddress();
            }
            catch (Exception exception) {
                printWriter.println("Unknown host: " + stringArray[0]);
                return;
            }
        }
        if (stringArray.length == 2 && stringArray[0] != null && stringArray[1] != null) {
            try {
                Integer.parseInt(stringArray[1]);
                string2 = string2 + ":" + stringArray[1];
            }
            catch (Exception exception) {
                printWriter.println("Invalid port: " + stringArray[1]);
                return;
            }
        }
        if (stringArray.length > 2) {
            printWriter.println(string);
            return;
        }
        if (string2 == null) {
            try {
                this.finder.wipeCaches();
            }
            catch (Exception exception) {
                printWriter.println("failed: " + exception.getMessage());
            }
        } else {
            try {
                this.finder.clearHostOidsFromCache(string2);
            }
            catch (Exception exception) {
                printWriter.println("failed: " + exception.getMessage());
            }
        }
    }

    public String dumpSnmpCache() {
        String string = this.dumpFinderCache();
        string = this.privCache != null ? string + this.privCache.dumpCaches() : string + "\nNo Privacy OID Cache Exists for this emitter.\n";
        return string;
    }

    public void clearSnmpCache() throws Exception {
        this.clearFinderCache();
        try {
            if (this.privCache != null) {
                this.privCache.wipeCaches();
            }
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("Failed to clear Privacy OID cache: " + exception));
            throw new Exception("Failed to clear Privacy OID cache: " + exception);
        }
    }

    private void clearPrivOidCache(String string, String string2) throws Exception {
        if (this.privCache == null) {
            return;
        }
        String string3 = null;
        try {
            string3 = InetAddress.getByName(string).getHostAddress();
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("Failed to clear host from Privacy OID cache: Unknown Host: " + string));
            throw new Exception("Failed to clear host from Privacy OID cache: Unknown Host: " + string);
        }
        if (string2 == null) {
            this.privCache.clearHost(string3);
        } else {
            this.privCache.clearHostPort(string3, string2);
        }
    }

    public void clearSnmpCache(String string) throws Exception {
        this.clearFinderCache(string);
        this.clearPrivOidCache(string, null);
    }

    public void clearSnmpCache(String string, String string2) throws Exception {
        this.clearFinderCache(string, string2);
        this.clearPrivOidCache(string, string2);
    }

    static /* synthetic */ boolean access$000(SeSnmpEmitter seSnmpEmitter) {
        return seSnmpEmitter.fixedCommunities;
    }

    static /* synthetic */ String access$100(SeSnmpEmitter seSnmpEmitter) {
        return seSnmpEmitter.writeCommunity;
    }

    static /* synthetic */ String access$200(SeSnmpEmitter seSnmpEmitter) {
        return seSnmpEmitter.readCommunity;
    }
}

