/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.emitters.control;

import com.sun.symon.base.server.common.ScRequestDispatchException;
import com.sun.symon.base.server.common.ScRequestSink;
import com.sun.symon.base.server.common.ScResponseException;
import com.sun.symon.base.server.emitters.SeEmitter;
import com.sun.symon.base.server.emitters.control.SeControlEmitter;
import com.sun.symon.base.server.emitters.snmp.SeSnmpEmitter;
import com.sun.symon.base.server.events.SvRequestEvent;
import com.sun.symon.base.server.remitters.crosscontext.SmCrossContextRemitter;
import com.sun.symon.base.server.remitters.snmpjob.SmSnmpJobRemitter;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcURL;

public class SeControlEmitter
extends SeEmitter {
    private SeSnmpEmitter snmpEmitter;
    private SeSnmpEmitter snmppublicEmitter;
    private SeSnmpEmitter snmpv1Emitter;
    private SmCrossContextRemitter crossContextRemitter;
    private SmSnmpJobRemitter snmpJobRemitter;

    public SeControlEmitter() {
        super(false, false);
    }

    public void setSnmpEmitter(Object object) {
        this.snmpEmitter = (SeSnmpEmitter)object;
    }

    public void setSnmppublicEmitter(Object object) {
        this.snmppublicEmitter = (SeSnmpEmitter)object;
    }

    public void setSnmpv1Emitter(Object object) {
        this.snmpv1Emitter = (SeSnmpEmitter)object;
    }

    public void setCrossContextRemitter(Object object) {
        this.crossContextRemitter = (SmCrossContextRemitter)object;
    }

    public void setSnmpJobRemitter(Object object) {
        this.snmpJobRemitter = (SmSnmpJobRemitter)object;
        this.snmpJobRemitter.registerController(this);
    }

    public void handleMibRestructureTrap(String string) {
        this.handleWarmStartTrap(string);
    }

    public void handleWarmStartTrap(String string) {
        if (this.snmpEmitter != null) {
            try {
                this.snmpEmitter.clearFinderCache(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.snmppublicEmitter != null) {
            try {
                this.snmppublicEmitter.clearFinderCache(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.snmpv1Emitter != null) {
            try {
                this.snmpv1Emitter.clearFinderCache(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.crossContextRemitter != null) {
            try {
                this.crossContextRemitter.clearCache(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ScRequestSink newSink(SvRequestEvent svRequestEvent) throws ScRequestDispatchException {
        class Sink
        extends ScRequestSink {
            private SvRequestEvent theEvent;
            private final /* synthetic */ SeControlEmitter this$0;

            public Sink(SeControlEmitter seControlEmitter, SvRequestEvent svRequestEvent) {
                this.this$0 = seControlEmitter;
                this.theEvent = svRequestEvent;
            }

            private String getPrivateId() {
                return SeControlEmitter.access$000(this.this$0).getPrivateId();
            }

            private boolean checkSecurity() {
                String string = this.theEvent.getSecurity().getUser();
                return string.equals(this.getPrivateId());
            }

            protected void doEmit() {
                if (!this.checkSecurity()) {
                    this.respond(this.theEvent.getURL()[0], new ScResponseException("Server Control Functions must be requested by user " + this.getPrivateId(), 1));
                    return;
                }
                try {
                    int n;
                    UcURL ucURL = new UcURL(this.theEvent.getURL()[0]);
                    String string = ucURL.getSubPath();
                    StObject[][] stObjectArray = this.theEvent.getData();
                    String string2 = null;
                    String string3 = null;
                    int n2 = this.theEvent.getCommand();
                    if (n2 == 0 && (n = (string2 = ((StString)stObjectArray[0][0]).toString()).indexOf(" ")) > 0) {
                        string3 = string2.substring(n + 1);
                        string2 = string2.substring(0, n);
                    }
                    if (string.equals("finder") && string2 == null) {
                        this.dumpSnmpCache();
                    } else if (string.equals("finder") && string2.equals("clear")) {
                        this.clearSnmpCache();
                    } else if (string.equals("finder") && string2.equals("remove") && string3 != null) {
                        this.removeSnmpCache(string3);
                    } else if (string.equals("context") && string2 == null) {
                        this.dumpContext();
                    } else if (string.equals("context") && string2.equals("clear")) {
                        this.clearContext();
                    } else if (string.equals("context") && string2.equals("remove") && string3 != null) {
                        this.removeContext(string3);
                    } else {
                        this.respond(this.theEvent.getURL()[0], new ScResponseException("Unknown control command", 2));
                    }
                }
                catch (Exception exception) {
                    this.respond(this.theEvent.getURL()[0], new ScResponseException(exception.getMessage(), 3));
                }
            }

            private void dumpSnmpCache() throws Exception {
                boolean bl = false;
                String string = "";
                if (SeControlEmitter.access$000(this.this$0) != null) {
                    bl = true;
                    string = string + "\nSnmp Emitter's SNMP Caches:\n";
                    string = string + SeControlEmitter.access$000(this.this$0).dumpSnmpCache();
                }
                if (SeControlEmitter.access$100(this.this$0) != null) {
                    bl = true;
                    string = string + "\nCross Context Snmp Emitter's SNMP Caches:\n";
                    string = string + SeControlEmitter.access$100(this.this$0).dumpSnmpCache();
                }
                if (SeControlEmitter.access$200(this.this$0) != null) {
                    bl = true;
                    string = string + "\nSnmp V1 Emitter's SNMP Caches:\n";
                    string = string + SeControlEmitter.access$200(this.this$0).dumpSnmpCache();
                }
                if (!bl) {
                    throw new Exception("No snmp emitters found");
                }
                this.respond(new StObject[][]{{new StString(string)}});
            }

            private void clearSnmpCache() throws Exception {
                boolean bl = false;
                if (SeControlEmitter.access$000(this.this$0) != null) {
                    bl = true;
                    SeControlEmitter.access$000(this.this$0).clearSnmpCache();
                }
                if (SeControlEmitter.access$100(this.this$0) != null) {
                    bl = true;
                    SeControlEmitter.access$100(this.this$0).clearSnmpCache();
                }
                if (SeControlEmitter.access$200(this.this$0) != null) {
                    bl = true;
                    SeControlEmitter.access$200(this.this$0).clearSnmpCache();
                }
                if (!bl) {
                    throw new Exception("No snmp emitters found");
                }
                this.respond(new StObject[][]{{new StString("Server Snmp Caches cleared of all entries")}});
            }

            private void removeSnmpCache(String string) throws Exception {
                boolean bl = false;
                String string2 = null;
                String string3 = null;
                int n = string.indexOf(":");
                if (n > 0) {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 1);
                } else {
                    string2 = string;
                }
                if (SeControlEmitter.access$000(this.this$0) != null) {
                    bl = true;
                    if (string3 != null) {
                        SeControlEmitter.access$000(this.this$0).clearSnmpCache(string2, string3);
                    } else {
                        SeControlEmitter.access$000(this.this$0).clearSnmpCache(string2);
                    }
                }
                if (SeControlEmitter.access$100(this.this$0) != null) {
                    bl = true;
                    if (string3 != null) {
                        SeControlEmitter.access$100(this.this$0).clearSnmpCache(string2, string3);
                    } else {
                        SeControlEmitter.access$100(this.this$0).clearSnmpCache(string2);
                    }
                }
                if (SeControlEmitter.access$200(this.this$0) != null) {
                    bl = true;
                    if (string3 != null) {
                        SeControlEmitter.access$200(this.this$0).clearSnmpCache(string2, string3);
                    } else {
                        SeControlEmitter.access$200(this.this$0).clearSnmpCache(string2);
                    }
                }
                if (!bl) {
                    throw new Exception("No snmp emitters found");
                }
                this.respond(new StObject[][]{{new StString("Server Snmp Caches cleared of all entries for host " + string2 + " port " + string3)}});
            }

            private void dumpContext() throws Exception {
                String string = "\n*** Server Context Cache ***\n";
                if (SeControlEmitter.access$300(this.this$0) == null) {
                    throw new Exception("Could not find cross context remitter");
                }
                string = string + SeControlEmitter.access$300(this.this$0).dumpCache();
                this.respond(new StObject[][]{{new StString(string)}});
            }

            private void clearContext() throws Exception {
                if (SeControlEmitter.access$300(this.this$0) == null) {
                    throw new Exception("Could not find cross context remitter");
                }
                SeControlEmitter.access$300(this.this$0).clearCache();
                this.respond(new StObject[][]{{new StString("Server Context Cache cleared of all entries")}});
            }

            private void removeContext(String string) throws Exception {
                String string2 = null;
                String string3 = null;
                int n = string.indexOf(":");
                if (n > 0) {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 1);
                } else {
                    string2 = string;
                }
                if (SeControlEmitter.access$300(this.this$0) != null) {
                    if (string3 != null) {
                        SeControlEmitter.access$300(this.this$0).clearCache(string2, string3);
                    } else {
                        SeControlEmitter.access$300(this.this$0).clearCache(string2);
                    }
                } else {
                    throw new Exception("Could not find cross context remitter");
                }
                this.respond(new StObject[][]{{new StString("Server Context Cache cleared of entry for " + string)}});
            }

            protected void doDelete() {
            }
        }
        return new Sink(this, svRequestEvent);
    }

    static /* synthetic */ SeSnmpEmitter access$000(SeControlEmitter seControlEmitter) {
        return seControlEmitter.snmpEmitter;
    }

    static /* synthetic */ SeSnmpEmitter access$100(SeControlEmitter seControlEmitter) {
        return seControlEmitter.snmppublicEmitter;
    }

    static /* synthetic */ SeSnmpEmitter access$200(SeControlEmitter seControlEmitter) {
        return seControlEmitter.snmpv1Emitter;
    }

    static /* synthetic */ SmCrossContextRemitter access$300(SeControlEmitter seControlEmitter) {
        return seControlEmitter.crossContextRemitter;
    }
}

