/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.common;

import com.sun.symon.base.mgmtservice.common.MSProperties;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcDDLLocalSetup;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class MSLogPrintWriter
extends PrintWriter {
    private static MSProperties properties_;
    private static HashSet initialActiveChannels_;
    private int channel_;
    private boolean active_;
    private StringBuffer buf_ = new StringBuffer();
    private static String ACTIVE_KEY;
    private static MSLogPrintWriter debug_;
    private static MSLogPrintWriter error_;
    private static MSLogPrintWriter info_;
    private static MSLogPrintWriter warning_;
    private static Hashtable customChannels_;

    public static void init(String string) {
        MSLogPrintWriter.init(string, false);
    }

    public static void init(String string, boolean bl) {
        properties_ = new MSProperties();
        String string2 = "error warning info debug sql";
        try {
            properties_.load(string);
            if (bl) {
                MSLogPrintWriter.searchDirs(properties_);
            }
            String string3 = properties_.getProperty(ACTIVE_KEY, string2);
            UcDDL.setChannelActivateList((String)string3);
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            while (stringTokenizer.hasMoreTokens()) {
                initialActiveChannels_.add(stringTokenizer.nextToken());
            }
            String string4 = properties_.getProperty("DEFAULT");
            UcDDL.setDefaultOutputStream((String)string4);
            System.setOut(new PrintStream(new ServicePrintStream(info_)));
            System.setErr(new PrintStream(new ServicePrintStream(error_)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            UcDDL.setChannelActivateList((String)string2);
        }
    }

    public static MSLogPrintWriter getDebugWriter() {
        return debug_;
    }

    public static MSLogPrintWriter getErrorWriter() {
        return error_;
    }

    public static MSLogPrintWriter getInfoWriter() {
        return info_;
    }

    public static MSLogPrintWriter getWarningWriter() {
        return warning_;
    }

    public static MSLogPrintWriter createChannel(String string) throws IOException {
        if (customChannels_.containsKey(string)) {
            throw new FileNotFoundException(string + " channel already exists");
        }
        return new MSLogPrintWriter(string);
    }

    public static MSLogPrintWriter getChannel(String string) throws IOException {
        MSLogPrintWriter mSLogPrintWriter = (MSLogPrintWriter)customChannels_.get(string);
        if (mSLogPrintWriter == null) {
            throw new IOException(string + " not found");
        }
        return mSLogPrintWriter;
    }

    private MSLogPrintWriter(int n) {
        super(System.out);
        this.channel_ = n;
        this.active_ = UcDDL.channelIsActive((int)this.channel_);
    }

    private MSLogPrintWriter(String string) throws IOException {
        super(System.out);
        this.active_ = initialActiveChannels_.contains(string);
        if (properties_ == null) {
            this.channel_ = UcDDL.createChannel((String)string, (boolean)this.active_);
            return;
        }
        String string2 = properties_.getProperty(string);
        if (string2 != null && !string2.equals("")) {
            PrintWriter printWriter = UcDDLLocalSetup.createInterfaceStream((String)string2);
            this.channel_ = UcDDL.createChannel((String)string, (boolean)this.active_);
            UcDDL.channelSetStream((int)this.channel_, (PrintWriter)printWriter);
        } else {
            this.channel_ = UcDDL.createChannel((String)string, (boolean)this.active_);
        }
        customChannels_.put(string, this);
    }

    public void setActive(boolean bl) {
        UcDDL.channelActivate((int)this.channel_, (boolean)bl);
        this.active_ = bl;
    }

    public boolean isActive() {
        this.active_ = UcDDL.channelIsActive((int)this.channel_);
        return this.active_;
    }

    public void flush() {
        if (this.active_) {
            UcDDL.logMessage((int)this.channel_, (String)this.buf_.toString(), null);
        }
        this.buf_ = new StringBuffer();
    }

    public void close() {
        this.flush();
    }

    public boolean checkError() {
        this.flush();
        return false;
    }

    public void write(int n) {
        if (!this.active_) {
            return;
        }
        this.buf_.append(n);
    }

    public void write(char[] cArray, int n, int n2) {
        if (!this.active_) {
            return;
        }
        this.buf_.append(cArray, n, n2);
    }

    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    public void write(String string, int n, int n2) {
        if (!this.active_) {
            return;
        }
        this.buf_.append(new String(string.toCharArray(), n, n2));
    }

    public void write(String string) {
        this.write(string, 0, string.length());
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int n) {
        this.write(String.valueOf(n));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) {
        this.write(cArray);
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    public void println() {
        if (!this.active_) {
            return;
        }
        this.flush();
    }

    public void println(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.print(bl);
            this.println();
        }
    }

    public void println(char c) {
        Object object = this.lock;
        synchronized (object) {
            this.print(c);
            this.println();
        }
    }

    public void println(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.print(n);
            this.println();
        }
    }

    public void println(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.print(l);
            this.println();
        }
    }

    public void println(float f) {
        Object object = this.lock;
        synchronized (object) {
            this.print(f);
            this.println();
        }
    }

    public void println(double d) {
        Object object = this.lock;
        synchronized (object) {
            this.print(d);
            this.println();
        }
    }

    public void println(char[] cArray) {
        Object object = this.lock;
        synchronized (object) {
            this.print(cArray);
            this.println();
        }
    }

    public void println(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.print(string);
            this.println();
        }
    }

    public void println(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.print(object);
            this.println();
        }
    }

    public void println(Throwable throwable) {
        this.println("", throwable);
    }

    public void println(String string, Throwable throwable) {
        if (this.active_) {
            this.write(string);
            UcDDL.logMessage((int)this.channel_, (String)this.buf_.toString(), (Throwable)throwable);
        }
        this.buf_ = new StringBuffer();
    }

    static void searchDirs(MSProperties mSProperties) {
        String string = System.getProperty("ESDIR", "/var/opt/SUNWsymon");
        String string2 = string + "/AdvancedServices/logs/";
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory() && !fileArray[n].getName().startsWith("core")) {
                MSLogPrintWriter.searchDir(fileArray[n].getAbsoluteFile(), mSProperties);
            }
            ++n;
        }
    }

    private static void searchDir(File file, MSProperties mSProperties) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            block9: {
                if (fileArray[n].isFile() && fileArray[n].getName().endsWith(".properties")) {
                    MSProperties mSProperties2 = new MSProperties();
                    try {
                        mSProperties2.load(new FileInputStream(fileArray[n]));
                    }
                    catch (Exception exception) {
                        break block9;
                    }
                    Enumeration enumeration = ((Hashtable)mSProperties2).keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (string.equals(ACTIVE_KEY)) {
                            String string2 = (String)((Hashtable)mSProperties).get(ACTIVE_KEY);
                            if (string2 == null) {
                                string2 = "";
                            }
                            ((Hashtable)mSProperties).put(ACTIVE_KEY, string2 + " " + ((Hashtable)mSProperties2).get(string));
                            continue;
                        }
                        if (((Hashtable)mSProperties).containsKey(string)) {
                            warning_.println("Rejecting duplicate log key: " + string);
                            continue;
                        }
                        ((Hashtable)mSProperties).put(string, ((Hashtable)mSProperties2).get(string));
                    }
                }
            }
            ++n;
        }
    }

    static {
        initialActiveChannels_ = new HashSet();
        ACTIVE_KEY = "ACTIVE";
        debug_ = new MSLogPrintWriter(UcDDL.DDL_DEBUG);
        error_ = new MSLogPrintWriter(UcDDL.DDL_ERROR);
        info_ = new MSLogPrintWriter(UcDDL.DDL_INFO);
        warning_ = new MSLogPrintWriter(UcDDL.DDL_WARNING);
        customChannels_ = new Hashtable();
    }

    static class ServicePrintStream
    extends OutputStream {
        MSLogPrintWriter channel_;
        StringBuffer line_ = new StringBuffer();
        int lineSeparator_ = System.getProperty("line.separator").charAt(0);

        public ServicePrintStream(MSLogPrintWriter mSLogPrintWriter) {
            this.channel_ = mSLogPrintWriter;
        }

        public void write(int n) {
            if (n == this.lineSeparator_) {
                this.channel_.println(this.line_.toString());
                this.line_ = new StringBuffer();
            } else {
                this.line_.append((char)n);
            }
        }
    }
}

