#!/bin/sh

#pragma ident "@(#)gui-archivetool-filtering.sh	1.35 05/05/31 Sun Microsystems"
# Copyright 05/31/05 Sun Microsystems, Inc. All Rights Reserved.

#           Main starts here                                            #
#########################################################################
PROGNAME="archive-tool"

PREV_DIR=`/usr/bin/pwd`
SCRIPT_DIR=`/usr/bin/dirname $PROGNAME`

AGENT_UPDATE_DIR="/var/opt/SUNWsymon/agentupdate/"

AUTOCONFIG_SAVEFILE=""
REMOTE_TARGET_DIR="/opt"

UPGRADE_POLICY_FILE=""
UPGRADE_POLICY_FILE_NAME=""

API_DIR=""
LIB_DIR=""

ARCHIVE_BASE_FLAG=0
ARCHIVE_ADDON_FLAG=0
ARCHIVE_PATCHES_FLAG=0
ARCHIVE_PRODUCT_SELECTION=""
SPLIT_SIZE=0
DEFAULT_SPLIT_SIZE=1024

SETUP_RESPONSE_FILE=""
INSTALL_RESPONSE_FILE=""
RESPONSE_FILE_LIST=""
COMPONENT_SCRIPT_LIST=""

CURRENT_PROCESS=$$
/usr/bin/rm -f $AGENT_UPDATE_DIR/process.dat
/usr/bin/echo "CURRENT_PROCESS=$CURRENT_PROCESS" > $AGENT_UPDATE_DIR/process.dat

# The source image processing will create 4 source lists. One for each OS. 
# Declaring required variables.

SOURCE_LIST_6="" ; SELECTED_KEYS_6=""; AVAILABLE_KEYS_6="";
ALL_OPTIONAL_COMPONENTS_6=""; SORTED_COMPONENTS_LIST_6=""; 
COMPONENT_FILTERS_LIST_6=""; COMP_NAMES_6=""; INIT_COMP_DETAILS_6=""
SOURCE_LIST_7="" ; SELECTED_KEYS_7=""; AVAILABLE_KEYS_7="";
ALL_OPTIONAL_COMPONENTS_7=""; SORTED_COMPONENTS_LIST_7="";
COMPONENT_FILTERS_LIST_7=""; COMP_NAMES_7=""; INIT_COMP_DETAILS_7=""
SOURCE_LIST_8="" ; SELECTED_KEYS_8=""; AVAILABLE_KEYS_8="";
ALL_OPTIONAL_COMPONENTS_8=""; SORTED_COMPONENTS_LIST_8="";
COMPONENT_FILTERS_LIST_8=""; COMP_NAMES_8=""; INIT_COMP_DETAILS_8=""
SOURCE_LIST_9="" ; SELECTED_KEYS_9=""; AVAILABLE_KEYS_9="";
ALL_OPTIONAL_COMPONENTS_9=""; SORTED_COMPONENTS_LIST_9="";
COMPONENT_FILTERS_LIST_9=""; COMP_NAMES_9=""; INIT_COMP_DETAILS_9=""
SOURCE_LIST_10="" ; SELECTED_KEYS_10=""; AVAILABLE_KEYS_10="";
ALL_OPTIONAL_COMPONENTS_10=""; SORTED_COMPONENTS_LIST_10="";
COMPONENT_FILTERS_LIST_10=""; COMP_NAMES_10=""; INIT_COMP_DETAILS_10=""
UNIQUE_SELECTED_KEYS=""
ALL_CDS=""

PROTO_FILE=""
RUNTIME_PKG=""

PATCHES_TO_ARCHIVE=""
ALL_AVAILABLE_PATCHES=""

ARCHIVE_TOOL_CURRENT_CD=0
WAITING_FOR_NEXT_CD="FALSE"
CD_MOUNTED="FALSE"
ADDON_SETUP_INFO_COMPLETED="FALSE"

SMARTUPDATE_COMPATIBLE_PRODUCTS=""
OS_FOR_AVAILABLE_KEYS=""
ALL_SUPPORTED_OS="2.6,7,8,9,10"
SELECTED_OS=""

REQUIRED_SPACE_FORARCHIVES=0
COMMON_PACKAGES=""

PROGRESS_FILE="$AGENT_UPDATE_DIR/gui-progress.properties"
ARCHIVE_PROGRESS_FILE="$AGENT_UPDATE_DIR/gui-archive-progress.properties"
BACKUP_PROGRESS_FILE="$AGENT_UPDATE_DIR/gui-progress.properties"

INSTALL_SCRIPTS_DIR=`/usr/bin/pkgparam SUNWescom BASEDIR`/SUNWsymon/lib/sbin
ES_COMMON_DIR=`/usr/bin/pkgparam SUNWescom BASEDIR`/SUNWsymon/sbin
ARCHIVE_TOOL_SCRIPT_DIR=`/usr/bin/pkgparam SUNWescom BASEDIR`/SUNWsymon/lib/sbin

. ${ES_COMMON_DIR}/es-common.sh
. ${INSTALL_SCRIPTS_DIR}/script-errors.sh
. ${INSTALL_SCRIPTS_DIR}/install-functions.sh
. ${ARCHIVE_TOOL_SCRIPT_DIR}/archive-tool-functions.sh
. ${ARCHIVE_TOOL_SCRIPT_DIR}/gui-archivetool-functions.sh

setInstallFlags

umask 022

AUTOCONFIG_RUNFILE1=$AGENT_UPDATE_DIR/tmpGUI.properties 
SPLIT_SIZE=`getAutoConfig1 "SPLIT_SIZE"`
LOGFILE=`getAutoConfig1 "LOGFILE"`
check_split_size

check_server

setAPIDirs
API_CREATE_DOC="$API_DIR/createDocument" 
API_INSERT_TAG="$API_DIR/insertTag" 
API_SET_ATTRIBUTE="$API_DIR/setAttribute" 
API_QUERY_XML="$API_DIR/queryXml" 

checkOSVersion
set_commondirs

AGENT_ONLY=1
INSTALL_LAYERS="LAYER.AGENT"
INSTALL_TYPE="BASE"
#LOCALE_CODE=C
#L10N_CODE=en
check_for_l10n

setArchiveLogdir
initializeRegistry 	# Required for install-functions

$CMD_CLEAR

checkOSVersion
#getSourceDirectoryAndVersion
#getRemoteTargetDirectory
#getArchiveTargetDirectory

getSourceDirectoryAndVersionFromFile
getSourceArchAndSetPathPrefix
getRemoteTargetDirectoryFromFile
getArchiveTargetDirectoryFromFile

TARGET_ARCHIVE_DIR=$TARGET_DIR
SMART_UPDATE_DIR="$TARGET_ARCHIVE_DIR"
AUTOCONFIG_SAVEFILE=$SMART_UPDATE_DIR/tmpResponses.cfg

#createLink
#updateResponses
saveAutoConfig "TARGET_DIRECTORY" "$REMOTE_TARGET_DIR"
saveAutoConfig "SETUP_NOW" "0"
saveAutoConfig "PRESERVE_OLD_DATA" "1"
saveAutoConfig "RESPONSES_FOR_AGENT_UPDATE" "TRUE"


#getPolicyFileNames
#getPolicyFileNamesFromFile
#updateBasePolicy
#init_policy_file
#update_protofile

makeDirectories "PE"

AUTOCONFIG_RUNFILE1="$AGENT_UPDATE_DIR/tmpGUI.properties"
ARCHIVE_BASE_FLAG=`getAutoConfig1 "ARCHIVE_BASE_FLAG"`
ARCHIVE_ADDON_FLAG=`getAutoConfig1 "ARCHIVE_ADDON_FLAG"`
ARCHIVE_PATCHES_FLAG=`getAutoConfig1 "ARCHIVE_PATCHES_FLAG"`
SELECTED_OS=`getAutoConfig1 "SELECTED_OS"`

if [ "$ARCHIVE_BASE_FLAG" = "1" ]; then
    getLocales
    saveAutoConfig "INSTALL_LOCALES" "$INSTALL_LOCALES"
fi

getBaseResponseFileNames
findSmartUpdateCompatibleProducts
compatibles="$SMARTUPDATE_COMPATIBLE_PRODUCTS"
count=`$CMD_ECHO "$compatibles" | $CMD_AWK -F ',' '{print NF}'`
put_var_in_cfgfile "${AUTOCONFIG_RUNFILE1}" "COMPATIBLE_PRODUCTS" "$count" "="

$CMD_ECHO "\n"
#ask_user 'Do you want to archive available Addon Products?'

	setupArchiveProgressFile

        AUTOCONFIG_RUNFILE=$AUTOCONFIG_SAVEFILE

        for OSVERS in `$CMD_ECHO "$SELECTED_OS" | $CMD_AWK -F ',' '{ for (i= 1; i<= NF; i++) print $i }'`
        do
		put_var_in_cfgfile "${ARCHIVE_PROGRESS_FILE}" "PROCESS" "Scanning" "="
		put_var_in_cfgfile "${ARCHIVE_PROGRESS_FILE}" "OSVERS" "$OSVERS" "="
                resetSourceList $OSVERS         # restore source list for OS
                resetAvailableKeys $OSVERS      # restore available keys
                resetOptionalComponents $OSVERS
                resetComponentFiltersList $OSVERS
                resetCompNames $OSVERS
                resetInitCompDetails $OSVERS

                AGENT_ONLY=1
                INSTALL_LAYERS="LAYER.AGENT"
                if [ "$ARCHIVE_BASE_FLAG" = "1" ]; then
                        INSTALL_TYPE="BASE"
			SOURCE_IMAGE="DEFAULT"
                else
                        INSTALL_TYPE="ADDON"
			SOURCE_IMAGE="ADDON_ONLY"
                fi
		
		PROGRESS_FILE="$BACKUP_PROGRESS_FILE"

                # scanSourceForAllProducts may change the value of OSVERS
                # check and restore value of the var if necessary after call
                # to the function
                curr_os=$OSVERS
                scanSourceForAllProducts
                [ "$OSVERS" != "$curr_os" ] && OSVERS=${curr_os}

                setSourceList $OSVERS
		setComponentFiltersList $OSVERS
                setCompNames $OSVERS
                setInitCompDetails $OSVERS
                #echo "$SOURCE_LIST"
                setOptionalComponents $OSVERS

                listAllAvailableProducts

                setAvailableKeys $OSVERS
		setOSforAvailableProducts
        done

        UNIQ_AVAILABLE_KEYS=""
        UNIQ_OPTIONAL_COMPONENTS_LIST=""

        UNIQ_AVAILABLE_KEYS=`getUniqAvailableKeys`
        AVAILABLE_KEYS_WITH_NAMES=`getUniqAvailableKeysWithNames`
        UNIQ_OPTIONAL_COMPONENTS_LIST=`getUniqOptionalComponents`
        UNIQ_OPTIONAL_PACKAGES_LIST=`getUniqOptionalPackages`

        AVAILABLE_KEYS="$UNIQ_AVAILABLE_KEYS"
        ALL_OPTIONAL_COMPONENTS="$UNIQ_OPTIONAL_COMPONENTS_LIST"

        #LAST_OS=`getLastOSonCD`
        #resetSourceList $LAST_OS
        #OSVERS=$LAST_OS
	checkOSVersion
	resetSourceList $LAST_OS

	saveUniqOptionalComponentsWithNames
	put_var_in_cfgfile "${ARCHIVE_PROGRESS_FILE}" "PROCESS" "" "="
	put_var_in_cfgfile "${ARCHIVE_PROGRESS_FILE}" "OSVERS" "" "="

saveAllVariables
backup_runtime_data
exit 0

