#!/bin/sh
#=====================================================================
#
# @(#)gui-install-webserver.sh	1.8 05/04/15 
# Copyright (c) 04/15/05  Sun Microsystems, Inc. All Rights Reserved.
# The GUI Support script which will install the webserver ifv needed
#=====================================================================


PROGNAME=$0
TOOLS_DIR=`/usr/bin/dirname $PROGNAME`
SCRIPT_DIR="${TOOLS_DIR}/../../sbin"
PATH="$PATH:${SCRIPT_DIR}:${TOOLS_DIR}"
VAROPTDIR="/var/opt/SUNWsymon"

. ${SCRIPT_DIR}/es-common.sh
. ${TOOLS_DIR}/install-functions.sh
. ${TOOLS_DIR}/es-webserver
. ${TOOLS_DIR}/es-lhwebconsole

. ${VAROPTDIR}/install/filter-variable
 
# Call the main function which will install the
# webserver packages.
create_temp_directory
performChecksAndInitializations

. ${VAROPTDIR}/install/filter-variable

checkWebserverInstallRequired

installWebserver

checkJavaHelpInstallRequired
if [ $? -ne 0 ] ; then
    installJavaHelp
fi
ret=0
checkSunWebconsoleInstallRequired
if [ $? -ne 0 ] ; then
    installWebconsole
    ret=$?
fi
jHelp=`$CMD_PKGINFO -r SUNWjhrt`
/usr/sbin/smreg add -p javahelp.home=${jHelp}/j2se/opt/javahelp

if [ $ret -eq 0 ] ; then
    /usr/bin/echo "LH_PKGS=$WBCONSOLE_INSTALLED_PKGLIST" > ${TMP_DIR}/lhconsole-pkg-list
    exit 0
else
    exit 1
fi

#Done

