/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors;

import com.sun.symon.base.beans.BcTreeNode;
import com.sun.symon.base.security.SySecurity;
import com.sun.symon.base.server.emitters.cfile.SeCFileEmitter;
import com.sun.symon.base.server.emitters.control.SeControlEmitter;
import com.sun.symon.base.server.emitters.file.SeFileFileEmitter;
import com.sun.symon.base.server.emitters.snmp.SeSnmpEmitter;
import com.sun.symon.base.server.emitters.xfile.SeXFileEmitter;
import com.sun.symon.base.server.events.SvRequestListener;
import com.sun.symon.base.server.receptors.SrReceptor;
import com.sun.symon.base.server.remitters.SmRemitter;
import com.sun.symon.base.server.remitters.crosscontext.SmCrossContextRemitter;
import com.sun.symon.base.server.remitters.snmpjob.SmSnmpJobRemitter;
import com.sun.symon.base.utility.UcBeanIntrospector;
import com.sun.symon.base.utility.UcDDL;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class SrBaseReceptor
extends SrReceptor {
    protected SySecurity sySecurity = new SySecurity();
    protected String securityURL = null;
    protected int securityFlag = 1;
    protected String privateKey = null;
    protected String publicId = "public";
    protected String publicPassword = "public";
    protected String privateId = "private";
    protected String privatePassword = "maplesyrup";
    protected String topologyHost = null;
    protected int topologyPort = -1;
    protected String mdrHost = null;
    protected int mdrPort = -1;
    protected String configurationHost = null;
    protected int configurationPort = -1;
    protected String eventHost = null;
    protected int eventPort = -1;
    protected String cstHost = null;
    protected int cstPort = -1;
    protected int sessionLimit = 0;
    protected int numSessions = 0;
    protected boolean sunHostOnly = true;
    private String imageSubpath = null;

    public void addSvRequestListener(SvRequestListener svRequestListener) {
        super.addSvRequestListener(svRequestListener);
    }

    public String getConfigurationBaseURL() {
        String string = "";
        if (this.configurationHost != null && this.configurationPort != -1) {
            string = "snmp://" + this.configurationHost + ":" + this.configurationPort + "/";
        }
        return string;
    }

    public String getEventBaseURL() {
        String string = "";
        if (this.eventHost != null && this.eventPort != -1) {
            string = "snmp://" + this.eventHost + ":" + this.eventPort + "/";
        }
        return string;
    }

    public String getTopologyBaseURL() {
        String string = "";
        if (this.topologyHost != null && this.topologyPort != -1) {
            string = "snmp://" + this.topologyHost + ":" + this.topologyPort + "/";
        }
        return string;
    }

    public String getMDRBaseURL() {
        String string = "";
        if (this.mdrHost != null && this.mdrPort != -1) {
            string = "snmp://" + this.mdrHost + ":" + this.mdrPort + "/";
        }
        return string;
    }

    public String getCSTBaseURL() {
        String string = "";
        if (this.cstHost != null && this.cstPort != -1) {
            string = "snmp://" + this.cstHost + ":" + this.cstPort + "/";
        }
        return string;
    }

    public String getImageSubpath() {
        return this.imageSubpath;
    }

    public void setImageSubpath(String string) {
        this.imageSubpath = string;
    }

    public String getESDIR() {
        return System.getProperty("ESDIR");
    }

    public void removeSvRequestListener(SvRequestListener svRequestListener) {
        super.removeSvRequestListener(svRequestListener);
    }

    public void setSecurityURL(String string) {
        this.securityURL = string;
        this.restart();
    }

    public void setSecurityFlag(int n) {
        this.securityFlag = n;
        this.restart();
    }

    public void setPrivateKey(String string) {
        this.privateKey = string;
        this.restart();
    }

    public void setPublicId(String string) {
        this.publicId = string;
    }

    public void setSunHostOnly(boolean bl) {
        this.sunHostOnly = bl;
    }

    protected void restart() {
        if (this.securityFlag != -1 && this.privateKey != null && this.privatePassword != null && this.configurationPort > 0 && this.configurationHost != null && !this.configurationHost.equals("")) {
            this.startServer();
        }
    }

    public void setPublicPassword(String string) {
        this.publicPassword = string;
    }

    public void setPrivateId(String string) {
        this.privateId = string;
    }

    public void setPrivatePassword(String string) {
        this.privatePassword = string;
    }

    public void setTopologyHost(String string) {
        this.topologyHost = string;
        if (this.topologyPort != -1) {
            try {
                String string2 = InetAddress.getByName(this.topologyHost).getHostAddress();
                UcDDL.logInfoMessage((String)("topology agent host and port = " + this.topologyHost + " (" + string2 + ") port " + this.topologyPort));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public void setMDRHost(String string) {
        this.mdrHost = string;
        if (this.mdrPort != -1) {
            try {
                String string2 = InetAddress.getByName(this.mdrHost).getHostAddress();
                UcDDL.logInfoMessage((String)("mdr agent host and port = " + this.mdrHost + " (" + string2 + ") port " + this.mdrPort));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public void setMDRPort(int n) {
        this.mdrPort = n;
        if (this.mdrHost != null) {
            try {
                String string = InetAddress.getByName(this.mdrHost).getHostAddress();
                UcDDL.logInfoMessage((String)("mdr agent host and port = " + this.mdrHost + " (" + string + ") port " + this.mdrPort));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public void setTopologyPort(int n) {
        this.topologyPort = n;
        if (this.topologyHost != null) {
            try {
                String string = InetAddress.getByName(this.topologyHost).getHostAddress();
                UcDDL.logInfoMessage((String)("topology agent host and port = " + this.topologyHost + " (" + string + ") port " + this.topologyPort));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public void setConfigurationHost(String string) {
        this.configurationHost = string;
        if (this.configurationPort != -1) {
            try {
                String string2 = InetAddress.getByName(this.configurationHost).getHostAddress();
                UcDDL.logInfoMessage((String)("configuration server host and port = " + this.configurationHost + " (" + string2 + ") port " + this.configurationPort));
                this.restart();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public void setConfigurationPort(int n) {
        this.configurationPort = n;
        if (this.configurationHost != null) {
            try {
                String string = InetAddress.getByName(this.configurationHost).getHostAddress();
                UcDDL.logInfoMessage((String)("configuration server host and port = " + this.configurationHost + " (" + string + ") port " + this.configurationPort));
                this.restart();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public void setEventHost(String string) {
        this.eventHost = string;
        if (this.eventPort != -1) {
            try {
                String string2 = InetAddress.getByName(this.eventHost).getHostAddress();
                UcDDL.logInfoMessage((String)("event manager host and port = " + this.eventHost + " (" + string2 + ") port " + this.eventPort));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public void setEventPort(int n) {
        this.eventPort = n;
        if (this.eventHost != null) {
            try {
                String string = InetAddress.getByName(this.eventHost).getHostAddress();
                UcDDL.logInfoMessage((String)("event manager host and port = " + this.eventHost + " (" + string + ") port " + this.eventPort));
                this.restart();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public void setCSTHost(String string) {
        this.cstHost = string;
        if (this.cstPort != -1) {
            try {
                String string2 = InetAddress.getByName(this.cstHost).getHostAddress();
                UcDDL.logInfoMessage((String)("cstservice server host and port = " + this.cstHost + " (" + string2 + ") port " + this.cstPort));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public void setCSTPort(int n) {
        this.cstPort = n;
        if (this.cstHost != null) {
            try {
                String string = InetAddress.getByName(this.cstHost).getHostAddress();
                UcDDL.logInfoMessage((String)("cstservice server host and port = " + this.cstHost + " (" + string + ") port " + this.cstPort));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public void setSessionLimit(int n) {
        this.sessionLimit = n;
        this.calculateSessionLimit();
    }

    public void setEnabledSecuritySchemes(String string) {
        this.sySecurity.keepSchemes(string);
    }

    public boolean isSunHostOnly() {
        return this.sunHostOnly;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getPublicPassword() {
        return this.publicPassword;
    }

    public String getPrivateId() {
        return this.privateId;
    }

    public String getPrivatePassword() {
        return this.privatePassword;
    }

    void calculateSessionLimit() {
        if (this.sessionLimit == 0) {
            String string = null;
            try {
                string = System.getProperty("NUM_FDS");
                int n = Integer.parseInt(string);
                this.sessionLimit = (n - 30) / 4;
                if (this.sessionLimit < 1) {
                    this.sessionLimit = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                UcDDL.logErrorMessage((String)("can't parse NUM_FDS: '" + string + "'"), (Throwable)numberFormatException);
                this.sessionLimit = -1;
            }
        }
    }

    protected void startServer() {
        if (this.securityURL.compareTo("") == 0) {
            this.securityURL = this.getConfigurationBaseURL() + "oid/1.3.6.1.4.1.42.2.12.2.2.34.1.0";
        }
        this.calculateSessionLimit();
        UcDDL.logInfoMessage((String)("Number of client sessions that will be allowed to connect: " + (this.sessionLimit == -1 ? "unlimited" : "" + this.sessionLimit)));
    }

    public boolean addNewSession() {
        SrBaseReceptor srBaseReceptor = this;
        synchronized (srBaseReceptor) {
            UcDDL.logDebugMessage((String)("sessionLimit=" + this.sessionLimit));
            UcDDL.logDebugMessage((String)("numSessions=" + this.numSessions));
        }
        if (this.sessionLimit == -1 || this.numSessions < this.sessionLimit) {
            ++this.numSessions;
            return true;
        }
        return false;
    }

    public synchronized void clientDied() {
        --this.numSessions;
        UcDDL.logDebugMessage((String)("client died ... numSessions=" + this.numSessions));
    }

    protected void initialize() throws Exception {
        SeSnmpEmitter seSnmpEmitter;
        SeSnmpEmitter seSnmpEmitter2;
        SeControlEmitter seControlEmitter;
        SeSnmpEmitter seSnmpEmitter3;
        SeFileFileEmitter seFileFileEmitter;
        SeCFileEmitter seCFileEmitter;
        Object object;
        UcBeanIntrospector ucBeanIntrospector = new UcBeanIntrospector();
        ucBeanIntrospector.readProperties("domain-config.x", 0);
        ucBeanIntrospector.readProperties("server-config.x", 0);
        ucBeanIntrospector.readProperties("javaserver.properties");
        ucBeanIntrospector.readProperties("server-global-keys.x", 2);
        ucBeanIntrospector.apply((Object)this);
        boolean bl = BcTreeNode.isDebugOn();
        BcTreeNode bcTreeNode = null;
        if (bl) {
            object = BcTreeNode.getRootNode();
            bcTreeNode = new BcTreeNode("receptor", (Object)this);
            ((DefaultMutableTreeNode)object).add((MutableTreeNode)bcTreeNode);
        }
        object = new SmSnmpJobRemitter();
        ucBeanIntrospector.apply(object);
        this.addSvRequestListener((SvRequestListener)object);
        BcTreeNode bcTreeNode2 = null;
        if (bl) {
            bcTreeNode2 = new BcTreeNode("snmpjobremitter", object);
            bcTreeNode.add((MutableTreeNode)bcTreeNode2);
        }
        SmCrossContextRemitter smCrossContextRemitter = new SmCrossContextRemitter();
        ucBeanIntrospector.apply((Object)smCrossContextRemitter);
        ((SmRemitter)object).addSvRequestListener(smCrossContextRemitter);
        BcTreeNode bcTreeNode3 = null;
        if (bl) {
            bcTreeNode3 = new BcTreeNode("crossContext", (Object)smCrossContextRemitter);
            bcTreeNode2.add((MutableTreeNode)bcTreeNode3);
        }
        SeXFileEmitter seXFileEmitter = new SeXFileEmitter();
        ((SmRemitter)object).addSvRequestListener(seXFileEmitter);
        if (bl) {
            seCFileEmitter = new BcTreeNode("xfile", (Object)seXFileEmitter);
            bcTreeNode2.add((MutableTreeNode)((Object)seCFileEmitter));
        }
        seCFileEmitter = new SeCFileEmitter();
        ucBeanIntrospector.apply((Object)seCFileEmitter);
        ((SmRemitter)object).addSvRequestListener(seCFileEmitter);
        if (bl) {
            seFileFileEmitter = new BcTreeNode("cfile", (Object)seCFileEmitter);
            bcTreeNode2.add((MutableTreeNode)((Object)seFileFileEmitter));
        }
        seFileFileEmitter = new SeFileFileEmitter();
        ucBeanIntrospector.apply((Object)seFileFileEmitter);
        ((SmRemitter)object).addSvRequestListener(seFileFileEmitter);
        if (bl) {
            seSnmpEmitter3 = new BcTreeNode("ffile", (Object)seFileFileEmitter);
            bcTreeNode2.add((MutableTreeNode)((Object)seSnmpEmitter3));
        }
        seSnmpEmitter3 = new SeSnmpEmitter();
        ucBeanIntrospector.apply((Object)seSnmpEmitter3, "snmpv1");
        ((SmRemitter)object).addSvRequestListener(seSnmpEmitter3);
        if (bl) {
            seControlEmitter = new BcTreeNode("snmpv1", (Object)seSnmpEmitter3);
            bcTreeNode2.add((MutableTreeNode)((Object)seControlEmitter));
        }
        seControlEmitter = new SeControlEmitter();
        ucBeanIntrospector.apply((Object)seControlEmitter);
        ((SmRemitter)object).addSvRequestListener(seControlEmitter);
        if (bl) {
            seSnmpEmitter2 = new BcTreeNode("controller", (Object)seControlEmitter);
            bcTreeNode2.add((MutableTreeNode)((Object)seSnmpEmitter2));
        }
        seSnmpEmitter2 = new SeSnmpEmitter();
        ucBeanIntrospector.apply((Object)seSnmpEmitter2, "snmp");
        smCrossContextRemitter.addSvRequestListener(seSnmpEmitter2);
        if (bl) {
            seSnmpEmitter = new BcTreeNode("snmp", (Object)seSnmpEmitter2);
            bcTreeNode3.add((MutableTreeNode)((Object)seSnmpEmitter));
        }
        seSnmpEmitter = new SeSnmpEmitter();
        ucBeanIntrospector.apply((Object)seSnmpEmitter, "snmppublic");
        smCrossContextRemitter.addSvRequestListener(seSnmpEmitter);
        if (bl) {
            BcTreeNode bcTreeNode4 = new BcTreeNode("snmppublic", (Object)seSnmpEmitter);
            bcTreeNode3.add((MutableTreeNode)bcTreeNode4);
        }
        seControlEmitter.setScheme("control");
        seControlEmitter.setSnmpEmitter(seSnmpEmitter2);
        seControlEmitter.setSnmppublicEmitter(seSnmpEmitter);
        seControlEmitter.setSnmpv1Emitter(seSnmpEmitter3);
        seControlEmitter.setSnmpJobRemitter(object);
        seControlEmitter.setCrossContextRemitter(smCrossContextRemitter);
    }
}

