/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.emitters.snmp;

import com.sun.symon.base.server.common.ScRequestSinkInterface;
import com.sun.symon.base.server.emitters.snmp.SeSnmpException;
import com.sun.symon.base.server.emitters.snmp.SeSnmpFinder;
import com.sun.symon.base.server.emitters.snmp.SeSnmpMessenger;
import com.sun.symon.base.server.emitters.snmp.SeSnmpPrivCache;
import com.sun.symon.base.server.emitters.snmp.UrlRequest;
import com.sun.symon.base.server.snmp.SsMessage;
import com.sun.symon.base.server.snmp.v1.SsSetRequest;
import com.sun.symon.base.server.snmp.v2.SsGetBulkRequest;
import com.sun.symon.base.server.snmp.v2.SsGetRequest;
import com.sun.symon.base.server.snmp.v2.SsRequest;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StSnmpNULL;
import com.sun.symon.base.server.types.StSnmpOBJECT_IDENTIFIER;
import com.sun.symon.base.server.types.StString;
import java.net.InetAddress;

public class SeSnmpRequestor {
    private SeSnmpFinder finder;
    private SeSnmpMessenger messenger;
    private SeSnmpPrivCache privCache;
    private boolean autoNegotiate;
    private String publicUser;

    public SeSnmpRequestor(SeSnmpMessenger seSnmpMessenger, String string) {
        this.messenger = seSnmpMessenger;
        this.publicUser = string;
    }

    public void setFinder(SeSnmpFinder seSnmpFinder) {
        this.finder = seSnmpFinder;
    }

    public SeSnmpPrivCache setPrivFeatures(boolean bl, String string) {
        this.privCache = null;
        this.autoNegotiate = bl;
        if (bl) {
            this.privCache = SeSnmpPrivCache.getInstance(string, this);
        }
        return this.privCache;
    }

    public ScRequestSinkInterface createRequestByOid(final InetAddress inetAddress, final int n, final int n2, String string, int n3, int n4, String string2, String[] stringArray, StObject[] stObjectArray, final ResultCallback resultCallback) throws SeSnmpException {
        SeSnmpMessenger.ResponseCallback responseCallback = new SeSnmpMessenger.ResponseCallback(){

            public void handleResponse(SsMessage ssMessage) {
                SeSnmpRequestor.this.sendResults(ssMessage, resultCallback, n2, inetAddress, n);
            }

            public void handleException(SeSnmpException seSnmpException) {
                resultCallback.handleException(seSnmpException);
            }
        };
        if (string == null) {
            string = this.publicUser;
        }
        if (this.autoNegotiate) {
            int n5 = this.privCache.resolveRemote(inetAddress, n, n2, n3, n4);
            if (n5 == 0) {
                n3 = 2;
            } else if (n5 == 2) {
                throw new SeSnmpException("Unexpected result in resolving remote privacy oid.", -1);
            }
        }
        SsMessage ssMessage = this.createMsg(inetAddress, n, n2, string, n3, n4, string2, stringArray, stObjectArray);
        return this.messenger.registerMessage(inetAddress, n, ssMessage, responseCallback);
    }

    private void sendResults(SsMessage ssMessage, ResultCallback resultCallback, int n, InetAddress inetAddress, int n2) {
        StObject[] stObjectArray = ssMessage.getVariables();
        if (n == 6) {
            StSnmpOBJECT_IDENTIFIER[] stSnmpOBJECT_IDENTIFIERArray = ssMessage.getNames();
            StObject[][] stObjectArray2 = null;
            if (stObjectArray == null) {
                resultCallback.handleException(new SeSnmpException("no data received", 0));
                return;
            }
            stObjectArray2 = new StObject[2][stObjectArray.length];
            String string = "snmp://" + inetAddress.getHostAddress() + ":" + n2 + "/oid/";
            int n3 = 0;
            while (n3 < stObjectArray.length) {
                stObjectArray2[0][n3] = stObjectArray[n3];
                stObjectArray2[1][n3] = new StString(string + stSnmpOBJECT_IDENTIFIERArray[n3]);
                if (stObjectArray2[0][n3] == null) {
                    resultCallback.handleException(new SeSnmpException("no data received", 0));
                    return;
                }
                ++n3;
            }
            resultCallback.handleResultBulk(stObjectArray2);
        } else {
            int n4 = 0;
            while (n4 < stObjectArray.length) {
                if (stObjectArray[n4] == null) {
                    resultCallback.handleException(new SeSnmpException("no data received", n4));
                    return;
                }
                ++n4;
            }
            resultCallback.handleResult(stObjectArray);
        }
    }

    public ScRequestSinkInterface createRequestByUrl(int n, String string, int n2, int n3, String[] stringArray, StObject[] stObjectArray, ResultCallback resultCallback) throws SeSnmpException {
        return new UrlRequest(n, string, n2, n3, stringArray, stObjectArray, resultCallback, this, this.finder);
    }

    private SsMessage createMsg(InetAddress inetAddress, int n, int n2, String string, int n3, int n4, String string2, String[] stringArray, StObject[] stObjectArray) throws SeSnmpException {
        SsMessage ssMessage;
        switch (n2) {
            case 1: {
                ssMessage = this.createGetMsg(n4, stringArray);
                break;
            }
            case 0: {
                ssMessage = this.createSetMsg(n4, stringArray, stObjectArray);
                break;
            }
            case 6: {
                ssMessage = this.createBulkMsg(n4, stringArray, stObjectArray);
                break;
            }
            default: {
                throw new SeSnmpException("unknown event command = " + n2, 0);
            }
        }
        if (string2 != null) {
            ssMessage.setContextName(string2);
        }
        ssMessage.setSecurityName(string);
        ssMessage.setSecurityLevel(n3);
        ssMessage.setSecurityModel(n4);
        byte[] byArray = inetAddress.getAddress();
        long l = ((byArray[0] * 256 + byArray[1]) * 256 + byArray[2]) * 256 + byArray[3];
        ssMessage.setHost(l);
        ssMessage.setPort(n);
        return ssMessage;
    }

    private SsMessage createGetMsg(int n, String[] stringArray) throws SeSnmpException {
        SsMessage ssMessage;
        switch (n) {
            case 2: {
                ssMessage = new com.sun.symon.base.server.snmp.v1.SsGetRequest();
                break;
            }
            case 3: {
                ssMessage = new SsGetRequest();
                break;
            }
            case 1: 
            case 4: {
                ssMessage = new com.sun.symon.base.server.snmp.v2u.SsGetRequest();
                break;
            }
            default: {
                throw new SeSnmpException("unknown security model = " + n, 0);
            }
        }
        StSnmpNULL stSnmpNULL = new StSnmpNULL();
        int n2 = 0;
        while (n2 < stringArray.length) {
            ssMessage.setVariable(stringArray[n2], stSnmpNULL);
            ++n2;
        }
        return ssMessage;
    }

    private SsMessage createSetMsg(int n, String[] stringArray, StObject[] stObjectArray) throws SeSnmpException {
        SsMessage ssMessage;
        switch (n) {
            case 2: {
                ssMessage = new SsSetRequest();
                break;
            }
            case 3: {
                ssMessage = new com.sun.symon.base.server.snmp.v2.SsSetRequest();
                break;
            }
            case 1: 
            case 4: {
                ssMessage = new com.sun.symon.base.server.snmp.v2u.SsSetRequest();
                break;
            }
            default: {
                throw new SeSnmpException("unknown security model = " + n, 0);
            }
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            StObject stObject = stObjectArray == null || stObjectArray[n2] == null ? new StSnmpNULL() : stObjectArray[n2];
            ssMessage.setVariable(stringArray[n2], stObject);
            ++n2;
        }
        return ssMessage;
    }

    private SsMessage createBulkMsg(int n, String[] stringArray, StObject[] stObjectArray) throws SeSnmpException {
        SsRequest ssRequest;
        int n2 = new Integer(stObjectArray[0].toString());
        int n3 = new Integer(stObjectArray[1].toString());
        switch (n) {
            case 2: {
                throw new SeSnmpException("GET_BULK not supported on SNMP.V1", 0);
            }
            case 3: {
                SsGetBulkRequest ssGetBulkRequest = new SsGetBulkRequest();
                ssGetBulkRequest.setNonRepeaters(n2);
                ssGetBulkRequest.setMaxRepetitions(n3);
                ssRequest = ssGetBulkRequest;
                break;
            }
            case 1: 
            case 4: {
                com.sun.symon.base.server.snmp.v2u.SsGetBulkRequest ssGetBulkRequest = new com.sun.symon.base.server.snmp.v2u.SsGetBulkRequest();
                ssGetBulkRequest.setNonRepeaters(n2);
                ssGetBulkRequest.setMaxRepetitions(n3);
                ssRequest = ssGetBulkRequest;
                break;
            }
            default: {
                throw new SeSnmpException("unknown security model = " + n, 0);
            }
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            ssRequest.setVariable(stringArray[n4], new StSnmpNULL());
            ++n4;
        }
        return ssRequest;
    }

    public static interface ResultCallback {
        public void handleResult(StObject[] var1);

        public void handleResultBulk(StObject[][] var1);

        public void handleException(SeSnmpException var1);
    }
}

