/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.framework;

import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.framework.MSBaseService;
import com.sun.symon.base.mgmtservice.framework.MSBaseServiceInterface;
import com.sun.symon.base.mgmtservice.framework.MSRemoteServiceFactory;
import com.sun.symon.base.mgmtservice.framework.MSServerChecker;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.lookup.SlServiceRegistry;
import com.sun.symon.base.utility.UcBeanIntrospector;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class MSBaseFactory {
    private static int DEFREGISTRYPORT = 5600;
    private static int TRYINTERVAL = 5000;
    private static int DEFPINGINTERVAL = 120;
    private static int DEFPINGRETRIES = 5;
    private SlServiceRegistry lookupRegistry;
    private MSRemoteServiceFactory factoryStub;
    private HashSet serviceTable;
    private String registryHost = null;
    private int registryPort = 0;
    private int pingInterval;
    private int pingRetries;
    private String altServiceFile = null;
    private String javaServiceFile = null;
    private RemoteFactory factoryHandle;
    private Hashtable serviceHostTable = new Hashtable();
    private static Hashtable sessionTable = new Hashtable();
    private static MSLogPrintWriter logError = MSLogPrintWriter.getErrorWriter();
    static MSLogPrintWriter logInfo = MSLogPrintWriter.getInfoWriter();
    private MSServerChecker checker = null;
    private int checkTime = 0;

    protected void init() throws Exception {
        Object object;
        Object object2 = null;
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        while (bl) {
            block8: {
                try {
                    Socket socket = new Socket(this.registryHost, this.registryPort);
                    object = socket.getInputStream();
                    ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
                    object2 = objectInputStream.readObject();
                    if (object2 instanceof SlServiceRegistry) {
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    if (++n != 12) break block8;
                    object = "Fail in getting registry in " + ++n2 + " minutes!";
                    logError.println((String)object);
                }
            }
            try {
                Thread.sleep(TRYINTERVAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.lookupRegistry = (SlServiceRegistry)object2;
        try {
            this.factoryHandle = new RemoteFactory(this);
            this.factoryStub = (MSRemoteServiceFactory)RemoteObject.toStub(this.factoryHandle);
        }
        catch (Exception exception) {
            object = "Fail in geneating remote factory stub: " + exception.getMessage();
            logError.println((String)object);
            throw exception;
        }
    }

    public MSBaseFactory() throws RemoteException {
        this.serviceTable = new HashSet();
        if (this.registryHost == null || this.registryHost == "") {
            try {
                this.registryHost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                logError.println("Fail in gettting registryHost: " + exception.getMessage());
                System.exit(1);
            }
        }
        if (this.registryPort == 0) {
            this.registryPort = DEFREGISTRYPORT;
        }
        this.pingInterval = DEFPINGINTERVAL;
        this.pingRetries = DEFPINGRETRIES;
    }

    public void setConfiguration(String string) {
        this.javaServiceFile = string;
        this.initJService();
    }

    private void initJService() {
        try {
            if (this.javaServiceFile != null) {
                UcBeanIntrospector ucBeanIntrospector = new UcBeanIntrospector();
                ucBeanIntrospector.readProperties(this.javaServiceFile);
                ucBeanIntrospector.apply((Object)this);
            }
        }
        catch (Exception exception) {
            logError.println("Factory init: Unable to open " + this.javaServiceFile);
        }
    }

    public void setServiceRegistryHost(String string) {
        this.registryHost = string;
    }

    public void setServiceRegistryPort(int n) {
        this.registryPort = n;
    }

    public void setServerPingInterval(int n, int n2) {
        this.pingInterval = n;
        this.pingRetries = n2;
        logInfo.println("ServerPingInterval: " + this.pingInterval + ",  " + this.pingRetries);
    }

    boolean isAvailable(String string) {
        return this.serviceTable.contains(string);
    }

    synchronized void removeSession(String string) throws RemoteException {
        Vector vector = (Vector)sessionTable.get(string);
        if (vector == null) {
            return;
        }
        MSBaseService mSBaseService = null;
        int n = 0;
        while (n < vector.size()) {
            mSBaseService = (MSBaseService)vector.elementAt(n);
            mSBaseService.cleanup();
            if (mSBaseService != null) {
                mSBaseService = null;
            }
            ++n;
        }
        vector.removeAllElements();
        sessionTable.remove(string);
    }

    synchronized void removeSessions() {
        MSBaseService mSBaseService = null;
        Enumeration enumeration = sessionTable.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            int n = 0;
            while (n < vector.size()) {
                mSBaseService = (MSBaseService)vector.elementAt(n);
                mSBaseService.cleanup();
                mSBaseService = null;
                ++n;
            }
            vector.removeAllElements();
        }
        sessionTable.clear();
    }

    synchronized void addSession(String string, MSBaseServiceInterface mSBaseServiceInterface) {
        Vector<MSBaseServiceInterface> vector = (Vector<MSBaseServiceInterface>)sessionTable.get(string);
        if (vector != null) {
            vector.add(mSBaseServiceInterface);
        } else {
            vector = new Vector<MSBaseServiceInterface>();
            vector.add(mSBaseServiceInterface);
            sessionTable.put(string, vector);
        }
    }

    synchronized void alive() {
        this.checkTime = 0;
    }

    synchronized boolean isReachable() {
        if (this.checkTime > this.pingRetries) {
            return false;
        }
        ++this.checkTime;
        return true;
    }

    public static synchronized void removeService(MSBaseService mSBaseService) {
        String string = mSBaseService.getUserSession();
        if (string == null) {
            return;
        }
        Vector vector = (Vector)sessionTable.get(string);
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            MSBaseService mSBaseService2 = (MSBaseService)vector.elementAt(n);
            if (mSBaseService2.equals(mSBaseService)) {
                vector.remove(n);
                if (vector.size() == 0) {
                    sessionTable.remove(string);
                }
                mSBaseService2.cleanup();
                mSBaseService2 = null;
                logInfo.println("Factory: remove service instance: " + mSBaseService.getServiceName());
                return;
            }
            ++n;
        }
    }

    protected synchronized void register(String string) {
        if (this.serviceTable.contains(string)) {
            logError.println("register: service name is already bound");
            return;
        }
        this.doregister(string);
    }

    protected synchronized void register(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        String[] stringArray2 = new String[stringArray.length];
        String string = "";
        int n = 0;
        int n2 = 0;
        n2 = 0;
        n = 0;
        while (n2 < stringArray.length) {
            if (this.serviceTable.contains(stringArray[n2])) {
                string = string + stringArray[n2] + ", ";
            } else {
                stringArray2[n++] = stringArray[n2];
            }
            ++n2;
        }
        if (n != 0) {
            this.doregister(stringArray2, n);
        }
        if (!string.equals("")) {
            logError.println("register: service (" + string + ") are already bound");
        }
    }

    protected synchronized void reregister(String string) {
        if (this.serviceTable.contains(string)) {
            return;
        }
        this.doregister(string);
    }

    protected synchronized void reregister(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        int n2 = 0;
        n2 = 0;
        n = 0;
        while (n2 < stringArray.length) {
            if (!this.serviceTable.contains(stringArray[n2])) {
                stringArray2[n++] = stringArray[n2];
            }
            ++n2;
        }
        if (n != 0) {
            this.doregister(stringArray2, n);
        }
    }

    protected synchronized void unregister(String string) {
        if (!this.serviceTable.contains(string)) {
            String string2 = "service unregistry fails: no such service name bound";
            logInfo.println(string2);
        }
        try {
            this.lookupRegistry.unregister(string, (MSRemoteServiceFactory)RemoteObject.toStub(this.factoryHandle));
            this.removeService(string);
        }
        catch (Exception exception) {
            String string3 = "service unregistry fails: " + exception.getMessage();
            logError.println(string3);
        }
    }

    protected abstract MSBaseServiceInterface getService(String var1, ScSecurityCredential var2, String var3) throws SMNoSuchObjectException;

    synchronized void reregisterAll() {
        if (this.serviceTable.isEmpty()) {
            return;
        }
        int n = this.serviceTable.size();
        String[] stringArray = new String[n];
        Iterator iterator = this.serviceTable.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray[n2++] = (String)iterator.next();
        }
        this.serviceTable.clear();
        try {
            this.lookupRegistry.register(stringArray, (MSRemoteServiceFactory)RemoteObject.toStub(this.factoryHandle));
        }
        catch (Exception exception) {
            logError.println("service re-registry fails: try ..." + exception.getMessage());
            return;
        }
        this.alive();
        this.removeSessions();
        this.addServices(stringArray);
    }

    private void doregister(String[] stringArray, int n) {
        if (n == 0) {
            return;
        }
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = stringArray[n2];
            ++n2;
        }
        while (true) {
            try {
                this.lookupRegistry.register(stringArray2, (MSRemoteServiceFactory)RemoteObject.toStub(this.factoryHandle));
                this.addServices(stringArray2);
                return;
            }
            catch (Exception exception) {
                logError.println("service registry fails: try ..." + exception.getMessage());
                try {
                    Thread.sleep(TRYINTERVAL);
                }
                catch (Exception exception2) {
                    continue;
                }
            }
            break;
        }
    }

    private void doregister(String string) {
        while (true) {
            try {
                this.lookupRegistry.register(string, (MSRemoteServiceFactory)RemoteObject.toStub(this.factoryHandle));
                this.addServices(string);
                return;
            }
            catch (Exception exception) {
                logError.println("service registry fails: rey ..." + exception.getMessage());
                try {
                    Thread.sleep(TRYINTERVAL);
                }
                catch (Exception exception2) {
                }
                continue;
            }
            break;
        }
    }

    private void addServices(String string) {
        String[] stringArray = new String[]{string};
        this.addServices(stringArray);
    }

    private void addServices(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.serviceTable.add(stringArray[n]);
            ++n;
        }
        if (this.checker == null) {
            this.checker = new MSServerChecker(this.pingInterval, this);
            this.checker.start();
        }
    }

    private void removeService(String string) {
        this.serviceTable.remove(string);
        if (this.serviceTable.isEmpty()) {
            this.checker.setStop();
            this.checker = null;
        }
    }

    private class RemoteFactory
    extends UnicastRemoteObject
    implements MSRemoteServiceFactory {
        MSBaseFactory svcFactory;

        public RemoteFactory(MSBaseFactory mSBaseFactory2) throws RemoteException {
            this.svcFactory = mSBaseFactory2;
        }

        public Remote getHandle(String string, ScSecurityCredential scSecurityCredential, String string2, String string3) throws RemoteException, SMNoSuchObjectException {
            Remote remote;
            if (!this.svcFactory.isAvailable(string)) {
                throw new SMNoSuchObjectException("Service not found: " + string);
            }
            MSBaseServiceInterface mSBaseServiceInterface = null;
            String string4 = null;
            try {
                string4 = string3 != null ? string3 : System.getProperty("sunmc.host", InetAddress.getLocalHost().getHostName());
                mSBaseServiceInterface = this.svcFactory.getService(string, scSecurityCredential, string4);
                remote = (MSBaseService)mSBaseServiceInterface;
                remote.setUserSession(string2);
            }
            catch (Exception exception) {
                throw new SMNoSuchObjectException("Service not found: " + exception.getMessage());
            }
            try {
                remote = RemoteObject.toStub(mSBaseServiceInterface);
                this.svcFactory.addSession(string2, mSBaseServiceInterface);
                return remote;
            }
            catch (Exception exception) {
                throw new SMNoSuchObjectException("Service not found: " + exception.getMessage());
            }
        }

        public void removeSession(String string) throws RemoteException {
            this.svcFactory.removeSession(string);
        }

        public void setServerPingInterval(int n, int n2) throws RemoteException {
            this.svcFactory.setServerPingInterval(n, n2);
        }

        public void ping() throws RemoteException {
            this.svcFactory.alive();
        }
    }
}

