/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.common;

import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSProperties;
import com.sun.symon.base.mgmtservice.common.MSServiceException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;

public class MSObjectHandles {
    private Hashtable objectsTable;
    private static MSLogPrintWriter errorWriter = MSLogPrintWriter.getErrorWriter();

    public MSObjectHandles(String string) throws MSServiceException {
        MSProperties mSProperties = new MSProperties();
        try {
            mSProperties.load(string);
        }
        catch (Exception exception) {
            throw new MSServiceException("load property file failed", exception);
        }
        Enumeration<?> enumeration = mSProperties.propertyNames();
        this.objectsTable = new Hashtable();
        String string2 = null;
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string3 = mSProperties.getProperty(string2);
            ObjectCell objectCell = new ObjectCell(string3);
            if (objectCell == null) continue;
            this.objectsTable.put(string2, objectCell);
        }
    }

    public Object getInstance(String string) throws MSServiceException {
        ObjectCell objectCell = (ObjectCell)this.objectsTable.get(string);
        if (objectCell == null) {
            return null;
        }
        return objectCell.getInstance();
    }

    public Object createInstance(String string) throws MSServiceException {
        ObjectCell objectCell = (ObjectCell)this.objectsTable.get(string);
        if (objectCell == null) {
            return null;
        }
        return objectCell.createInstance();
    }

    class ObjectCell {
        String className = null;
        Class aClass = null;
        Object objInst = null;

        ObjectCell(String string) {
            this.className = string;
        }

        Object getInstance() throws MSServiceException {
            if (this.objInst == null) {
                this.objInst = this.createInstance();
            }
            return this.objInst;
        }

        Object createInstance() throws MSServiceException {
            try {
                if (this.aClass == null) {
                    this.aClass = Class.forName(this.className);
                }
                Class<?>[] classArray = null;
                Constructor constructor = this.aClass.getDeclaredConstructor(classArray);
                Object[] objectArray = null;
                Object t = constructor.newInstance(objectArray);
                return t;
            }
            catch (Exception exception) {
                throw new MSServiceException("createInstance failed", exception);
            }
        }
    }
}

