/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.common;

import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.client.service.SMDBConcurrencyTimestamp;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.mgmtservice.common.MSProperties;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.sql.ConnectionPoolDataSource;
import oracle.jdbc.pool.OracleConnectionCacheImpl;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;

public class MSDB {
    public static final String STALE_DATA = "STALE_DATA";
    public static final String ROW_NOT_FOUND = "ROW_NOT_FOUND";
    public static final String DUPLICATE_INDEX = "DUPLICATE_INDEX";
    public static final String VIOLATED_CONSTRAINT = "INTEGRITY CONSTRAINT";
    private static OracleConnectionCacheImpl cache_;
    private static String i18nBase_;

    private MSDB() {
        throw new AbstractMethodError("This method is not to be called");
    }

    public static Connection getConnection() throws SMDatabaseException {
        try {
            Connection connection = cache_.getConnection();
            connection.setAutoCommit(false);
            return connection;
        }
        catch (Exception exception) {
            SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)exception);
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
            throw sMDatabaseException;
        }
    }

    public static Connection getConnection(String string, String string2) throws SMDatabaseException {
        try {
            Connection connection = cache_.getConnection(string, string2);
            connection.setAutoCommit(false);
            return connection;
        }
        catch (Exception exception) {
            SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)exception);
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
            throw sMDatabaseException;
        }
    }

    public static void setNullable(PreparedStatement preparedStatement, int n, SMDBObjectID sMDBObjectID) throws SQLException {
        if (sMDBObjectID != null) {
            preparedStatement.setLong(n, sMDBObjectID.getID());
        } else {
            preparedStatement.setNull(n, 4);
        }
    }

    public static void setNullable(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        if (string != null) {
            preparedStatement.setString(n, string.trim());
        } else {
            preparedStatement.setNull(n, 12);
        }
    }

    public static void setNullable(PreparedStatement preparedStatement, int n, Timestamp timestamp) throws SQLException {
        if (timestamp != null) {
            preparedStatement.setTimestamp(n, timestamp);
        } else {
            preparedStatement.setNull(n, 93);
        }
    }

    public static void setNullable(PreparedStatement preparedStatement, int n, Date date) throws SQLException {
        if (date != null) {
            preparedStatement.setTimestamp(n, new Timestamp(date.getTime()));
        } else {
            preparedStatement.setNull(n, 93);
        }
    }

    public static void setNullable(PreparedStatement preparedStatement, int n, SMDBConcurrencyTimestamp sMDBConcurrencyTimestamp) throws SQLException {
        if (sMDBConcurrencyTimestamp != null) {
            preparedStatement.setTimestamp(n, sMDBConcurrencyTimestamp.getValue());
        } else {
            preparedStatement.setNull(n, 93);
        }
    }

    public static void rollback(Connection connection) throws SMDatabaseException {
        try {
            connection.rollback();
        }
        catch (SQLException sQLException) {
            SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
            throw sMDatabaseException;
        }
    }

    public static void closeConnection(Connection connection) throws SMDatabaseException {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
            throw sMDatabaseException;
        }
    }

    public static void printCacheStatus(PrintWriter printWriter) {
        printWriter.print("scheme: ");
        switch (cache_.getCacheScheme()) {
            case 1: {
                printWriter.print("dynamic");
                break;
            }
            case 2: {
                printWriter.print("wait");
                break;
            }
            case 3: {
                printWriter.print("return null");
            }
        }
        printWriter.print(" cache size: " + cache_.getCacheSize());
        printWriter.print(" active size: " + cache_.getActiveSize());
        printWriter.print(" min: " + cache_.getMinLimit());
        printWriter.println(" max: " + cache_.getMaxLimit());
    }

    static {
        i18nBase_ = "com.sun.symon.base.client.ClientApiMessages";
        try {
            OracleConnectionPoolDataSource oracleConnectionPoolDataSource = new OracleConnectionPoolDataSource();
            MSProperties mSProperties = new MSProperties();
            mSProperties.load("dbase.cfg");
            oracleConnectionPoolDataSource.setDriverType(mSProperties.getProperty("driver"));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(mSProperties.getProperty("url"));
            stringBuffer.append(":@");
            stringBuffer.append(mSProperties.getProperty("host"));
            stringBuffer.append(":");
            stringBuffer.append(mSProperties.getProperty("port"));
            stringBuffer.append(":");
            stringBuffer.append(mSProperties.getProperty("database"));
            oracleConnectionPoolDataSource.setURL(stringBuffer.toString());
            oracleConnectionPoolDataSource.setUser(mSProperties.getProperty("user"));
            oracleConnectionPoolDataSource.setPassword(mSProperties.getProperty("password"));
            cache_ = new OracleConnectionCacheImpl((ConnectionPoolDataSource)oracleConnectionPoolDataSource);
            cache_.setCacheScheme(1);
            int n = new Integer(mSProperties.getProperty("minConnections", "5"));
            int n2 = new Integer(mSProperties.getProperty("maxConnections", "10"));
            cache_.setMinLimit(n);
            cache_.setMaxLimit(n2);
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

